/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.authz.fgap;

import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.authorization.fgap.AdminPermissionsSchema;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.representations.idm.authorization.ScopePermissionRepresentation;
import org.keycloak.representations.idm.authorization.UserPolicyRepresentation;
import org.keycloak.testframework.annotations.InjectAdminClient;
import org.keycloak.testframework.annotations.InjectUser;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.ManagedUser;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.testframework.util.ApiUtil;
import org.keycloak.tests.admin.authz.fgap.AbstractPermissionTest;

@KeycloakIntegrationTest
public class UserResourceTypeEvaluationTest
extends AbstractPermissionTest {
    @InjectUser(ref="alice")
    ManagedUser userAlice;
    @InjectAdminClient(mode=InjectAdminClient.Mode.MANAGED_REALM, client="myclient", user="myadmin")
    Keycloak realmAdminClient;
    private final String usersType = AdminPermissionsSchema.USERS.getType();
    private final String newUserUsername = "new_user";

    @Test
    public void testSingleUserPermission() {
        UserRepresentation myadmin = (UserRepresentation)this.realm.admin().users().search("myadmin").get(0);
        UserPolicyRepresentation allowMyAdminPermission = UserResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", myadmin.getId());
        this.createPermission(this.client, this.userAlice.admin().toRepresentation().getId(), this.usersType, Set.of("view"), new AbstractPolicyRepresentation[]{allowMyAdminPermission});
        List search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertEquals((int)1, (int)search.size());
        Assertions.assertEquals((Object)this.userAlice.getUsername(), (Object)((UserRepresentation)search.get(0)).getUsername());
    }

    @Test
    public void testImpersonatePermission() {
        try {
            this.realmAdminClient.realm(this.realm.getName()).users().get(this.userAlice.getId()).impersonate();
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
        UserPolicyRepresentation policy = UserResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        UserResourceTypeEvaluationTest.createAllPermission(this.client, this.usersType, (AbstractPolicyRepresentation)policy, Set.of("impersonate"));
        UserPolicyRepresentation negativePolicy = UserResourceTypeEvaluationTest.createUserPolicy(Logic.NEGATIVE, this.realm, this.client, "Not My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        String cannotImpersonateAlice = this.createPermission(this.client, this.userAlice.getId(), this.usersType, Set.of("impersonate"), new AbstractPolicyRepresentation[]{negativePolicy}).getName();
        try {
            this.realmAdminClient.realm(this.realm.getName()).users().get(this.userAlice.getId()).impersonate();
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
        String cannotImpersonateAliceId = UserResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findByName(cannotImpersonateAlice).getId();
        UserResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findById(cannotImpersonateAliceId).remove();
        try (Keycloak adminClient = KeycloakBuilder.builder().serverUrl("http://localhost:8080").realm(this.realm.getName()).clientId("myclient").clientSecret("mysecret").username("myadmin").password("password").build();){
            adminClient.realm(this.realm.getName()).users().get(this.userAlice.getId()).impersonate();
        }
    }

    @Test
    public void testManageAllPermission() {
        try (Response response = this.realmAdminClient.realm(this.realm.getName()).users().create(UserConfigBuilder.create().username("new_user").build());){
            Assertions.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)response.getStatus());
        }
        UserPolicyRepresentation policy = UserResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        UserResourceTypeEvaluationTest.createAllPermission(this.client, this.usersType, (AbstractPolicyRepresentation)policy, Set.of("view", "manage"));
        String newUserId = ApiUtil.handleCreatedResponse((Response)this.realmAdminClient.realm(this.realm.getName()).users().create(UserConfigBuilder.create().username("new_user").build()));
        this.realmAdminClient.realm(this.realm.getName()).users().get(newUserId).update(UserConfigBuilder.create().email("new@test.com").build());
        Assertions.assertEquals((Object)"new@test.com", (Object)this.realmAdminClient.realm(this.realm.getName()).users().get(newUserId).toRepresentation().getEmail());
    }

    @Test
    public void testManageUserPermission() {
        String myadminId = ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId();
        UserPolicyRepresentation policy = UserResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", myadminId);
        ScopePermissionRepresentation allUsersPermission = UserResourceTypeEvaluationTest.createAllPermission(this.client, this.usersType, (AbstractPolicyRepresentation)policy, Set.of("view", "manage"));
        String newUserId = ApiUtil.handleCreatedResponse((Response)this.realmAdminClient.realm(this.realm.getName()).users().create(UserConfigBuilder.create().username("new_user").build()));
        allUsersPermission = UserResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findByName(allUsersPermission.getName());
        UserResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findById(allUsersPermission.getId()).remove();
        this.createPermission(this.client, UserConfigBuilder.create().id(newUserId).build().getId(), this.usersType, Set.of("view", "manage"), new AbstractPolicyRepresentation[]{policy});
        this.realmAdminClient.realm(this.realm.getName()).users().get(newUserId).update(UserConfigBuilder.create().email("email@test.com").build());
        Assertions.assertEquals((Object)"email@test.com", (Object)this.realmAdminClient.realm(this.realm.getName()).users().get(newUserId).toRepresentation().getEmail());
        UserResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findAll(null, null, null, null, null).forEach(permission -> UserResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findById(permission.getId()).remove());
        try {
            this.realmAdminClient.realm(this.realm.getName()).users().get(newUserId).update(UserConfigBuilder.create().email("email@test.com").build());
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
    }

    @Test
    public void testViewAllPermission() {
        UserPolicyRepresentation policy = UserResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        ScopePermissionRepresentation permission = UserResourceTypeEvaluationTest.createAllPermission(this.client, this.usersType, (AbstractPolicyRepresentation)policy, Set.of("view"));
        List search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertFalse((boolean)search.isEmpty());
        permission = this.client.admin().authorization().permissions().scope().findByName(permission.getName());
        permission.setPolicies(Set.of());
        this.client.admin().authorization().permissions().scope().findById(permission.getId()).update(permission);
        search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertTrue((boolean)search.isEmpty());
    }

    @Test
    public void testViewUserPermission() {
        UserRepresentation myadmin = (UserRepresentation)this.realm.admin().users().search("myadmin").get(0);
        UserPolicyRepresentation allowMyAdminPermission = UserResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", myadmin.getId());
        UserResourceTypeEvaluationTest.createAllPermission(this.client, this.usersType, (AbstractPolicyRepresentation)allowMyAdminPermission, Set.of("view"));
        UserPolicyRepresentation denyMyAdminAccessingHisAccountPermission = UserResourceTypeEvaluationTest.createUserPolicy(Logic.NEGATIVE, this.realm, this.client, "Not My Admin User Policy", myadmin.getId());
        this.createPermission(this.client, myadmin.getId(), this.usersType, Set.of("view"), new AbstractPolicyRepresentation[]{denyMyAdminAccessingHisAccountPermission});
        List search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertEquals((int)1, (int)search.size());
        Assertions.assertEquals((Object)this.userAlice.getUsername(), (Object)((UserRepresentation)search.get(0)).getUsername());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testViewUserPermissionUserMemberOfGroup() {
        UserRepresentation myadmin = (UserRepresentation)this.realm.admin().users().search("myadmin").get(0);
        UserPolicyRepresentation allowMyAdminPermission = UserResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", myadmin.getId());
        this.createPermission(this.client, this.userAlice.getId(), this.usersType, Set.of("view"), new AbstractPolicyRepresentation[]{allowMyAdminPermission});
        GroupRepresentation group = new GroupRepresentation();
        group.setName("foo");
        try (Response response = this.realm.admin().groups().add(group);){
            group.setId(ApiUtil.getCreatedId((Response)response));
            this.realm.admin().users().get(myadmin.getId()).joinGroup(group.getId());
            List search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(-1), Integer.valueOf(-1));
            Assertions.assertEquals((int)1, (int)search.size());
            Assertions.assertEquals((Object)this.userAlice.getUsername(), (Object)((UserRepresentation)search.get(0)).getUsername());
        }
        finally {
            this.realm.admin().users().get(myadmin.getId()).leaveGroup(group.getId());
        }
    }

    @Test
    public void testViewUserPermissionDenyByDefault() {
        String myadminId = ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId();
        UserPolicyRepresentation disallowMyAdmin = UserResourceTypeEvaluationTest.createUserPolicy(Logic.NEGATIVE, this.realm, this.client, "Not My Admin User Policy", myadminId);
        UserResourceTypeEvaluationTest.createAllPermission(this.client, this.usersType, (AbstractPolicyRepresentation)disallowMyAdmin, Set.of("view"));
        UserPolicyRepresentation allowAliceOnlyForMyAdmin = UserResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "My Admin User Policy", myadminId);
        this.createPermission(this.client, this.userAlice.getId(), this.usersType, Set.of("view"), new AbstractPolicyRepresentation[]{allowAliceOnlyForMyAdmin});
        List search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertEquals((int)1, (int)search.size());
        Assertions.assertEquals((Object)this.userAlice.getUsername(), (Object)((UserRepresentation)search.get(0)).getUsername());
    }

    @Test
    public void testMapRoles() {
        RoleRepresentation testRole = new RoleRepresentation();
        testRole.setName("testRole");
        this.realm.admin().roles().create(testRole);
        this.realm.cleanup().add(r -> r.roles().get("testRole").remove());
        try {
            this.realmAdminClient.realm(this.realm.getName()).users().get(this.userAlice.getId()).roles().realmLevel().add(List.of(testRole));
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
        UserPolicyRepresentation policy = UserResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        ScopePermissionRepresentation allUsersPermission = UserResourceTypeEvaluationTest.createAllPermission(this.client, this.usersType, (AbstractPolicyRepresentation)policy, Set.of("map-roles"));
        try {
            this.realmAdminClient.realm(this.realm.getName()).users().get(this.userAlice.getId()).roles().realmLevel().add(List.of(testRole));
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(NotFoundException.class));
        }
        allUsersPermission = UserResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findByName(allUsersPermission.getName());
        UserResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findById(allUsersPermission.getId()).remove();
        try {
            this.realmAdminClient.realm(this.realm.getName()).users().get(this.userAlice.getId()).roles().realmLevel().add(List.of(testRole));
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
        this.createPermission(this.client, this.userAlice.getId(), this.usersType, Set.of("map-roles"), new AbstractPolicyRepresentation[]{policy});
        try {
            this.realmAdminClient.realm(this.realm.getName()).users().get(this.userAlice.getId()).roles().realmLevel().add(List.of(testRole));
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(NotFoundException.class));
        }
    }

    @Test
    public void testManageGroupMembership() {
        try {
            this.realmAdminClient.realm(this.realm.getName()).users().get(this.userAlice.getId()).joinGroup("no-such");
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
        UserPolicyRepresentation policy = UserResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        ScopePermissionRepresentation allUsersPermission = UserResourceTypeEvaluationTest.createAllPermission(this.client, this.usersType, (AbstractPolicyRepresentation)policy, Set.of("manage-group-membership"));
        try {
            this.realmAdminClient.realm(this.realm.getName()).users().get(this.userAlice.getId()).joinGroup("no-such");
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(NotFoundException.class));
        }
        allUsersPermission = UserResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findByName(allUsersPermission.getName());
        UserResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findById(allUsersPermission.getId()).remove();
        try {
            this.realmAdminClient.realm(this.realm.getName()).users().get(this.userAlice.getId()).joinGroup("no-such");
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
        this.createPermission(this.client, this.userAlice.getId(), this.usersType, Set.of("manage-group-membership"), new AbstractPolicyRepresentation[]{policy});
        try {
            this.realmAdminClient.realm(this.realm.getName()).users().get(this.userAlice.getId()).joinGroup("no-such");
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(NotFoundException.class));
        }
    }

    @Test
    public void testNoTransitiveUserPermissions() {
        UserPolicyRepresentation policy = UserResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        UserResourceTypeEvaluationTest.createAllPermission(this.client, this.usersType, (AbstractPolicyRepresentation)policy, Set.of("manage"));
        List search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertTrue((boolean)search.isEmpty());
        try {
            this.realmAdminClient.realm(this.realm.getName()).users().get(this.userAlice.getId()).roles().realmLevel().add(List.of(new RoleRepresentation()));
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
        try {
            this.realmAdminClient.realm(this.realm.getName()).users().get(this.userAlice.getId()).joinGroup("no-such");
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
        try {
            this.realmAdminClient.realm(this.realm.getName()).users().get(this.userAlice.getId()).impersonate();
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ForbiddenException.class));
        }
    }

    @Test
    public void testEvaluateAllResourcePermissionsForSpecificResourcePermission() {
        UserRepresentation adminUser = (UserRepresentation)this.realm.admin().users().search("myadmin").get(0);
        UserPolicyRepresentation allowPolicy = UserResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin", adminUser.getId());
        ScopePermissionRepresentation allResourcesPermission = UserResourceTypeEvaluationTest.createAllPermission(this.client, this.usersType, (AbstractPolicyRepresentation)allowPolicy, Set.of("manage", "impersonate"));
        UsersResource users = this.realmAdminClient.realm(this.realm.getName()).users();
        users.get(this.userAlice.getId()).update(this.userAlice.admin().toRepresentation());
        ScopePermissionRepresentation resourcePermission = this.createPermission(this.client, this.userAlice.getId(), this.usersType, Set.of("manage"), new AbstractPolicyRepresentation[]{allowPolicy});
        users.get(this.userAlice.getId()).update(this.userAlice.admin().toRepresentation());
        allResourcesPermission = UserResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findByName(allResourcesPermission.getName());
        allResourcesPermission.setScopes(Set.of("impersonate"));
        UserResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findById(allResourcesPermission.getId()).update(allResourcesPermission);
        users.get(this.userAlice.getId()).update(this.userAlice.admin().toRepresentation());
        resourcePermission = UserResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findByName(resourcePermission.getName());
        resourcePermission.setScopes(Set.of("impersonate"));
        UserResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findById(resourcePermission.getId()).update(resourcePermission);
        try {
            users.get(this.userAlice.getId()).update(this.userAlice.admin().toRepresentation());
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (ForbiddenException forbiddenException) {
            // empty catch block
        }
        allResourcesPermission.setScopes(Set.of("manage"));
        UserResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findById(allResourcesPermission.getId()).update(allResourcesPermission);
        users.get(this.userAlice.getId()).update(this.userAlice.admin().toRepresentation());
        UserPolicyRepresentation notAllowPolicy = UserResourceTypeEvaluationTest.createUserPolicy(Logic.NEGATIVE, this.realm, this.client, "Not My Admin", adminUser.getId());
        this.createPermission(this.client, this.userAlice.getId(), this.usersType, Set.of("manage"), new AbstractPolicyRepresentation[]{notAllowPolicy});
        try {
            users.get(this.userAlice.getId()).update(this.userAlice.admin().toRepresentation());
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (ForbiddenException forbiddenException) {
            // empty catch block
        }
        resourcePermission = UserResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findByName(resourcePermission.getName());
        resourcePermission.setScopes(Set.of("impersonate", "manage"));
        UserResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findById(resourcePermission.getId()).update(resourcePermission);
        try {
            users.get(this.userAlice.getId()).update(this.userAlice.admin().toRepresentation());
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (ForbiddenException forbiddenException) {
            // empty catch block
        }
    }

    @Test
    public void testResetPassword() {
        UserRepresentation myadmin = (UserRepresentation)this.realm.admin().users().search("myadmin").get(0);
        UserPolicyRepresentation allowMyAdminPermission = UserResourceTypeEvaluationTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", myadmin.getId());
        UserPolicyRepresentation notAllowMyAdminPermission = UserResourceTypeEvaluationTest.createUserPolicy(Logic.NEGATIVE, this.realm, this.client, "Not Allow My Admin User Policy", myadmin.getId());
        ScopePermissionRepresentation managePermission = this.createPermission(this.client, this.userAlice.admin().toRepresentation().getId(), this.usersType, Set.of("view", "manage"), new AbstractPolicyRepresentation[]{allowMyAdminPermission});
        ScopePermissionRepresentation resetPasswordPermission = this.createPermission(this.client, this.userAlice.admin().toRepresentation().getId(), this.usersType, Set.of("reset-password"), new AbstractPolicyRepresentation[]{notAllowMyAdminPermission});
        List search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertEquals((int)1, (int)search.size());
        Assertions.assertEquals((Object)this.userAlice.getUsername(), (Object)((UserRepresentation)search.get(0)).getUsername());
        CredentialRepresentation credential = new CredentialRepresentation();
        credential.setType("password");
        credential.setValue("password");
        try {
            UsersResource users = this.realmAdminClient.realm(this.realm.getName()).users();
            users.get(((UserRepresentation)search.get(0)).getId()).resetPassword(credential);
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (ForbiddenException users) {
            // empty catch block
        }
        String permissionId = UserResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findByName(resetPasswordPermission.getName()).getId();
        UserResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findById(permissionId).remove();
        this.createPermission(this.client, this.userAlice.admin().toRepresentation().getId(), this.usersType, Set.of("reset-password"), new AbstractPolicyRepresentation[]{allowMyAdminPermission});
        UsersResource users = this.realmAdminClient.realm(this.realm.getName()).users();
        users.get(((UserRepresentation)search.get(0)).getId()).resetPassword(credential);
        permissionId = UserResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findByName(managePermission.getName()).getId();
        UserResourceTypeEvaluationTest.getScopePermissionsResource(this.client).findById(permissionId).remove();
        this.createPermission(this.client, this.userAlice.admin().toRepresentation().getId(), this.usersType, Set.of("view"), new AbstractPolicyRepresentation[]{allowMyAdminPermission});
        users.get(((UserRepresentation)search.get(0)).getId()).resetPassword(credential);
    }
}

