/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.authz.fgap;

import jakarta.ws.rs.core.Response;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RolePoliciesResource;
import org.keycloak.authorization.fgap.AdminPermissionsSchema;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.AbstractUserRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.GroupPolicyRepresentation;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.representations.idm.authorization.RolePolicyRepresentation;
import org.keycloak.representations.idm.authorization.UserPolicyRepresentation;
import org.keycloak.testframework.annotations.InjectAdminClient;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.RoleConfigBuilder;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.testframework.util.ApiUtil;
import org.keycloak.tests.admin.authz.fgap.AbstractPermissionTest;

@KeycloakIntegrationTest
public class UserResourceTypeFilteringTest
extends AbstractPermissionTest {
    @InjectAdminClient(mode=InjectAdminClient.Mode.MANAGED_REALM, client="myclient", user="myadmin")
    Keycloak realmAdminClient;
    private final String usersType = AdminPermissionsSchema.USERS.getType();

    @BeforeEach
    public void onBeforeEach() {
        for (int i = 0; i < 50; ++i) {
            this.realm.admin().users().create(UserConfigBuilder.create().username("user-" + i).build()).close();
        }
    }

    @Test
    public void testViewAllUsersUsingUserPolicy() {
        UserPolicyRepresentation policy = UserResourceTypeFilteringTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        UserResourceTypeFilteringTest.createAllPermission(this.client, this.usersType, (AbstractPolicyRepresentation)policy, Set.of("view"));
        List search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(0), Integer.valueOf(50));
        Assertions.assertFalse((boolean)search.isEmpty());
        Assertions.assertEquals((int)50, (int)search.size());
    }

    @Test
    public void testDeniedResourcesPrecedenceOverGrantedResources() {
        UserPolicyRepresentation policy = UserResourceTypeFilteringTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        UserResourceTypeFilteringTest.createAllPermission(this.client, this.usersType, (AbstractPolicyRepresentation)policy, Set.of("view"));
        List search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(0), Integer.valueOf(50));
        Assertions.assertFalse((boolean)search.isEmpty());
        Assertions.assertEquals((int)50, (int)search.size());
        UserPolicyRepresentation notMyAdminPolicy = UserResourceTypeFilteringTest.createUserPolicy(Logic.NEGATIVE, this.realm, this.client, "Not My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        Set<String> notAllowedUsers = Set.of("user-0", "user-15", "user-30", "user-45");
        this.createPermission(this.client, notAllowedUsers, this.usersType, Set.of("view"), new AbstractPolicyRepresentation[]{notMyAdminPolicy});
        search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertFalse((boolean)search.isEmpty());
        Assertions.assertTrue((boolean)search.stream().map(AbstractUserRepresentation::getUsername).noneMatch(notAllowedUsers::contains));
    }

    @Test
    public void testCountWithFilters() {
        MatcherAssert.assertThat((Object)this.realmAdminClient.realm(this.realm.getName()).users().count("user-"), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.realmAdminClient.realm(this.realm.getName()).users().count(null, null, null, "user-15"), (Matcher)CoreMatchers.is((Object)0));
        UserPolicyRepresentation allowPolicy = UserResourceTypeFilteringTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        Set<String> allowedUsers = Set.of("user-0", "user-15", "user-30");
        this.createPermission(this.client, allowedUsers, this.usersType, Set.of("view"), new AbstractPolicyRepresentation[]{allowPolicy});
        List search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertEquals((int)allowedUsers.size(), (int)search.size());
        Assertions.assertTrue((boolean)search.stream().map(AbstractUserRepresentation::getUsername).allMatch(allowedUsers::contains));
        MatcherAssert.assertThat((Object)this.realmAdminClient.realm(this.realm.getName()).users().count("user-"), (Matcher)CoreMatchers.is((Object)allowedUsers.size()));
        MatcherAssert.assertThat((Object)this.realmAdminClient.realm(this.realm.getName()).users().count(null, null, null, "user-15"), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testViewUserUsingUserPolicy() {
        List search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertTrue((boolean)search.isEmpty());
        UserPolicyRepresentation policy = UserResourceTypeFilteringTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        this.createPermission(this.client, "user-9", this.usersType, Set.of("view"), new AbstractPolicyRepresentation[]{policy});
        search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertFalse((boolean)search.isEmpty());
        Assertions.assertEquals((int)1, (int)search.size());
    }

    @Test
    public void testViewUserUsingGroupPolicy() {
        List search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertTrue((boolean)search.isEmpty());
        GroupRepresentation rep = new GroupRepresentation();
        rep.setName("administrators");
        try (Response response = this.realm.admin().groups().add(rep);){
            String adminUserId = ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId();
            String groupId = ApiUtil.getCreatedId((Response)response);
            this.realm.admin().users().get(adminUserId).joinGroup(groupId);
            GroupPolicyRepresentation policy = UserResourceTypeFilteringTest.createGroupPolicy(this.realm, this.client, "Admin Group Policy", groupId, Logic.POSITIVE);
            this.createPermission(this.client, "user-9", this.usersType, Set.of("view"), new AbstractPolicyRepresentation[]{policy});
        }
        search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertFalse((boolean)search.isEmpty());
        Assertions.assertEquals((int)1, (int)search.size());
    }

    @Test
    public void testViewUserUsingRolePolicy() {
        List search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertTrue((boolean)search.isEmpty());
        RoleRepresentation role = new RoleRepresentation();
        role.setName("administrators");
        this.realm.admin().roles().create(role);
        String adminUserId = ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId();
        role = this.realm.admin().roles().get(role.getName()).toRepresentation();
        this.realm.admin().users().get(adminUserId).roles().realmLevel().add(List.of(role));
        RolePolicyRepresentation policy = UserResourceTypeFilteringTest.createRolePolicy(this.realm, this.client, "Admin Role Policy", role.getId(), Logic.POSITIVE);
        this.createPermission(this.client, "user-9", this.usersType, Set.of("view"), new AbstractPolicyRepresentation[]{policy});
        search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertFalse((boolean)search.isEmpty());
        Assertions.assertEquals((int)1, (int)search.size());
    }

    @Test
    public void testViewUserUsingMultiplePolicies() {
        GroupPolicyRepresentation groupPolicy;
        List search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertTrue((boolean)search.isEmpty());
        RoleRepresentation role = new RoleRepresentation();
        role.setName(KeycloakModelUtils.generateId());
        this.realm.admin().roles().create(role);
        String adminUserId = ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId();
        role = this.realm.admin().roles().get(role.getName()).toRepresentation();
        this.realm.admin().users().get(adminUserId).roles().realmLevel().add(List.of(role));
        RolePolicyRepresentation rolePolicy = UserResourceTypeFilteringTest.createRolePolicy(this.realm, this.client, "Admin Role Policy", role.getId(), Logic.POSITIVE);
        GroupRepresentation rep = new GroupRepresentation();
        rep.setName(KeycloakModelUtils.generateId());
        try (Response response = this.realm.admin().groups().add(rep);){
            String groupId = ApiUtil.getCreatedId((Response)response);
            this.realm.admin().users().get(adminUserId).joinGroup(groupId);
            groupPolicy = UserResourceTypeFilteringTest.createGroupPolicy(this.realm, this.client, "Admin Group Policy", groupId, Logic.POSITIVE);
        }
        this.createPermission(this.client, "user-9", this.usersType, Set.of("view"), new AbstractPolicyRepresentation[]{rolePolicy, groupPolicy});
        search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertFalse((boolean)search.isEmpty());
        Assertions.assertEquals((int)1, (int)search.size());
        RolePoliciesResource rolePolicyResource = this.client.admin().authorization().policies().role();
        rolePolicy = rolePolicyResource.findByName(rolePolicy.getName());
        rolePolicy.setLogic(Logic.NEGATIVE);
        rolePolicyResource.findById(rolePolicy.getId()).update(rolePolicy);
        search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertTrue((boolean)search.isEmpty());
    }

    @Test
    public void testViewGroupMembersPolicy() {
        List search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertTrue((boolean)search.isEmpty());
        GroupRepresentation group = new GroupRepresentation();
        group.setName(KeycloakModelUtils.generateId());
        Set<String> memberUsernames = Set.of("user-0", "user-15", "user-30", "user-45");
        try (Response response = this.realm.admin().groups().add(group);){
            group.setId(ApiUtil.getCreatedId((Response)response));
            for (String username : memberUsernames) {
                String id = ((UserRepresentation)this.realm.admin().users().search(username).get(0)).getId();
                this.realm.admin().users().get(id).joinGroup(group.getId());
            }
        }
        UserPolicyRepresentation policy = UserResourceTypeFilteringTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        this.createPermission(this.client, group.getId(), "Groups", Set.of("view-members"), new AbstractPolicyRepresentation[]{policy});
        search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertEquals((int)memberUsernames.size(), (int)search.size());
        Assertions.assertTrue((boolean)search.stream().map(AbstractUserRepresentation::getUsername).allMatch(memberUsernames::contains));
        UserPolicyRepresentation negativePolicy = UserResourceTypeFilteringTest.createUserPolicy(Logic.NEGATIVE, this.realm, this.client, "Not My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        this.createPermission(this.client, ((UserRepresentation)this.realm.admin().users().search("user-0").get(0)).getId(), "Users", Set.of("view"), new AbstractPolicyRepresentation[]{negativePolicy});
        search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertFalse((boolean)search.isEmpty());
        Assertions.assertTrue((boolean)search.stream().map(AbstractUserRepresentation::getUsername).noneMatch("user-0"::equals));
        Assertions.assertTrue((boolean)this.realmAdminClient.realm(this.realm.getName()).groups().group(group.getId()).members().stream().map(AbstractUserRepresentation::getUsername).noneMatch("user-0"::equals));
    }

    @Test
    public void testDenyGroupViewMembersPolicy() {
        List search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertTrue((boolean)search.isEmpty());
        GroupRepresentation allowedMembers = new GroupRepresentation();
        allowedMembers.setName(KeycloakModelUtils.generateId());
        Set<String> memberUsernames = Set.of("user-0", "user-15", "user-30", "user-45");
        try (Response response = this.realm.admin().groups().add(allowedMembers);){
            allowedMembers.setId(ApiUtil.getCreatedId((Response)response));
            this.addGroupMember(allowedMembers.getId(), memberUsernames);
        }
        GroupRepresentation deniedMembers = new GroupRepresentation();
        deniedMembers.setName(KeycloakModelUtils.generateId());
        Set<String> deniedMemberUsernames = Set.of("user-0", "user-45");
        try (Response response = this.realm.admin().groups().add(deniedMembers);){
            deniedMembers.setId(ApiUtil.getCreatedId((Response)response));
            this.addGroupMember(deniedMembers.getId(), memberUsernames.stream().filter(deniedMemberUsernames::contains).collect(Collectors.toSet()));
        }
        UserPolicyRepresentation permitPolicy = UserResourceTypeFilteringTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        this.createPermission(this.client, allowedMembers.getId(), "Groups", Set.of("view-members"), new AbstractPolicyRepresentation[]{permitPolicy});
        search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertEquals((int)memberUsernames.size(), (int)search.size());
        Assertions.assertTrue((boolean)search.stream().map(AbstractUserRepresentation::getUsername).allMatch(memberUsernames::contains));
        UserPolicyRepresentation denyPolicy = UserResourceTypeFilteringTest.createUserPolicy(Logic.NEGATIVE, this.realm, this.client, "Not My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        this.createPermission(this.client, deniedMembers.getId(), "Groups", Set.of("view-members"), new AbstractPolicyRepresentation[]{denyPolicy});
        search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertFalse((boolean)search.isEmpty());
        Assertions.assertEquals((int)(memberUsernames.size() - deniedMemberUsernames.size()), (int)search.size());
        Assertions.assertTrue((boolean)search.stream().map(AbstractUserRepresentation::getUsername).noneMatch(deniedMemberUsernames::contains));
        String userId = ((UserRepresentation)this.realm.admin().users().search("user-0").get(0)).getId();
        this.createPermission(this.client, userId, "Users", Set.of("view"), new AbstractPolicyRepresentation[]{permitPolicy});
        search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(0), Integer.valueOf(10));
        HashSet<String> expected = new HashSet<String>(memberUsernames);
        expected.removeAll(deniedMemberUsernames);
        Assertions.assertFalse((boolean)search.isEmpty());
        Assertions.assertEquals((int)expected.size(), (int)search.size());
        Assertions.assertTrue((boolean)search.stream().map(AbstractUserRepresentation::getUsername).allMatch(expected::contains));
        this.realm.admin().users().get(userId).leaveGroup(deniedMembers.getId());
        search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(0), Integer.valueOf(10));
        expected = new HashSet<String>(memberUsernames);
        expected.removeAll(deniedMemberUsernames);
        expected.add("user-0");
        Assertions.assertFalse((boolean)search.isEmpty());
        Assertions.assertEquals((int)expected.size(), (int)search.size());
        Assertions.assertTrue((boolean)search.stream().map(AbstractUserRepresentation::getUsername).allMatch(expected::contains));
    }

    private void addGroupMember(String groupId, Set<String> usernames) {
        for (String username : usernames) {
            String id = ((UserRepresentation)this.realm.admin().users().search(username).get(0)).getId();
            this.realm.admin().users().get(id).joinGroup(groupId);
        }
    }

    @Test
    public void testListingUsersWithRolesOnly() {
        List search = this.realm.admin().users().search("myadmin");
        MatcherAssert.assertThat((Object)search, (Matcher)Matchers.hasSize((int)1));
        String userId = ((UserRepresentation)search.get(0)).getId();
        String clientUuid = ((ClientRepresentation)this.realm.admin().clients().findByClientId("realm-management").get(0)).getId();
        RoleRepresentation viewUsers = this.realm.admin().clients().get(clientUuid).roles().get("view-users").toRepresentation();
        this.realm.admin().users().get(userId).roles().clientLevel(clientUuid).add(List.of(viewUsers));
        this.realm.cleanup().add(r -> r.users().get(userId).roles().clientLevel(clientUuid).remove(List.of(viewUsers)));
        MatcherAssert.assertThat((Object)this.realmAdminClient.realm(this.realm.getName()).users().list(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
    }

    @Test
    public void testSearchById() {
        UserRepresentation expected = (UserRepresentation)this.realm.admin().users().search("user-0").get(0);
        MatcherAssert.assertThat((Object)this.realmAdminClient.realm(this.realm.getName()).users().search("id:" + expected.getId(), Integer.valueOf(-1), Integer.valueOf(-1)), (Matcher)Matchers.hasSize((int)0));
        UserPolicyRepresentation negativePolicy = UserResourceTypeFilteringTest.createUserPolicy(this.realm, this.client, "Only My Admin User Policy", ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId());
        this.createPermission(this.client, expected.getId(), "Users", Set.of("view"), new AbstractPolicyRepresentation[]{negativePolicy});
        List search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertFalse((boolean)search.isEmpty());
        MatcherAssert.assertThat((Object)search, (Matcher)Matchers.hasSize((int)1));
        UserRepresentation user = (UserRepresentation)search.get(0);
        MatcherAssert.assertThat((Object)user.getUsername(), (Matcher)Matchers.is((Object)"user-0"));
        MatcherAssert.assertThat((Object)this.realmAdminClient.realm(this.realm.getName()).users().search("id:" + user.getId(), Integer.valueOf(-1), Integer.valueOf(-1)), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void testViewUserUsingRoleInheritedFromGroup() {
        List search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertTrue((boolean)search.isEmpty());
        RoleRepresentation role = RoleConfigBuilder.create().name("myrole").build();
        this.realm.admin().roles().create(role);
        role = this.realm.admin().roles().get(role.getName()).toRepresentation();
        GroupRepresentation rep = new GroupRepresentation();
        rep.setName("administrators");
        try (Response response = this.realm.admin().groups().add(rep);){
            String adminUserId = ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId();
            String groupId = ApiUtil.getCreatedId((Response)response);
            this.realm.admin().users().get(adminUserId).joinGroup(groupId);
            this.realm.admin().groups().group(groupId).roles().realmLevel().add(List.of(role));
            RolePolicyRepresentation policy = UserResourceTypeFilteringTest.createRolePolicy(this.realm, this.client, "My Role Policy", role.getId(), Logic.POSITIVE);
            this.createPermission(this.client, "user-9", this.usersType, Set.of("view"), new AbstractPolicyRepresentation[]{policy});
        }
        search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertFalse((boolean)search.isEmpty());
        Assertions.assertEquals((int)1, (int)search.size());
    }

    @Test
    public void testViewUserUsingRoleInheritedFromCompositeRole() {
        List search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertTrue((boolean)search.isEmpty());
        RoleRepresentation role = RoleConfigBuilder.create().name("myrole").build();
        this.realm.admin().roles().create(role);
        role = this.realm.admin().roles().get(role.getName()).toRepresentation();
        RoleRepresentation compositeRole = RoleConfigBuilder.create().name("mycompositerole").composite(true).realmComposite(role.getName()).build();
        this.realm.admin().roles().create(compositeRole);
        compositeRole = this.realm.admin().roles().get(compositeRole.getName()).toRepresentation();
        GroupRepresentation rep = new GroupRepresentation();
        rep.setName("administrators");
        try (Response response = this.realm.admin().groups().add(rep);){
            String adminUserId = ((UserRepresentation)this.realm.admin().users().search("myadmin").get(0)).getId();
            String groupId = ApiUtil.getCreatedId((Response)response);
            this.realm.admin().users().get(adminUserId).joinGroup(groupId);
            this.realm.admin().groups().group(groupId).roles().realmLevel().add(List.of(compositeRole));
            RolePolicyRepresentation policy = UserResourceTypeFilteringTest.createRolePolicy(this.realm, this.client, "My Role Policy", role.getId(), Logic.POSITIVE);
            this.createPermission(this.client, "user-9", this.usersType, Set.of("view"), new AbstractPolicyRepresentation[]{policy});
        }
        search = this.realmAdminClient.realm(this.realm.getName()).users().search(null, Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertFalse((boolean)search.isEmpty());
        Assertions.assertEquals((int)1, (int)search.size());
    }
}

