/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.authz.fgap;

import jakarta.ws.rs.NotFoundException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ScopePermissionResource;
import org.keycloak.authorization.fgap.AdminPermissionsSchema;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopePermissionRepresentation;
import org.keycloak.representations.idm.authorization.UserPolicyRepresentation;
import org.keycloak.testframework.annotations.InjectUser;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.realm.ManagedUser;
import org.keycloak.tests.admin.authz.fgap.AbstractPermissionTest;

@KeycloakIntegrationTest
public class UserResourceTypePermissionTest
extends AbstractPermissionTest {
    @InjectUser(ref="alice", lifecycle=LifeCycle.METHOD)
    ManagedUser userAlice;
    @InjectUser(ref="bob")
    ManagedUser userBob;

    @BeforeEach
    public void onBefore() {
        for (int i = 0; i < 3; ++i) {
            UserPolicyRepresentation policy = new UserPolicyRepresentation();
            policy.setName("User Policy " + i);
            this.client.admin().authorization().policies().user().create(policy).close();
        }
    }

    @Test
    public void testCreateResourceTypePermission() {
        ScopePermissionRepresentation expected = this.createAllUserPermission();
        List result = UserResourceTypePermissionTest.getScopePermissionsResource(this.client).findAll(null, null, null, Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertEquals((int)1, (int)result.size());
        ScopePermissionRepresentation permissionRep = (ScopePermissionRepresentation)result.get(0);
        ScopePermissionResource permission = UserResourceTypePermissionTest.getScopePermissionsResource(this.client).findById(permissionRep.getId());
        Assertions.assertEquals((Object)expected.getName(), (Object)permissionRep.getName());
        Assertions.assertEquals((int)AdminPermissionsSchema.USERS.getScopes().size(), (int)permission.scopes().size());
        Assertions.assertEquals((int)3, (int)permission.associatedPolicies().size());
        Assertions.assertEquals((int)1, (int)permission.resources().size());
        Assertions.assertEquals((Object)"Users", (Object)((ResourceRepresentation)permission.resources().get(0)).getDisplayName());
    }

    @Test
    public void testCreateResourceObjectPermission() {
        ScopePermissionRepresentation expected = this.createUserPermission(this.userAlice);
        List result = UserResourceTypePermissionTest.getScopePermissionsResource(this.client).findAll(null, null, null, Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertEquals((int)1, (int)result.size());
        ScopePermissionRepresentation permissionRep = (ScopePermissionRepresentation)result.get(0);
        ScopePermissionResource permission = UserResourceTypePermissionTest.getScopePermissionsResource(this.client).findById(permissionRep.getId());
        Assertions.assertEquals((Object)expected.getName(), (Object)permissionRep.getName());
        Assertions.assertEquals((int)AdminPermissionsSchema.USERS.getScopes().size(), (int)permission.scopes().size());
        Assertions.assertEquals((int)3, (int)permission.associatedPolicies().size());
        Assertions.assertEquals((int)1, (int)permission.resources().size());
        Assertions.assertEquals((Object)this.userAlice.getUsername(), (Object)((ResourceRepresentation)permission.resources().get(0)).getDisplayName());
    }

    @Test
    public void testFindByResourceObject() {
        this.createUserPermission(this.userAlice, this.userBob);
        List existing = UserResourceTypePermissionTest.getScopePermissionsResource(this.client).findAll(null, null, this.userAlice.getId(), Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertEquals((int)1, (int)existing.size());
        existing = UserResourceTypePermissionTest.getScopePermissionsResource(this.client).findAll(null, null, this.userBob.getId(), Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertEquals((int)1, (int)existing.size());
    }

    @Test
    public void testDelete() {
        List resources = this.client.admin().authorization().resources().find(null, null, null, null, null, null, null);
        Assertions.assertEquals((int)AdminPermissionsSchema.SCHEMA.getResourceTypes().entrySet().size(), (int)resources.size());
        this.createUserPermission(this.userAlice);
        resources = this.client.admin().authorization().resources().find(null, null, null, null, null, null, null);
        Assertions.assertEquals((int)(1 + AdminPermissionsSchema.SCHEMA.getResourceTypes().entrySet().size()), (int)resources.size());
        this.createUserPermission(this.userBob);
        resources = this.client.admin().authorization().resources().find(null, null, null, null, null, null, null);
        Assertions.assertEquals((int)(2 + AdminPermissionsSchema.SCHEMA.getResourceTypes().entrySet().size()), (int)resources.size());
        List existing = UserResourceTypePermissionTest.getScopePermissionsResource(this.client).findAll(null, null, this.userAlice.getId(), Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertEquals((int)1, (int)existing.size());
        UserResourceTypePermissionTest.getScopePermissionsResource(this.client).findById(((ScopePermissionRepresentation)existing.get(0)).getId()).remove();
        existing = UserResourceTypePermissionTest.getScopePermissionsResource(this.client).findAll(null, null, this.userAlice.getId(), Integer.valueOf(-1), Integer.valueOf(-1));
        MatcherAssert.assertThat((Object)existing, (Matcher)Matchers.nullValue());
        existing = UserResourceTypePermissionTest.getScopePermissionsResource(this.client).findAll(null, null, this.userBob.getId(), Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertEquals((int)1, (int)existing.size());
        UserResourceTypePermissionTest.getScopePermissionsResource(this.client).findById(((ScopePermissionRepresentation)existing.get(0)).getId()).remove();
        resources = this.client.admin().authorization().resources().find(null, null, null, null, null, null, null);
        Assertions.assertEquals((int)AdminPermissionsSchema.SCHEMA.getResourceTypes().entrySet().size(), (int)resources.size());
    }

    @Test
    public void testUpdate() {
        this.createUserPermission(this.userAlice, this.userBob);
        List searchByResourceAlice = UserResourceTypePermissionTest.getScopePermissionsResource(this.client).findAll(null, null, this.userAlice.getId(), Integer.valueOf(-1), Integer.valueOf(-1));
        MatcherAssert.assertThat((Object)searchByResourceAlice, (Matcher)Matchers.hasSize((int)1));
        List searchByResourceBob = UserResourceTypePermissionTest.getScopePermissionsResource(this.client).findAll(null, null, this.userBob.getId(), Integer.valueOf(-1), Integer.valueOf(-1));
        MatcherAssert.assertThat((Object)searchByResourceBob, (Matcher)Matchers.hasSize((int)1));
        ScopePermissionRepresentation permission = (ScopePermissionRepresentation)searchByResourceAlice.get(0);
        MatcherAssert.assertThat((Object)permission.getId(), (Matcher)Matchers.equalTo((Object)((ScopePermissionRepresentation)searchByResourceBob.get(0)).getId()));
        List resources = this.getPolicies().policy(permission.getId()).resources();
        MatcherAssert.assertThat((Object)resources, (Matcher)Matchers.hasSize((int)2));
        ResourceRepresentation toRemove = (ResourceRepresentation)resources.get(1);
        resources.remove(toRemove);
        permission.setResources(resources.stream().map(ResourceRepresentation::getId).collect(Collectors.toSet()));
        UserResourceTypePermissionTest.getScopePermissionsResource(this.client).findById(permission.getId()).update(permission);
        MatcherAssert.assertThat((Object)this.getPolicies().policy(permission.getId()).resources(), (Matcher)Matchers.hasSize((int)1));
        try {
            this.client.admin().authorization().resources().resource(toRemove.getId()).toRepresentation();
            Assertions.fail((String)"Expected Exception wasn't thrown.");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(NotFoundException.class));
        }
    }

    @Test
    public void testUpdatePermissionResources() {
        AuthorizationResource authorization = this.client.admin().authorization();
        ScopePermissionRepresentation representation = this.createAllUserPermission();
        representation = UserResourceTypePermissionTest.getScopePermissionsResource(this.client).findByName(representation.getName());
        MatcherAssert.assertThat((Object)representation, (Matcher)Matchers.notNullValue());
        List resources = authorization.resources().resources();
        MatcherAssert.assertThat((Object)resources.size(), (Matcher)Matchers.is((Object)AdminPermissionsSchema.SCHEMA.getResourceTypes().size()));
        ScopePermissionResource permission = authorization.permissions().scope().findById(representation.getId());
        List permissionResources = permission.resources();
        MatcherAssert.assertThat((Object)permissionResources.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((ResourceRepresentation)permissionResources.get(0)).getName(), (Matcher)Matchers.is((Object)AdminPermissionsSchema.USERS.getType()));
        representation.setResources(Set.of(this.userAlice.getId()));
        permission.update(representation);
        resources = authorization.resources().resources();
        MatcherAssert.assertThat((Object)resources.size(), (Matcher)Matchers.is((Object)(AdminPermissionsSchema.SCHEMA.getResourceTypes().size() + 1)));
        permissionResources = permission.resources();
        MatcherAssert.assertThat((Object)permissionResources.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((ResourceRepresentation)permissionResources.get(0)).getName(), (Matcher)Matchers.is((Object)this.userAlice.getId()));
        representation.setResources(Set.of());
        permission.update(representation);
        resources = authorization.resources().resources();
        MatcherAssert.assertThat((Object)resources.size(), (Matcher)Matchers.is((Object)AdminPermissionsSchema.SCHEMA.getResourceTypes().size()));
        permissionResources = permission.resources();
        MatcherAssert.assertThat((Object)permissionResources.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((ResourceRepresentation)permissionResources.get(0)).getName(), (Matcher)Matchers.is((Object)AdminPermissionsSchema.USERS.getType()));
        representation.setResources(Set.of(this.userAlice.getId()));
        permission.update(representation);
        resources = authorization.resources().resources();
        MatcherAssert.assertThat((Object)resources.size(), (Matcher)Matchers.is((Object)(AdminPermissionsSchema.SCHEMA.getResourceTypes().size() + 1)));
        permissionResources = permission.resources();
        MatcherAssert.assertThat((Object)permissionResources.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((ResourceRepresentation)permissionResources.get(0)).getName(), (Matcher)Matchers.is((Object)this.userAlice.getId()));
        this.createUserPermission(this.userAlice, this.userBob);
        representation.setResources(Set.of());
        permission.update(representation);
        resources = authorization.resources().resources();
        MatcherAssert.assertThat((Object)resources.size(), (Matcher)Matchers.is((Object)(AdminPermissionsSchema.SCHEMA.getResourceTypes().size() + 2)));
        permissionResources = permission.resources();
        MatcherAssert.assertThat((Object)permissionResources.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((ResourceRepresentation)permissionResources.get(0)).getName(), (Matcher)Matchers.is((Object)AdminPermissionsSchema.USERS.getType()));
    }

    @Test
    public void testRemoveUser() {
        UserResourceTypePermissionTest.createUserPolicy(this.realm, this.client, "Only Alice or Bob User Policy", this.userAlice.getId(), this.userBob.getId());
        UserResourceTypePermissionTest.createUserPolicy(this.realm, this.client, "Only Alice User Policy", this.userAlice.getId());
        this.createUserPermission(this.userAlice, this.userBob);
        this.createUserPermission(this.userAlice);
        List policies = this.getPolicies().policies(null, "Only", "user", null, null, null, null, null, null, null);
        MatcherAssert.assertThat((Object)policies, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((String)((PolicyRepresentation)policies.get(0)).getConfig().get("users")), (Matcher)Matchers.containsString((String)this.userAlice.getId()));
        MatcherAssert.assertThat((Object)((String)((PolicyRepresentation)policies.get(1)).getConfig().get("users")), (Matcher)Matchers.containsString((String)this.userAlice.getId()));
        List permissions = UserResourceTypePermissionTest.getScopePermissionsResource(this.client).findAll(null, null, null, null, null);
        MatcherAssert.assertThat((Object)permissions, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(this.getPolicies().policy(((ScopePermissionRepresentation)permissions.get(0)).getId()).resources().stream().map(ResourceRepresentation::getName).collect(Collectors.toList()), (Matcher)Matchers.hasItem((Object)this.userAlice.getId()));
        MatcherAssert.assertThat(this.getPolicies().policy(((ScopePermissionRepresentation)permissions.get(1)).getId()).resources().stream().map(ResourceRepresentation::getName).collect(Collectors.toList()), (Matcher)Matchers.hasItem((Object)this.userAlice.getId()));
        this.realm.admin().users().get(this.userAlice.getId()).remove();
        UserPolicyRepresentation userPolicy = this.getPolicies().user().findByName("Only Alice or Bob User Policy");
        MatcherAssert.assertThat((Object)userPolicy, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)userPolicy.getUsers(), (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new String[]{this.userAlice.getId()})));
        UserPolicyRepresentation userPolicy1 = this.getPolicies().user().findByName("Only Alice User Policy");
        MatcherAssert.assertThat((Object)userPolicy1, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)userPolicy1.getUsers(), (Matcher)Matchers.empty());
        permissions = UserResourceTypePermissionTest.getScopePermissionsResource(this.client).findAll(null, null, null, null, null);
        MatcherAssert.assertThat((Object)permissions, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(this.getPolicies().policy(((ScopePermissionRepresentation)permissions.get(0)).getId()).resources().stream().map(ResourceRepresentation::getName).collect(Collectors.toList()), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)this.userAlice.getId())));
    }

    private ScopePermissionRepresentation createUserPermission(ManagedUser ... users) {
        ScopePermissionRepresentation permission = AbstractPermissionTest.PermissionBuilder.create().resourceType(AdminPermissionsSchema.USERS.getType()).resources(Arrays.stream(users).map(ManagedUser::getUsername).collect(Collectors.toSet())).scopes(AdminPermissionsSchema.USERS.getScopes()).addPolicies(List.of("User Policy 0", "User Policy 1", "User Policy 2")).build();
        UserResourceTypePermissionTest.createPermission(this.client, permission);
        return permission;
    }

    private ScopePermissionRepresentation createAllUserPermission() {
        ScopePermissionRepresentation permission = AbstractPermissionTest.PermissionBuilder.create().resourceType(AdminPermissionsSchema.USERS.getType()).scopes(AdminPermissionsSchema.USERS.getScopes()).addPolicies(List.of("User Policy 0", "User Policy 1", "User Policy 2")).build();
        UserResourceTypePermissionTest.createPermission(this.client, permission);
        return permission;
    }
}

