/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.client;

import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.keycloak.admin.client.resource.ClientScopesResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.testframework.annotations.InjectAdminEvents;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.events.AdminEvents;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.tests.utils.admin.AdminEventPaths;
import org.keycloak.tests.utils.admin.ApiUtil;
import org.keycloak.util.JsonSerialization;

@KeycloakIntegrationTest
public class AbstractClientScopeTest {
    @InjectRealm
    ManagedRealm managedRealm;
    @InjectAdminEvents
    AdminEvents adminEvents;

    void handleExpectedCreateFailure(ClientScopeRepresentation scopeRep, int expectedErrorCode, String expectedErrorMessage) {
        try (Response resp = this.clientScopes().create(scopeRep);){
            Assertions.assertEquals((int)expectedErrorCode, (int)resp.getStatus());
            String respBody = (String)resp.readEntity(String.class);
            try {
                Map responseJson = (Map)JsonSerialization.readValue((String)respBody, Map.class);
                Assertions.assertEquals((Object)expectedErrorMessage, responseJson.get("errorMessage"));
            }
            catch (IOException e) {
                Assertions.fail((String)"Failed to extract the errorMessage from a CreateScope Response");
            }
        }
    }

    ClientScopesResource clientScopes() {
        return this.managedRealm.admin().clientScopes();
    }

    String createClientScope(ClientScopeRepresentation clientScopeRep) {
        Response resp = this.clientScopes().create(clientScopeRep);
        String clientScopeId = ApiUtil.getCreatedId((Response)resp);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientScopeResourcePath((String)clientScopeId), (Object)clientScopeRep, (ResourceType)ResourceType.CLIENT_SCOPE);
        return clientScopeId;
    }

    String createClientScopeWithCleanup(ClientScopeRepresentation clientScopeRep) {
        String clientScopeId = this.createClientScope(clientScopeRep);
        this.managedRealm.cleanup().add(r -> r.clientScopes().get(clientScopeId).remove());
        return clientScopeId;
    }

    String createClientWithCleanup(ClientRepresentation clientRep) {
        Response resp = this.managedRealm.admin().clients().create(clientRep);
        String clientUuid = ApiUtil.getCreatedId((Response)resp);
        this.managedRealm.cleanup().add(r -> r.clients().get(clientUuid).remove());
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientResourcePath((String)clientUuid), (Object)clientRep, (ResourceType)ResourceType.CLIENT);
        return clientUuid;
    }
}

