/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.client;

import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.RealmConfig;
import org.keycloak.testframework.realm.RealmConfigBuilder;

public class AbstractClientSearchTest {
    @InjectRealm(config=ClientSearchRealmConfig.class)
    ManagedRealm testRealm;
    static final String CLIENT_ID_1 = "client1";
    static final String CLIENT_ID_2 = "client2";
    static final String CLIENT_ID_3 = "client3";
    static final String ATTR_ORG_NAME = "org";
    static final String ATTR_ORG_VAL = "Test_\"organisation\"";
    static final String ATTR_URL_NAME = "url";
    static final String ATTR_URL_VAL = "https://foo.bar/clflds";
    static final String ATTR_QUOTES_NAME = "test \"123\"";
    static final String ATTR_QUOTES_NAME_ESCAPED = "\"test \\\"123\\\"\"";
    static final String ATTR_QUOTES_VAL = "field=\"blah blah\"";
    static final String ATTR_QUOTES_VAL_ESCAPED = "\"field=\\\"blah blah\\\"\"";
    static final String ATTR_FILTERED_NAME = "filtered";
    static final String ATTR_FILTERED_VAL = "does_not_matter";

    void search(String searchQuery, String ... expectedClientIds) {
        List found = this.testRealm.admin().clients().query(searchQuery).stream().map(ClientRepresentation::getClientId).collect(Collectors.toList());
        MatcherAssert.assertThat(found, (Matcher)Matchers.containsInAnyOrder((Object[])expectedClientIds));
    }

    public static class ClientSearchRealmConfig
    implements RealmConfig {
        public RealmConfigBuilder configure(RealmConfigBuilder realm) {
            realm.addClient(AbstractClientSearchTest.CLIENT_ID_1).attribute(AbstractClientSearchTest.ATTR_ORG_NAME, AbstractClientSearchTest.ATTR_ORG_VAL).attribute(AbstractClientSearchTest.ATTR_URL_NAME, AbstractClientSearchTest.ATTR_URL_VAL);
            realm.addClient(AbstractClientSearchTest.CLIENT_ID_2).attribute(AbstractClientSearchTest.ATTR_URL_NAME, AbstractClientSearchTest.ATTR_URL_VAL).attribute(AbstractClientSearchTest.ATTR_FILTERED_NAME, AbstractClientSearchTest.ATTR_FILTERED_VAL);
            realm.addClient(AbstractClientSearchTest.CLIENT_ID_3).attribute(AbstractClientSearchTest.ATTR_ORG_NAME, "fake val").attribute(AbstractClientSearchTest.ATTR_QUOTES_NAME, AbstractClientSearchTest.ATTR_QUOTES_VAL);
            return realm;
        }
    }
}

