/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.client;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ProtocolMappersResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.testframework.annotations.InjectAdminClient;
import org.keycloak.testframework.annotations.InjectAdminEvents;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.events.AdminEvents;
import org.keycloak.util.JsonSerialization;

@KeycloakIntegrationTest
public abstract class AbstractProtocolMapperTest {
    @InjectAdminClient
    Keycloak adminClient;
    @InjectAdminEvents
    AdminEvents adminEvents;

    protected ProtocolMapperRepresentation makeMapper(String protocol, String name, String mapperType, Map<String, String> config) {
        ProtocolMapperRepresentation rep = new ProtocolMapperRepresentation();
        rep.setProtocol(protocol);
        rep.setName(name);
        rep.setProtocolMapper(mapperType);
        rep.setConfig(config);
        return rep;
    }

    protected ProtocolMapperRepresentation makeSamlMapper(String name) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("role", "account.view-profile");
        config.put("new.role.name", "new-role-name");
        return this.makeMapper("saml", name, "saml-role-name-mapper", config);
    }

    protected ProtocolMapperRepresentation makeOidcMapper(String name) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("role", "myrole");
        return this.makeMapper("openid-connect", name, "oidc-hardcoded-role-mapper", config);
    }

    protected void assertEqualMappers(ProtocolMapperRepresentation original, ProtocolMapperRepresentation created) {
        Assert.assertNotNull((Object)created);
        Assert.assertEquals((Object)original.getName(), (Object)created.getName());
        Assert.assertEquals((Object)original.getConfig(), (Object)created.getConfig());
        Assert.assertEquals((Object)original.getProtocol(), (Object)created.getProtocol());
        Assert.assertEquals((Object)original.getProtocolMapper(), (Object)created.getProtocolMapper());
    }

    protected boolean containsMapper(List<ProtocolMapperRepresentation> mappers, ProtocolMapperRepresentation mapper) {
        for (ProtocolMapperRepresentation listedMapper : mappers) {
            if (!listedMapper.getName().equals(mapper.getName())) continue;
            return true;
        }
        return false;
    }

    protected List<ProtocolMapperRepresentation> mappersToAdd(List<ProtocolMapperRepresentation> oldMappers, List<ProtocolMapperRepresentation> builtins) {
        ArrayList<ProtocolMapperRepresentation> mappersToAdd = new ArrayList<ProtocolMapperRepresentation>();
        for (ProtocolMapperRepresentation builtin : builtins) {
            if (this.containsMapper(oldMappers, builtin)) continue;
            mappersToAdd.add(builtin);
        }
        return mappersToAdd;
    }

    protected void testAddAllBuiltinMappers(ProtocolMappersResource resource, String protocolName, String adminEventPath) {
        List oldMappers = resource.getMappersPerProtocol(protocolName);
        List builtins = (List)this.adminClient.serverInfo().getInfo().getBuiltinProtocolMappers().get(protocolName);
        List<ProtocolMapperRepresentation> mappersToAdd = this.mappersToAdd(oldMappers, builtins);
        resource.createMapper(mappersToAdd);
        AdminEventRepresentation adminEvent = (AdminEventRepresentation)this.adminEvents.poll();
        AdminEventAssertion.assertEvent((AdminEventRepresentation)adminEvent, (OperationType)OperationType.CREATE, (String)(adminEventPath + "/add-models"), (ResourceType)ResourceType.PROTOCOL_MAPPER);
        try {
            List eventMappers = (List)JsonSerialization.readValue((InputStream)new ByteArrayInputStream(adminEvent.getRepresentation().getBytes()), (TypeReference)new TypeReference<List<ProtocolMapperRepresentation>>(){});
            Assertions.assertEquals((int)eventMappers.size(), (int)mappersToAdd.size());
            for (int i = 0; i < mappersToAdd.size(); ++i) {
                ProtocolMapperRepresentation repExpected = mappersToAdd.get(i);
                ProtocolMapperRepresentation repActual = (ProtocolMapperRepresentation)eventMappers.get(i);
                this.assertEqualMappers(repExpected, repActual);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        List newMappers = resource.getMappersPerProtocol(protocolName);
        Assert.assertEquals((long)(oldMappers.size() + mappersToAdd.size()), (long)newMappers.size());
        for (ProtocolMapperRepresentation rep : mappersToAdd) {
            Assert.assertTrue((boolean)this.containsMapper(newMappers, rep));
        }
    }
}

