/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.client;

import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.keycloak.admin.client.resource.ProtocolMappersResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.testframework.annotations.InjectClient;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.realm.ClientConfig;
import org.keycloak.testframework.realm.ClientConfigBuilder;
import org.keycloak.testframework.realm.ManagedClient;
import org.keycloak.testframework.util.ApiUtil;
import org.keycloak.tests.admin.client.AbstractProtocolMapperTest;
import org.keycloak.tests.utils.admin.AdminEventPaths;

@TestMethodOrder(value=MethodOrderer.MethodName.class)
@KeycloakIntegrationTest
public class ClientProtocolMapperTest
extends AbstractProtocolMapperTest {
    @InjectClient(config=OidcClient.class, ref="oidcClient")
    ManagedClient oidcClient;
    @InjectClient(config=SamlClient.class, ref="samlClient")
    ManagedClient samlClient;
    private ProtocolMappersResource oidcMappersRsc;
    private ProtocolMappersResource samlMappersRsc;

    @BeforeEach
    public void setProtocolMapperResources() {
        this.oidcMappersRsc = this.oidcClient.admin().getProtocolMappers();
        this.samlMappersRsc = this.samlClient.admin().getProtocolMappers();
    }

    @Test
    public void test01GetMappersList() {
        Assertions.assertTrue((boolean)this.oidcMappersRsc.getMappers().isEmpty());
        Assertions.assertTrue((boolean)this.samlMappersRsc.getMappers().isEmpty());
    }

    @Test
    public void test02CreateOidcMappersFromList() {
        this.testAddAllBuiltinMappers(this.oidcMappersRsc, "openid-connect", AdminEventPaths.clientProtocolMappersPath((String)this.oidcClient.getId()));
    }

    @Test
    public void test03CreateSamlMappersFromList() {
        this.testAddAllBuiltinMappers(this.samlMappersRsc, "saml", AdminEventPaths.clientProtocolMappersPath((String)this.samlClient.getId()));
    }

    @Test
    public void test04CreateSamlProtocolMapper() {
        ProtocolMapperRepresentation rep = this.makeSamlMapper("saml-role-name-mapper");
        int totalMappers = this.samlMappersRsc.getMappers().size();
        int totalSamlMappers = this.samlMappersRsc.getMappersPerProtocol("saml").size();
        Response resp = this.samlMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId((Response)resp);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientProtocolMapperPath((String)this.samlClient.getId(), (String)createdId), (Object)rep, (ResourceType)ResourceType.PROTOCOL_MAPPER);
        Assertions.assertEquals((int)(totalMappers + 1), (int)this.samlMappersRsc.getMappers().size());
        Assertions.assertEquals((int)(totalSamlMappers + 1), (int)this.samlMappersRsc.getMappersPerProtocol("saml").size());
        ProtocolMapperRepresentation created = this.samlMappersRsc.getMapperById(createdId);
        this.assertEqualMappers(rep, created);
    }

    @Test
    public void test05CreateOidcProtocolMapper() {
        ProtocolMapperRepresentation rep = this.makeOidcMapper("oidc-hardcoded-role-mapper");
        int totalMappers = this.oidcMappersRsc.getMappers().size();
        int totalOidcMappers = this.oidcMappersRsc.getMappersPerProtocol("openid-connect").size();
        Response resp = this.oidcMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId((Response)resp);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientProtocolMapperPath((String)this.oidcClient.getId(), (String)createdId), (Object)rep, (ResourceType)ResourceType.PROTOCOL_MAPPER);
        Assertions.assertEquals((int)(totalMappers + 1), (int)this.oidcMappersRsc.getMappers().size());
        Assertions.assertEquals((int)(totalOidcMappers + 1), (int)this.oidcMappersRsc.getMappersPerProtocol("openid-connect").size());
        ProtocolMapperRepresentation created = this.oidcMappersRsc.getMapperById(createdId);
        this.assertEqualMappers(rep, created);
    }

    @Test
    public void test06UpdateSamlMapper() {
        ProtocolMapperRepresentation rep = this.makeSamlMapper("saml-role-name-mapper2");
        Response resp = this.samlMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId((Response)resp);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientProtocolMapperPath((String)this.samlClient.getId(), (String)createdId), (Object)rep, (ResourceType)ResourceType.PROTOCOL_MAPPER);
        rep.getConfig().put("role", "account.manage-account");
        rep.setId(createdId);
        this.samlMappersRsc.update(createdId, rep);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.clientProtocolMapperPath((String)this.samlClient.getId(), (String)createdId), (Object)rep, (ResourceType)ResourceType.PROTOCOL_MAPPER);
        ProtocolMapperRepresentation updated = this.samlMappersRsc.getMapperById(createdId);
        this.assertEqualMappers(rep, updated);
    }

    @Test
    public void test07UpdateOidcMapper() {
        ProtocolMapperRepresentation rep = this.makeOidcMapper("oidc-hardcoded-role-mapper2");
        Response resp = this.oidcMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId((Response)resp);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientProtocolMapperPath((String)this.oidcClient.getId(), (String)createdId), (Object)rep, (ResourceType)ResourceType.PROTOCOL_MAPPER);
        rep.getConfig().put("role", "myotherrole");
        rep.setId(createdId);
        this.oidcMappersRsc.update(createdId, rep);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.clientProtocolMapperPath((String)this.oidcClient.getId(), (String)createdId), (Object)rep, (ResourceType)ResourceType.PROTOCOL_MAPPER);
        ProtocolMapperRepresentation updated = this.oidcMappersRsc.getMapperById(createdId);
        this.assertEqualMappers(rep, updated);
    }

    @Test
    public void test08DeleteSamlMapper() {
        ProtocolMapperRepresentation rep = this.makeSamlMapper("saml-role-name-mapper3");
        Response resp = this.samlMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId((Response)resp);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientProtocolMapperPath((String)this.samlClient.getId(), (String)createdId), (Object)rep, (ResourceType)ResourceType.PROTOCOL_MAPPER);
        this.samlMappersRsc.delete(createdId);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.clientProtocolMapperPath((String)this.samlClient.getId(), (String)createdId), (ResourceType)ResourceType.PROTOCOL_MAPPER);
        try {
            this.samlMappersRsc.getMapperById(createdId);
            Assertions.fail((String)"Not expected to find mapper");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void test09DeleteOidcMapper() {
        ProtocolMapperRepresentation rep = this.makeOidcMapper("oidc-hardcoded-role-mapper3");
        Response resp = this.oidcMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId((Response)resp);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientProtocolMapperPath((String)this.oidcClient.getId(), (String)createdId), (Object)rep, (ResourceType)ResourceType.PROTOCOL_MAPPER);
        this.oidcMappersRsc.delete(createdId);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.clientProtocolMapperPath((String)this.oidcClient.getId(), (String)createdId), (ResourceType)ResourceType.PROTOCOL_MAPPER);
        try {
            this.oidcMappersRsc.getMapperById(createdId);
            Assertions.fail((String)"Not expected to find mapper");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void test10EffectiveMappers() {
        ProtocolMapperRepresentation rep = this.makeMapper("openid-connect", "web-origins", "oidc-allowed-origins-mapper", Collections.emptyMap());
        Response resp = this.oidcMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId((Response)resp);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientProtocolMapperPath((String)this.oidcClient.getId(), (String)createdId), (Object)rep, (ResourceType)ResourceType.PROTOCOL_MAPPER);
        rep = this.oidcMappersRsc.getMapperById(createdId);
        Assertions.assertEquals((Object)"true", rep.getConfig().get("access.token.claim"));
        Assertions.assertEquals((Object)"true", rep.getConfig().get("introspection.token.claim"));
        rep.getConfig().remove("access.token.claim");
        rep.getConfig().remove("introspection.token.claim");
        this.oidcMappersRsc.update(createdId, rep);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.clientProtocolMapperPath((String)this.oidcClient.getId(), (String)createdId), (Object)rep, (ResourceType)ResourceType.PROTOCOL_MAPPER);
        rep = this.oidcMappersRsc.getMapperById(createdId);
        Assertions.assertEquals((Object)"true", rep.getConfig().get("access.token.claim"));
        Assertions.assertEquals((Object)"true", rep.getConfig().get("introspection.token.claim"));
        rep.getConfig().put("introspection.token.claim", "false");
        this.oidcMappersRsc.update(createdId, rep);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.clientProtocolMapperPath((String)this.oidcClient.getId(), (String)createdId), (Object)rep, (ResourceType)ResourceType.PROTOCOL_MAPPER);
        rep = this.oidcMappersRsc.getMapperById(createdId);
        Assertions.assertEquals((Object)"true", rep.getConfig().get("access.token.claim"));
        Assertions.assertEquals((Object)"false", rep.getConfig().get("introspection.token.claim"));
    }

    public static class SamlClient
    implements ClientConfig {
        public ClientConfigBuilder configure(ClientConfigBuilder client) {
            return client.clientId("samlMapperClient").name("samlMapperClient").protocol("saml");
        }
    }

    public static class OidcClient
    implements ClientConfig {
        public ClientConfigBuilder configure(ClientConfigBuilder client) {
            return client.clientId("oidcMapperClient").name("oidcMapperClient").protocol("openid-connect");
        }
    }
}

