/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.client;

import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RoleByIdResource;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AbstractUserRepresentation;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testframework.annotations.InjectAdminEvents;
import org.keycloak.testframework.annotations.InjectClient;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.events.AdminEvents;
import org.keycloak.testframework.realm.ClientConfig;
import org.keycloak.testframework.realm.ClientConfigBuilder;
import org.keycloak.testframework.realm.ManagedClient;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.RoleConfigBuilder;
import org.keycloak.tests.utils.Assert;
import org.keycloak.tests.utils.admin.AdminEventPaths;
import org.keycloak.tests.utils.admin.ApiUtil;

@KeycloakIntegrationTest
public class ClientRolesTest {
    @InjectRealm
    ManagedRealm managedRealm;
    @InjectAdminEvents
    AdminEvents adminEvents;
    @InjectClient(config=ClientRolesClientConfig.class)
    ManagedClient managedClient;
    private ClientResource clientRsc;
    private String clientDbId;
    private RolesResource rolesRsc;

    @BeforeEach
    public void init() {
        this.clientDbId = this.managedClient.getId();
        this.clientRsc = this.managedClient.admin();
        this.rolesRsc = this.clientRsc.roles();
    }

    private RoleRepresentation makeRole(String name) {
        return RoleConfigBuilder.create().name(name).build();
    }

    private boolean hasRole(RolesResource rolesRsc, String name) {
        for (RoleRepresentation role : rolesRsc.list()) {
            if (!role.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testAddRole() {
        RoleRepresentation role1 = RoleConfigBuilder.create().name("role1").description("role1-description").singleAttribute("role1-attr-key", "role1-attr-val").build();
        this.rolesRsc.create(role1);
        this.managedClient.cleanup().add(c -> c.roles().deleteRole("role1"));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientRoleResourcePath((String)this.clientDbId, (String)"role1"), (Object)role1, (ResourceType)ResourceType.CLIENT_ROLE);
        RoleRepresentation addedRole = this.rolesRsc.get(role1.getName()).toRepresentation();
        Assertions.assertEquals((Object)role1.getName(), (Object)addedRole.getName());
        Assertions.assertEquals((Object)role1.getDescription(), (Object)addedRole.getDescription());
        Assertions.assertEquals((Object)role1.getAttributes(), (Object)addedRole.getAttributes());
    }

    @Test
    public void createRoleWithSameName() {
        RoleRepresentation role = RoleConfigBuilder.create().name("role-a").build();
        this.rolesRsc.create(role);
        this.managedClient.cleanup().add(c -> c.roles().deleteRole("role-a"));
        Assertions.assertThrows(ClientErrorException.class, () -> this.rolesRsc.create(role), (String)"Client role with the same name is not allowed");
    }

    @Test
    public void createRoleWithNamePattern() {
        RoleRepresentation role = RoleConfigBuilder.create().name("role-a-{pattern}").build();
        this.rolesRsc.create(role);
        this.managedClient.cleanup().add(c -> c.roles().deleteRole("role-a-{pattern}"));
    }

    @Test
    public void testRemoveRole() {
        RoleRepresentation role2 = this.makeRole("role2");
        this.rolesRsc.create(role2);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientRoleResourcePath((String)this.clientDbId, (String)"role2"), (Object)role2, (ResourceType)ResourceType.CLIENT_ROLE);
        this.rolesRsc.deleteRole("role2");
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.clientRoleResourcePath((String)this.clientDbId, (String)"role2"), (ResourceType)ResourceType.CLIENT_ROLE);
        Assertions.assertFalse((boolean)this.hasRole(this.rolesRsc, "role2"));
    }

    @Test
    public void testComposites() {
        RoleRepresentation roleA = this.makeRole("role-a");
        this.rolesRsc.create(roleA);
        this.managedClient.cleanup().add(c -> c.roles().deleteRole("role-a"));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientRoleResourcePath((String)this.clientDbId, (String)"role-a"), (Object)roleA, (ResourceType)ResourceType.CLIENT_ROLE);
        Assertions.assertFalse((boolean)this.rolesRsc.get("role-a").toRepresentation().isComposite());
        Assertions.assertEquals((int)0, (int)this.rolesRsc.get("role-a").getRoleComposites().size());
        RoleRepresentation roleB = this.makeRole("role-b");
        this.rolesRsc.create(roleB);
        this.managedClient.cleanup().add(c -> c.roles().deleteRole("role-b"));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientRoleResourcePath((String)this.clientDbId, (String)"role-b"), (Object)roleB, (ResourceType)ResourceType.CLIENT_ROLE);
        RoleRepresentation roleC = this.makeRole("role-c");
        this.managedRealm.admin().roles().create(roleC);
        this.managedRealm.cleanup().add(r -> r.roles().deleteRole("role-c"));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.roleResourcePath((String)"role-c"), (Object)roleC, (ResourceType)ResourceType.REALM_ROLE);
        LinkedList<RoleRepresentation> l = new LinkedList<RoleRepresentation>();
        l.add(this.rolesRsc.get("role-b").toRepresentation());
        l.add(this.managedRealm.admin().roles().get("role-c").toRepresentation());
        this.rolesRsc.get("role-a").addComposites(l);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientRoleResourceCompositesPath((String)this.clientDbId, (String)"role-a"), l, (ResourceType)ResourceType.CLIENT_ROLE);
        Set composites = this.rolesRsc.get("role-a").getRoleComposites();
        Assertions.assertTrue((boolean)this.rolesRsc.get("role-a").toRepresentation().isComposite());
        Assert.assertNames((Set)composites, (String[])new String[]{"role-b", "role-c"});
        Set realmComposites = this.rolesRsc.get("role-a").getRealmRoleComposites();
        Assert.assertNames((Set)realmComposites, (String[])new String[]{"role-c"});
        Set clientComposites = this.rolesRsc.get("role-a").getClientRoleComposites(this.clientRsc.toRepresentation().getId());
        Assert.assertNames((Set)clientComposites, (String[])new String[]{"role-b"});
        this.rolesRsc.get("role-a").deleteComposites(l);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.clientRoleResourceCompositesPath((String)this.clientDbId, (String)"role-a"), l, (ResourceType)ResourceType.CLIENT_ROLE);
        Assertions.assertFalse((boolean)this.rolesRsc.get("role-a").toRepresentation().isComposite());
        Assertions.assertEquals((int)0, (int)this.rolesRsc.get("role-a").getRoleComposites().size());
    }

    @Test
    public void testCompositeRolesSearch() {
        RoleRepresentation mainRole = this.makeRole("main-role");
        this.rolesRsc.create(mainRole);
        this.managedClient.cleanup().add(c -> c.roles().deleteRole("main-role"));
        RoleResource mainRoleRsc = this.rolesRsc.get("main-role");
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientRoleResourcePath((String)this.clientDbId, (String)"main-role"), (Object)mainRole, (ResourceType)ResourceType.CLIENT_ROLE);
        List createdRoles = IntStream.range(0, 20).boxed().map(i -> this.makeRole("role" + i)).peek(arg_0 -> ((RolesResource)this.rolesRsc).create(arg_0)).peek(role -> this.managedClient.cleanup().add(c -> c.roles().deleteRole(role.getName()))).peek(role -> AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientRoleResourcePath((String)this.clientDbId, (String)role.getName()), (Object)role, (ResourceType)ResourceType.CLIENT_ROLE)).map(role -> this.rolesRsc.get(role.getName()).toRepresentation()).collect(Collectors.toList());
        mainRoleRsc.addComposites(createdRoles);
        mainRole = mainRoleRsc.toRepresentation();
        RoleByIdResource roleByIdResource = this.managedRealm.admin().rolesById();
        Set foundRoles = roleByIdResource.getRoleComposites(mainRole.getId());
        MatcherAssert.assertThat((Object)foundRoles, (Matcher)Matchers.hasSize((int)createdRoles.size()));
        foundRoles = roleByIdResource.searchRoleComposites(mainRole.getId(), null, Integer.valueOf(0), Integer.valueOf(10));
        MatcherAssert.assertThat((Object)foundRoles, (Matcher)Matchers.hasSize((int)10));
        foundRoles = roleByIdResource.searchRoleComposites(mainRole.getId(), "role1", null, null);
        MatcherAssert.assertThat((Object)foundRoles, (Matcher)Matchers.hasSize((int)11));
        foundRoles = roleByIdResource.searchRoleComposites(mainRole.getId(), "role1", Integer.valueOf(5), Integer.valueOf(5));
        MatcherAssert.assertThat((Object)foundRoles, (Matcher)Matchers.hasSize((int)5));
    }

    @Test
    public void usersInRole() {
        String clientID = this.managedClient.getId();
        String roleName = "test-role";
        RoleRepresentation role = this.makeRole(roleName);
        this.rolesRsc.create(role);
        this.managedClient.cleanup().add(c -> c.roles().deleteRole(roleName));
        Assertions.assertTrue((boolean)this.hasRole(this.rolesRsc, roleName));
        List<RoleRepresentation> roleToAdd = Collections.singletonList(this.rolesRsc.get(roleName).toRepresentation());
        List<String> usernames = ClientRolesTest.createUsernames(0, 10);
        usernames.forEach(username -> {
            UserRepresentation user = new UserRepresentation();
            user.setUsername(username);
            String userUuid = ApiUtil.getCreatedId((Response)this.managedRealm.admin().users().create(user));
            this.managedRealm.cleanup().add(r -> r.users().delete(userUuid));
            this.managedRealm.admin().users().get(userUuid).roles().clientLevel(clientID).add(roleToAdd);
        });
        RoleResource roleResource = this.rolesRsc.get(roleName);
        List usersInRole = roleResource.getUserMembers();
        Assertions.assertEquals(usernames, ClientRolesTest.extractUsernames(usersInRole));
        List usersInRole1 = roleResource.getUserMembers(Integer.valueOf(0), Integer.valueOf(5));
        Assertions.assertEquals(ClientRolesTest.createUsernames(0, 5), ClientRolesTest.extractUsernames(usersInRole1));
        Assertions.assertNotNull((Object)((UserRepresentation)usersInRole1.get(0)).getNotBefore(), (String)"Not in full representation");
        List usersInRole2 = roleResource.getUserMembers(Boolean.valueOf(true), Integer.valueOf(5), Integer.valueOf(10));
        Assertions.assertEquals(ClientRolesTest.createUsernames(5, 10), ClientRolesTest.extractUsernames(usersInRole2));
        Assert.assertNull((Object)((UserRepresentation)usersInRole2.get(0)).getNotBefore(), (String)"Not in brief representation");
    }

    private static List<String> createUsernames(int startIndex, int endIndex) {
        ArrayList<String> usernames = new ArrayList<String>();
        for (int i = startIndex; i < endIndex; ++i) {
            String userName = "user" + i;
            usernames.add(userName);
        }
        return usernames;
    }

    private static List<String> extractUsernames(Collection<UserRepresentation> users) {
        return users.stream().map(AbstractUserRepresentation::getUsername).collect(Collectors.toList());
    }

    @Test
    public void testSearchForRoles() {
        for (int i = 0; i < 15; ++i) {
            String roleName = "role" + i;
            RoleRepresentation role = this.makeRole(roleName);
            this.rolesRsc.create(role);
            this.managedClient.cleanup().add(c -> c.roles().deleteRole(roleName));
            AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientRoleResourcePath((String)this.clientDbId, (String)roleName), (Object)role, (ResourceType)ResourceType.CLIENT_ROLE);
        }
        String roleNameA = "abcdef";
        RoleRepresentation roleA = this.makeRole(roleNameA);
        this.rolesRsc.create(roleA);
        this.managedClient.cleanup().add(c -> c.roles().deleteRole(roleNameA));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientRoleResourcePath((String)this.clientDbId, (String)roleNameA), (Object)roleA, (ResourceType)ResourceType.CLIENT_ROLE);
        String roleNameB = "defghi";
        RoleRepresentation roleB = this.makeRole(roleNameB);
        this.rolesRsc.create(roleB);
        this.managedClient.cleanup().add(c -> c.roles().deleteRole(roleNameB));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientRoleResourcePath((String)this.clientDbId, (String)roleNameB), (Object)roleB, (ResourceType)ResourceType.CLIENT_ROLE);
        List resultSearch = this.rolesRsc.list("def", Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertEquals((int)2, (int)resultSearch.size());
        List resultSearch2 = this.rolesRsc.list("role", Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertEquals((int)15, (int)resultSearch2.size());
        List resultSearchPagination = this.rolesRsc.list("role", Integer.valueOf(1), Integer.valueOf(5));
        Assertions.assertEquals((int)5, (int)resultSearchPagination.size());
    }

    @Test
    public void testPaginationRoles() {
        for (int i = 0; i < 15; ++i) {
            String roleName = "role" + i;
            RoleRepresentation role = this.makeRole(roleName);
            this.rolesRsc.create(role);
            this.managedClient.cleanup().add(c -> c.roles().deleteRole(roleName));
            AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientRoleResourcePath((String)this.clientDbId, (String)roleName), (Object)role, (ResourceType)ResourceType.CLIENT_ROLE);
        }
        List resultSearchWithoutPagination = this.rolesRsc.list();
        Assertions.assertEquals((int)15, (int)resultSearchWithoutPagination.size());
        List resultSearchPagination = this.rolesRsc.list(Integer.valueOf(1), Integer.valueOf(5));
        Assertions.assertEquals((int)5, (int)resultSearchPagination.size());
        List resultSearchPaginationIncoherentParams = this.rolesRsc.list(Integer.valueOf(1), null);
        Assertions.assertTrue((resultSearchPaginationIncoherentParams.size() >= 15 ? 1 : 0) != 0);
    }

    @Test
    public void testPaginationRolesCache() {
        for (int i = 0; i < 5; ++i) {
            String roleName = "paginaterole" + i;
            RoleRepresentation role = this.makeRole(roleName);
            this.rolesRsc.create(role);
            this.managedClient.cleanup().add(c -> c.roles().deleteRole(roleName));
            AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientRoleResourcePath((String)this.clientDbId, (String)roleName), (Object)role, (ResourceType)ResourceType.CLIENT_ROLE);
        }
        List resultBeforeAddingRoleToTestCache = this.rolesRsc.list(Integer.valueOf(1), Integer.valueOf(1000));
        RoleRepresentation role = this.makeRole("anewrole");
        this.rolesRsc.create(role);
        this.managedClient.cleanup().add(c -> c.roles().deleteRole("anewrole"));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientRoleResourcePath((String)this.clientDbId, (String)"anewrole"), (Object)role, (ResourceType)ResourceType.CLIENT_ROLE);
        List resultAfterAddingRoleToTestCache = this.rolesRsc.list(Integer.valueOf(1), Integer.valueOf(1000));
        Assertions.assertEquals((int)(resultBeforeAddingRoleToTestCache.size() + 1), (int)resultAfterAddingRoleToTestCache.size());
    }

    @Test
    public void getRolesWithFullRepresentation() {
        for (int i = 0; i < 5; ++i) {
            String roleName = "attributesrole" + i;
            RoleRepresentation role2 = RoleConfigBuilder.create().name(roleName).attributes(Map.of("attribute1", List.of("value1", "value2"))).build();
            this.rolesRsc.create(role2);
            this.managedClient.cleanup().add(c -> c.roles().deleteRole(roleName));
            AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientRoleResourcePath((String)this.clientDbId, (String)roleName), (Object)role2, (ResourceType)ResourceType.CLIENT_ROLE);
        }
        List roles = this.rolesRsc.list(false);
        roles.forEach(role -> Assertions.assertTrue((boolean)role.getAttributes().containsKey("attribute1")));
    }

    @Test
    public void getRolesWithBriefRepresentation() {
        for (int i = 0; i < 5; ++i) {
            String roleName = "attributesrole" + i;
            RoleRepresentation role2 = RoleConfigBuilder.create().name(roleName).attributes(Map.of("attribute1", List.of("value1", "value2"))).build();
            this.rolesRsc.create(role2);
            this.managedClient.cleanup().add(c -> c.roles().deleteRole(roleName));
            AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientRoleResourcePath((String)this.clientDbId, (String)roleName), (Object)role2, (ResourceType)ResourceType.CLIENT_ROLE);
        }
        List roles = this.rolesRsc.list();
        roles.forEach(role -> Assertions.assertNull((Object)role.getAttributes()));
    }

    private static class ClientRolesClientConfig
    implements ClientConfig {
        private ClientRolesClientConfig() {
        }

        public ClientConfigBuilder configure(ClientConfigBuilder client) {
            return client.clientId("roleClient").name("roleClient").protocol("openid-connect");
        }
    }
}

