/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.client;

import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;
import org.keycloak.testframework.annotations.InjectClient;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.InjectUser;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.ManagedClient;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.ManagedUser;
import org.keycloak.testframework.realm.UserConfig;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.tests.utils.admin.ApiUtil;

@KeycloakIntegrationTest
public class ClientScopeEvaluateTest {
    @InjectRealm
    ManagedRealm managedRealm;
    @InjectUser(config=ClientScopeUserConfig.class)
    ManagedUser managedUser;
    @InjectClient
    ManagedClient managedClient;

    @Test
    public void testGenerateAccessToken() {
        AccessToken accessToken = this.managedClient.admin().clientScopesEvaluate().generateAccessToken("openid", this.managedUser.getId(), null);
        Assertions.assertNotNull((Object)accessToken);
        Assertions.assertNotNull((Object)accessToken.getSubject());
        Assertions.assertNotNull((Object)accessToken.getPreferredUsername());
        List sessions = this.managedClient.admin().getUserSessions(Integer.valueOf(0), Integer.valueOf(5));
        Assertions.assertEquals((int)0, (int)sessions.size());
    }

    @Test
    public void testGenerateIdToken() {
        IDToken idToken = this.managedClient.admin().clientScopesEvaluate().generateExampleIdToken("openid", this.managedUser.getId(), null);
        Assertions.assertNotNull((Object)idToken);
        Assertions.assertNotNull((Object)idToken.getSubject());
        Assertions.assertNotNull((Object)idToken.getPreferredUsername());
    }

    @Test
    public void testGenerateUserInfo() {
        Map userinfo = this.managedClient.admin().clientScopesEvaluate().generateExampleUserinfo("openid", this.managedUser.getId());
        Assertions.assertFalse((boolean)userinfo.isEmpty());
        Assertions.assertNotNull(userinfo.get("sub"));
        Assertions.assertNotNull(userinfo.get("preferred_username"));
    }

    @Test
    public void testGenerateAccessTokenWithoutBasicScope() {
        String basicScopeId = ApiUtil.findClientScopeByName((RealmResource)this.managedRealm.admin(), (String)"basic").toRepresentation().getId();
        this.managedClient.admin().removeDefaultClientScope(basicScopeId);
        AccessToken accessToken = this.managedClient.admin().clientScopesEvaluate().generateAccessToken("openid", this.managedUser.getId(), null);
        Assertions.assertNotNull((Object)accessToken);
        Assertions.assertNull((Object)accessToken.getSubject());
        this.managedClient.admin().addDefaultClientScope(basicScopeId);
    }

    @Test
    public void testGenerateAccessTokenWithOptionalScope() {
        String emailScopeId = ApiUtil.findClientScopeByName((RealmResource)this.managedRealm.admin(), (String)"email").toRepresentation().getId();
        this.managedClient.admin().removeDefaultClientScope(emailScopeId);
        this.managedClient.admin().addOptionalClientScope(emailScopeId);
        AccessToken accessToken = this.managedClient.admin().clientScopesEvaluate().generateAccessToken("openid", this.managedUser.getId(), null);
        Assertions.assertNotNull((Object)accessToken);
        Assertions.assertNull((Object)accessToken.getEmail());
        accessToken = this.managedClient.admin().clientScopesEvaluate().generateAccessToken("openid email", this.managedUser.getId(), null);
        Assertions.assertNotNull((Object)accessToken);
        Assertions.assertNotNull((Object)accessToken.getEmail());
        this.managedClient.admin().removeOptionalClientScope(emailScopeId);
        this.managedClient.admin().addDefaultClientScope(emailScopeId);
    }

    private static class ClientScopeUserConfig
    implements UserConfig {
        private ClientScopeUserConfig() {
        }

        public UserConfigBuilder configure(UserConfigBuilder config) {
            return config.username("test-user").name("Test", "User").email("test@user.com").emailVerified(true);
        }
    }
}

