/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.client;

import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.ClientScopeResource;
import org.keycloak.admin.client.resource.ClientScopesResource;
import org.keycloak.admin.client.resource.ProtocolMappersResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.tests.admin.client.AbstractProtocolMapperTest;
import org.keycloak.tests.utils.admin.AdminEventPaths;
import org.keycloak.tests.utils.admin.ApiUtil;

@KeycloakIntegrationTest
public class ClientScopeProtocolMapperTest
extends AbstractProtocolMapperTest {
    @InjectRealm
    ManagedRealm managedRealm;
    private String oidcClientScopeId;
    private ProtocolMappersResource oidcMappersRsc;
    private String samlClientScopeId;
    private ProtocolMappersResource samlMappersRsc;

    @BeforeEach
    public void init() {
        this.oidcClientScopeId = this.createClientScope("oidcMapperClient-scope", "openid-connect");
        this.oidcMappersRsc = this.clientScopes().get(this.oidcClientScopeId).getProtocolMappers();
        this.samlClientScopeId = this.createClientScope("samlMapperClient-scope", "saml");
        this.samlMappersRsc = this.clientScopes().get(this.samlClientScopeId).getProtocolMappers();
    }

    @AfterEach
    public void tearDown() {
        this.removeClientScope(this.oidcClientScopeId);
        this.removeClientScope(this.samlClientScopeId);
    }

    @Test
    public void test01GetMappersList() {
        Assertions.assertTrue((boolean)this.oidcMappersRsc.getMappers().isEmpty());
        Assertions.assertTrue((boolean)this.samlMappersRsc.getMappers().isEmpty());
    }

    @Test
    public void test02CreateOidcMappersFromList() {
        this.testAddAllBuiltinMappers(this.oidcMappersRsc, "openid-connect", AdminEventPaths.clientScopeProtocolMappersPath((String)this.oidcClientScopeId));
    }

    @Test
    public void test03CreateSamlMappersFromList() {
        this.testAddAllBuiltinMappers(this.samlMappersRsc, "saml", AdminEventPaths.clientScopeProtocolMappersPath((String)this.samlClientScopeId));
    }

    @Test
    public void test04CreateSamlProtocolMapper() {
        ProtocolMapperRepresentation rep = this.makeSamlMapper("saml-role-name-mapper");
        int totalMappers = this.samlMappersRsc.getMappers().size();
        int totalSamlMappers = this.samlMappersRsc.getMappersPerProtocol("saml").size();
        Response resp = this.samlMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId((Response)resp);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientScopeProtocolMapperPath((String)this.samlClientScopeId, (String)createdId), (Object)rep, (ResourceType)ResourceType.PROTOCOL_MAPPER);
        Assertions.assertEquals((int)(totalMappers + 1), (int)this.samlMappersRsc.getMappers().size());
        Assertions.assertEquals((int)(totalSamlMappers + 1), (int)this.samlMappersRsc.getMappersPerProtocol("saml").size());
        ProtocolMapperRepresentation created = this.samlMappersRsc.getMapperById(createdId);
        this.assertEqualMappers(rep, created);
    }

    @Test
    public void test05CreateOidcProtocolMapper() {
        ProtocolMapperRepresentation rep = this.makeOidcMapper("oidc-hardcoded-role-mapper");
        int totalMappers = this.oidcMappersRsc.getMappers().size();
        int totalOidcMappers = this.oidcMappersRsc.getMappersPerProtocol("openid-connect").size();
        Response resp = this.oidcMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId((Response)resp);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientScopeProtocolMapperPath((String)this.oidcClientScopeId, (String)createdId), (Object)rep, (ResourceType)ResourceType.PROTOCOL_MAPPER);
        Assertions.assertEquals((int)(totalMappers + 1), (int)this.oidcMappersRsc.getMappers().size());
        Assertions.assertEquals((int)(totalOidcMappers + 1), (int)this.oidcMappersRsc.getMappersPerProtocol("openid-connect").size());
        ProtocolMapperRepresentation created = this.oidcMappersRsc.getMapperById(createdId);
        this.assertEqualMappers(rep, created);
    }

    @Test
    public void test06UpdateSamlMapper() {
        ProtocolMapperRepresentation rep = this.makeSamlMapper("saml-role-name-mapper2");
        Response resp = this.samlMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId((Response)resp);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientScopeProtocolMapperPath((String)this.samlClientScopeId, (String)createdId), (Object)rep, (ResourceType)ResourceType.PROTOCOL_MAPPER);
        rep.getConfig().put("role", "account.manage-account");
        rep.setId(createdId);
        this.samlMappersRsc.update(createdId, rep);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.clientScopeProtocolMapperPath((String)this.samlClientScopeId, (String)createdId), (Object)rep, (ResourceType)ResourceType.PROTOCOL_MAPPER);
        ProtocolMapperRepresentation updated = this.samlMappersRsc.getMapperById(createdId);
        this.assertEqualMappers(rep, updated);
    }

    @Test
    public void test07UpdateOidcMapper() {
        ProtocolMapperRepresentation rep = this.makeOidcMapper("oidc-hardcoded-role-mapper2");
        Response resp = this.oidcMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId((Response)resp);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientScopeProtocolMapperPath((String)this.oidcClientScopeId, (String)createdId), (Object)rep, (ResourceType)ResourceType.PROTOCOL_MAPPER);
        rep.getConfig().put("role", "myotherrole");
        rep.setId(createdId);
        this.oidcMappersRsc.update(createdId, rep);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.clientScopeProtocolMapperPath((String)this.oidcClientScopeId, (String)createdId), (Object)rep, (ResourceType)ResourceType.PROTOCOL_MAPPER);
        ProtocolMapperRepresentation updated = this.oidcMappersRsc.getMapperById(createdId);
        this.assertEqualMappers(rep, updated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test08EffectiveMappers() {
        ClientScopeResource rolesScope = ApiUtil.findClientScopeByName((RealmResource)this.managedRealm.admin(), (String)"roles");
        Assertions.assertNotNull((Object)rolesScope);
        List mappers = rolesScope.getProtocolMappers().getMappers();
        ProtocolMapperRepresentation audienceMapper = mappers.stream().filter(mapper -> mapper.getProtocol().equals("openid-connect") && mapper.getName().equals("audience resolve")).findFirst().orElseThrow();
        String clientScopeID = rolesScope.toRepresentation().getId();
        String protocolMapperId = audienceMapper.getId();
        Map origConfig = audienceMapper.getConfig();
        try {
            Assertions.assertEquals((Object)"true", audienceMapper.getConfig().get("access.token.claim"));
            Assertions.assertEquals((Object)"true", audienceMapper.getConfig().get("introspection.token.claim"));
            audienceMapper.getConfig().remove("access.token.claim");
            audienceMapper.getConfig().remove("introspection.token.claim");
            rolesScope.getProtocolMappers().update(protocolMapperId, audienceMapper);
            AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.clientScopeProtocolMapperPath((String)clientScopeID, (String)protocolMapperId), (Object)audienceMapper, (ResourceType)ResourceType.PROTOCOL_MAPPER);
            audienceMapper = rolesScope.getProtocolMappers().getMapperById(protocolMapperId);
            Assertions.assertEquals((Object)"true", audienceMapper.getConfig().get("access.token.claim"));
            Assertions.assertEquals((Object)"true", audienceMapper.getConfig().get("introspection.token.claim"));
            audienceMapper.getConfig().put("introspection.token.claim", "false");
            rolesScope.getProtocolMappers().update(protocolMapperId, audienceMapper);
            AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.clientScopeProtocolMapperPath((String)clientScopeID, (String)protocolMapperId), (Object)audienceMapper, (ResourceType)ResourceType.PROTOCOL_MAPPER);
            audienceMapper = rolesScope.getProtocolMappers().getMapperById(protocolMapperId);
            Assertions.assertEquals((Object)"true", audienceMapper.getConfig().get("access.token.claim"));
            Assertions.assertEquals((Object)"false", audienceMapper.getConfig().get("introspection.token.claim"));
        }
        finally {
            audienceMapper.getConfig().putAll(origConfig);
            rolesScope.getProtocolMappers().update(protocolMapperId, audienceMapper);
            AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.clientScopeProtocolMapperPath((String)clientScopeID, (String)protocolMapperId), (Object)audienceMapper, (ResourceType)ResourceType.PROTOCOL_MAPPER);
        }
    }

    @Test
    public void testDeleteSamlMapper() {
        ProtocolMapperRepresentation rep = this.makeSamlMapper("saml-role-name-mapper3");
        Response resp = this.samlMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId((Response)resp);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientScopeProtocolMapperPath((String)this.samlClientScopeId, (String)createdId), (Object)rep, (ResourceType)ResourceType.PROTOCOL_MAPPER);
        this.samlMappersRsc.delete(createdId);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.clientScopeProtocolMapperPath((String)this.samlClientScopeId, (String)createdId), (ResourceType)ResourceType.PROTOCOL_MAPPER);
        try {
            this.samlMappersRsc.getMapperById(createdId);
            Assertions.fail((String)"Not expected to find mapper");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteOidcMapper() {
        ProtocolMapperRepresentation rep = this.makeOidcMapper("oidc-hardcoded-role-mapper3");
        Response resp = this.oidcMappersRsc.createMapper(rep);
        resp.close();
        String createdId = ApiUtil.getCreatedId((Response)resp);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientScopeProtocolMapperPath((String)this.oidcClientScopeId, (String)createdId), (Object)rep, (ResourceType)ResourceType.PROTOCOL_MAPPER);
        this.oidcMappersRsc.delete(createdId);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.clientScopeProtocolMapperPath((String)this.oidcClientScopeId, (String)createdId), (ResourceType)ResourceType.PROTOCOL_MAPPER);
        try {
            this.oidcMappersRsc.getMapperById(createdId);
            Assertions.fail((String)"Not expected to find mapper");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private ClientScopesResource clientScopes() {
        return this.managedRealm.admin().clientScopes();
    }

    private String createClientScope(String clientScopeName, String protocol) {
        ClientScopeRepresentation rep = new ClientScopeRepresentation();
        rep.setName(clientScopeName);
        rep.setProtocol(protocol);
        Response resp = this.clientScopes().create(rep);
        String scopeId = ApiUtil.getCreatedId((Response)resp);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientScopeResourcePath((String)scopeId), (Object)rep, (ResourceType)ResourceType.CLIENT_SCOPE);
        return scopeId;
    }

    private void removeClientScope(String clientScopeId) {
        this.clientScopes().get(clientScopeId).remove();
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.clientScopeResourcePath((String)clientScopeId), (ResourceType)ResourceType.CLIENT_SCOPE);
    }
}

