/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.client;

import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ProtocolMappersResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleMappingResource;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.ClientMappingsRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.representations.idm.MappingsRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.RoleConfigBuilder;
import org.keycloak.tests.admin.client.AbstractClientScopeTest;
import org.keycloak.tests.utils.Assert;
import org.keycloak.tests.utils.admin.AdminEventPaths;
import org.keycloak.tests.utils.admin.ApiUtil;
import org.keycloak.tests.utils.matchers.Matchers;

@KeycloakIntegrationTest
public class ClientScopeTest
extends AbstractClientScopeTest {
    @Test
    public void testAddFailureWithInvalidScopeName() {
        ErrorRepresentation error;
        ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("\u30de\u30eb\u30c1\u30d0\u30a4\u30c8");
        try (Response response = this.clientScopes().create(scopeRep);){
            Assertions.assertEquals((int)400, (int)response.getStatus());
            error = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
        }
        Assertions.assertEquals((Object)"Unexpected name \"\u30de\u30eb\u30c1\u30d0\u30a4\u30c8\" for ClientScope", (Object)error.getErrorMessage());
    }

    @Test
    public void testUpdateFailureWithInvalidScopeName() {
        ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("scope1");
        scopeRep.setProtocol("openid-connect");
        String scope1Id = this.createClientScopeWithCleanup(scopeRep);
        scopeRep = this.clientScopes().get(scope1Id).toRepresentation();
        Assertions.assertEquals((Object)"scope1", (Object)scopeRep.getName());
        scopeRep.setName("\u30de\u30eb\u30c1\u30d0\u30a4\u30c8");
        try {
            this.clientScopes().get(scope1Id).update(scopeRep);
        }
        catch (ClientErrorException e) {
            ErrorRepresentation error;
            try (Response response = e.getResponse();){
                Assertions.assertEquals((int)400, (int)response.getStatus());
                error = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
            }
            Assertions.assertEquals((Object)"Unexpected name \"\u30de\u30eb\u30c1\u30d0\u30a4\u30c8\" for ClientScope", (Object)error.getErrorMessage());
        }
    }

    @Test
    public void testAddDuplicatedClientScope() {
        ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("scope1");
        scopeRep.setProtocol("openid-connect");
        this.createClientScopeWithCleanup(scopeRep);
        scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("scope1");
        scopeRep.setProtocol("openid-connect");
        Response response = this.clientScopes().create(scopeRep);
        Assertions.assertEquals((int)409, (int)response.getStatus());
        ErrorRepresentation error = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
        Assertions.assertEquals((Object)"Client Scope scope1 already exists", (Object)error.getErrorMessage());
        response.close();
    }

    @Test
    public void testGetUnknownScope() {
        String unknownId = UUID.randomUUID().toString();
        Assertions.assertThrows(NotFoundException.class, () -> this.clientScopes().get(unknownId).toRepresentation());
    }

    private List<String> getClientScopeNames(List<ClientScopeRepresentation> scopes) {
        return scopes.stream().map(ClientScopeRepresentation::getName).collect(Collectors.toList());
    }

    @Test
    public void testRemoveClientScope() {
        ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("scope1");
        scopeRep.setProtocol("openid-connect");
        String scope1Id = this.createClientScope(scopeRep);
        List clientScopes = this.clientScopes().findAll();
        Assertions.assertTrue((boolean)this.getClientScopeNames(clientScopes).contains("scope1"));
        scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("scope2");
        scopeRep.setProtocol("openid-connect");
        String scope2Id = this.createClientScope(scopeRep);
        clientScopes = this.clientScopes().findAll();
        Assertions.assertTrue((boolean)this.getClientScopeNames(clientScopes).contains("scope2"));
        this.removeClientScope(scope1Id);
        clientScopes = this.clientScopes().findAll();
        Assertions.assertFalse((boolean)this.getClientScopeNames(clientScopes).contains("scope1"));
        Assertions.assertTrue((boolean)this.getClientScopeNames(clientScopes).contains("scope2"));
        this.removeClientScope(scope2Id);
        clientScopes = this.clientScopes().findAll();
        Assertions.assertFalse((boolean)this.getClientScopeNames(clientScopes).contains("scope1"));
        Assertions.assertFalse((boolean)this.getClientScopeNames(clientScopes).contains("scope2"));
    }

    @Test
    public void testUpdateScopeScope() {
        ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("scope1");
        scopeRep.setDescription("scope1-desc");
        scopeRep.setProtocol("openid-connect");
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("someAttr", "someAttrValue");
        attrs.put("emptyAttr", "");
        scopeRep.setAttributes(attrs);
        String scope1Id = this.createClientScopeWithCleanup(scopeRep);
        scopeRep = this.clientScopes().get(scope1Id).toRepresentation();
        Assertions.assertEquals((Object)"scope1", (Object)scopeRep.getName());
        Assertions.assertEquals((Object)"scope1-desc", (Object)scopeRep.getDescription());
        Assertions.assertEquals((Object)"someAttrValue", scopeRep.getAttributes().get("someAttr"));
        Assertions.assertTrue((boolean)ObjectUtil.isBlank((CharSequence)((CharSequence)scopeRep.getAttributes().get("emptyAttr"))));
        Assertions.assertEquals((Object)"openid-connect", (Object)scopeRep.getProtocol());
        scopeRep.setName("scope1-updated");
        scopeRep.setDescription("scope1-desc-updated");
        scopeRep.setProtocol("saml");
        scopeRep.getAttributes().put("emptyAttr", "someValue");
        this.clientScopes().get(scope1Id).update(scopeRep);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.clientScopeResourcePath((String)scope1Id), (Object)scopeRep, (ResourceType)ResourceType.CLIENT_SCOPE);
        scopeRep = this.clientScopes().get(scope1Id).toRepresentation();
        Assertions.assertEquals((Object)"scope1-updated", (Object)scopeRep.getName());
        Assertions.assertEquals((Object)"scope1-desc-updated", (Object)scopeRep.getDescription());
        Assertions.assertEquals((Object)"saml", (Object)scopeRep.getProtocol());
        Assertions.assertEquals((Object)"someAttrValue", scopeRep.getAttributes().get("someAttr"));
        Assertions.assertEquals((Object)"someValue", scopeRep.getAttributes().get("emptyAttr"));
    }

    @Test
    public void testRenameScope() {
        ClientScopeRepresentation scope1Rep = new ClientScopeRepresentation();
        scope1Rep.setName("scope1");
        scope1Rep.setDescription("scope1-desc");
        scope1Rep.setProtocol("openid-connect");
        String scope1Id = this.createClientScopeWithCleanup(scope1Rep);
        ClientScopeRepresentation scope2Rep = new ClientScopeRepresentation();
        scope2Rep.setName("scope2");
        scope2Rep.setDescription("scope2-desc");
        scope2Rep.setProtocol("openid-connect");
        String scope2Id = this.createClientScopeWithCleanup(scope2Rep);
        scope2Rep.setName("scope1");
        try {
            this.clientScopes().get(scope2Id).update(scope2Rep);
        }
        catch (ClientErrorException ex) {
            MatcherAssert.assertThat((Object)ex.getResponse(), (Matcher)Matchers.statusCodeIs((Response.Status)Response.Status.CONFLICT));
        }
    }

    @Test
    public void testScopes() {
        RoleRepresentation realmCompositeRole = this.createRealmRoleWithCleanup("realm-composite");
        RoleRepresentation realmChildRole = this.createRealmRoleWithCleanup("realm-child");
        this.managedRealm.admin().roles().get("realm-composite").addComposites(Collections.singletonList(realmChildRole));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.roleResourceCompositesPath((String)"realm-composite"), Collections.singletonList(realmChildRole), (ResourceType)ResourceType.REALM_ROLE);
        ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("bar-scope");
        scopeRep.setProtocol("openid-connect");
        String scopeId = this.createClientScopeWithCleanup(scopeRep);
        String accountMgmtId = ((ClientRepresentation)this.managedRealm.admin().clients().findByClientId("account").get(0)).getId();
        RoleRepresentation viewAccountRoleRep = this.managedRealm.admin().clients().get(accountMgmtId).roles().get("view-profile").toRepresentation();
        RoleMappingResource scopesResource = this.clientScopes().get(scopeId).getScopeMappings();
        scopesResource.realmLevel().add(Collections.singletonList(realmCompositeRole));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientScopeRoleMappingsRealmLevelPath((String)scopeId), Collections.singletonList(realmCompositeRole), (ResourceType)ResourceType.REALM_SCOPE_MAPPING);
        scopesResource.clientLevel(accountMgmtId).add(Collections.singletonList(viewAccountRoleRep));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientScopeRoleMappingsClientLevelPath((String)scopeId, (String)accountMgmtId), Collections.singletonList(viewAccountRoleRep), (ResourceType)ResourceType.CLIENT_SCOPE_MAPPING);
        List allRealm = scopesResource.realmLevel().listAll();
        List availableRealm = scopesResource.realmLevel().listAvailable();
        List effectiveRealm = scopesResource.realmLevel().listEffective();
        List accountRoles = scopesResource.clientLevel(accountMgmtId).listAll();
        Assert.assertNames((List)allRealm, (String[])new String[]{"realm-composite"});
        Assert.assertNames((List)availableRealm, (String[])new String[]{"realm-child", "offline_access", "uma_authorization", "default-roles-default"});
        Assert.assertNames((List)effectiveRealm, (String[])new String[]{"realm-composite", "realm-child"});
        Assert.assertNames((List)accountRoles, (String[])new String[]{"view-profile"});
        MappingsRepresentation mappingsRep = this.clientScopes().get(scopeId).getScopeMappings().getAll();
        Assert.assertNames((List)mappingsRep.getRealmMappings(), (String[])new String[]{"realm-composite"});
        Assert.assertNames((List)((ClientMappingsRepresentation)mappingsRep.getClientMappings().get("account")).getMappings(), (String[])new String[]{"view-profile"});
        scopesResource.realmLevel().remove(Collections.singletonList(realmCompositeRole));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.clientScopeRoleMappingsRealmLevelPath((String)scopeId), Collections.singletonList(realmCompositeRole), (ResourceType)ResourceType.REALM_SCOPE_MAPPING);
        scopesResource.clientLevel(accountMgmtId).remove(Collections.singletonList(viewAccountRoleRep));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.clientScopeRoleMappingsClientLevelPath((String)scopeId, (String)accountMgmtId), Collections.singletonList(viewAccountRoleRep), (ResourceType)ResourceType.CLIENT_SCOPE_MAPPING);
        allRealm = scopesResource.realmLevel().listAll();
        availableRealm = scopesResource.realmLevel().listAvailable();
        effectiveRealm = scopesResource.realmLevel().listEffective();
        accountRoles = scopesResource.clientLevel(accountMgmtId).listAll();
        Assert.assertNames((List)allRealm, (String[])new String[0]);
        Assert.assertNames((List)availableRealm, (String[])new String[]{"realm-composite", "realm-child", "offline_access", "uma_authorization", "default-roles-default"});
        Assert.assertNames((List)effectiveRealm, (String[])new String[0]);
        Assert.assertNames((List)accountRoles, (String[])new String[0]);
    }

    @Test
    public void rolesCanBeAddedToScopeEvenWhenTheyAreAlreadyIndirectlyAssigned() {
        RealmResource realm = this.managedRealm.admin();
        ClientScopeRepresentation clientScopeRep = new ClientScopeRepresentation();
        clientScopeRep.setName("my-scope");
        clientScopeRep.setProtocol("openid-connect");
        String clientScopeId = this.createClientScopeWithCleanup(clientScopeRep);
        this.createRealmRoleWithCleanup("realm-composite");
        this.createRealmRoleWithCleanup("realm-child");
        realm.roles().get("realm-composite").addComposites(Collections.singletonList(realm.roles().get("realm-child").toRepresentation()));
        AdminEventAssertion.assertSuccess((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll())).operationType(OperationType.CREATE).resourceType(ResourceType.REALM_ROLE);
        ClientRepresentation clientRep = new ClientRepresentation();
        clientRep.setClientId("role-container-client");
        this.createClientWithCleanup(clientRep);
        String roleContainerClientUuid = ((ClientRepresentation)realm.clients().findByClientId("role-container-client").stream().findFirst().orElseThrow()).getId();
        ClientResource roleContainerClient = realm.clients().get(roleContainerClientUuid);
        RoleRepresentation clientCompositeRole = RoleConfigBuilder.create().name("client-composite").build();
        roleContainerClient.roles().create(clientCompositeRole);
        roleContainerClient.roles().create(RoleConfigBuilder.create().name("client-child").build());
        roleContainerClient.roles().get("client-composite").addComposites(Collections.singletonList(roleContainerClient.roles().get("client-child").toRepresentation()));
        RoleMappingResource scopesResource = realm.clientScopes().get(clientScopeId).getScopeMappings();
        scopesResource.realmLevel().add(Collections.singletonList(realm.roles().get("realm-composite").toRepresentation()));
        scopesResource.clientLevel(roleContainerClientUuid).add(Collections.singletonList(realm.clients().get(roleContainerClientUuid).roles().get("client-composite").toRepresentation()));
        Assert.assertNames((List)scopesResource.realmLevel().listAll(), (String[])new String[]{"realm-composite"});
        Assert.assertNames((List)scopesResource.realmLevel().listAvailable(), (String[])new String[]{"realm-child", "offline_access", "uma_authorization", "default-roles-default"});
        Assert.assertNames((List)scopesResource.realmLevel().listEffective(), (String[])new String[]{"realm-composite", "realm-child"});
        Assert.assertNames((List)scopesResource.clientLevel(roleContainerClientUuid).listAll(), (String[])new String[]{"client-composite"});
        Assert.assertNames((List)scopesResource.clientLevel(roleContainerClientUuid).listAvailable(), (String[])new String[]{"client-child"});
        Assert.assertNames((List)scopesResource.clientLevel(roleContainerClientUuid).listEffective(), (String[])new String[]{"client-composite", "client-child"});
        scopesResource.realmLevel().add(Collections.singletonList(realm.roles().get("realm-child").toRepresentation()));
        scopesResource.clientLevel(roleContainerClientUuid).add(Collections.singletonList(realm.clients().get(roleContainerClientUuid).roles().get("client-child").toRepresentation()));
        Assert.assertNames((List)scopesResource.realmLevel().listAll(), (String[])new String[]{"realm-composite", "realm-child"});
        Assert.assertNames((List)scopesResource.realmLevel().listAvailable(), (String[])new String[]{"offline_access", "uma_authorization", "default-roles-default"});
        Assert.assertNames((List)scopesResource.realmLevel().listEffective(), (String[])new String[]{"realm-composite", "realm-child"});
        Assert.assertNames((List)scopesResource.clientLevel(roleContainerClientUuid).listAll(), (String[])new String[]{"client-composite", "client-child"});
        Assert.assertNames((List)scopesResource.clientLevel(roleContainerClientUuid).listAvailable(), (String[])new String[0]);
        Assert.assertNames((List)scopesResource.clientLevel(roleContainerClientUuid).listEffective(), (String[])new String[]{"client-composite", "client-child"});
    }

    @Test
    public void testRemoveScopedRole() {
        RoleRepresentation roleRep = this.createRealmRole("foo-role");
        ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("bar-scope");
        scopeRep.setProtocol("openid-connect");
        String scopeId = this.createClientScopeWithCleanup(scopeRep);
        this.clientScopes().get(scopeId).getScopeMappings().realmLevel().add(Collections.singletonList(roleRep));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientScopeRoleMappingsRealmLevelPath((String)scopeId), Collections.singletonList(roleRep), (ResourceType)ResourceType.REALM_SCOPE_MAPPING);
        List roleReps = this.clientScopes().get(scopeId).getScopeMappings().realmLevel().listAll();
        Assertions.assertEquals((int)1, (int)roleReps.size());
        Assertions.assertEquals((Object)"foo-role", (Object)((RoleRepresentation)roleReps.get(0)).getName());
        this.managedRealm.admin().roles().deleteRole("foo-role");
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.roleResourcePath((String)"foo-role"), (ResourceType)ResourceType.REALM_ROLE);
        roleReps = this.clientScopes().get(scopeId).getScopeMappings().realmLevel().listAll();
        Assertions.assertEquals((int)0, (int)roleReps.size());
    }

    private RoleRepresentation createRealmRole(String roleName) {
        RoleRepresentation roleRep = new RoleRepresentation();
        roleRep.setName(roleName);
        this.managedRealm.admin().roles().create(roleRep);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.roleResourcePath((String)roleName), (Object)roleRep, (ResourceType)ResourceType.REALM_ROLE);
        return this.managedRealm.admin().roles().get(roleName).toRepresentation();
    }

    private RoleRepresentation createRealmRoleWithCleanup(String roleName) {
        RoleRepresentation roleRep = this.createRealmRole(roleName);
        this.managedRealm.cleanup().add(r -> r.roles().get(roleName).remove());
        return roleRep;
    }

    @Test
    public void testRemoveClientScopeInUse() {
        ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("foo-scope");
        scopeRep.setProtocol("openid-connect");
        String scopeId = this.createClientScope(scopeRep);
        this.managedRealm.updateWithCleanup(new ManagedRealm.RealmUpdate[]{r -> {
            r.addClient("bar-client").name("bar-client").protocol("openid-connect").defaultClientScopes(new String[]{"foo-scope"});
            return r;
        }});
        this.adminEvents.skip();
        this.removeClientScope(scopeId);
    }

    @Test
    public void testRealmDefaultClientScopes() {
        ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("scope-def");
        scopeRep.setProtocol("openid-connect");
        String scopeDefId = this.createClientScopeWithCleanup(scopeRep);
        scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("scope-opt");
        scopeRep.setProtocol("openid-connect");
        String scopeOptId = this.createClientScopeWithCleanup(scopeRep);
        this.managedRealm.admin().addDefaultDefaultClientScope(scopeDefId);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.defaultDefaultClientScopePath((String)scopeDefId), (ResourceType)ResourceType.CLIENT_SCOPE);
        this.managedRealm.admin().addDefaultOptionalClientScope(scopeOptId);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.defaultOptionalClientScopePath((String)scopeOptId), (ResourceType)ResourceType.CLIENT_SCOPE);
        List<String> realmDefaultScopes = this.getClientScopeNames(this.managedRealm.admin().getDefaultDefaultClientScopes());
        List<String> realmOptionalScopes = this.getClientScopeNames(this.managedRealm.admin().getDefaultOptionalClientScopes());
        Assertions.assertTrue((boolean)realmDefaultScopes.contains("scope-def"));
        Assertions.assertFalse((boolean)realmOptionalScopes.contains("scope-def"));
        Assertions.assertFalse((boolean)realmDefaultScopes.contains("scope-opt"));
        Assertions.assertTrue((boolean)realmOptionalScopes.contains("scope-opt"));
        ClientRepresentation clientRep = new ClientRepresentation();
        clientRep.setClientId("bar-client");
        clientRep.setProtocol("openid-connect");
        String clientUuid = this.createClientWithCleanup(clientRep);
        ClientResource client = this.managedRealm.admin().clients().get(clientUuid);
        List<String> clientDefaultScopes = this.getClientScopeNames(client.getDefaultClientScopes());
        List<String> clientOptionalScopes = this.getClientScopeNames(client.getOptionalClientScopes());
        Assertions.assertTrue((boolean)clientDefaultScopes.contains("scope-def"));
        Assertions.assertFalse((boolean)clientOptionalScopes.contains("scope-def"));
        Assertions.assertFalse((boolean)clientDefaultScopes.contains("scope-opt"));
        Assertions.assertTrue((boolean)clientOptionalScopes.contains("scope-opt"));
        this.managedRealm.admin().removeDefaultDefaultClientScope(scopeDefId);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.defaultDefaultClientScopePath((String)scopeDefId), (ResourceType)ResourceType.CLIENT_SCOPE);
        this.managedRealm.admin().removeDefaultOptionalClientScope(scopeOptId);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.defaultOptionalClientScopePath((String)scopeOptId), (ResourceType)ResourceType.CLIENT_SCOPE);
        realmDefaultScopes = this.getClientScopeNames(this.managedRealm.admin().getDefaultDefaultClientScopes());
        realmOptionalScopes = this.getClientScopeNames(this.managedRealm.admin().getDefaultOptionalClientScopes());
        Assertions.assertFalse((boolean)realmDefaultScopes.contains("scope-def"));
        Assertions.assertFalse((boolean)realmOptionalScopes.contains("scope-def"));
        Assertions.assertFalse((boolean)realmDefaultScopes.contains("scope-opt"));
        Assertions.assertFalse((boolean)realmOptionalScopes.contains("scope-opt"));
        ClientRepresentation clientRep2 = new ClientRepresentation();
        clientRep2.setClientId("bar-client-2");
        clientRep2.setProtocol("openid-connect");
        String clientUuid2 = this.createClientWithCleanup(clientRep2);
        ClientResource client2 = this.managedRealm.admin().clients().get(clientUuid2);
        clientDefaultScopes = this.getClientScopeNames(client2.getDefaultClientScopes());
        clientOptionalScopes = this.getClientScopeNames(client2.getOptionalClientScopes());
        Assertions.assertFalse((boolean)clientDefaultScopes.contains("scope-def"));
        Assertions.assertFalse((boolean)clientOptionalScopes.contains("scope-def"));
        Assertions.assertFalse((boolean)clientDefaultScopes.contains("scope-opt"));
        Assertions.assertFalse((boolean)clientOptionalScopes.contains("scope-opt"));
    }

    @Test
    public void defaultOptionalClientScopeCanBeAssignedToClientAsDefaultScope() {
        ClientScopeRepresentation optionalClientScope = new ClientScopeRepresentation();
        optionalClientScope.setName("optional-client-scope");
        optionalClientScope.setProtocol("openid-connect");
        String optionalClientScopeId = this.createClientScopeWithCleanup(optionalClientScope);
        this.managedRealm.admin().addDefaultOptionalClientScope(optionalClientScopeId);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.defaultOptionalClientScopePath((String)optionalClientScopeId), (ResourceType)ResourceType.CLIENT_SCOPE);
        List<String> realmOptionalScopes = this.getClientScopeNames(this.managedRealm.admin().getDefaultOptionalClientScopes());
        Assertions.assertTrue((boolean)realmOptionalScopes.contains("optional-client-scope"));
        ClientRepresentation clientRep = new ClientRepresentation();
        clientRep.setClientId("test-client");
        clientRep.setDefaultClientScopes(Collections.singletonList("optional-client-scope"));
        String clientUuid = this.createClientWithCleanup(clientRep);
        ClientResource client = this.managedRealm.admin().clients().get(clientUuid);
        List<String> clientDefaultScopes = this.getClientScopeNames(client.getDefaultClientScopes());
        Assertions.assertTrue((boolean)clientDefaultScopes.contains("optional-client-scope"));
        List<String> clientOptionalScopes = this.getClientScopeNames(client.getOptionalClientScopes());
        Assertions.assertTrue((boolean)clientOptionalScopes.isEmpty());
        this.managedRealm.admin().removeDefaultOptionalClientScope(optionalClientScopeId);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.defaultOptionalClientScopePath((String)optionalClientScopeId), (ResourceType)ResourceType.CLIENT_SCOPE);
    }

    @Test
    public void scopesRemainAfterClientUpdate() {
        ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("scope-def");
        scopeRep.setProtocol("openid-connect");
        String scopeDefId = this.createClientScopeWithCleanup(scopeRep);
        scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("scope-opt");
        scopeRep.setProtocol("openid-connect");
        String scopeOptId = this.createClientScopeWithCleanup(scopeRep);
        this.managedRealm.admin().addDefaultDefaultClientScope(scopeDefId);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.defaultDefaultClientScopePath((String)scopeDefId), (ResourceType)ResourceType.CLIENT_SCOPE);
        this.managedRealm.admin().addDefaultOptionalClientScope(scopeOptId);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.defaultOptionalClientScopePath((String)scopeOptId), (ResourceType)ResourceType.CLIENT_SCOPE);
        ClientRepresentation clientRep = new ClientRepresentation();
        clientRep.setClientId("bar-client");
        clientRep.setProtocol("openid-connect");
        String clientUuid = this.createClientWithCleanup(clientRep);
        ClientResource client = this.managedRealm.admin().clients().get(clientUuid);
        Assertions.assertTrue((boolean)this.getClientScopeNames(client.getDefaultClientScopes()).contains("scope-def"));
        Assertions.assertTrue((boolean)this.getClientScopeNames(client.getOptionalClientScopes()).contains("scope-opt"));
        client.removeDefaultClientScope(scopeDefId);
        client.removeOptionalClientScope(scopeOptId);
        List<String> expectedDefScopes = this.getClientScopeNames(client.getDefaultClientScopes());
        List<String> expectedOptScopes = this.getClientScopeNames(client.getOptionalClientScopes());
        Assertions.assertFalse((boolean)expectedDefScopes.contains("scope-def"));
        Assertions.assertFalse((boolean)expectedOptScopes.contains("scope-opt"));
        clientRep = client.toRepresentation();
        clientRep.setDescription("desc");
        client.update(clientRep);
        Assertions.assertEquals(expectedDefScopes, this.getClientScopeNames(client.getDefaultClientScopes()));
        Assertions.assertEquals(expectedOptScopes, this.getClientScopeNames(client.getOptionalClientScopes()));
    }

    @Test
    public void testUpdateProtocolMappers() {
        ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("testUpdateProtocolMappers");
        scopeRep.setProtocol("openid-connect");
        String scopeId = this.createClientScopeWithCleanup(scopeRep);
        ProtocolMapperRepresentation mapper = new ProtocolMapperRepresentation();
        mapper.setName("test");
        mapper.setProtocol("openid-connect");
        mapper.setProtocolMapper("oidc-usermodel-attribute-mapper");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("user.attribute", "test");
        m.put("claim.name", "");
        m.put("jsonType.label", "");
        mapper.setConfig(m);
        ProtocolMappersResource protocolMappers = this.clientScopes().get(scopeId).getProtocolMappers();
        Response response = protocolMappers.createMapper(mapper);
        String mapperId = ApiUtil.getCreatedId((Response)response);
        mapper = protocolMappers.getMapperById(mapperId);
        mapper.getConfig().put("claim.name", "claim");
        protocolMappers.update(mapperId, mapper);
        List mappers = protocolMappers.getMappers();
        Assertions.assertEquals((int)1, (int)mappers.size());
        Assertions.assertEquals((int)2, (int)((ProtocolMapperRepresentation)mappers.get(0)).getConfig().size());
        Assertions.assertEquals((Object)"test", ((ProtocolMapperRepresentation)mappers.get(0)).getConfig().get("user.attribute"));
        Assertions.assertEquals((Object)"claim", ((ProtocolMapperRepresentation)mappers.get(0)).getConfig().get("claim.name"));
    }

    @Test
    public void updateClientWithDefaultScopeAssignedAsOptionalAndOpposite() {
        ClientRepresentation clientRep = new ClientRepresentation();
        clientRep.setClientId("bar-client");
        clientRep.setProtocol("openid-connect");
        String clientUuid = this.createClientWithCleanup(clientRep);
        ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("scope-def");
        scopeRep.setProtocol("openid-connect");
        String scopeDefId = this.createClientScopeWithCleanup(scopeRep);
        scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("scope-opt");
        scopeRep.setProtocol("openid-connect");
        String scopeOptId = this.createClientScopeWithCleanup(scopeRep);
        ClientResource client = this.managedRealm.admin().clients().get(clientUuid);
        client.addOptionalClientScope(scopeDefId);
        client.addDefaultClientScope(scopeOptId);
        this.managedRealm.admin().addDefaultDefaultClientScope(scopeDefId);
        this.managedRealm.admin().addDefaultOptionalClientScope(scopeOptId);
        clientRep.setDescription("new_description");
        Assertions.assertDoesNotThrow(() -> this.managedRealm.admin().clients().get(clientUuid).update(clientRep));
    }

    @Test
    public void testCreateDynamicScopeWithFeatureDisabledAndIsDynamicScopeTrue() {
        ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("non-dynamic-scope-def2");
        scopeRep.setProtocol("openid-connect");
        scopeRep.setAttributes((Map)new HashMap<String, String>(){
            {
                this.put("is.dynamic.scope", "true");
                this.put("dynamic.scope.regexp", "");
            }
        });
        this.handleExpectedCreateFailure(scopeRep, 400, "Unexpected value \"true\" for attribute is.dynamic.scope in ClientScope");
    }

    @Test
    public void testCreateDynamicScopeWithFeatureDisabledAndNonEmptyDynamicScopeRegexp() {
        ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("non-dynamic-scope-def3");
        scopeRep.setProtocol("openid-connect");
        scopeRep.setAttributes((Map)new HashMap<String, String>(){
            {
                this.put("is.dynamic.scope", "false");
                this.put("dynamic.scope.regexp", "not-empty");
            }
        });
        this.handleExpectedCreateFailure(scopeRep, 400, "Unexpected value \"not-empty\" for attribute dynamic.scope.regexp in ClientScope");
    }

    @Test
    public void deleteAllClientScopesMustFail() {
        List clientScopes = this.clientScopes().findAll();
        for (int i = 0; i < clientScopes.size(); ++i) {
            ClientScopeRepresentation clientScope = (ClientScopeRepresentation)clientScopes.get(i);
            if (i != clientScopes.size() - 1) {
                this.removeClientScope(clientScope.getId());
                continue;
            }
            this.removeClientScopeMustFail(clientScope.getId());
        }
    }

    @Test
    public void createClientScopeWithoutProtocol() {
        ClientScopeRepresentation clientScope = new ClientScopeRepresentation();
        clientScope.setName("test-client-scope");
        clientScope.setDescription("test-client-scope-description");
        clientScope.setProtocol(null);
        clientScope.setAttributes(Map.of("test-attribute", "test-value"));
        try (Response response = this.clientScopes().create(clientScope);){
            Assertions.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatus());
            String errorMessage = (String)response.readEntity(String.class);
            Assertions.assertTrue((boolean)errorMessage.contains("Unexpected protocol"));
        }
    }

    @DisplayName(value="Create ClientScope with protocol:")
    @ParameterizedTest
    @ValueSource(strings={"openid-connect", "saml", "oid4vc"})
    public void createClientScopeWithOpenIdProtocol(String protocol) {
        this.createClientScope(protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createClientScope(String protocol) {
        ClientScopeRepresentation clientScope = new ClientScopeRepresentation();
        clientScope.setName("test-client-scope");
        clientScope.setDescription("test-client-scope-description");
        clientScope.setProtocol(protocol);
        clientScope.setAttributes(Map.of("test-attribute", "test-value"));
        String clientScopeId = null;
        try (Response response = this.clientScopes().create(clientScope);){
            Assertions.assertEquals((int)Response.Status.CREATED.getStatusCode(), (int)response.getStatus());
            String location = Optional.ofNullable((List)response.getHeaders().get((Object)"Location")).map(list -> list.get(0)).orElse(null);
            Assertions.assertNotNull((Object)location);
            clientScopeId = location.substring(location.lastIndexOf("/") + 1);
        }
        catch (Throwable throwable) {
            Assertions.assertNotNull(clientScopeId);
            this.clientScopes().get(clientScopeId).remove();
            throw throwable;
        }
        Assertions.assertNotNull((Object)clientScopeId);
        this.clientScopes().get(clientScopeId).remove();
    }

    private void removeClientScopeMustFail(String clientScopeId) {
        try {
            this.clientScopes().get(clientScopeId).remove();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void removeClientScope(String clientScopeId) {
        this.clientScopes().get(clientScopeId).remove();
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.clientScopeResourcePath((String)clientScopeId), (ResourceType)ResourceType.CLIENT_SCOPE);
    }
}

