/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.client;

import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.keycloak.common.Profile;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;
import org.keycloak.tests.admin.client.AbstractClientScopeTest;

@KeycloakIntegrationTest(config=DefaultServerConfigWithOid4Vci.class)
public class ClientScopeTestOid4Vci
extends AbstractClientScopeTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DisplayName(value="Verify default values are correctly set")
    @Test
    public void testDefaultOid4VciClientScopeAttributes() {
        ClientScopeRepresentation clientScope = new ClientScopeRepresentation();
        clientScope.setName("test-client-scope");
        clientScope.setDescription("test-client-scope-description");
        clientScope.setProtocol("oid4vc");
        clientScope.setAttributes(Map.of("test-attribute", "test-value"));
        String clientScopeId = null;
        try (Response response = this.clientScopes().create(clientScope);){
            Assertions.assertEquals((int)Response.Status.CREATED.getStatusCode(), (int)response.getStatus());
            String location = Optional.ofNullable((List)response.getHeaders().get((Object)"Location")).map(list -> list.get(0)).orElse(null);
            Assertions.assertNotNull((Object)location);
            clientScopeId = location.substring(location.lastIndexOf("/") + 1);
            ClientScopeRepresentation createdClientScope = this.clientScopes().get(clientScopeId).toRepresentation();
            Assertions.assertNotNull((Object)createdClientScope);
            Assertions.assertEquals((Object)"id,iat,nbf,exp,jti", createdClientScope.getAttributes().get("vc.credential_build_config.sd_jwt.visible_claims"));
            Assertions.assertEquals((Object)String.valueOf(10), createdClientScope.getAttributes().get("vc.sd_jwt.number_of_decoys"));
            Assertions.assertEquals((Object)"dc+sd-jwt", createdClientScope.getAttributes().get("vc.format"));
            Assertions.assertEquals((Object)"SHA-256", createdClientScope.getAttributes().get("vc.credential_build_config.hash_algorithm"));
            Assertions.assertEquals((Object)"JWS", createdClientScope.getAttributes().get("vc.credential_build_config.token_jws_type"));
            Assertions.assertEquals((Object)String.valueOf(31536000), createdClientScope.getAttributes().get("vc.expiry_in_seconds"));
            Assertions.assertEquals((Object)"jwk", createdClientScope.getAttributes().get("vc.cryptographic_binding_methods_supported"));
            Assertions.assertEquals((Object)clientScope.getName(), createdClientScope.getAttributes().get("vc.credential_configuration_id"));
            Assertions.assertEquals((Object)clientScope.getName(), createdClientScope.getAttributes().get("vc.credential_identifier"));
            Assertions.assertEquals((Object)clientScope.getName(), createdClientScope.getAttributes().get("vc.supported_credential_types"));
            Assertions.assertEquals((Object)clientScope.getName(), createdClientScope.getAttributes().get("vc.credential_contexts"));
            Assertions.assertEquals((Object)clientScope.getName(), createdClientScope.getAttributes().get("vc.verifiable_credential_type"));
            Assertions.assertEquals((Object)clientScope.getName(), createdClientScope.getAttributes().get("vc.issuer_did"));
        }
        catch (Throwable throwable) {
            Assertions.assertNotNull(clientScopeId);
            this.clientScopes().get(clientScopeId).remove();
            throw throwable;
        }
        Assertions.assertNotNull((Object)clientScopeId);
        this.clientScopes().get(clientScopeId).remove();
    }

    public static class DefaultServerConfigWithOid4Vci
    implements KeycloakServerConfig {
        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder config) {
            return config.features(new Profile.Feature[]{Profile.Feature.OID4VC_VCI});
        }
    }
}

