/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.client;

import org.junit.jupiter.api.Test;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;
import org.keycloak.tests.admin.client.AbstractClientSearchTest;

@KeycloakIntegrationTest(config=SearchableServer.class)
public class ClientSearchTest
extends AbstractClientSearchTest {
    @Test
    public void testQuerySearch() {
        this.search(String.format("%s:%s", "org", "Test_\"organisation\""), "client1");
        this.search(String.format("%s:%s", "url", "https://foo.bar/clflds"), "client1", "client2");
        this.search(String.format("%s:%s %s:%s", "org", "Test_\"organisation\"", "url", "https://foo.bar/clflds"), "client1");
        this.search(String.format("%s:%s %s:%s", "org", "wrong val", "url", "https://foo.bar/clflds"), new String[0]);
        this.search(String.format("%s:%s", "\"test \\\"123\\\"\"", "\"field=\\\"blah blah\\\"\""), "client3");
        String[] expectedRes = new String[]{"client1", "client2"};
        this.search(String.format("%s:%s %s:%s", "url", "https://foo.bar/clflds", "filtered", "does_not_matter"), expectedRes);
    }

    public static class SearchableServer
    implements KeycloakServerConfig {
        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder config) {
            return config.option("spi-client-jpa-searchable-attributes", String.join((CharSequence)",", "url", "org", "test \"123\""));
        }
    }
}

