/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.client;

import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.common.Profile;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;
import org.keycloak.tests.admin.client.AbstractClientScopeTest;
import org.keycloak.tests.utils.matchers.Matchers;

@KeycloakIntegrationTest(config=DynamicClientScopeServerConfig.class)
public class DynamicClientScopeTest
extends AbstractClientScopeTest {
    @Test
    public void testCreateValidDynamicScope() {
        ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("dynamic-scope-def");
        scopeRep.setProtocol("openid-connect");
        scopeRep.setAttributes((Map)new HashMap<String, String>(){
            {
                this.put("is.dynamic.scope", "true");
                this.put("dynamic.scope.regexp", "dynamic-scope-def:*");
            }
        });
        String scopeDefId = this.createClientScopeWithCleanup(scopeRep);
        scopeRep = this.clientScopes().get(scopeDefId).toRepresentation();
        Assertions.assertEquals((Object)"dynamic-scope-def", (Object)scopeRep.getName());
        Assertions.assertEquals((Object)"true", scopeRep.getAttributes().get("is.dynamic.scope"));
        Assertions.assertEquals((Object)"dynamic-scope-def:*", scopeRep.getAttributes().get("dynamic.scope.regexp"));
    }

    @Test
    public void testCreateNonDynamicScopeWithFeatureEnabled() {
        ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("non-dynamic-scope-def");
        scopeRep.setProtocol("openid-connect");
        scopeRep.setAttributes((Map)new HashMap<String, String>(){
            {
                this.put("is.dynamic.scope", "false");
                this.put("dynamic.scope.regexp", "");
            }
        });
        String scopeDefId = this.createClientScopeWithCleanup(scopeRep);
        scopeRep = this.clientScopes().get(scopeDefId).toRepresentation();
        Assertions.assertEquals((Object)"non-dynamic-scope-def", (Object)scopeRep.getName());
        Assertions.assertEquals((Object)"false", scopeRep.getAttributes().get("is.dynamic.scope"));
        MatcherAssert.assertThat((Object)((String)scopeRep.getAttributes().get("dynamic.scope.regexp")), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.nullValue(), (Matcher)CoreMatchers.equalTo((Object)"")));
    }

    @Test
    public void testCreateInvalidRegexpDynamicScope() {
        ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("dynamic-scope-def4");
        scopeRep.setProtocol("openid-connect");
        scopeRep.setAttributes((Map)new HashMap<String, String>(){
            {
                this.put("is.dynamic.scope", "true");
                this.put("dynamic.scope.regexp", "dynamic-scope-def:*:*");
            }
        });
        this.handleExpectedCreateFailure(scopeRep, 400, "Invalid format for the Dynamic Scope regexp dynamic-scope-def:*:*");
    }

    @Test
    public void updateAssignedDefaultClientScopeToDynamicScope() {
        ClientRepresentation clientRep = new ClientRepresentation();
        clientRep.setClientId("dyn-scope-client");
        clientRep.setProtocol("openid-connect");
        String clientUuid = this.createClientWithCleanup(clientRep);
        ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
        scopeRep.setName("dynamic-scope-def");
        scopeRep.setProtocol("openid-connect");
        String scopeDefId = this.createClientScopeWithCleanup(scopeRep);
        this.managedRealm.admin().clients().get(clientUuid).addDefaultClientScope(scopeDefId);
        scopeRep.setAttributes((Map)new HashMap<String, String>(){
            {
                this.put("is.dynamic.scope", "true");
                this.put("dynamic.scope.regexp", "dynamic-scope-def:*:*");
            }
        });
        try {
            this.clientScopes().get(scopeDefId).update(scopeRep);
            Assertions.fail((String)"This update should fail");
        }
        catch (ClientErrorException ex) {
            MatcherAssert.assertThat((Object)ex.getResponse(), (Matcher)Matchers.statusCodeIs((Response.Status)Response.Status.BAD_REQUEST));
        }
    }

    @Test
    public void dynamicClientScopeCannotBeAssignedAsDefaultClientScope() {
        ClientRepresentation clientRep = new ClientRepresentation();
        clientRep.setClientId("dyn-scope-client");
        clientRep.setProtocol("openid-connect");
        String clientUuid = this.createClientWithCleanup(clientRep);
        ClientScopeRepresentation optionalClientScope = new ClientScopeRepresentation();
        optionalClientScope.setName("optional-dynamic-client-scope");
        optionalClientScope.setProtocol("openid-connect");
        optionalClientScope.setAttributes((Map)new HashMap<String, String>(){
            {
                this.put("is.dynamic.scope", "true");
                this.put("dynamic.scope.regexp", "dynamic-scope-def:*");
            }
        });
        String optionalClientScopeId = this.createClientScopeWithCleanup(optionalClientScope);
        try {
            ClientResource clientResource = this.managedRealm.admin().clients().get(clientUuid);
            clientResource.addDefaultClientScope(optionalClientScopeId);
            Assertions.fail((String)"A Dynamic Scope shouldn't not be assigned as a default scope to a client");
        }
        catch (ClientErrorException ex) {
            MatcherAssert.assertThat((Object)ex.getResponse(), (Matcher)Matchers.statusCodeIs((Response.Status)Response.Status.BAD_REQUEST));
        }
    }

    public static class DynamicClientScopeServerConfig
    implements KeycloakServerConfig {
        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder config) {
            return config.features(new Profile.Feature[]{Profile.Feature.DYNAMIC_SCOPES});
        }
    }
}

