/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.client;

import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.Profile;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.testframework.annotations.InjectAdminEvents;
import org.keycloak.testframework.annotations.InjectClient;
import org.keycloak.testframework.annotations.InjectKeycloakUrls;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.events.AdminEvents;
import org.keycloak.testframework.realm.ClientConfig;
import org.keycloak.testframework.realm.ClientConfigBuilder;
import org.keycloak.testframework.realm.ManagedClient;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;
import org.keycloak.testframework.server.KeycloakUrls;
import org.keycloak.testframework.util.ApiUtil;
import org.keycloak.tests.utils.KeyUtils;
import org.keycloak.tests.utils.admin.AdminEventPaths;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@KeycloakIntegrationTest(config=InstallationTestServerConfig.class)
public class InstallationTest {
    @InjectRealm
    ManagedRealm realm;
    @InjectClient(config=OidcClientConfig.class, ref="oidc")
    ManagedClient oidcClient;
    @InjectClient(config=OidcBearerOnlyClientConfig.class, ref="oidcBearerOnly")
    ManagedClient oidcBearerOnlyClient;
    @InjectClient(config=OidcBearerOnlyWithAuthzClientConfig.class, ref="oidcBearerOnlyWithAuthz")
    ManagedClient oidcBearerOnlyWithAuthzClient;
    @InjectClient(config=SamlClientConfig.class, ref="saml")
    ManagedClient samlClient;
    @InjectKeycloakUrls
    KeycloakUrls keycloakUrls;
    @InjectAdminEvents
    AdminEvents adminEvents;
    private static final String OIDC_NAME = "oidcInstallationClient";
    private static final String OIDC_NAME_BEARER_ONLY_NAME = "oidcInstallationClientBearerOnly";
    private static final String OIDC_NAME_BEARER_ONLY_WITH_AUTHZ_NAME = "oidcInstallationClientBearerOnlyWithAuthz";
    private static final String SAML_NAME = "samlInstallationClient";

    private String samlUrl() {
        return this.realm.getBaseUrl() + "/protocol/saml";
    }

    @Test
    public void testOidcJBossXml() {
        String xml = this.oidcClient.admin().getInstallationProvider("keycloak-oidc-jboss-subsystem");
        this.assertOidcInstallationConfig(xml);
        MatcherAssert.assertThat((Object)xml, (Matcher)Matchers.containsString((String)"<secure-deployment"));
    }

    @Test
    public void testOidcJson() {
        String json = this.oidcClient.admin().getInstallationProvider("keycloak-oidc-keycloak-json");
        this.assertOidcInstallationConfig(json);
    }

    @Test
    public void testOidcJBossCli() {
        String cli = this.oidcClient.admin().getInstallationProvider("keycloak-oidc-jboss-subsystem-cli");
        this.assertOidcInstallationConfig(cli);
        MatcherAssert.assertThat((Object)cli, (Matcher)Matchers.containsString((String)"/subsystem=keycloak/secure-deployment=\"WAR MODULE NAME.war\""));
    }

    @Test
    public void testOidcBearerOnlyJson() {
        String json = this.oidcBearerOnlyClient.admin().getInstallationProvider("keycloak-oidc-keycloak-json");
        this.assertOidcInstallationConfig(json);
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"bearer-only"));
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"public-client")));
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"credentials")));
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"verify-token-audience")));
    }

    @Test
    public void testOidcBearerOnlyJsonWithAudienceClientScope() {
        String clientScopeId = this.createAudienceClientScope();
        String json = this.oidcBearerOnlyClient.admin().getInstallationProvider("keycloak-oidc-keycloak-json");
        this.assertOidcInstallationConfig(json);
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"bearer-only"));
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"public-client")));
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"credentials")));
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"verify-token-audience"));
        this.realm.admin().clientScopes().get(clientScopeId).remove();
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.clientScopeResourcePath((String)clientScopeId), null, (ResourceType)ResourceType.CLIENT_SCOPE);
    }

    private String createAudienceClientScope() {
        ClientScopeRepresentation clientScopeRepresentation = new ClientScopeRepresentation();
        clientScopeRepresentation.setProtocol("openid-connect");
        clientScopeRepresentation.setName(this.oidcBearerOnlyClient.getClientId());
        ProtocolMapperRepresentation mapper = this.createProtocolMapper();
        clientScopeRepresentation.setProtocolMappers(List.of(mapper));
        Response response = this.realm.admin().clientScopes().create(clientScopeRepresentation);
        String id = ApiUtil.handleCreatedResponse((Response)response);
        response.close();
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientScopeResourcePath((String)id), (ResourceType)ResourceType.CLIENT_SCOPE);
        return id;
    }

    private ProtocolMapperRepresentation createProtocolMapper() {
        ProtocolMapperRepresentation mapper = new ProtocolMapperRepresentation();
        mapper.setName("Audience for " + this.oidcBearerOnlyClient.getClientId());
        mapper.setProtocolMapper("oidc-audience-mapper");
        mapper.setProtocol("openid-connect");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("included.client.audience", this.oidcBearerOnlyClient.getClientId());
        config.put("access.token.claim", "true");
        config.put("introspection.token.claim", "true");
        mapper.setConfig(config);
        return mapper;
    }

    @Test
    public void testOidcBearerOnlyWithAuthzJson() {
        String json = this.oidcBearerOnlyWithAuthzClient.admin().getInstallationProvider("keycloak-oidc-keycloak-json");
        this.assertOidcInstallationConfig(json);
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"bearer-only")));
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"public-client")));
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"credentials"));
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"secret"));
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"policy-enforcer"));
    }

    private void assertOidcInstallationConfig(String config) {
        MatcherAssert.assertThat((Object)config, (Matcher)Matchers.containsString((String)"default"));
        MatcherAssert.assertThat((Object)config, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)KeyUtils.findActiveSigningKey((RealmResource)this.realm.admin()).getPublicKey())));
        MatcherAssert.assertThat((Object)config, (Matcher)Matchers.containsString((String)this.keycloakUrls.getBase()));
    }

    @Test
    public void testSamlMetadataIdpDescriptor() {
        try {
            this.samlClient.admin().getInstallationProvider("saml-idp-descriptor");
            Assertions.fail((String)"Successful saml-idp-descriptor not expected");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testSamlAdapterXml() {
        String xml = this.samlClient.admin().getInstallationProvider("keycloak-saml");
        MatcherAssert.assertThat((Object)xml, (Matcher)Matchers.containsString((String)"<keycloak-saml-adapter>"));
        MatcherAssert.assertThat((Object)xml, (Matcher)Matchers.containsString((String)"SPECIFY YOUR entityID!"));
        MatcherAssert.assertThat((Object)xml, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)KeyUtils.findActiveSigningKey((RealmResource)this.realm.admin()).getCertificate())));
        MatcherAssert.assertThat((Object)xml, (Matcher)Matchers.containsString((String)this.samlUrl()));
    }

    @Test
    public void testSamlAdapterCli() {
        String cli = this.samlClient.admin().getInstallationProvider("keycloak-saml-subsystem-cli");
        MatcherAssert.assertThat((Object)cli, (Matcher)Matchers.containsString((String)"/subsystem=keycloak-saml/secure-deployment=YOUR-WAR.war/"));
        MatcherAssert.assertThat((Object)cli, (Matcher)Matchers.containsString((String)"SPECIFY YOUR entityID!"));
        MatcherAssert.assertThat((Object)cli, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)KeyUtils.findActiveSigningKey((RealmResource)this.realm.admin()).getCertificate())));
        MatcherAssert.assertThat((Object)cli, (Matcher)Matchers.containsString((String)this.samlUrl()));
    }

    @Test
    public void testSamlMetadataSpDescriptor() throws Exception {
        String xml = this.samlClient.admin().getInstallationProvider("saml-sp-descriptor");
        Document doc = this.getDocumentFromXmlString(xml);
        this.assertElements(doc, JBossSAMLURIConstants.METADATA_NSURI.get(), "EntityDescriptor", null);
        this.assertElements(doc, JBossSAMLURIConstants.METADATA_NSURI.get(), "SPSSODescriptor", null);
        MatcherAssert.assertThat((Object)xml, (Matcher)Matchers.containsString((String)SAML_NAME));
    }

    @Test
    public void testSamlJBossXml() {
        String xml = this.samlClient.admin().getInstallationProvider("keycloak-saml-subsystem");
        MatcherAssert.assertThat((Object)xml, (Matcher)Matchers.containsString((String)"<secure-deployment"));
        MatcherAssert.assertThat((Object)xml, (Matcher)Matchers.containsString((String)"SPECIFY YOUR entityID!"));
        MatcherAssert.assertThat((Object)xml, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)KeyUtils.findActiveSigningKey((RealmResource)this.realm.admin()).getCertificate())));
        MatcherAssert.assertThat((Object)xml, (Matcher)Matchers.containsString((String)this.samlUrl()));
    }

    @Test
    public void testSamlMetadataSpDescriptorPost() throws Exception {
        MatcherAssert.assertThat((Object)((String)this.samlClient.admin().toRepresentation().getAttributes().get("saml.force.post.binding")), (Matcher)Matchers.equalTo((Object)"true"));
        String response = this.samlClient.admin().getInstallationProvider("saml-sp-descriptor");
        Document doc = this.getDocumentFromXmlString(response);
        HashMap<String, String> attrNamesAndValues = new HashMap<String, String>();
        attrNamesAndValues.put("Binding", JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get());
        attrNamesAndValues.put("Location", "ERROR:ENDPOINT_NOT_SET");
        this.assertElements(doc, JBossSAMLURIConstants.METADATA_NSURI.get(), "SingleLogoutService", attrNamesAndValues);
        this.assertElements(doc, JBossSAMLURIConstants.METADATA_NSURI.get(), "AssertionConsumerService", attrNamesAndValues);
        attrNamesAndValues.clear();
        this.samlClient.updateWithCleanup(new ManagedClient.ClientUpdate[]{c -> c.adminUrl("https://admin-url")});
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.clientResourcePath((String)this.samlClient.getId()), (ResourceType)ResourceType.CLIENT);
        response = this.samlClient.admin().getInstallationProvider("saml-sp-descriptor");
        doc = this.getDocumentFromXmlString(response);
        attrNamesAndValues.put("Binding", JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get());
        attrNamesAndValues.put("Location", "https://admin-url");
        this.assertElements(doc, JBossSAMLURIConstants.METADATA_NSURI.get(), "SingleLogoutService", attrNamesAndValues);
        this.assertElements(doc, JBossSAMLURIConstants.METADATA_NSURI.get(), "AssertionConsumerService", attrNamesAndValues);
        attrNamesAndValues.clear();
        this.samlClient.updateWithCleanup(new ManagedClient.ClientUpdate[]{c -> c.attribute("saml_assertion_consumer_url_post", "https://saml-assertion-post-url").attribute("saml_single_logout_service_url_post", "https://saml-logout-post-url").attribute("saml_assertion_consumer_url_redirect", "https://saml-assertion-redirect-url").attribute("saml_single_logout_service_url_redirect", "https://saml-logout-redirect-url")});
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.clientResourcePath((String)this.samlClient.getId()), (ResourceType)ResourceType.CLIENT);
        response = this.samlClient.admin().getInstallationProvider("saml-sp-descriptor");
        doc = this.getDocumentFromXmlString(response);
        attrNamesAndValues.put("Binding", JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get());
        attrNamesAndValues.put("Location", "https://saml-logout-post-url");
        this.assertElements(doc, JBossSAMLURIConstants.METADATA_NSURI.get(), "SingleLogoutService", attrNamesAndValues);
        attrNamesAndValues.clear();
        attrNamesAndValues.put("Binding", JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get());
        attrNamesAndValues.put("Location", "https://saml-assertion-post-url");
        this.assertElements(doc, JBossSAMLURIConstants.METADATA_NSURI.get(), "AssertionConsumerService", attrNamesAndValues);
    }

    @Test
    public void testSamlMetadataSpDescriptorRedirect() throws Exception {
        this.samlClient.updateWithCleanup(new ManagedClient.ClientUpdate[]{c -> c.attribute("saml.force.post.binding", "false")});
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.clientResourcePath((String)this.samlClient.getId()), (ResourceType)ResourceType.CLIENT);
        MatcherAssert.assertThat((Object)((String)this.samlClient.admin().toRepresentation().getAttributes().get("saml.force.post.binding")), (Matcher)Matchers.equalTo((Object)"false"));
        String response = this.samlClient.admin().getInstallationProvider("saml-sp-descriptor");
        Document doc = this.getDocumentFromXmlString(response);
        HashMap<String, String> attrNamesAndValues = new HashMap<String, String>();
        attrNamesAndValues.put("Binding", JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get());
        attrNamesAndValues.put("Location", "ERROR:ENDPOINT_NOT_SET");
        this.assertElements(doc, JBossSAMLURIConstants.METADATA_NSURI.get(), "SingleLogoutService", attrNamesAndValues);
        this.assertElements(doc, JBossSAMLURIConstants.METADATA_NSURI.get(), "AssertionConsumerService", attrNamesAndValues);
        attrNamesAndValues.clear();
        this.samlClient.updateWithCleanup(new ManagedClient.ClientUpdate[]{c -> c.adminUrl("https://admin-url")});
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.clientResourcePath((String)this.samlClient.getId()), (ResourceType)ResourceType.CLIENT);
        response = this.samlClient.admin().getInstallationProvider("saml-sp-descriptor");
        doc = this.getDocumentFromXmlString(response);
        attrNamesAndValues.put("Binding", JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get());
        attrNamesAndValues.put("Location", "https://admin-url");
        this.assertElements(doc, JBossSAMLURIConstants.METADATA_NSURI.get(), "SingleLogoutService", attrNamesAndValues);
        this.assertElements(doc, JBossSAMLURIConstants.METADATA_NSURI.get(), "AssertionConsumerService", attrNamesAndValues);
        attrNamesAndValues.clear();
        this.samlClient.updateWithCleanup(new ManagedClient.ClientUpdate[]{c -> c.attribute("saml_assertion_consumer_url_post", "https://saml-assertion-post-url").attribute("saml_single_logout_service_url_post", "https://saml-logout-post-url").attribute("saml_assertion_consumer_url_redirect", "https://saml-assertion-redirect-url").attribute("saml_single_logout_service_url_redirect", "https://saml-logout-redirect-url")});
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.clientResourcePath((String)this.samlClient.getId()), (ResourceType)ResourceType.CLIENT);
        response = this.samlClient.admin().getInstallationProvider("saml-sp-descriptor");
        doc = this.getDocumentFromXmlString(response);
        attrNamesAndValues.put("Binding", JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get());
        attrNamesAndValues.put("Location", "https://saml-logout-redirect-url");
        this.assertElements(doc, JBossSAMLURIConstants.METADATA_NSURI.get(), "SingleLogoutService", attrNamesAndValues);
        attrNamesAndValues.clear();
        attrNamesAndValues.put("Binding", JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get());
        attrNamesAndValues.put("Location", "https://saml-assertion-redirect-url");
        this.assertElements(doc, JBossSAMLURIConstants.METADATA_NSURI.get(), "AssertionConsumerService", attrNamesAndValues);
    }

    @Test
    public void testPemsInModAuthMellonExportShouldBeFormattedInRfc7468() throws IOException {
        Response response = this.samlClient.admin().getInstallationProviderAsResponse("mod-auth-mellon");
        byte[] result = (byte[])response.readEntity(byte[].class);
        String clientPrivateKey = null;
        String clientCert = null;
        try (ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(result));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.getName().endsWith("client-private-key.pem")) {
                    clientPrivateKey = new String(zis.readAllBytes(), StandardCharsets.US_ASCII);
                    continue;
                }
                if (!entry.getName().endsWith("client-cert.pem")) continue;
                clientCert = new String(zis.readAllBytes(), StandardCharsets.US_ASCII);
            }
        }
        Assertions.assertNotNull(clientPrivateKey);
        Assertions.assertNotNull(clientCert);
        this.assertRfc7468PrivateKey(clientPrivateKey);
        this.assertRfc7468Cert(clientCert);
    }

    private void assertRfc7468PrivateKey(String result) {
        Assertions.assertTrue((boolean)result.startsWith("-----BEGIN PRIVATE KEY-----"));
        Assertions.assertTrue((boolean)result.endsWith("-----END PRIVATE KEY-----"));
        result.lines().forEach(line -> Assertions.assertTrue((line.length() <= 64 ? 1 : 0) != 0));
    }

    private void assertRfc7468Cert(String result) {
        Assertions.assertTrue((boolean)result.startsWith("-----BEGIN CERTIFICATE-----"));
        Assertions.assertTrue((boolean)result.endsWith("-----END CERTIFICATE-----"));
        result.lines().forEach(line -> Assertions.assertTrue((line.length() <= 64 ? 1 : 0) != 0));
    }

    private Document getDocumentFromXmlString(String xml) throws SAXException, ParserConfigurationException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        return db.parse(is);
    }

    private void assertElements(Document doc, String tagNamespace, String tagName, Map<String, String> attrNamesAndValues) {
        NodeList elementsByTagName = doc.getElementsByTagNameNS(tagNamespace, tagName);
        MatcherAssert.assertThat((String)("Expected exactly one " + tagName + " element!"), (Object)elementsByTagName.getLength(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        Node element = elementsByTagName.item(0);
        if (attrNamesAndValues != null) {
            for (Map.Entry<String, String> entry : attrNamesAndValues.entrySet()) {
                MatcherAssert.assertThat((Object)element.getAttributes().getNamedItem(entry.getKey()).getNodeValue(), (Matcher)Matchers.containsString((String)entry.getValue()));
            }
        }
    }

    public static class SamlClientConfig
    implements ClientConfig {
        public ClientConfigBuilder configure(ClientConfigBuilder client) {
            return client.clientId(InstallationTest.SAML_NAME).name(InstallationTest.SAML_NAME).protocol("saml");
        }
    }

    public static class OidcBearerOnlyWithAuthzClientConfig
    implements ClientConfig {
        public ClientConfigBuilder configure(ClientConfigBuilder client) {
            return client.clientId(InstallationTest.OIDC_NAME_BEARER_ONLY_WITH_AUTHZ_NAME).name(InstallationTest.OIDC_NAME_BEARER_ONLY_WITH_AUTHZ_NAME).protocol("openid-connect").bearerOnly(false).publicClient(false).authorizationServicesEnabled(true).serviceAccountsEnabled(true);
        }
    }

    public static class OidcBearerOnlyClientConfig
    implements ClientConfig {
        public ClientConfigBuilder configure(ClientConfigBuilder client) {
            return client.clientId(InstallationTest.OIDC_NAME_BEARER_ONLY_NAME).name(InstallationTest.OIDC_NAME_BEARER_ONLY_NAME).protocol("openid-connect").bearerOnly(true).publicClient(false);
        }
    }

    public static class OidcClientConfig
    implements ClientConfig {
        public ClientConfigBuilder configure(ClientConfigBuilder client) {
            return client.clientId(InstallationTest.OIDC_NAME).name(InstallationTest.OIDC_NAME).protocol("openid-connect");
        }
    }

    public static class InstallationTestServerConfig
    implements KeycloakServerConfig {
        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder config) {
            return config.features(new Profile.Feature[]{Profile.Feature.AUTHORIZATION});
        }
    }
}

