/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.client;

import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.ClientScopeResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testframework.annotations.InjectClient;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.oauth.OAuthClient;
import org.keycloak.testframework.oauth.annotations.InjectOAuthClient;
import org.keycloak.testframework.realm.ClientConfig;
import org.keycloak.testframework.realm.ClientConfigBuilder;
import org.keycloak.testframework.realm.ManagedClient;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.tests.utils.admin.ApiUtil;
import org.keycloak.testsuite.util.oauth.AccessTokenResponse;

@KeycloakIntegrationTest
public class ServiceAccountClientTest {
    @InjectRealm
    ManagedRealm managedRealm;
    @InjectClient(config=ServiceAccountClientConfig.class)
    ManagedClient managedClient;
    @InjectOAuthClient
    OAuthClient oAuthClient;
    private static final String clientId = "service-account-client";

    @Test
    public void testServiceAccountEnableDisable() {
        ClientScopeResource serviceAccountScopeRsc = ApiUtil.findClientScopeByName((RealmResource)this.managedRealm.admin(), (String)"service_account");
        Assertions.assertNotNull((Object)serviceAccountScopeRsc);
        ClientScopeRepresentation serviceAccountScope = serviceAccountScopeRsc.toRepresentation();
        MatcherAssert.assertThat(this.managedClient.admin().getDefaultClientScopes().stream().map(ClientScopeRepresentation::getName).collect(Collectors.toList()), (Matcher)Matchers.hasItem((Object)"service_account"));
        this.oAuthClient.client(clientId, "password");
        AccessTokenResponse response = this.oAuthClient.doClientCredentialsGrantAccessTokenRequest();
        AccessToken accessToken = this.oAuthClient.verifyToken(response.getAccessToken());
        Assertions.assertEquals((Object)clientId, accessToken.getOtherClaims().get("client_id"));
        Assertions.assertNotNull(accessToken.getOtherClaims().get("clientHost"));
        Assertions.assertNotNull(accessToken.getOtherClaims().get("clientAddress"));
        this.managedClient.updateWithCleanup(new ManagedClient.ClientUpdate[]{c -> c.serviceAccountsEnabled(false)});
        MatcherAssert.assertThat(this.managedClient.admin().getDefaultClientScopes().stream().map(ClientScopeRepresentation::getName).collect(Collectors.toList()), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)"service_account")));
        response = this.oAuthClient.doClientCredentialsGrantAccessTokenRequest();
        Assertions.assertEquals((Object)"unauthorized_client", (Object)response.getError());
        this.managedClient.updateWithCleanup(new ManagedClient.ClientUpdate[]{c -> c.serviceAccountsEnabled(true)});
        MatcherAssert.assertThat(this.managedClient.admin().getDefaultClientScopes().stream().map(ClientScopeRepresentation::getName).collect(Collectors.toList()), (Matcher)Matchers.hasItem((Object)"service_account"));
        response = this.oAuthClient.doClientCredentialsGrantAccessTokenRequest();
        accessToken = this.oAuthClient.verifyToken(response.getAccessToken());
        Assertions.assertEquals((Object)clientId, accessToken.getOtherClaims().get("client_id"));
        Assertions.assertNotNull(accessToken.getOtherClaims().get("clientHost"));
        Assertions.assertNotNull(accessToken.getOtherClaims().get("clientAddress"));
        this.managedClient.admin().removeDefaultClientScope(serviceAccountScope.getId());
        this.managedClient.admin().addOptionalClientScope(serviceAccountScope.getId());
        this.managedClient.updateWithCleanup(new ManagedClient.ClientUpdate[]{c -> c.serviceAccountsEnabled(true)});
        MatcherAssert.assertThat(this.managedClient.admin().getDefaultClientScopes().stream().map(ClientScopeRepresentation::getName).collect(Collectors.toList()), (Matcher)Matchers.hasItem((Object)"service_account"));
        response = this.oAuthClient.doClientCredentialsGrantAccessTokenRequest();
        accessToken = this.oAuthClient.verifyToken(response.getAccessToken());
        Assertions.assertEquals((Object)clientId, accessToken.getOtherClaims().get("client_id"));
        Assertions.assertNotNull(accessToken.getOtherClaims().get("clientHost"));
        Assertions.assertNotNull(accessToken.getOtherClaims().get("clientAddress"));
        UserRepresentation serviceAccountUser = this.managedClient.admin().getServiceAccountUser();
        this.managedRealm.admin().users().delete(serviceAccountUser.getId()).close();
        response = this.oAuthClient.doClientCredentialsGrantAccessTokenRequest();
        Assertions.assertEquals((Object)"invalid_request", (Object)response.getError());
    }

    private static class ServiceAccountClientConfig
    implements ClientConfig {
        private ServiceAccountClientConfig() {
        }

        public ClientConfigBuilder configure(ClientConfigBuilder client) {
            return client.clientId(ServiceAccountClientTest.clientId).protocol("openid-connect").secret("password").serviceAccountsEnabled(true).authenticatorType("client-secret").publicClient(false);
        }
    }
}

