/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.concurrency;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.testframework.admin.AdminClientFactory;
import org.keycloak.testframework.annotations.InjectAdminClientFactory;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.config.Config;
import org.keycloak.testframework.realm.ManagedRealm;

public abstract class AbstractConcurrencyTest {
    @InjectRealm
    ManagedRealm managedRealm;
    @InjectAdminClientFactory
    static AdminClientFactory clientFactory;
    private static final Logger LOGGER;
    private static final int DEFAULT_THREADS = 4;
    public static final String REALM_NAME = "default";
    public static final String MASTER_REALM_NAME = "master";
    private static final boolean SYNCHRONIZED = false;

    protected void run(KeycloakRunnable ... runnables) {
        AbstractConcurrencyTest.run(4, runnables);
    }

    public static void run(int numThreads, KeycloakRunnable ... runnables) {
        ExecutorService service = Executors.newFixedThreadPool(numThreads);
        ThreadLocal<Keycloak> keycloaks = new ThreadLocal<Keycloak>(){

            @Override
            protected Keycloak initialValue() {
                return clientFactory.create().realm(AbstractConcurrencyTest.MASTER_REALM_NAME).clientId(Config.getAdminClientId()).clientSecret(Config.getAdminClientSecret()).grantType("client_credentials").build();
            }
        };
        AtomicInteger currentThreadIndex = new AtomicInteger();
        LinkedList tasks = new LinkedList();
        ConcurrentLinkedQueue<Exception> failures = new ConcurrentLinkedQueue<Exception>();
        LinkedList<Callable<Void>> runnablesToTasks = new LinkedList<Callable<Void>>();
        Set<Keycloak> usedKeycloaks = Collections.synchronizedSet(new HashSet());
        for (KeycloakRunnable runnable : runnables) {
            runnablesToTasks.add(() -> {
                int arrayIndex = currentThreadIndex.getAndIncrement() % numThreads;
                try {
                    Keycloak keycloak = (Keycloak)keycloaks.get();
                    usedKeycloaks.add(keycloak);
                    runnable.run(arrayIndex % numThreads, keycloak, keycloak.realm(REALM_NAME));
                }
                catch (Throwable ex) {
                    failures.add((Exception)ex);
                }
                return null;
            });
        }
        tasks.addAll(runnablesToTasks);
        try {
            service.invokeAll(tasks);
            service.shutdown();
            service.awaitTermination(3L, TimeUnit.MINUTES);
        }
        catch (InterruptedException ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                for (Keycloak keycloak : usedKeycloaks) {
                    try {
                        keycloak.close();
                    }
                    catch (Exception e2) {
                        failures.add(e2);
                    }
                }
                throw throwable;
            }
        }
        for (Keycloak keycloak : usedKeycloaks) {
            try {
                keycloak.close();
            }
            catch (Exception e2) {
                failures.add(e2);
            }
        }
        if (!failures.isEmpty()) {
            RuntimeException ex = new RuntimeException("There were failures in threads. Failures count: " + failures.size());
            failures.forEach(ex::addSuppressed);
            failures.forEach(e -> LOGGER.error((Object)e.getMessage(), e));
            throw ex;
        }
    }

    static {
        LOGGER = Logger.getLogger(AbstractConcurrencyTest.class);
    }

    public static interface KeycloakRunnable {
        public void run(int var1, Keycloak var2, RealmResource var3) throws Throwable;
    }
}

