/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.concurrency;

import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.admin.client.resource.UserProfileResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.tests.admin.concurrency.AbstractConcurrencyTest;
import org.keycloak.tests.utils.admin.ApiUtil;
import org.keycloak.testsuite.util.userprofile.UserProfileUtil;

@KeycloakIntegrationTest
public class ConcurrencyTest
extends AbstractConcurrencyTest {
    @Test
    public void createUserAttributes() throws Throwable {
        String userId;
        AtomicInteger c = new AtomicInteger();
        UsersResource users = this.managedRealm.admin().users();
        UserProfileUtil.enableUnmanagedAttributes((UserProfileResource)users.userProfile());
        UserRepresentation u = UserConfigBuilder.create().username("attributes").build();
        try (Response response = users.create(u);){
            userId = ApiUtil.getCreatedId((Response)response);
        }
        UserResource user = users.get(userId);
        this.concurrentTest((threadIndex, keycloak, realm) -> {
            UserRepresentation rep = user.toRepresentation();
            rep.singleAttribute("a-" + c.getAndIncrement(), "value");
            user.update(rep);
        });
        UserRepresentation rep = user.toRepresentation();
        Assertions.assertTrue((rep.getAttributes().size() <= c.get() ? 1 : 0) != 0);
        for (Map.Entry e : rep.getAttributes().entrySet()) {
            Assertions.assertEquals((int)1, (int)((List)e.getValue()).size());
        }
    }

    @Test
    public void testAllConcurrently() throws Throwable {
        AtomicInteger uniqueCounter = new AtomicInteger(100000);
        this.concurrentTest(new CreateClient(uniqueCounter), new CreateRemoveClient(uniqueCounter), new CreateGroup(uniqueCounter), new CreateRole(uniqueCounter));
    }

    @Test
    public void createClient() throws Throwable {
        AtomicInteger uniqueCounter = new AtomicInteger();
        this.concurrentTest(new CreateClient(uniqueCounter));
    }

    @Test
    public void createGroup() throws Throwable {
        AtomicInteger uniqueCounter = new AtomicInteger();
        this.concurrentTest(new CreateGroup(uniqueCounter));
    }

    @Test
    public void createRemoveClient() throws Throwable {
        AtomicInteger uniqueCounter = new AtomicInteger();
        this.concurrentTest(new CreateRemoveClient(uniqueCounter));
    }

    @Test
    public void createClientRole() throws Throwable {
        String clientId;
        ClientRepresentation c = new ClientRepresentation();
        c.setClientId("client");
        try (Response response = this.managedRealm.admin().clients().create(c);){
            clientId = ApiUtil.getCreatedId((Response)response);
        }
        AtomicInteger uniqueCounter = new AtomicInteger();
        this.concurrentTest(new CreateClientRole(uniqueCounter, clientId));
    }

    @Test
    public void createRole() throws Throwable {
        AtomicInteger uniqueCounter = new AtomicInteger();
        this.run(new CreateRole(uniqueCounter));
    }

    public void concurrentTest(AbstractConcurrencyTest.KeycloakRunnable ... tasks) throws Throwable {
        System.out.println("***************************");
        long start = System.currentTimeMillis();
        this.run(tasks);
        long end = System.currentTimeMillis() - start;
        System.out.println("took " + end + " ms");
    }

    private class CreateClient
    implements AbstractConcurrencyTest.KeycloakRunnable {
        private final AtomicInteger clientIndex;

        public CreateClient(AtomicInteger clientIndex) {
            this.clientIndex = clientIndex;
        }

        @Override
        public void run(int threadIndex, Keycloak keycloak, RealmResource realm) throws Throwable {
            String id;
            String name = "cc-" + this.clientIndex.getAndIncrement();
            ClientRepresentation c = new ClientRepresentation();
            c.setClientId(name);
            try (Response response = realm.clients().create(c);){
                id = ApiUtil.getCreatedId((Response)response);
            }
            c = realm.clients().get(id).toRepresentation();
            Assertions.assertNotNull((Object)c);
            int findAttempts = 5;
            boolean clientFound = IntStream.range(0, findAttempts).anyMatch(i -> realm.clients().findAll().stream().map(ClientRepresentation::getClientId).filter(Objects::nonNull).anyMatch(name::equals));
            Assertions.assertTrue((boolean)clientFound, (String)("Client " + name + " not found in client list after " + findAttempts + " attempts"));
        }
    }

    private class CreateRemoveClient
    implements AbstractConcurrencyTest.KeycloakRunnable {
        private final AtomicInteger clientIndex;

        public CreateRemoveClient(AtomicInteger clientIndex) {
            this.clientIndex = clientIndex;
        }

        @Override
        public void run(int threadIndex, Keycloak keycloak, RealmResource realm) throws Throwable {
            String id;
            String name = "crc-" + this.clientIndex.getAndIncrement();
            ClientRepresentation c = new ClientRepresentation();
            c.setClientId(name);
            ClientsResource clients = realm.clients();
            try (Response response = clients.create(c);){
                id = ApiUtil.getCreatedId((Response)response);
            }
            ClientResource client = clients.get(id);
            c = client.toRepresentation();
            Assertions.assertNotNull((Object)c);
            int findAttempts = 5;
            boolean clientFound = IntStream.range(0, findAttempts).anyMatch(i -> clients.findAll().stream().map(ClientRepresentation::getClientId).filter(Objects::nonNull).anyMatch(name::equals));
            Assertions.assertTrue((boolean)clientFound, (String)("Client " + name + " not found in client list after " + findAttempts + " attempts"));
            client.remove();
            try {
                client.toRepresentation();
                Assertions.fail((String)("Client " + name + " should not be found.  Should throw a 404"));
            }
            catch (NotFoundException notFoundException) {
            }
            Assertions.assertFalse((boolean)clients.findAll().stream().map(ClientRepresentation::getClientId).filter(Objects::nonNull).anyMatch(name::equals), (String)("Client " + name + " should now not present in client list"));
        }
    }

    private class CreateGroup
    implements AbstractConcurrencyTest.KeycloakRunnable {
        private final AtomicInteger uniqueIndex;

        public CreateGroup(AtomicInteger uniqueIndex) {
            this.uniqueIndex = uniqueIndex;
        }

        @Override
        public void run(int threadIndex, Keycloak keycloak, RealmResource realm) throws Throwable {
            String id;
            String name = "g-" + this.uniqueIndex.getAndIncrement();
            GroupRepresentation c = new GroupRepresentation();
            c.setName(name);
            try (Response response = realm.groups().add(c);){
                id = ApiUtil.getCreatedId((Response)response);
            }
            c = realm.groups().group(id).toRepresentation();
            Assertions.assertNotNull((Object)c);
            Assertions.assertTrue((boolean)realm.groups().groups().stream().map(GroupRepresentation::getName).filter(Objects::nonNull).anyMatch(name::equals), (String)("Group " + name + " [" + id + "]  not found in group list"));
        }
    }

    private class CreateRole
    implements AbstractConcurrencyTest.KeycloakRunnable {
        private final AtomicInteger uniqueCounter;

        public CreateRole(AtomicInteger uniqueCounter) {
            this.uniqueCounter = uniqueCounter;
        }

        @Override
        public void run(int threadIndex, Keycloak keycloak, RealmResource realm) throws Throwable {
            String name = "r-" + this.uniqueCounter.getAndIncrement();
            RoleRepresentation r = new RoleRepresentation(name, null, false);
            RolesResource roles = realm.roles();
            roles.create(r);
            Assertions.assertNotNull((Object)roles.get(name).toRepresentation());
        }
    }

    private class CreateClientRole
    implements AbstractConcurrencyTest.KeycloakRunnable {
        private final AtomicInteger uniqueCounter;
        private final String clientId;

        public CreateClientRole(AtomicInteger uniqueCounter, String clientId) {
            this.uniqueCounter = uniqueCounter;
            this.clientId = clientId;
        }

        @Override
        public void run(int threadIndex, Keycloak keycloak, RealmResource realm) throws Throwable {
            String name = "cr-" + this.uniqueCounter.getAndIncrement();
            RoleRepresentation r = new RoleRepresentation(name, null, false);
            RolesResource roles = realm.clients().get(this.clientId).roles();
            roles.create(r);
            Assertions.assertNotNull((Object)roles.get(name).toRepresentation());
        }
    }
}

