/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.event;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testframework.annotations.InjectAdminClient;
import org.keycloak.testframework.annotations.InjectAdminEvents;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.events.AdminEvents;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.RealmConfig;
import org.keycloak.testframework.realm.RealmConfigBuilder;
import org.keycloak.tests.utils.admin.AdminEventPaths;
import org.keycloak.tests.utils.admin.ApiUtil;
import org.opentest4j.AssertionFailedError;

@KeycloakIntegrationTest
public class AdminEventAuthDetailsTest {
    @InjectRealm(config=AdminEventsAuthDetailsRealmConfig.class)
    ManagedRealm managedRealm;
    @InjectAdminClient(ref="admin", mode=InjectAdminClient.Mode.MANAGED_REALM, client="client", user="admin")
    Keycloak adminClient;
    @InjectAdminEvents
    AdminEvents adminEvents;
    private String clientUuid;
    private String adminId;
    private String appUserId;
    private String adminCliUuid;

    @BeforeEach
    public void initConfig() {
        this.clientUuid = ((ClientRepresentation)this.adminClient.realm(this.managedRealm.getName()).clients().findByClientId("client").get(0)).getId();
        this.adminId = ((UserRepresentation)this.adminClient.realm(this.managedRealm.getName()).users().search("admin", Boolean.valueOf(true)).get(0)).getId();
        this.appUserId = ((UserRepresentation)this.adminClient.realm(this.managedRealm.getName()).users().search("app-user", Boolean.valueOf(true)).get(0)).getId();
        this.adminCliUuid = ApiUtil.findClientByClientId((RealmResource)this.managedRealm.admin(), (String)"admin-cli").toRepresentation().getId();
    }

    @Test
    public void testAuthSuccess() {
        this.testClient(this.adminClient, this.appUserId, this.managedRealm.getId(), this.clientUuid, this.adminId);
    }

    @Test
    public void testAuthFailure() {
        Assertions.assertThrows(AssertionFailedError.class, () -> this.testClient(this.adminClient, this.appUserId, this.managedRealm.getId(), this.adminCliUuid, this.adminId));
    }

    private void testClient(Keycloak admin, String userId, String expectedRealmId, String expectedClientUuid, String expectedUserId) {
        UserRepresentation rep = admin.realm(this.managedRealm.getName()).users().get(userId).toRepresentation();
        rep.setEmail("foo@email.org");
        admin.realm(this.managedRealm.getName()).users().get(userId).update(rep);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.userResourcePath((String)userId), (Object)rep, (ResourceType)ResourceType.USER).auth(expectedRealmId, expectedClientUuid, expectedUserId);
    }

    public static class AdminEventsAuthDetailsRealmConfig
    implements RealmConfig {
        public RealmConfigBuilder configure(RealmConfigBuilder realm) {
            realm.addClient("client").name("client").publicClient(true).directAccessGrantsEnabled(true);
            realm.addUser("admin").password("password").name("My", "Admin").email("admin@localhost").emailVerified(true).clientRoles("realm-management", new String[]{"realm-admin"});
            realm.addUser("app-user").password("password");
            return realm;
        }
    }
}

