/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.event;

import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.events.admin.AuthDetails;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.AuthDetailsRepresentation;
import org.keycloak.representations.idm.OrganizationDomainRepresentation;
import org.keycloak.representations.idm.OrganizationRepresentation;
import org.keycloak.representations.idm.RealmEventsConfigRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testframework.annotations.InjectAdminClient;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.RealmConfig;
import org.keycloak.testframework.realm.RealmConfigBuilder;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.testframework.remote.providers.runonserver.RunOnServer;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.tests.utils.admin.ApiUtil;
import org.keycloak.util.JsonSerialization;

@KeycloakIntegrationTest
public class AdminEventTest {
    @InjectRealm(attachTo="master", ref="master")
    ManagedRealm masterRealm;
    @InjectRealm(config=AdminEventRealmConfig.class, ref="default")
    ManagedRealm managedRealm;
    @InjectAdminClient(mode=InjectAdminClient.Mode.BOOTSTRAP)
    Keycloak adminClient;
    @InjectRunOnServer(realmRef="default")
    RunOnServerClient runOnServerClient;

    @BeforeEach
    public void initConfig() {
        this.managedRealm.admin().clearAdminEvents();
    }

    private List<AdminEventRepresentation> events() {
        return this.managedRealm.admin().getAdminEvents();
    }

    private String createUser(String username) {
        UserRepresentation user = UserConfigBuilder.create().username(username).email(username + "@foo.com").name("foo", "bar").password("password").build();
        String userUuid = ApiUtil.getCreatedId((Response)this.managedRealm.admin().users().create(user));
        this.managedRealm.cleanup().add(r -> r.users().get(userUuid).remove());
        return userUuid;
    }

    @Test
    public void clearAdminEventsTest() {
        this.createUser("user0");
        Assertions.assertEquals((int)1, (int)this.events().size());
        this.managedRealm.admin().clearAdminEvents();
        Assertions.assertEquals((int)0, (int)this.events().size());
    }

    @Test
    public void adminEventAttributeTest() {
        this.createUser("user5");
        List<AdminEventRepresentation> events = this.events();
        Assertions.assertEquals((int)1, (int)events.size());
        AdminEventRepresentation event = events.get(0);
        AdminEventAssertion.assertSuccess((AdminEventRepresentation)event).operationType(OperationType.CREATE);
        Assertions.assertTrue((event.getTime() > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((Object)this.managedRealm.getId(), (Object)event.getRealmId());
        Assertions.assertNotNull((Object)event.getResourcePath());
        AuthDetailsRepresentation details = event.getAuthDetails();
        Assertions.assertEquals((Object)this.masterRealm.getId(), (Object)details.getRealmId());
        Assertions.assertNotNull((Object)details.getClientId());
        Assertions.assertNotNull((Object)details.getUserId());
        Assertions.assertNotNull((Object)details.getIpAddress());
    }

    @Test
    public void testEventDetails() {
        String userUuid = this.createUser("user5");
        UserRepresentation userRep = this.managedRealm.admin().users().get(userUuid).toRepresentation();
        this.managedRealm.updateWithCleanup(new ManagedRealm.RealmUpdate[]{r -> r.organizationsEnabled(true)});
        OrganizationRepresentation orgRep = new OrganizationRepresentation();
        orgRep.setName("test-org");
        orgRep.setAlias(orgRep.getName());
        orgRep.addDomain(new OrganizationDomainRepresentation(orgRep.getName()));
        this.managedRealm.admin().organizations().create(orgRep).close();
        orgRep = (OrganizationRepresentation)this.managedRealm.admin().organizations().list(Integer.valueOf(-1), Integer.valueOf(-1)).get(0);
        this.managedRealm.admin().organizations().get(orgRep.getId()).members().addMember(userUuid).close();
        String orgId = orgRep.getId();
        this.managedRealm.cleanup().add(r -> r.organizations().get(orgId).delete());
        List<AdminEventRepresentation> events = this.events();
        Assertions.assertEquals((int)4, (int)events.size());
        AdminEventRepresentation event = events.get(0);
        AdminEventAssertion.assertSuccess((AdminEventRepresentation)event).operationType(OperationType.CREATE).resourceType(ResourceType.ORGANIZATION_MEMBERSHIP);
        Assertions.assertEquals((Object)this.managedRealm.getId(), (Object)event.getRealmId());
        MatcherAssert.assertThat((Object)event.getDetails(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(Map.of("username", userRep.getUsername(), "email", userRep.getEmail()))));
    }

    @Test
    public void retrieveAdminEventTest() {
        this.createUser("user1");
        List<AdminEventRepresentation> events = this.events();
        Assertions.assertEquals((int)1, (int)events.size());
        AdminEventRepresentation event = this.events().get(0);
        AdminEventAssertion.assertSuccess((AdminEventRepresentation)event).operationType(OperationType.CREATE);
        Assertions.assertEquals((Object)this.managedRealm.getId(), (Object)event.getRealmId());
        Assertions.assertEquals((Object)this.masterRealm.getId(), (Object)event.getAuthDetails().getRealmId());
        Assertions.assertNull((Object)event.getRepresentation());
    }

    @Test
    public void testGetRepresentation() {
        this.managedRealm.updateWithCleanup(new ManagedRealm.RealmUpdate[]{r -> r.adminEventsDetailsEnabled(true)});
        this.createUser("user2");
        AdminEventRepresentation event = this.events().stream().filter(adminEventRep -> adminEventRep.getOperationType().equals("CREATE")).findFirst().orElseThrow(() -> new IllegalStateException("Wasn't able to obtain CREATE admin event."));
        Assertions.assertNotNull((Object)event.getRepresentation());
        MatcherAssert.assertThat((Object)event.getRepresentation(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"foo"), (Matcher)Matchers.containsString((String)"bar")));
    }

    @Test
    public void testFilterAdminEvents() {
        this.createUser("user3");
        this.createUser("user4");
        this.managedRealm.updateWithCleanup(new ManagedRealm.RealmUpdate[]{r -> r.displayName("Fury Road")});
        Assertions.assertEquals((int)3, (int)this.events().size());
        List events = this.managedRealm.admin().getAdminEvents(List.of("CREATE"), null, null, null, null, null, null, null, null, null);
        Assertions.assertEquals((int)2, (int)events.size());
    }

    @Test
    public void defaultMaxResults() {
        RealmResource realm = this.managedRealm.admin();
        String realmId = this.managedRealm.getId();
        this.runOnServerClient.run((RunOnServer & Serializable)session -> {
            EventStoreProvider provider = (EventStoreProvider)session.getProvider(EventStoreProvider.class);
            AdminEvent event = new AdminEvent();
            event.setOperationType(OperationType.CREATE);
            event.setAuthDetails(new AuthDetails());
            event.setRealmId(realmId);
            for (int i = 0; i < 110; ++i) {
                event.setId(UUID.randomUUID().toString());
                provider.onEvent(event, false);
            }
        });
        Assertions.assertEquals((int)100, (int)realm.getAdminEvents(null, null, null, null, null, null, null, null, null, null).size());
        Assertions.assertEquals((int)105, (int)realm.getAdminEvents(null, null, null, null, null, null, null, null, Integer.valueOf(0), Integer.valueOf(105)).size());
        Assertions.assertEquals((int)110, (int)realm.getAdminEvents(null, null, null, null, null, null, null, null, Integer.valueOf(0), Integer.valueOf(1000)).size());
    }

    @Test
    public void adminEventRepresentationLenght() {
        RealmResource realm = this.managedRealm.admin();
        String realmId = this.managedRealm.getId();
        String longValue = RandomStringUtils.secure().next(30000, true, true);
        this.runOnServerClient.run((RunOnServer & Serializable)session -> {
            EventStoreProvider provider = (EventStoreProvider)session.getProvider(EventStoreProvider.class);
            AdminEvent event = new AdminEvent();
            event.setOperationType(OperationType.CREATE);
            event.setAuthDetails(new AuthDetails());
            event.setRealmId(realmId);
            event.setRepresentation(longValue);
            provider.onEvent(event, true);
        });
        List adminEvents = realm.getAdminEvents(null, null, null, null, null, null, null, null, null, null);
        Assertions.assertEquals((int)1, (int)adminEvents.size());
        Assertions.assertEquals((Object)longValue, (Object)((AdminEventRepresentation)adminEvents.get(0)).getRepresentation());
    }

    @Test
    public void orderResultsTest() {
        RealmResource realm = this.managedRealm.admin();
        String realmId = this.managedRealm.getId();
        this.runOnServerClient.run((RunOnServer & Serializable)session -> {
            EventStoreProvider provider = (EventStoreProvider)session.getProvider(EventStoreProvider.class);
            AdminEvent firstEvent = new AdminEvent();
            firstEvent.setOperationType(OperationType.CREATE);
            firstEvent.setAuthDetails(new AuthDetails());
            firstEvent.setRealmId(realmId);
            firstEvent.setTime(System.currentTimeMillis() - 1000L);
            AdminEvent secondEvent = new AdminEvent();
            secondEvent.setOperationType(OperationType.DELETE);
            secondEvent.setAuthDetails(new AuthDetails());
            secondEvent.setRealmId(realmId);
            secondEvent.setTime(System.currentTimeMillis());
            provider.onEvent(firstEvent, false);
            provider.onEvent(secondEvent, false);
        });
        List adminEvents = realm.getAdminEvents(null, null, null, null, null, null, null, null, null, null, null, "desc");
        Assertions.assertEquals((int)2, (int)adminEvents.size());
        Assertions.assertEquals((Object)OperationType.DELETE.toString(), (Object)((AdminEventRepresentation)adminEvents.get(0)).getOperationType());
        Assertions.assertEquals((Object)OperationType.CREATE.toString(), (Object)((AdminEventRepresentation)adminEvents.get(1)).getOperationType());
        adminEvents = realm.getAdminEvents(null, null, null, null, null, null, null, null, null, null, null, "asc");
        Assertions.assertEquals((int)2, (int)adminEvents.size());
        Assertions.assertEquals((Object)OperationType.DELETE.toString(), (Object)((AdminEventRepresentation)adminEvents.get(1)).getOperationType());
        Assertions.assertEquals((Object)OperationType.CREATE.toString(), (Object)((AdminEventRepresentation)adminEvents.get(0)).getOperationType());
    }

    @Test
    public void filterByEpochTimeStamp() {
        RealmResource realm = this.managedRealm.admin();
        String realmId = this.managedRealm.getId();
        long currentTime = System.currentTimeMillis();
        this.runOnServerClient.run((RunOnServer & Serializable)session -> {
            EventStoreProvider provider = (EventStoreProvider)session.getProvider(EventStoreProvider.class);
            AdminEvent event = new AdminEvent();
            event.setOperationType(OperationType.CREATE);
            event.setAuthDetails(new AuthDetails());
            event.setRealmId(realmId);
            event.setTime(currentTime - 172800000L);
            provider.onEvent(event, false);
            event.setTime(currentTime - 1000L);
            provider.onEvent(event, false);
            event.setTime(currentTime);
            provider.onEvent(event, false);
            event.setTime(currentTime + 1000L);
            provider.onEvent(event, false);
            event.setTime(currentTime + 172800000L);
            provider.onEvent(event, false);
        });
        List events = realm.getAdminEvents();
        Assertions.assertEquals((int)5, (int)events.size());
        events = realm.getAdminEvents(null, null, null, null, null, null, null, currentTime, currentTime, null, null, null);
        Assertions.assertEquals((int)1, (int)events.size());
        events = realm.getAdminEvents(null, null, null, null, null, null, null, currentTime - 1000L, currentTime + 1000L, null, null, null);
        Assertions.assertEquals((int)3, (int)events.size());
        LocalDate dateFrom = Instant.ofEpochMilli(currentTime - 1000L).atZone(ZoneOffset.UTC).toLocalDate();
        LocalDate dateTo = Instant.ofEpochMilli(currentTime + 1000L).atZone(ZoneOffset.UTC).toLocalDate();
        events = realm.getAdminEvents(null, null, null, null, null, null, null, dateFrom.toString(), dateTo.toString(), null, null, null);
        Assertions.assertEquals((int)3, (int)events.size());
    }

    private void checkUpdateRealmEventsConfigEvent(int size) {
        List<AdminEventRepresentation> events = this.events();
        Assertions.assertEquals((int)size, (int)events.size());
        AdminEventRepresentation event = events.get(0);
        AdminEventAssertion.assertSuccess((AdminEventRepresentation)event).operationType(OperationType.UPDATE).resourcePath(new String[]{"events", "config"});
        Assertions.assertEquals((Object)this.managedRealm.getId(), (Object)event.getRealmId());
        Assertions.assertEquals((Object)this.masterRealm.getId(), (Object)event.getAuthDetails().getRealmId());
        Assertions.assertNotNull((Object)event.getRepresentation());
    }

    private RealmEventsConfigRepresentation updateEventsConfig(RealmEventsConfigRepresentation configRep) {
        this.managedRealm.admin().updateRealmEventsConfig(configRep);
        return this.managedRealm.admin().getRealmEventsConfig();
    }

    @Test
    public void updateRealmEventsConfig() {
        RealmEventsConfigRepresentation configRep = this.managedRealm.admin().getRealmEventsConfig();
        configRep.setAdminEventsDetailsEnabled(Boolean.valueOf(true));
        configRep.setAdminEventsEnabled(Boolean.valueOf(true));
        configRep = this.updateEventsConfig(configRep);
        this.checkUpdateRealmEventsConfigEvent(1);
        configRep.setEventsEnabled(true);
        configRep = this.updateEventsConfig(configRep);
        this.checkUpdateRealmEventsConfigEvent(2);
        configRep.setAdminEventsEnabled(Boolean.valueOf(false));
        configRep = this.updateEventsConfig(configRep);
        this.checkUpdateRealmEventsConfigEvent(3);
        configRep.setAdminEventsDetailsEnabled(Boolean.valueOf(false));
        configRep = this.updateEventsConfig(configRep);
        MatcherAssert.assertThat((Object)this.events().size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)3)));
        configRep.setAdminEventsEnabled(Boolean.valueOf(true));
        this.updateEventsConfig(configRep);
    }

    @Test
    public void createAndDeleteRealm() {
        RealmEventsConfigRepresentation masterConfig = this.masterRealm.admin().getRealmEventsConfig();
        masterConfig.setAdminEventsDetailsEnabled(Boolean.valueOf(true));
        masterConfig.setAdminEventsEnabled(Boolean.valueOf(true));
        this.masterRealm.admin().updateRealmEventsConfig(masterConfig);
        this.masterRealm.admin().clearAdminEvents();
        String testRealm = "test-realm";
        RealmRepresentation realm = new RealmRepresentation();
        realm.setId(testRealm);
        realm.setRealm(testRealm);
        this.adminClient.realms().create(realm);
        this.adminClient.realm(realm.getRealm()).remove();
        List events = this.masterRealm.admin().getAdminEvents();
        Assertions.assertEquals((int)2, (int)events.size());
        AdminEventRepresentation createEvent = (AdminEventRepresentation)events.get(1);
        AdminEventAssertion.assertSuccess((AdminEventRepresentation)createEvent).operationType(OperationType.CREATE).resourceType(ResourceType.REALM).resourcePath(new String[]{testRealm});
        Assertions.assertEquals((Object)this.masterRealm.getId(), (Object)createEvent.getRealmId());
        Assertions.assertNotNull((Object)createEvent.getRepresentation());
        AdminEventRepresentation deleteEvent = (AdminEventRepresentation)events.get(0);
        AdminEventAssertion.assertSuccess((AdminEventRepresentation)deleteEvent).operationType(OperationType.DELETE).resourceType(ResourceType.REALM).resourcePath(new String[]{testRealm});
        Assertions.assertEquals((Object)this.masterRealm.getId(), (Object)deleteEvent.getRealmId());
    }

    @Test
    public void testStripOutUserSensitiveData() throws IOException {
        this.managedRealm.updateWithCleanup(new ManagedRealm.RealmUpdate[]{r -> {
            r.adminEventsDetailsEnabled(true);
            r.adminEventsEnabled(true);
            return r;
        }});
        UserResource user = this.managedRealm.admin().users().get(this.createUser("sensitive"));
        List<AdminEventRepresentation> events = this.events();
        UserRepresentation eventUserRep = (UserRepresentation)JsonSerialization.readValue((String)events.get(0).getRepresentation(), UserRepresentation.class);
        Assertions.assertNull((Object)eventUserRep.getCredentials());
        UserRepresentation userRep = user.toRepresentation();
        userRep = UserConfigBuilder.update((UserRepresentation)userRep).password("password").build();
        user.update(userRep);
        events = this.events();
        eventUserRep = (UserRepresentation)JsonSerialization.readValue((String)events.get(0).getRepresentation(), UserRepresentation.class);
        Assertions.assertNull((Object)eventUserRep.getCredentials());
    }

    private static class AdminEventRealmConfig
    implements RealmConfig {
        private AdminEventRealmConfig() {
        }

        public RealmConfigBuilder configure(RealmConfigBuilder realm) {
            return realm.eventsEnabled(true).adminEventsEnabled(true).adminEventsDetailsEnabled(false);
        }
    }
}

