/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.event;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.InjectUser;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.mail.MailServer;
import org.keycloak.testframework.mail.annotations.InjectMailServer;
import org.keycloak.testframework.oauth.OAuthClient;
import org.keycloak.testframework.oauth.annotations.InjectOAuthClient;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.ManagedUser;
import org.keycloak.testframework.realm.RealmConfig;
import org.keycloak.testframework.realm.RealmConfigBuilder;
import org.keycloak.testframework.realm.UserConfig;
import org.keycloak.testframework.realm.UserConfigBuilder;

@KeycloakIntegrationTest
public class EmailEventListenerTest {
    @InjectRealm(config=EmailSenderRealmConfig.class)
    ManagedRealm realm;
    @InjectUser(config=UserWithEmail.class)
    ManagedUser user;
    @InjectMailServer
    MailServer mail;
    @InjectOAuthClient
    OAuthClient oAuthClient;

    @Test
    public void testFailedLoginEmailEvent() throws MessagingException {
        this.oAuthClient.doPasswordGrantRequest(this.user.getUsername(), "invalid");
        this.mail.waitForIncomingEmail(1);
        MimeMessage lastReceivedMessage = this.mail.getLastReceivedMessage();
        Assertions.assertEquals((Object)"Login error", (Object)lastReceivedMessage.getSubject());
    }

    public static class UserWithEmail
    implements UserConfig {
        public UserConfigBuilder configure(UserConfigBuilder user) {
            return user.username("test").email("test@local").password("password").emailVerified(true);
        }
    }

    public static class EmailSenderRealmConfig
    implements RealmConfig {
        public RealmConfigBuilder configure(RealmConfigBuilder realm) {
            return realm.eventsListeners(new String[]{"email"});
        }
    }
}

