/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.event;

import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.keycloak.representations.idm.RealmEventsConfigRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.RealmConfig;
import org.keycloak.testframework.realm.RealmConfigBuilder;

@KeycloakIntegrationTest
public class EventConfigTest {
    @InjectRealm(config=EventConfigRealmConfig.class)
    ManagedRealm configRealm;
    RealmEventsConfigRepresentation configRep;

    @BeforeEach
    public void setConfigRep() {
        this.configRep = this.configRealm.admin().getRealmEventsConfig();
    }

    @Test
    public void defaultEventConfigTest() {
        this.configRealm.updateWithCleanup(new ManagedRealm.RealmUpdate[]{r -> r.eventsEnabled(false).adminEventsEnabled(false)});
        this.configRep = this.configRealm.admin().getRealmEventsConfig();
        Assertions.assertFalse((boolean)this.configRep.isAdminEventsDetailsEnabled());
        Assertions.assertFalse((boolean)this.configRep.isAdminEventsEnabled());
        Assertions.assertFalse((boolean)this.configRep.isEventsEnabled());
        List eventListeners = this.configRep.getEventsListeners();
        Assertions.assertEquals((int)1, (int)eventListeners.size());
        Assertions.assertEquals((Object)"jboss-logging", eventListeners.get(0));
    }

    @Test
    public void enableEventsTest() {
        Assertions.assertTrue((boolean)this.configRep.isEventsEnabled());
        Assertions.assertTrue((boolean)this.configRep.isAdminEventsEnabled());
    }

    @Test
    public void addRemoveListenerTest() {
        this.configRealm.updateWithCleanup(new ManagedRealm.RealmUpdate[]{r -> r.eventsEnabled(false).adminEventsEnabled(false).overwriteEventsListeners(new String[0])});
        this.configRep = this.configRealm.admin().getRealmEventsConfig();
        Assertions.assertEquals((int)0, (int)this.configRep.getEventsListeners().size());
        this.configRealm.updateWithCleanup(new ManagedRealm.RealmUpdate[]{r -> r.overwriteEventsListeners(new String[]{"email"})});
        this.configRep = this.configRealm.admin().getRealmEventsConfig();
        List eventListeners = this.configRep.getEventsListeners();
        Assertions.assertEquals((int)1, (int)eventListeners.size());
        Assertions.assertEquals((Object)"email", eventListeners.get(0));
    }

    @Test
    public void loginEventSettingsTest() {
        Assertions.assertTrue((boolean)this.hasEventType("LOGIN"));
        Assertions.assertTrue((boolean)this.hasEventType("LOGOUT"));
        Assertions.assertTrue((boolean)this.hasEventType("CLIENT_DELETE_ERROR"));
        int defaultEventCount = this.configRep.getEnabledEventTypes().size();
        this.configRealm.updateWithCleanup(new ManagedRealm.RealmUpdate[]{r -> r.enabledEventTypes(new String[]{"CLIENT_DELETE", "CLIENT_DELETE_ERROR"})});
        List enabledEventTypes = this.configRealm.admin().getRealmEventsConfig().getEnabledEventTypes();
        Assertions.assertEquals((int)2, (int)enabledEventTypes.size());
        this.configRealm.updateWithCleanup(new ManagedRealm.RealmUpdate[]{rec$ -> rec$.setEnabledEventTypes(new String[0])});
        Assertions.assertEquals((int)defaultEventCount, (int)this.configRealm.admin().getRealmEventsConfig().getEnabledEventTypes().size());
    }

    private boolean hasEventType(String eventType) {
        for (String event : this.configRep.getEnabledEventTypes()) {
            if (!eventType.equals(event)) continue;
            return true;
        }
        return false;
    }

    @Test
    public void includeRepresentationTest() {
        Assertions.assertTrue((boolean)this.configRep.isAdminEventsEnabled());
        Assertions.assertFalse((boolean)this.configRep.isAdminEventsDetailsEnabled());
        this.configRealm.updateWithCleanup(new ManagedRealm.RealmUpdate[]{r -> r.adminEventsDetailsEnabled(true)});
        Assertions.assertTrue((boolean)this.configRealm.admin().getRealmEventsConfig().isAdminEventsDetailsEnabled());
    }

    @Test
    public void setLoginEventExpirationTest() {
        Assertions.assertNull((Object)this.configRep.getEventsExpiration());
        long oneHour = 3600L;
        this.configRealm.updateWithCleanup(new ManagedRealm.RealmUpdate[]{r -> r.eventsExpiration(oneHour)});
        Assertions.assertEquals((long)oneHour, (Long)this.configRealm.admin().getRealmEventsConfig().getEventsExpiration());
    }

    public static class EventConfigRealmConfig
    implements RealmConfig {
        public RealmConfigBuilder configure(RealmConfigBuilder realm) {
            return realm.eventsEnabled(true).adminEventsEnabled(true);
        }
    }
}

