/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.event;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.keycloak.events.Event;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.events.EventType;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.EventMatchers;
import org.keycloak.testframework.oauth.OAuthClient;
import org.keycloak.testframework.oauth.annotations.InjectOAuthClient;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.RealmConfig;
import org.keycloak.testframework.realm.RealmConfigBuilder;
import org.keycloak.testframework.remote.providers.runonserver.RunOnServer;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;

@KeycloakIntegrationTest
public class LoginEventsTest {
    @InjectRealm(config=LoginEventsRealmConfig.class)
    ManagedRealm managedRealm;
    @InjectOAuthClient
    OAuthClient oAuthClient;
    @InjectRunOnServer
    RunOnServerClient runOnServerClient;

    @BeforeEach
    public void init() {
        this.managedRealm.admin().clearEvents();
    }

    private List<EventRepresentation> events() {
        return this.managedRealm.admin().getEvents();
    }

    private void badLogin() {
        this.oAuthClient.doLogin("bad", "user");
    }

    private void pause(int seconds) {
        try {
            Thread.sleep((long)seconds * 1000L);
        }
        catch (InterruptedException e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    public void eventAttributesTest() {
        this.badLogin();
        List<EventRepresentation> events = this.events();
        Assertions.assertEquals((int)1, (int)events.size());
        EventRepresentation event = events.get(0);
        MatcherAssert.assertThat((Object)event.getId(), (Matcher)EventMatchers.isUUID());
        Assertions.assertTrue((event.getTime() > 0L ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)event.getIpAddress());
        Assertions.assertEquals((Object)"LOGIN_ERROR", (Object)event.getType());
        Assertions.assertEquals((Object)this.managedRealm.getId(), (Object)event.getRealmId());
        Assertions.assertNull((Object)event.getUserId());
        Assertions.assertNull((Object)event.getSessionId());
        Assertions.assertEquals((Object)"user_not_found", (Object)event.getError());
        Map details = event.getDetails();
        Assertions.assertEquals((Object)"openid-connect", details.get("auth_method"));
        Assertions.assertEquals((Object)"code", details.get("auth_type"));
        Assertions.assertNotNull(details.get("redirect_uri"));
        Assertions.assertNotNull(details.get("code_id"));
        Assertions.assertEquals((Object)"bad", details.get("username"));
    }

    @Test
    public void clearEventsTest() {
        Assertions.assertEquals((int)0, (int)this.events().size());
        this.badLogin();
        this.badLogin();
        Assertions.assertEquals((int)2, (int)this.events().size());
        this.managedRealm.admin().clearEvents();
        Assertions.assertEquals((int)0, (int)this.events().size());
    }

    @Test
    public void loggingOfCertainTypeTest() {
        Assertions.assertEquals((int)0, (int)this.events().size());
        this.managedRealm.updateWithCleanup(new ManagedRealm.RealmUpdate[]{r -> r.enabledEventTypes(new String[]{"REVOKE_GRANT"})});
        this.badLogin();
        Assertions.assertEquals((int)0, (int)this.events().size());
        this.managedRealm.updateWithCleanup(new ManagedRealm.RealmUpdate[]{r -> r.setEnabledEventTypes(new String[]{"LOGIN_ERROR"})});
        this.badLogin();
        Assertions.assertEquals((int)1, (int)this.events().size());
    }

    @Test
    public void filterTest() {
        this.badLogin();
        this.badLogin();
        Assertions.assertEquals((int)2, (int)this.events().size());
        List filteredEvents = this.managedRealm.admin().getEvents(List.of("REVOKE_GRANT"), null, null, null, null, null, null, null);
        Assertions.assertEquals((int)0, (int)filteredEvents.size());
        filteredEvents = this.managedRealm.admin().getEvents(List.of("LOGIN_ERROR"), null, null, null, null, null, null, null);
        Assertions.assertEquals((int)2, (int)filteredEvents.size());
    }

    @Test
    public void defaultMaxResults() {
        String realmId = this.managedRealm.getId();
        this.runOnServerClient.run((RunOnServer & Serializable)session -> {
            EventStoreProvider provider = (EventStoreProvider)session.getProvider(EventStoreProvider.class);
            Event event = new Event();
            event.setRealmId(realmId);
            event.setType(EventType.LOGIN);
            for (int i = 0; i < 110; ++i) {
                provider.onEvent(event);
            }
        });
        Assertions.assertEquals((int)100, (int)this.managedRealm.admin().getEvents(null, null, null, null, null, null, null, null).size());
        Assertions.assertEquals((int)105, (int)this.managedRealm.admin().getEvents(null, null, null, null, null, null, Integer.valueOf(0), Integer.valueOf(105)).size());
        Assertions.assertTrue((this.managedRealm.admin().getEvents(null, null, null, null, null, null, Integer.valueOf(0), Integer.valueOf(1000)).size() >= 110 ? 1 : 0) != 0);
    }

    @Test
    public void orderResultsTest() {
        String realmId = this.managedRealm.getId();
        this.runOnServerClient.run((RunOnServer & Serializable)session -> {
            EventStoreProvider provider = (EventStoreProvider)session.getProvider(EventStoreProvider.class);
            Event firstEvent = new Event();
            firstEvent.setRealmId(realmId);
            firstEvent.setType(EventType.LOGIN);
            firstEvent.setTime(System.currentTimeMillis() - 1000L);
            Event secondEvent = new Event();
            secondEvent.setRealmId(realmId);
            secondEvent.setType(EventType.LOGOUT);
            secondEvent.setTime(System.currentTimeMillis());
            provider.onEvent(firstEvent);
            provider.onEvent(secondEvent);
        });
        List events = this.managedRealm.admin().getEvents(null, null, null, null, null, null, null, null, "desc");
        Assertions.assertEquals((int)2, (int)events.size());
        Assertions.assertEquals((Object)EventType.LOGOUT.toString(), (Object)((EventRepresentation)events.get(0)).getType());
        Assertions.assertEquals((Object)EventType.LOGIN.toString(), (Object)((EventRepresentation)events.get(1)).getType());
        events = this.managedRealm.admin().getEvents(null, null, null, null, null, null, null, null, "asc");
        Assertions.assertEquals((int)2, (int)events.size());
        Assertions.assertEquals((Object)EventType.LOGOUT.toString(), (Object)((EventRepresentation)events.get(1)).getType());
        Assertions.assertEquals((Object)EventType.LOGIN.toString(), (Object)((EventRepresentation)events.get(0)).getType());
    }

    @Test
    public void filterByEpochTimeStamp() {
        long currentTime = System.currentTimeMillis();
        String realmId = this.managedRealm.getId();
        this.runOnServerClient.run((RunOnServer & Serializable)session -> {
            EventStoreProvider provider = (EventStoreProvider)session.getProvider(EventStoreProvider.class);
            Event event = new Event();
            event.setType(EventType.LOGIN);
            event.setRealmId(realmId);
            event.setTime(currentTime - 172800000L);
            provider.onEvent(event);
            event.setTime(currentTime - 1000L);
            provider.onEvent(event);
            event.setTime(currentTime);
            provider.onEvent(event);
            event.setTime(currentTime + 1000L);
            provider.onEvent(event);
            event.setTime(currentTime + 172800000L);
            provider.onEvent(event);
        });
        List events = this.managedRealm.admin().getEvents();
        Assertions.assertEquals((int)5, (int)events.size());
        events = this.managedRealm.admin().getEvents(null, null, null, currentTime, currentTime, null, null, null, null);
        Assertions.assertEquals((int)1, (int)events.size());
        events = this.managedRealm.admin().getEvents(null, null, null, currentTime - 1000L, currentTime + 1000L, null, null, null, null);
        Assertions.assertEquals((int)3, (int)events.size());
        LocalDate dateFrom = Instant.ofEpochMilli(currentTime - 1000L).atZone(ZoneOffset.UTC).toLocalDate();
        LocalDate dateTo = Instant.ofEpochMilli(currentTime + 1000L).atZone(ZoneOffset.UTC).toLocalDate();
        events = this.managedRealm.admin().getEvents(null, null, null, dateFrom.toString(), dateTo.toString(), null, null, null, null);
        Assertions.assertEquals((int)3, (int)events.size());
    }

    @Test
    public void testErrorEventsAreNotStoredWhenDisabled() {
        this.managedRealm.updateWithCleanup(new ManagedRealm.RealmUpdate[]{r -> r.eventsEnabled(false)});
        this.badLogin();
        Assertions.assertEquals((int)0, (int)this.events().size());
    }

    private static class LoginEventsRealmConfig
    implements RealmConfig {
        private LoginEventsRealmConfig() {
        }

        public RealmConfigBuilder configure(RealmConfigBuilder realm) {
            return realm.eventsEnabled(true);
        }
    }
}

