/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.finegrainedadminv1;

import java.util.LinkedList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.authorization.model.Resource;
import org.keycloak.credential.CredentialInput;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.resources.admin.fgap.AdminPermissionManagement;
import org.keycloak.services.resources.admin.fgap.AdminPermissions;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.tests.admin.finegrainedadminv1.AbstractFineGrainedAdminTest;

@KeycloakIntegrationTest(config=AbstractFineGrainedAdminTest.FineGrainedAdminServerConf.class)
public class FineGrainedAdminDefaultRealmTest
extends AbstractFineGrainedAdminTest {
    @Test
    public void testRealmWithComposites() {
        this.runOnServer.run(FineGrainedAdminDefaultRealmTest::setup5152);
        try (Keycloak realmClient = this.adminClientFactory.create().realm("default").username("realm-admin").password("password").clientId("admin-cli").build();){
            RoleRepresentation composite = new RoleRepresentation();
            composite.setName("composite");
            composite.setComposite(true);
            realmClient.realm("default").roles().create(composite);
            composite = this.managedRealm.admin().roles().get("composite").toRepresentation();
            ClientRepresentation client = (ClientRepresentation)this.managedRealm.admin().clients().findByClientId("realm-management").get(0);
            RoleRepresentation viewUsers = this.managedRealm.admin().clients().get(client.getId()).roles().get("create-client").toRepresentation();
            LinkedList<RoleRepresentation> composites = new LinkedList<RoleRepresentation>();
            composites.add(viewUsers);
            realmClient.realm("default").rolesById().addComposites(composite.getId(), composites);
        }
    }

    @Test
    public void testRemoveCleanup() {
        this.runOnServer.run(FineGrainedAdminDefaultRealmTest::setupDeleteTest);
        this.runOnServer.run(FineGrainedAdminDefaultRealmTest::invokeDelete);
    }

    public static void setup5152(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("default");
        ClientModel realmAdminClient = realm.getClientByClientId("realm-management");
        RoleModel realmAdminRole = realmAdminClient.getRole("realm-admin");
        UserModel realmUser = session.users().addUser(realm, "realm-admin");
        realmUser.setFirstName("Realm");
        realmUser.setLastName("Admin");
        realmUser.setEmail("realm@admin");
        realmUser.grantRole(realmAdminRole);
        realmUser.setEnabled(true);
        realmUser.credentialManager().updateCredential((CredentialInput)UserCredentialModel.password((String)"password"));
    }

    public static void setupDeleteTest(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("default");
        RoleModel removedRole = realm.addRole("removedRole");
        ClientModel client = realm.addClient("removedClient");
        RoleModel removedClientRole = client.addRole("removedClientRole");
        GroupModel removedGroup = realm.createGroup("removedGroup");
        AdminPermissionManagement management = AdminPermissions.management((KeycloakSession)session, (RealmModel)realm);
        management.roles().setPermissionsEnabled(removedRole, true);
        management.roles().setPermissionsEnabled(removedClientRole, true);
        management.groups().setPermissionsEnabled(removedGroup, true);
        management.clients().setPermissionsEnabled(client, true);
        management.users().setPermissionsEnabled(true);
    }

    public static void invokeDelete(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("default");
        AdminPermissionManagement management = AdminPermissions.management((KeycloakSession)session, (RealmModel)realm);
        List byResourceServer = management.authz().getStoreFactory().getResourceStore().findByResourceServer(management.realmResourceServer());
        Assertions.assertEquals((int)5, (int)byResourceServer.size());
        RoleModel removedRole = realm.getRole("removedRole");
        realm.removeRole(removedRole);
        ClientModel client = realm.getClientByClientId("removedClient");
        RoleModel removedClientRole = client.getRole("removedClientRole");
        client.removeRole(removedClientRole);
        GroupModel group = KeycloakModelUtils.findGroupByPath((KeycloakSession)session, (RealmModel)realm, (String)"removedGroup");
        realm.removeGroup(group);
        byResourceServer = management.authz().getStoreFactory().getResourceStore().findByResourceServer(management.realmResourceServer());
        Assertions.assertEquals((int)2, (int)byResourceServer.size());
        realm.removeClient(client.getId());
        byResourceServer = management.authz().getStoreFactory().getResourceStore().findByResourceServer(management.realmResourceServer());
        Assertions.assertEquals((int)1, (int)byResourceServer.size());
        management.users().setPermissionsEnabled(false);
        Resource userResource = management.authz().getStoreFactory().getResourceStore().findByName(management.realmResourceServer(), "Users");
        Assertions.assertNull((Object)userResource);
        byResourceServer = management.authz().getStoreFactory().getResourceStore().findByResourceServer(management.realmResourceServer());
        Assertions.assertEquals((int)0, (int)byResourceServer.size());
    }
}

