/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.finegrainedadminv1;

import jakarta.ws.rs.core.Response;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.tests.admin.finegrainedadminv1.AbstractFineGrainedAdminTest;

@KeycloakIntegrationTest(config=AbstractFineGrainedAdminTest.FineGrainedAdminServerConf.class)
public class FineGrainedAdminMasterRealmTest
extends AbstractFineGrainedAdminTest {
    @Test
    public void testMasterRealm() throws Exception {
        this.runOnServer.run(AbstractFineGrainedAdminTest::setupPolices);
        this.runOnServer.run(AbstractFineGrainedAdminTest::setupUsers);
        UserRepresentation user1 = (UserRepresentation)this.managedRealm.admin().users().search("user1").get(0);
        RoleRepresentation realmRole = this.managedRealm.admin().roles().get("realm-role").toRepresentation();
        LinkedList<RoleRepresentation> realmRoleSet = new LinkedList<RoleRepresentation>();
        realmRoleSet.add(realmRole);
        RoleRepresentation realmRole2 = this.managedRealm.admin().roles().get("realm-role2").toRepresentation();
        LinkedList<RoleRepresentation> realmRole2Set = new LinkedList<RoleRepresentation>();
        realmRole2Set.add(realmRole);
        ClientRepresentation client = (ClientRepresentation)this.managedRealm.admin().clients().findByClientId("application").get(0);
        RoleRepresentation clientRole = this.managedRealm.admin().clients().get(client.getId()).roles().get("client-role").toRepresentation();
        LinkedList<RoleRepresentation> clientRoleSet = new LinkedList<RoleRepresentation>();
        clientRoleSet.add(clientRole);
        this.adminClient.realm("default").users().get(user1.getId()).roles().realmLevel().add(realmRoleSet);
        List roles = this.managedRealm.admin().users().get(user1.getId()).roles().realmLevel().listAll();
        Assertions.assertTrue((boolean)roles.stream().anyMatch(r -> r.getName().equals("realm-role")));
        this.adminClient.realm("default").users().get(user1.getId()).roles().realmLevel().remove(realmRoleSet);
        roles = this.managedRealm.admin().users().get(user1.getId()).roles().realmLevel().listAll();
        Assertions.assertTrue((boolean)roles.stream().noneMatch(r -> r.getName().equals("realm-role")));
        this.adminClient.realm("default").users().get(user1.getId()).roles().clientLevel(client.getId()).add(clientRoleSet);
        roles = this.managedRealm.admin().users().get(user1.getId()).roles().clientLevel(client.getId()).listAll();
        Assertions.assertTrue((boolean)roles.stream().anyMatch(r -> r.getName().equals("client-role")));
        this.adminClient.realm("default").users().get(user1.getId()).roles().clientLevel(client.getId()).remove(clientRoleSet);
        roles = this.managedRealm.admin().users().get(user1.getId()).roles().clientLevel(client.getId()).listAll();
        Assertions.assertTrue((boolean)roles.stream().noneMatch(r -> r.getName().equals("client-role")));
    }

    @Test
    public void testMasterRealmWithComposites() throws Exception {
        RoleRepresentation composite = new RoleRepresentation();
        composite.setName("composite");
        composite.setComposite(true);
        this.managedRealm.admin().roles().create(composite);
        composite = this.managedRealm.admin().roles().get("composite").toRepresentation();
        ClientRepresentation client = (ClientRepresentation)this.managedRealm.admin().clients().findByClientId("realm-management").get(0);
        RoleRepresentation createClient = this.managedRealm.admin().clients().get(client.getId()).roles().get("create-client").toRepresentation();
        RoleRepresentation queryRealms = this.managedRealm.admin().clients().get(client.getId()).roles().get("query-realms").toRepresentation();
        LinkedList<RoleRepresentation> composites = new LinkedList<RoleRepresentation>();
        composites.add(createClient);
        composites.add(queryRealms);
        this.managedRealm.admin().rolesById().addComposites(composite.getId(), composites);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateRealmCreateClient() throws Exception {
        ClientRepresentation rep = new ClientRepresentation();
        rep.setName("fullScopedClient");
        rep.setClientId("fullScopedClient");
        rep.setFullScopeAllowed(Boolean.valueOf(true));
        rep.setSecret("618268aa-51e6-4e64-93c4-3c0bc65b8171");
        rep.setProtocol("openid-connect");
        rep.setPublicClient(Boolean.valueOf(false));
        rep.setEnabled(Boolean.valueOf(true));
        this.masterRealm.admin().clients().create(rep);
        Keycloak realmClient = this.adminClientFactory.create().realm("master").username("admin").password("admin").clientId("fullScopedClient").clientSecret("618268aa-51e6-4e64-93c4-3c0bc65b8171").build();
        try {
            RealmRepresentation newRealm = new RealmRepresentation();
            newRealm.setRealm("anotherRealm");
            newRealm.setId("anotherRealm");
            newRealm.setEnabled(Boolean.valueOf(true));
            realmClient.realms().create(newRealm);
            ClientRepresentation newClient = new ClientRepresentation();
            newClient.setName("newClient");
            newClient.setClientId("newClient");
            newClient.setFullScopeAllowed(Boolean.valueOf(true));
            newClient.setSecret("secret");
            newClient.setProtocol("openid-connect");
            newClient.setPublicClient(Boolean.valueOf(false));
            newClient.setEnabled(Boolean.valueOf(true));
            Response response = realmClient.realm("anotherRealm").clients().create(newClient);
            Assertions.assertEquals((int)403, (int)response.getStatus());
            response.close();
            realmClient.close();
            realmClient = this.adminClientFactory.create().realm("master").username("admin").password("admin").clientId("fullScopedClient").clientSecret("618268aa-51e6-4e64-93c4-3c0bc65b8171").build();
            MatcherAssert.assertThat(realmClient.realms().findAll().stream().map(RealmRepresentation::getRealm).collect(Collectors.toSet()), (Matcher)Matchers.hasItem((Object)"anotherRealm"));
            response = realmClient.realm("anotherRealm").clients().create(newClient);
            Assertions.assertEquals((int)201, (int)response.getStatus());
            response.close();
        }
        finally {
            this.adminClient.realm("anotherRealm").remove();
            realmClient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateRealmCreateClientWithMaster() throws Exception {
        ClientRepresentation rep = new ClientRepresentation();
        rep.setName("fullScopedClient");
        rep.setClientId("fullScopedClient");
        rep.setFullScopeAllowed(Boolean.valueOf(true));
        rep.setSecret("618268aa-51e6-4e64-93c4-3c0bc65b8171");
        rep.setProtocol("openid-connect");
        rep.setPublicClient(Boolean.valueOf(false));
        rep.setEnabled(Boolean.valueOf(true));
        this.masterRealm.admin().clients().create(rep);
        RealmRepresentation newRealm = new RealmRepresentation();
        newRealm.setRealm("anotherRealm");
        newRealm.setId("anotherRealm");
        newRealm.setEnabled(Boolean.valueOf(true));
        this.adminClient.realms().create(newRealm);
        try {
            ClientRepresentation newClient = new ClientRepresentation();
            newClient.setName("newClient");
            newClient.setClientId("newClient");
            newClient.setFullScopeAllowed(Boolean.valueOf(true));
            newClient.setSecret("secret");
            newClient.setProtocol("openid-connect");
            newClient.setPublicClient(Boolean.valueOf(false));
            newClient.setEnabled(Boolean.valueOf(true));
            Response response = this.adminClient.realm("anotherRealm").clients().create(newClient);
            Assertions.assertEquals((int)201, (int)response.getStatus());
            response.close();
        }
        finally {
            this.adminClient.realm("anotherRealm").remove();
        }
    }
}

