/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.finegrainedadminv1;

import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.GroupConfigBuilder;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.tests.admin.finegrainedadminv1.AbstractFineGrainedAdminTest;
import org.keycloak.tests.utils.admin.ApiUtil;

@KeycloakIntegrationTest(config=AbstractFineGrainedAdminTest.FineGrainedAdminServerConf.class)
public class FineGrainedAdminRestTest
extends AbstractFineGrainedAdminTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestEvaluation() throws Exception {
        List queryUsers;
        List roles;
        String groupId = ApiUtil.getCreatedId((Response)this.managedRealm.admin().groups().add(GroupConfigBuilder.create().name("restricted-group").build()));
        this.runOnServer.run(AbstractFineGrainedAdminTest::setupPolices);
        this.runOnServer.run(AbstractFineGrainedAdminTest::setupUsers);
        UserRepresentation user1 = (UserRepresentation)this.managedRealm.admin().users().search("user1").get(0);
        UserRepresentation anotherAdmin = (UserRepresentation)this.managedRealm.admin().users().search("anotherAdmin").get(0);
        UserRepresentation groupMember = (UserRepresentation)this.managedRealm.admin().users().search("groupMember").get(0);
        RoleRepresentation realmRole = this.managedRealm.admin().roles().get("realm-role").toRepresentation();
        LinkedList<RoleRepresentation> realmRoleSet = new LinkedList<RoleRepresentation>();
        realmRoleSet.add(realmRole);
        RoleRepresentation realmRole2 = this.managedRealm.admin().roles().get("realm-role2").toRepresentation();
        LinkedList<RoleRepresentation> realmRole2Set = new LinkedList<RoleRepresentation>();
        realmRole2Set.add(realmRole2);
        ClientRepresentation client = (ClientRepresentation)this.managedRealm.admin().clients().findByClientId("application").get(0);
        ClientScopeRepresentation scope = (ClientScopeRepresentation)this.managedRealm.admin().clientScopes().findAll().get(0);
        RoleRepresentation clientRole = this.managedRealm.admin().clients().get(client.getId()).roles().get("client-role").toRepresentation();
        LinkedList<RoleRepresentation> clientRoleSet = new LinkedList<RoleRepresentation>();
        clientRoleSet.add(clientRole);
        try (Keycloak realmClient = this.adminClientFactory.create().realm("default").username("clientConfigurer").password("password").clientId("admin-cli").build();){
            client.setAdminUrl("http://nowhere");
            realmClient.realm("default").clients().get(client.getId()).update(client);
            client.setFullScopeAllowed(Boolean.valueOf(true));
            try {
                realmClient.realm("default").clients().get(client.getId()).update(client);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assertions.assertEquals((int)403, (int)e.getResponse().getStatus());
            }
            client.setFullScopeAllowed(Boolean.valueOf(false));
            realmClient.realm("default").clients().get(client.getId()).update(client);
            try {
                realmClient.realm("default").clients().get(client.getId()).addDefaultClientScope(scope.getId());
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assertions.assertEquals((int)403, (int)e.getResponse().getStatus());
            }
            try {
                realmClient.realm("default").clients().get(client.getId()).getScopeMappings().realmLevel().add(realmRoleSet);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assertions.assertEquals((int)403, (int)e.getResponse().getStatus());
            }
        }
        realmClient = this.adminClientFactory.create().realm("default").username("nomap-admin").password("password").clientId("admin-cli").build();
        try {
            realmClient.realm("default").users().get(user1.getId()).impersonate();
            realmClient.close();
            realmClient = this.adminClientFactory.create().realm("default").username("nomap-admin").password("password").clientId("admin-cli").build();
            try {
                realmClient.realm("default").users().get(anotherAdmin.getId()).impersonate();
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assertions.assertEquals((int)403, (int)e.getResponse().getStatus());
            }
        }
        finally {
            realmClient.close();
        }
        realmClient = this.adminClientFactory.create().realm("default").username("authorized").password("password").clientId("admin-cli").build();
        try {
            realmClient.realm("default").users().get(user1.getId()).roles().realmLevel().add(realmRoleSet);
            roles = this.managedRealm.admin().users().get(user1.getId()).roles().realmLevel().listAll();
            Assertions.assertTrue((boolean)roles.stream().anyMatch(r -> r.getName().equals("realm-role")));
            realmClient.realm("default").users().get(user1.getId()).roles().realmLevel().remove(realmRoleSet);
            roles = this.managedRealm.admin().users().get(user1.getId()).roles().realmLevel().listAll();
            Assertions.assertTrue((boolean)roles.stream().noneMatch(r -> r.getName().equals("realm-role")));
            realmClient.realm("default").users().get(user1.getId()).roles().clientLevel(client.getId()).add(clientRoleSet);
            roles = this.managedRealm.admin().users().get(user1.getId()).roles().clientLevel(client.getId()).listAll();
            Assertions.assertTrue((boolean)roles.stream().anyMatch(r -> r.getName().equals("client-role")));
            realmClient.realm("default").users().get(user1.getId()).roles().clientLevel(client.getId()).remove(clientRoleSet);
            roles = this.managedRealm.admin().users().get(user1.getId()).roles().clientLevel(client.getId()).listAll();
            Assertions.assertTrue((boolean)roles.stream().noneMatch(r -> r.getName().equals("client-role")));
        }
        finally {
            if (realmClient != null) {
                realmClient.close();
            }
        }
        realmClient = this.adminClientFactory.create().realm("default").username("authorizedComposite").password("password").clientId("admin-cli").build();
        try {
            realmClient.realm("default").users().get(user1.getId()).roles().realmLevel().add(realmRoleSet);
            roles = this.managedRealm.admin().users().get(user1.getId()).roles().realmLevel().listAll();
            Assertions.assertTrue((boolean)roles.stream().anyMatch(r -> r.getName().equals("realm-role")));
            realmClient.realm("default").users().get(user1.getId()).roles().realmLevel().remove(realmRoleSet);
            roles = this.managedRealm.admin().users().get(user1.getId()).roles().realmLevel().listAll();
            Assertions.assertTrue((boolean)roles.stream().noneMatch(r -> r.getName().equals("realm-role")));
            realmClient.realm("default").users().get(user1.getId()).roles().clientLevel(client.getId()).add(clientRoleSet);
            roles = this.managedRealm.admin().users().get(user1.getId()).roles().clientLevel(client.getId()).listAll();
            Assertions.assertTrue((boolean)roles.stream().anyMatch(r -> r.getName().equals("client-role")));
            realmClient.realm("default").users().get(user1.getId()).roles().clientLevel(client.getId()).remove(clientRoleSet);
            roles = this.managedRealm.admin().users().get(user1.getId()).roles().clientLevel(client.getId()).listAll();
            Assertions.assertTrue((boolean)roles.stream().noneMatch(r -> r.getName().equals("client-role")));
        }
        finally {
            if (realmClient != null) {
                realmClient.close();
            }
        }
        try {
            realmClient = this.adminClientFactory.create().realm("default").username("unauthorized").password("password").clientId("admin-cli").build();
            try {
                realmClient.realm("default").users().get(user1.getId()).roles().realmLevel().add(realmRoleSet);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            finally {
                if (realmClient != null) {
                    realmClient.close();
                }
            }
        }
        catch (ClientErrorException e) {
            Assertions.assertEquals((int)403, (int)e.getResponse().getStatus());
        }
        try {
            realmClient = this.adminClientFactory.create().realm("default").username("unauthorizedMapper").password("password").clientId("admin-cli").build();
            try {
                realmClient.realm("default").users().get(user1.getId()).roles().realmLevel().add(realmRoleSet);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            finally {
                if (realmClient != null) {
                    realmClient.close();
                }
            }
        }
        catch (ClientErrorException e) {
            Assertions.assertEquals((int)403, (int)e.getResponse().getStatus());
        }
        realmClient = this.adminClientFactory.create().realm("default").username("groupManager").password("password").clientId("admin-cli").build();
        try {
            realmClient.realm("default").users().get(groupMember.getId()).roles().clientLevel(client.getId()).add(clientRoleSet);
            roles = realmClient.realm("default").users().get(groupMember.getId()).roles().clientLevel(client.getId()).listAll();
            Assertions.assertTrue((boolean)roles.stream().anyMatch(r -> r.getName().equals("client-role")));
            realmClient.realm("default").users().get(groupMember.getId()).roles().clientLevel(client.getId()).remove(clientRoleSet);
            roles = realmClient.realm("default").users().get(groupMember.getId()).roles().realmLevel().listAvailable();
            Assertions.assertEquals((int)1, (int)roles.size());
            realmClient.realm("default").users().get(groupMember.getId()).roles().realmLevel().add(realmRoleSet);
            realmClient.realm("default").users().get(groupMember.getId()).roles().realmLevel().remove(realmRoleSet);
            try {
                realmClient.realm("default").users().get(groupMember.getId()).roles().realmLevel().add(realmRole2Set);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assertions.assertEquals((int)403, (int)e.getResponse().getStatus());
            }
            try {
                realmClient.realm("default").users().get(user1.getId()).roles().realmLevel().add(realmRoleSet);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assertions.assertEquals((int)403, (int)e.getResponse().getStatus());
            }
        }
        finally {
            if (realmClient != null) {
                realmClient.close();
            }
        }
        realmClient = this.adminClientFactory.create().realm("default").username("clientMapper").password("password").clientId("admin-cli").build();
        try {
            roles = realmClient.realm("default").users().get(user1.getId()).roles().clientLevel(client.getId()).listAll();
            Assertions.assertTrue((boolean)roles.isEmpty());
            realmClient.realm("default").users().get(user1.getId()).roles().clientLevel(client.getId()).add(clientRoleSet);
            roles = realmClient.realm("default").users().get(user1.getId()).roles().clientLevel(client.getId()).listAll();
            Assertions.assertTrue((boolean)roles.stream().anyMatch(r -> r.getName().equals("client-role")));
            roles = realmClient.realm("default").users().get(user1.getId()).roles().realmLevel().listAvailable();
            Assertions.assertTrue((boolean)roles.isEmpty());
            try {
                realmClient.realm("default").users().get(user1.getId()).roles().realmLevel().add(realmRoleSet);
                Assertions.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assertions.assertEquals((int)403, (int)e.getResponse().getStatus());
            }
        }
        finally {
            if (realmClient != null) {
                realmClient.close();
            }
        }
        realmClient = this.adminClientFactory.create().realm("default").username("groupViewer").password("password").clientId("admin-cli").build();
        try {
            queryUsers = realmClient.realm("default").users().list();
            Assertions.assertEquals((int)queryUsers.size(), (int)1);
            MatcherAssert.assertThat((Object)"groupmember", (Matcher)Matchers.equalTo((Object)((UserRepresentation)queryUsers.get(0)).getUsername()));
            for (UserRepresentation user : queryUsers) {
                System.out.println(user.getUsername());
            }
        }
        finally {
            if (realmClient != null) {
                realmClient.close();
            }
        }
        realmClient = this.adminClientFactory.create().realm("default").username("noMapperGroupManager").password("password").clientId("admin-cli").build();
        try {
            queryUsers = realmClient.realm("default").users().list();
            Assertions.assertEquals((int)1, (int)queryUsers.size());
            UserRepresentation newGroupMemberWithoutGroup = UserConfigBuilder.create().username("new-group-member").email("new-group-member@keycloak.org").name("New", "Member").build();
            Response response1 = realmClient.realm("default").users().create(newGroupMemberWithoutGroup);
            Assertions.assertEquals((int)403, (int)response1.getStatus());
            UserRepresentation newEmptyGroupList = UserConfigBuilder.create().username("new-group-member").email("new-group-member@keycloak.org").name("New", "Member").build();
            newEmptyGroupList.setGroups(Collections.emptyList());
            Response response2 = realmClient.realm("default").users().create(newEmptyGroupList);
            Assertions.assertEquals((int)403, (int)response2.getStatus());
            UserRepresentation newGroupMemberWithNonExistentGroup = UserConfigBuilder.create().username("new-group-member").email("new-group-member@keycloak.org").name("New", "Member").groups(new String[]{"wrong-group"}).build();
            Response response3 = realmClient.realm("default").users().create(newGroupMemberWithNonExistentGroup);
            Assertions.assertEquals((int)403, (int)response3.getStatus());
            UserRepresentation newGroupMemberOfNotManagedGroup = UserConfigBuilder.create().username("new-group-member").email("new-group-member@keycloak.org").name("New", "Member").groups(new String[]{"restricted-group"}).build();
            Response response4 = realmClient.realm("default").users().create(newGroupMemberOfNotManagedGroup);
            Assertions.assertEquals((int)403, (int)response4.getStatus());
            UserRepresentation newGroupMember = UserConfigBuilder.create().username("new-group-member").email("new-group-member@keycloak.org").name("New", "Member").groups(new String[]{"top"}).build();
            ApiUtil.createUserWithAdminClient((RealmResource)realmClient.realm("default"), (UserRepresentation)newGroupMember);
            queryUsers = realmClient.realm("default").users().list();
            Assertions.assertEquals((int)2, (int)queryUsers.size());
        }
        finally {
            if (realmClient != null) {
                realmClient.close();
            }
        }
        this.managedRealm.cleanup().add(r -> r.groups().group(groupId).remove());
    }
}

