/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.finegrainedadminv1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.credential.CredentialInput;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.UserPolicyRepresentation;
import org.keycloak.services.resources.admin.fgap.AdminPermissionManagement;
import org.keycloak.services.resources.admin.fgap.AdminPermissions;
import org.keycloak.services.resources.admin.fgap.ClientPermissionManagement;
import org.keycloak.services.resources.admin.fgap.GroupPermissionManagement;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.remote.providers.runonserver.RunOnServer;
import org.keycloak.tests.admin.finegrainedadminv1.AbstractFineGrainedAdminTest;

@KeycloakIntegrationTest(config=AbstractFineGrainedAdminTest.FineGrainedAdminServerConf.class)
public class FineGrainedAdminSearchTest
extends AbstractFineGrainedAdminTest {
    @Test
    public void testUserPagination() {
        List result;
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            UserModel userModel;
            int i;
            RealmModel realm = session.realms().getRealmByName("default");
            session.getContext().setRealm(realm);
            GroupModel customerAGroup = session.groups().createGroup(realm, "Customer A");
            UserModel customerAManager = session.users().addUser(realm, "customer-a-manager");
            customerAManager.setFirstName("Customer");
            customerAManager.setLastName("A");
            customerAManager.setEmail("customer@a");
            customerAManager.credentialManager().updateCredential((CredentialInput)UserCredentialModel.password((String)"password"));
            ClientModel realmAdminClient = realm.getClientByClientId("realm-management");
            customerAManager.grantRole(realmAdminClient.getRole("query-users"));
            customerAManager.setEnabled(true);
            UserModel regularAdminUser = session.users().addUser(realm, "regular-admin-user");
            regularAdminUser.setFirstName("Regular");
            regularAdminUser.setLastName("Admin");
            regularAdminUser.setEmail("regular@admin");
            regularAdminUser.credentialManager().updateCredential((CredentialInput)UserCredentialModel.password((String)"password"));
            regularAdminUser.grantRole(realmAdminClient.getRole("view-users"));
            regularAdminUser.setEnabled(true);
            AdminPermissionManagement management = AdminPermissions.management((KeycloakSession)session, (RealmModel)realm);
            GroupPermissionManagement groupPermission = management.groups();
            groupPermission.setPermissionsEnabled(customerAGroup, true);
            UserPolicyRepresentation userPolicyRepresentation = new UserPolicyRepresentation();
            userPolicyRepresentation.setName("Only " + customerAManager.getUsername());
            userPolicyRepresentation.addUser(customerAManager.getId());
            Policy policy = groupPermission.viewMembersPermission(customerAGroup);
            AuthorizationProvider provider = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
            Policy userPolicy = provider.getStoreFactory().getPolicyStore().create(management.realmResourceServer(), (AbstractPolicyRepresentation)userPolicyRepresentation);
            policy.addAssociatedPolicy(RepresentationToModel.toModel((AbstractPolicyRepresentation)userPolicyRepresentation, (AuthorizationProvider)provider, (Policy)userPolicy));
            for (i = 0; i < 20; ++i) {
                userModel = session.users().addUser(realm, "a" + i);
                userModel.setFirstName("test");
            }
            for (i = 20; i < 40; ++i) {
                userModel = session.users().addUser(realm, "b" + i);
                userModel.setFirstName("test");
                userModel.joinGroup(customerAGroup);
            }
        });
        try (Keycloak client = this.adminClientFactory.create().realm("default").username("customer-a-manager").password("password").clientId("admin-cli").build();){
            result = client.realm("default").users().search(null, "test", null, null, Integer.valueOf(-1), Integer.valueOf(20));
            Assertions.assertEquals((int)20, (int)result.size());
            MatcherAssert.assertThat((Object)result, (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"username", (Matcher)Matchers.startsWith((String)"b"))));
            result = client.realm("default").users().search(null, "test", null, null, Integer.valueOf(20), Integer.valueOf(40));
            Assertions.assertEquals((int)0, (int)result.size());
        }
        client = this.adminClientFactory.create().realm("default").username("regular-admin-user").password("password").clientId("admin-cli").build();
        try {
            result = client.realm("default").users().search(null, "test", null, null, Integer.valueOf(-1), Integer.valueOf(20));
            Assertions.assertEquals((int)20, (int)result.size());
            MatcherAssert.assertThat((Object)result, (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"username", (Matcher)Matchers.startsWith((String)"a"))));
            client.realm("default").users().search(null, null, null, null, Integer.valueOf(-1), Integer.valueOf(-1));
            Assertions.assertEquals((int)20, (int)result.size());
            MatcherAssert.assertThat((Object)result, (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"username", (Matcher)Matchers.startsWith((String)"a"))));
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
        client = this.adminClientFactory.create().realm("default").username("customer-a-manager").password("password").clientId("admin-cli").build();
        try {
            result = client.realm("default").users().search(null, null, null, null, Integer.valueOf(-1), Integer.valueOf(20));
            Assertions.assertEquals((int)20, (int)result.size());
            MatcherAssert.assertThat((Object)result, (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"username", (Matcher)Matchers.startsWith((String)"b"))));
            result = client.realm("default").users().search("test", Integer.valueOf(-1), Integer.valueOf(20), Boolean.valueOf(false));
            Assertions.assertEquals((int)20, (int)result.size());
            MatcherAssert.assertThat((Object)result, (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"username", (Matcher)Matchers.startsWith((String)"b"))));
            result = client.realm("default").users().search("a", Integer.valueOf(-1), Integer.valueOf(20), Boolean.valueOf(false));
            Assertions.assertEquals((int)0, (int)result.size());
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void testClientsSearch() {
        List result;
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("default");
            session.getContext().setRealm(realm);
            ClientModel realmAdminClient = realm.getClientByClientId("realm-management");
            UserModel regularAdminUser = session.users().addUser(realm, "regular-admin-user");
            regularAdminUser.setFirstName("Regular");
            regularAdminUser.setLastName("Admin");
            regularAdminUser.setEmail("regular@admin");
            regularAdminUser.credentialManager().updateCredential((CredentialInput)UserCredentialModel.password((String)"password"));
            regularAdminUser.grantRole(realmAdminClient.getRole("query-clients"));
            regularAdminUser.setEnabled(true);
            UserPolicyRepresentation userPolicyRepresentation = new UserPolicyRepresentation();
            userPolicyRepresentation.setName("Only " + regularAdminUser.getUsername());
            userPolicyRepresentation.addUser(regularAdminUser.getId());
            for (int i = 0; i < 30; ++i) {
                realm.addClient("client-search-" + String.valueOf(i < 10 ? "0" + i : Integer.valueOf(i)));
            }
            AdminPermissionManagement management = AdminPermissions.management((KeycloakSession)session, (RealmModel)realm);
            ClientPermissionManagement clientPermission = management.clients();
            ClientModel clientModel = realm.getClientByClientId("client-search-09");
            clientPermission.setPermissionsEnabled(clientModel, true);
            Policy policy = clientPermission.viewPermission(clientModel);
            AuthorizationProvider provider = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
            Policy userPolicy = provider.getStoreFactory().getPolicyStore().create(management.realmResourceServer(), (AbstractPolicyRepresentation)userPolicyRepresentation);
            policy.addAssociatedPolicy(RepresentationToModel.toModel((AbstractPolicyRepresentation)userPolicyRepresentation, (AuthorizationProvider)provider, (Policy)userPolicy));
        });
        try (Keycloak client = this.adminClientFactory.create().realm("default").username("regular-admin-user").password("password").clientId("admin-cli").build();){
            result = client.realm("default").clients().findAll("client-search-", Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(5));
            Assertions.assertEquals((int)1, (int)result.size());
            Assertions.assertEquals((Object)"client-search-09", (Object)((ClientRepresentation)result.get(0)).getClientId());
        }
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("default");
            session.getContext().setRealm(realm);
            AdminPermissionManagement management = AdminPermissions.management((KeycloakSession)session, (RealmModel)realm);
            ClientPermissionManagement clientPermission = management.clients();
            ClientModel clientModel = realm.getClientByClientId("client-search-10");
            clientPermission.setPermissionsEnabled(clientModel, true);
            Policy policy = clientPermission.viewPermission(clientModel);
            AuthorizationProvider provider = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
            ClientModel realmAdminClient = realm.getClientByClientId("realm-management");
            ResourceServer resourceServer = provider.getStoreFactory().getResourceServerStore().findByClient(realmAdminClient);
            policy.addAssociatedPolicy(provider.getStoreFactory().getPolicyStore().findByName(resourceServer, "Only regular-admin-user"));
        });
        client = this.adminClientFactory.create().realm("default").username("regular-admin-user").password("password").clientId("admin-cli").build();
        try {
            result = client.realm("default").clients().findAll("client-search-", Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(-1), Integer.valueOf(-1));
            Assertions.assertEquals((int)2, (int)result.size());
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
        client = this.adminClientFactory.create().realm("default").username("regular-admin-user").password("password").clientId("admin-cli").build();
        try {
            result = client.realm("default").clients().findAll(null, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(0), Integer.valueOf(5));
            Assertions.assertEquals((int)2, (int)result.size());
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
        client = this.adminClientFactory.create().realm("default").username("regular-admin-user").password("password").clientId("admin-cli").build();
        try {
            result = client.realm("default").clients().findAll(null, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(0), Integer.valueOf(1));
            Assertions.assertEquals((int)1, (int)result.size());
            MatcherAssert.assertThat((Object)result, (Matcher)Matchers.hasItem((Matcher)Matchers.hasProperty((String)"clientId", (Matcher)Matchers.is((Object)"client-search-09"))));
            result = client.realm("default").clients().findAll(null, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1));
            MatcherAssert.assertThat((Object)result, (Matcher)Matchers.hasItem((Matcher)Matchers.hasProperty((String)"clientId", (Matcher)Matchers.is((Object)"client-search-10"))));
            Assertions.assertEquals((int)1, (int)result.size());
            result = client.realm("default").clients().findAll(null, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(2), Integer.valueOf(1));
            Assertions.assertTrue((boolean)result.isEmpty());
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
        client = this.adminClientFactory.create().realm("default").username("regular-admin-user").password("password").clientId("admin-cli").build();
        try {
            result = client.realm("default").clients().findAll(null, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(-1), Integer.valueOf(-1));
            Assertions.assertEquals((int)2, (int)result.size());
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("default");
            session.getContext().setRealm(realm);
            AdminPermissionManagement management = AdminPermissions.management((KeycloakSession)session, (RealmModel)realm);
            ClientPermissionManagement clientPermission = management.clients();
            for (int i = 11; i < 30; ++i) {
                ClientModel clientModel = realm.getClientByClientId("client-search-" + i);
                clientPermission.setPermissionsEnabled(clientModel, true);
                Policy policy = clientPermission.viewPermission(clientModel);
                AuthorizationProvider provider = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
                ClientModel realmAdminClient = realm.getClientByClientId("realm-management");
                ResourceServer resourceServer = provider.getStoreFactory().getResourceServerStore().findByClient(realmAdminClient);
                policy.addAssociatedPolicy(provider.getStoreFactory().getPolicyStore().findByName(resourceServer, "Only regular-admin-user"));
            }
        });
        client = this.adminClientFactory.create().realm("default").username("regular-admin-user").password("password").clientId("admin-cli").build();
        try {
            ArrayList clients = new ArrayList();
            List result2 = client.realm("default").clients().findAll("client-search-", Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(10));
            clients.addAll(result2);
            Assertions.assertEquals((int)10, (int)result2.size());
            MatcherAssert.assertThat(result2.stream().map(rep -> rep.getClientId()).collect(Collectors.toList()), (Matcher)Matchers.is(Arrays.asList("client-search-09", "client-search-10", "client-search-11", "client-search-12", "client-search-13", "client-search-14", "client-search-15", "client-search-16", "client-search-17", "client-search-18")));
            result2 = client.realm("default").clients().findAll("client-search-", Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(10), Integer.valueOf(10));
            clients.addAll(result2);
            Assertions.assertEquals((int)10, (int)result2.size());
            MatcherAssert.assertThat(result2.stream().map(rep -> rep.getClientId()).collect(Collectors.toList()), (Matcher)Matchers.is(Arrays.asList("client-search-19", "client-search-20", "client-search-21", "client-search-22", "client-search-23", "client-search-24", "client-search-25", "client-search-26", "client-search-27", "client-search-28")));
            result2 = client.realm("default").clients().findAll("client-search-", Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(20), Integer.valueOf(10));
            clients.addAll(result2);
            Assertions.assertEquals((int)1, (int)result2.size());
            MatcherAssert.assertThat((Object)result2, (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.hasProperty((String)"clientId", (Matcher)Matchers.is((Matcher)Matchers.oneOf((Object[])new String[]{"client-search-29"})))}));
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void testClientsSearchAfterFirstPage() {
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("default");
            session.getContext().setRealm(realm);
            ClientModel realmAdminClient = realm.getClientByClientId("realm-management");
            UserModel regularAdminUser = session.users().addUser(realm, "regular-admin-user");
            regularAdminUser.setFirstName("Regular");
            regularAdminUser.setLastName("Admin");
            regularAdminUser.setEmail("regular@admin");
            regularAdminUser.credentialManager().updateCredential((CredentialInput)UserCredentialModel.password((String)"password"));
            regularAdminUser.grantRole(realmAdminClient.getRole("query-clients"));
            regularAdminUser.setEnabled(true);
            UserPolicyRepresentation userPolicyRepresentation = new UserPolicyRepresentation();
            userPolicyRepresentation.setName("Only " + regularAdminUser.getUsername());
            userPolicyRepresentation.addUser(regularAdminUser.getId());
            AdminPermissionManagement management = AdminPermissions.management((KeycloakSession)session, (RealmModel)realm);
            ClientPermissionManagement clientPermission = management.clients();
            for (int i = 15; i < 30; ++i) {
                ClientModel clientModel = realm.addClient("client-search-" + String.valueOf(i < 10 ? "0" + i : Integer.valueOf(i)));
                clientPermission.setPermissionsEnabled(clientModel, true);
                Policy policy = clientPermission.viewPermission(clientModel);
                AuthorizationProvider provider = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
                if (i == 15) {
                    provider.getStoreFactory().getPolicyStore().create(management.realmResourceServer(), (AbstractPolicyRepresentation)userPolicyRepresentation);
                }
                policy.addAssociatedPolicy(provider.getStoreFactory().getPolicyStore().findByName(management.realmResourceServer(), "Only regular-admin-user"));
            }
        });
        try (Keycloak client = this.adminClientFactory.create().realm("default").username("regular-admin-user").password("password").clientId("admin-cli").build();){
            ArrayList clients = new ArrayList();
            List result = client.realm("default").clients().findAll("client-search-", Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(10));
            clients.addAll(result);
            Assertions.assertEquals((int)10, (int)result.size());
            MatcherAssert.assertThat(result.stream().map(rep -> rep.getClientId()).collect(Collectors.toList()), (Matcher)Matchers.is(Arrays.asList("client-search-15", "client-search-16", "client-search-17", "client-search-18", "client-search-19", "client-search-20", "client-search-21", "client-search-22", "client-search-23", "client-search-24")));
            result = client.realm("default").clients().findAll("client-search-", Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(10), Integer.valueOf(10));
            clients.addAll(result);
            Assertions.assertEquals((int)5, (int)result.size());
            MatcherAssert.assertThat(result.stream().map(rep -> rep.getClientId()).collect(Collectors.toList()), (Matcher)Matchers.is(Arrays.asList("client-search-25", "client-search-26", "client-search-27", "client-search-28", "client-search-29")));
            result = client.realm("default").clients().findAll("client-search-", Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(20), Integer.valueOf(10));
            clients.addAll(result);
            Assertions.assertTrue((boolean)result.isEmpty());
        }
    }
}

