/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.finegrainedadminv1;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.common.Profile;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;
import org.keycloak.tests.admin.finegrainedadminv1.AbstractFineGrainedAdminTest;

@KeycloakIntegrationTest(config=FineGrainedWithTokenExchangeServerConf.class)
public class FineGrainedAdminWithTokenExchangeTest
extends AbstractFineGrainedAdminTest {
    @Test
    public void testWithTokenExchange() {
        String exchanged = this.checkTokenExchange(true);
        try (Keycloak client = this.adminClientFactory.create().realm("master").authorization(exchanged).clientId("admin-cli").build();){
            Assertions.assertNotNull((Object)client.realm("master").roles().get("offline_access"));
        }
    }

    public static class FineGrainedWithTokenExchangeServerConf
    implements KeycloakServerConfig {
        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder config) {
            config.features(new Profile.Feature[]{Profile.Feature.TOKEN_EXCHANGE, Profile.Feature.ADMIN_FINE_GRAINED_AUTHZ});
            return config;
        }
    }
}

