/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.finegrainedadminv1;

import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.ManagementPermissionRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ScopePermissionRepresentation;
import org.keycloak.representations.idm.authorization.UserPolicyRepresentation;
import org.keycloak.testframework.annotations.InjectKeycloakUrls;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.testframework.server.KeycloakUrls;
import org.keycloak.testframework.util.ApiUtil;
import org.keycloak.tests.admin.finegrainedadminv1.AbstractFineGrainedAdminTest;

@KeycloakIntegrationTest(config=AbstractFineGrainedAdminTest.FineGrainedAdminServerConf.class)
public class FineGrainedPermissionsV1UsersTest
extends AbstractFineGrainedAdminTest {
    @InjectRealm(lifecycle=LifeCycle.METHOD)
    ManagedRealm realm;
    @InjectKeycloakUrls
    KeycloakUrls keycloakUrls;

    private void assertSearchMatchesCount(RealmResource realmResource, String search, Integer expectedCount) {
        Integer count = realmResource.users().count(search);
        MatcherAssert.assertThat((Object)count, (Matcher)CoreMatchers.is((Object)expectedCount));
        MatcherAssert.assertThat((Object)realmResource.users().search(search, null, null), (Matcher)Matchers.hasSize((int)count));
    }

    @Test
    public void countUsersWithGroupViewPermission() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        RealmResource testRealmResource = this.setupTestEnvironmentWithPermissions(true);
        MatcherAssert.assertThat((Object)testRealmResource.users().count(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void countUsersBySearchWithGroupViewPermission() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        RealmResource testRealmResource = this.setupTestEnvironmentWithPermissions(true);
        this.assertSearchMatchesCount(testRealmResource, "user", 3);
        this.assertSearchMatchesCount(testRealmResource, "*FirstName*", 3);
        this.assertSearchMatchesCount(testRealmResource, "user2FirstName", 1);
        this.assertSearchMatchesCount(testRealmResource, "*LastName*", 3);
        this.assertSearchMatchesCount(testRealmResource, "user2LastName", 1);
        this.assertSearchMatchesCount(testRealmResource, "*@example.com*", 3);
        this.assertSearchMatchesCount(testRealmResource, "user1@example.com", 1);
        this.assertSearchMatchesCount(testRealmResource, "notExisting", 0);
        this.assertSearchMatchesCount(testRealmResource, "", 3);
        this.assertSearchMatchesCount(testRealmResource, null, 3);
    }

    @Test
    public void countUsersByFiltersWithGroupViewPermission() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        RealmResource testRealmResource = this.setupTestEnvironmentWithPermissions(true);
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, null, "user"), (Matcher)Matchers.equalTo((Object)testRealmResource.users().search("user", null, null, null, null, null).size()));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, null, "user"), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, null, "user1"), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, null, "notExisting"), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, null, ""), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, "FirstName", null, null), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, "user2FirstName", null, null), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, "notExisting", null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, "", null, null), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("LastName", null, null, null), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("user2LastName", null, null, null), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("notExisting", null, null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("", null, null, null), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, "@example.com", null), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, "user1@example.com", null), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, "user1@test.com", null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, "", null), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("LastName", "FirstName", null, null), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("user1LastName", "FirstName", null, null), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("user1LastName", "", null, null), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("LastName", "", null, null), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("LastName", "", null, null), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, "@example.com", "user"), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, null, null), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("", "", "", ""), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void countUsersWithNoViewPermission() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException {
        RealmResource testRealmResource = this.setupTestEnvironmentWithPermissions(false);
        MatcherAssert.assertThat((Object)testRealmResource.users().count(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void countUsersBySearchWithNoViewPermission() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        RealmResource testRealmResource = this.setupTestEnvironmentWithPermissions(false);
        this.assertSearchMatchesCount(testRealmResource, "user", 0);
        this.assertSearchMatchesCount(testRealmResource, "FirstName", 0);
        this.assertSearchMatchesCount(testRealmResource, "user2FirstName", 0);
        this.assertSearchMatchesCount(testRealmResource, "LastName", 0);
        this.assertSearchMatchesCount(testRealmResource, "user2LastName", 0);
        this.assertSearchMatchesCount(testRealmResource, "@example.com", 0);
        this.assertSearchMatchesCount(testRealmResource, "user1@example.com", 0);
        this.assertSearchMatchesCount(testRealmResource, "notExisting", 0);
        this.assertSearchMatchesCount(testRealmResource, "", 0);
        this.assertSearchMatchesCount(testRealmResource, null, 0);
    }

    @Test
    public void countUsersByFiltersWithNoViewPermission() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        RealmResource testRealmResource = this.setupTestEnvironmentWithPermissions(false);
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, null, "user"), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, null, "user1"), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, null, "notExisting"), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, null, ""), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, "FirstName", null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, "user2FirstName", null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, "notExisting", null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, "", null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("LastName", null, null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("user2LastName", null, null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("notExisting", null, null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("", null, null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, "@example.com", null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, "user1@example.com", null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, "user1@test.com", null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, "", null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("LastName", "FirstName", null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("user1LastName", "FirstName", null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("user1LastName", "", null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("LastName", "", null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("LastName", "", null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, "@example.com", "user"), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count(null, null, null, null), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)testRealmResource.users().count("", "", "", ""), (Matcher)CoreMatchers.is((Object)0));
    }

    private RealmResource setupTestEnvironmentWithPermissions(boolean grp1ViewPermissions) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        UserRepresentation user = UserConfigBuilder.create().username("test-user").password("password").name("a", "b").email("c@d.com").enabled(true).build();
        String testUserId = ApiUtil.getCreatedId((Response)this.realm.admin().users().create(user));
        ClientRepresentation clientRepresentation = (ClientRepresentation)this.realm.admin().clients().findByClientId("realm-management").get(0);
        String realmManagementId = clientRepresentation.getId();
        RoleRepresentation roleRepresentation = this.realm.admin().clients().get(realmManagementId).roles().get("query-users").toRepresentation();
        this.realm.admin().users().get(testUserId).roles().clientLevel(realmManagementId).add(Collections.singletonList(roleRepresentation));
        List<GroupRepresentation> groups = this.setupUsersInGroupsWithPermissions();
        if (grp1ViewPermissions) {
            AuthorizationResource authorizationResource = this.realm.admin().clients().get(realmManagementId).authorization();
            UserPolicyRepresentation policy = new UserPolicyRepresentation();
            String policyName = "test-policy";
            policy.setName(policyName);
            policy.setUsers(Collections.singleton(testUserId));
            authorizationResource.policies().user().create(policy).close();
            PolicyRepresentation policyRepresentation = authorizationResource.policies().findByName(policyName);
            Optional<GroupRepresentation> optional = groups.stream().filter(g -> g.getName().equals("grp1")).findFirst();
            MatcherAssert.assertThat((Object)optional.isPresent(), (Matcher)CoreMatchers.is((Object)true));
            GroupRepresentation grp1 = optional.get();
            ScopePermissionRepresentation scopePermissionRepresentation = authorizationResource.permissions().scope().findByName("view.members.permission.group." + grp1.getId());
            scopePermissionRepresentation.setPolicies(Collections.singleton(policyRepresentation.getId()));
            scopePermissionRepresentation.setDecisionStrategy(DecisionStrategy.UNANIMOUS);
            authorizationResource.permissions().scope().findById(scopePermissionRepresentation.getId()).update(scopePermissionRepresentation);
        }
        Keycloak testUserClient = KeycloakBuilder.builder().serverUrl(this.keycloakUrls.getBaseUrl().toString()).realm(this.realm.getName()).username("test-user").password("password").clientId("admin-cli").clientSecret("").build();
        return testUserClient.realm(this.realm.getCreatedRepresentation().getRealm());
    }

    private List<GroupRepresentation> setupUsersInGroupsWithPermissions() {
        GroupRepresentation grp1 = this.createGroupWithPermissions("grp1");
        GroupRepresentation grp2 = this.createGroupWithPermissions("grp2");
        UserRepresentation user1 = UserConfigBuilder.create().username("user1").password("password").name("user1FirstName", "user1LastName").email("user1@example.com").enabled(true).build();
        String user1Id = ApiUtil.getCreatedId((Response)this.realm.admin().users().create(user1));
        UserRepresentation user2 = UserConfigBuilder.create().username("user2").password("password").name("user2FirstName", "user2LastName").email("user2@example.com").enabled(true).build();
        String user2Id = ApiUtil.getCreatedId((Response)this.realm.admin().users().create(user2));
        UserRepresentation user3 = UserConfigBuilder.create().username("user3").password("password").name("user3FirstName", "user3LastName").email("user3@example.com").enabled(true).build();
        String user3Id = ApiUtil.getCreatedId((Response)this.realm.admin().users().create(user3));
        UserRepresentation user4 = UserConfigBuilder.create().username("user4").password("password").name("user4FirstName", "user4LastName").email("user4@example.com").enabled(true).build();
        String user4Id = ApiUtil.getCreatedId((Response)this.realm.admin().users().create(user4));
        this.realm.admin().users().get(user1Id).joinGroup(grp1.getId());
        this.realm.admin().users().get(user2Id).joinGroup(grp1.getId());
        this.realm.admin().users().get(user3Id).joinGroup(grp1.getId());
        this.realm.admin().users().get(user4Id).joinGroup(grp2.getId());
        ArrayList<GroupRepresentation> groups = new ArrayList<GroupRepresentation>();
        groups.add(grp1);
        groups.add(grp2);
        return groups;
    }

    private GroupRepresentation createGroupWithPermissions(String name) {
        GroupRepresentation grp = new GroupRepresentation();
        grp.setName(name);
        this.realm.admin().groups().add(grp);
        Optional<GroupRepresentation> optional = this.realm.admin().groups().groups().stream().filter(g -> g.getName().equals(name)).findFirst();
        MatcherAssert.assertThat((Object)optional.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        grp = optional.get();
        String id = grp.getId();
        this.realm.admin().groups().group(id).setPermissions(new ManagementPermissionRepresentation(true));
        MatcherAssert.assertThat((Object)this.realm.admin().groups().group(id).getPermissions().isEnabled(), (Matcher)CoreMatchers.is((Object)true));
        return grp;
    }
}

