/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.group;

import jakarta.ws.rs.core.Response;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.testframework.annotations.InjectAdminEvents;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.events.AdminEvents;
import org.keycloak.testframework.oauth.OAuthClient;
import org.keycloak.testframework.oauth.annotations.InjectOAuthClient;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.tests.utils.admin.AdminEventPaths;
import org.keycloak.tests.utils.admin.ApiUtil;
import org.keycloak.testsuite.util.oauth.AccessTokenResponse;

@KeycloakIntegrationTest
public abstract class AbstractGroupTest {
    @InjectAdminEvents
    AdminEvents adminEvents;
    @InjectOAuthClient
    OAuthClient oAuth;

    AccessToken login(String username, String clientId, String clientSecret) {
        AccessTokenResponse tokenResponse = ((OAuthClient)this.oAuth.client(clientId, clientSecret)).doPasswordGrantRequest(username, "password");
        return (AccessToken)this.oAuth.parseToken(tokenResponse.getAccessToken(), AccessToken.class);
    }

    String createGroup(ManagedRealm managedRealm, GroupRepresentation group) {
        Response response = managedRealm.admin().groups().add(group);
        String groupId = ApiUtil.getCreatedId((Response)response);
        managedRealm.cleanup().add(r -> r.groups().group(groupId).remove());
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.groupPath((String)groupId), (Object)group, (ResourceType)ResourceType.GROUP);
        group.setId(groupId);
        return groupId;
    }

    void addSubGroup(ManagedRealm managedRealm, GroupRepresentation parent, GroupRepresentation child) {
        Response response = managedRealm.admin().groups().add(child);
        String childUuid = ApiUtil.getCreatedId((Response)response);
        child.setId(childUuid);
        response = managedRealm.admin().groups().group(parent.getId()).subGroup(child);
        response.close();
    }

    RoleRepresentation createRealmRole(ManagedRealm managedRealm, RoleRepresentation role) {
        managedRealm.admin().roles().create(role);
        RoleRepresentation created = managedRealm.admin().roles().get(role.getName()).toRepresentation();
        String createdName = created.getName();
        managedRealm.cleanup().add(r -> r.roles().deleteRole(createdName));
        return created;
    }
}

