/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.group;

import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.GroupResource;
import org.keycloak.admin.client.resource.GroupsResource;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;
import org.keycloak.tests.utils.admin.ApiUtil;

@KeycloakIntegrationTest(config=GroupSearchServerConfig.class)
public class GroupAttributeSearchTest {
    @InjectRealm
    ManagedRealm managedRealm;
    private static final String GROUP1 = "group1";
    private static final String GROUP2 = "group2";
    private static final String GROUP3 = "group3";
    private static final String PARENT_GROUP = "parentGroup";
    private static final String CHILD_GROUP = "childGroup";
    private static final String ATTR_ORG_NAME = "org";
    private static final String ATTR_ORG_VAL = "Test_\"organisation\"";
    private static final String ATTR_URL_NAME = "url";
    private static final String ATTR_URL_VAL = "https://foo.bar/clflds";
    private static final String ATTR_FILTERED_NAME = "filtered";
    private static final String ATTR_FILTERED_VAL = "does_not_matter";
    private static final String ATTR_QUOTES_NAME = "test \"123\"";
    private static final String ATTR_QUOTES_NAME_ESCAPED = "\"test \\\"123\\\"\"";
    private static final String ATTR_QUOTES_VAL = "field=\"blah blah\"";
    private static final String ATTR_QUOTES_VAL_ESCAPED = "\"field=\\\"blah blah\\\"\"";
    private GroupRepresentation group1;
    private GroupRepresentation group2;
    private GroupRepresentation group3;
    private GroupRepresentation parentGroup;
    private GroupRepresentation childGroup;
    private GroupRepresentation secondChildGroup;

    @BeforeEach
    public void init() {
        this.group1 = new GroupRepresentation();
        this.group2 = new GroupRepresentation();
        this.group3 = new GroupRepresentation();
        this.parentGroup = new GroupRepresentation();
        this.childGroup = new GroupRepresentation();
        this.secondChildGroup = new GroupRepresentation();
        this.group1.setAttributes(Map.of(ATTR_ORG_NAME, List.of(ATTR_ORG_VAL), ATTR_URL_NAME, List.of(ATTR_URL_VAL)));
        this.group2.setAttributes(Map.of(ATTR_FILTERED_NAME, List.of(ATTR_FILTERED_VAL), ATTR_URL_NAME, List.of(ATTR_URL_VAL)));
        this.group3.setAttributes(Map.of(ATTR_ORG_NAME, List.of("fake group"), ATTR_QUOTES_NAME, List.of(ATTR_QUOTES_VAL)));
        this.parentGroup.setAttributes(Map.of(ATTR_ORG_NAME, List.of("parentOrg")));
        this.childGroup.setAttributes(Map.of(ATTR_ORG_NAME, List.of("childOrg")));
        this.group1.setName(GROUP1);
        this.group2.setName(GROUP2);
        this.group3.setName(GROUP3);
        this.parentGroup.setName(PARENT_GROUP);
        this.childGroup.setName(CHILD_GROUP);
        this.secondChildGroup.setName("childGroup2");
    }

    @Test
    public void querySearch() {
        this.createGroupWithCleanup(this.group1);
        this.createGroupWithCleanup(this.group2);
        this.createGroupWithCleanup(this.group3);
        this.search(GroupAttributeSearchTest.buildSearchQuery(ATTR_ORG_NAME, ATTR_ORG_VAL, new String[0]), GROUP1);
        this.search(GroupAttributeSearchTest.buildSearchQuery(ATTR_URL_NAME, ATTR_URL_VAL, new String[0]), GROUP1, GROUP2);
        this.search(GroupAttributeSearchTest.buildSearchQuery(ATTR_ORG_NAME, ATTR_ORG_VAL, ATTR_URL_NAME, ATTR_URL_VAL), GROUP1);
        this.search(GroupAttributeSearchTest.buildSearchQuery(ATTR_ORG_NAME, "wrong val", ATTR_URL_NAME, ATTR_URL_VAL), new String[0]);
        this.search(GroupAttributeSearchTest.buildSearchQuery(ATTR_QUOTES_NAME_ESCAPED, ATTR_QUOTES_VAL_ESCAPED, new String[0]), GROUP3);
        this.search(GroupAttributeSearchTest.buildSearchQuery(ATTR_URL_NAME, ATTR_URL_VAL, ATTR_FILTERED_NAME, ATTR_FILTERED_VAL), GROUP1, GROUP2);
    }

    @Test
    public void nestedGroupQuerySearch() {
        String groupUuid = this.createGroupWithCleanup(this.parentGroup);
        GroupResource parentGroupResource = this.managedRealm.admin().groups().group(groupUuid);
        parentGroupResource.subGroup(this.childGroup);
        GroupsResource search = this.managedRealm.admin().groups();
        String searchQuery = GroupAttributeSearchTest.buildSearchQuery(ATTR_ORG_NAME, "childOrg", new String[0]);
        List found = search.query(searchQuery);
        MatcherAssert.assertThat((Object)found.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((GroupRepresentation)found.get(0)).getName(), (Matcher)CoreMatchers.is((Matcher)Matchers.equalTo((Object)PARENT_GROUP)));
        List subGroups = ((GroupRepresentation)found.get(0)).getSubGroups();
        MatcherAssert.assertThat((Object)subGroups.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((GroupRepresentation)subGroups.get(0)).getName(), (Matcher)CoreMatchers.is((Matcher)Matchers.equalTo((Object)CHILD_GROUP)));
    }

    @Test
    public void nestedGroupQuerySearchNoHierarchy() throws Exception {
        String groupUuid = this.createGroupWithCleanup(this.parentGroup);
        GroupResource parentGroupResource = this.managedRealm.admin().groups().group(groupUuid);
        parentGroupResource.subGroup(this.childGroup);
        GroupRepresentation testGroup = new GroupRepresentation();
        testGroup.setName("test_child");
        parentGroupResource.subGroup(testGroup);
        GroupsResource search = this.managedRealm.admin().groups();
        String searchQuery = GroupAttributeSearchTest.buildSearchQuery(ATTR_ORG_NAME, "childOrg", new String[0]);
        List found = search.query(searchQuery, false);
        MatcherAssert.assertThat((Object)found.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((GroupRepresentation)found.get(0)).getName(), (Matcher)CoreMatchers.is((Matcher)Matchers.equalTo((Object)CHILD_GROUP)));
        String path = ((GroupRepresentation)found.get(0)).getPath();
        MatcherAssert.assertThat((Object)path, (Matcher)CoreMatchers.is((Object)String.format("/%s/%s", PARENT_GROUP, CHILD_GROUP)));
    }

    @Test
    public void queryPaging() {
        this.createGroupWithCleanup(this.group1);
        this.createGroupWithCleanup(this.group2);
        String searchQuery = GroupAttributeSearchTest.buildSearchQuery(ATTR_URL_NAME, ATTR_URL_VAL, new String[0]);
        List firstPage = this.managedRealm.admin().groups().query(searchQuery, true, Integer.valueOf(0), Integer.valueOf(1), true);
        MatcherAssert.assertThat((Object)firstPage, (Matcher)Matchers.hasSize((int)1));
        GroupRepresentation firstGroup = (GroupRepresentation)firstPage.get(0);
        MatcherAssert.assertThat((Object)firstGroup.getName(), (Matcher)CoreMatchers.is((Matcher)Matchers.equalTo((Object)GROUP1)));
        List secondPage = this.managedRealm.admin().groups().query(searchQuery, true, Integer.valueOf(1), Integer.valueOf(1), true);
        MatcherAssert.assertThat((Object)secondPage, (Matcher)Matchers.hasSize((int)1));
        GroupRepresentation secondGroup = (GroupRepresentation)secondPage.get(0);
        MatcherAssert.assertThat((Object)secondGroup.getName(), (Matcher)CoreMatchers.is((Matcher)Matchers.equalTo((Object)GROUP2)));
        List thirdPage = this.managedRealm.admin().groups().query(searchQuery, true, Integer.valueOf(2), Integer.valueOf(1), true);
        MatcherAssert.assertThat((Object)thirdPage, (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void queryFullRepresentation() {
        this.createGroupWithCleanup(this.group1);
        List found = this.managedRealm.admin().groups().query(GroupAttributeSearchTest.buildSearchQuery(ATTR_ORG_NAME, ATTR_ORG_VAL, new String[0]), true, Integer.valueOf(0), Integer.valueOf(100), false);
        MatcherAssert.assertThat((Object)found, (Matcher)Matchers.hasSize((int)1));
        GroupRepresentation group = (GroupRepresentation)found.get(0);
        MatcherAssert.assertThat((Object)group.getName(), (Matcher)CoreMatchers.is((Matcher)Matchers.equalTo((Object)GROUP1)));
        MatcherAssert.assertThat((Object)group.getAttributes(), (Matcher)CoreMatchers.is((Matcher)Matchers.equalTo((Object)this.group1.getAttributes())));
    }

    private String createGroupWithCleanup(GroupRepresentation rep) {
        Response resp = this.managedRealm.admin().groups().add(rep);
        String groupUuid = ApiUtil.getCreatedId((Response)resp);
        this.managedRealm.cleanup().add(r -> r.groups().group(groupUuid).remove());
        return groupUuid;
    }

    private void search(String searchQuery, String ... expectedGroupIds) {
        GroupsResource search = this.managedRealm.admin().groups();
        List found = search.query(searchQuery).stream().map(GroupRepresentation::getName).collect(Collectors.toList());
        MatcherAssert.assertThat(found, (Matcher)Matchers.hasSize((int)expectedGroupIds.length));
        MatcherAssert.assertThat(found, (Matcher)Matchers.containsInAnyOrder((Object[])expectedGroupIds));
    }

    public static String buildSearchQuery(String firstAttrName, String firstAttrValue, String ... furtherAttrKeysAndValues) {
        if (furtherAttrKeysAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid length of furtherAttrKeysAndValues. Must be even, but is: " + furtherAttrKeysAndValues.length);
        }
        String keyValueSep = ":";
        String attributesSep = " ";
        StringBuilder sb = new StringBuilder();
        sb.append(firstAttrName).append(keyValueSep).append(firstAttrValue);
        if (furtherAttrKeysAndValues.length != 0) {
            for (int i = 0; i < furtherAttrKeysAndValues.length; ++i) {
                if (i % 2 == 0) {
                    sb.append(attributesSep);
                } else {
                    sb.append(keyValueSep);
                }
                sb.append(furtherAttrKeysAndValues[i]);
            }
        }
        return sb.toString();
    }

    public static class GroupSearchServerConfig
    implements KeycloakServerConfig {
        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder config) {
            return config.option("spi-group-jpa-searchable-attributes", String.join((CharSequence)",", GroupAttributeSearchTest.ATTR_URL_NAME, GroupAttributeSearchTest.ATTR_ORG_NAME, GroupAttributeSearchTest.ATTR_QUOTES_NAME));
        }
    }
}

