/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.group;

import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ProtocolMappersResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.GroupConfigBuilder;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.RealmConfig;
import org.keycloak.testframework.realm.RealmConfigBuilder;
import org.keycloak.tests.admin.group.AbstractGroupTest;
import org.keycloak.tests.utils.admin.ApiUtil;
import org.keycloak.testsuite.util.ProtocolMapperUtil;

@KeycloakIntegrationTest
public class GroupMappersTest
extends AbstractGroupTest {
    @InjectRealm(config=GroupMappersTestRealmConfig.class)
    ManagedRealm managedRealm;
    private static final String CLIENT_ID = "my-app";
    private static final String CLIENT_SECRET = "password";
    private static final String CLIENT_ROLE = "customer-user";
    private static final String TOP_GROUP = "topGroup";
    private static final String TOP_ATTRIBUTE = "topAttribute";
    private static final String LEVEL_2_ATTRIBUTE = "level2Attribute";
    private static final String LEVEL_2_GROUP = "level2group";
    private static final String TOP_GROUP_USER = "topGroupUser";
    private static final String LEVEL_2_GROUP_USER = "level2GroupUser";

    @Test
    public void testGroupMappers() {
        UserRepresentation user = ApiUtil.findUserByUsername((RealmResource)this.managedRealm.admin(), (String)TOP_GROUP_USER);
        AccessToken token = this.login(user.getUsername(), CLIENT_ID, CLIENT_SECRET);
        Assertions.assertTrue((boolean)token.getRealmAccess().getRoles().contains("user"));
        Assertions.assertNotNull(token.getOtherClaims().get("groups"));
        Map groups = (Map)token.getOtherClaims().get("groups");
        MatcherAssert.assertThat((Object)((Collection)groups.get("groups")), (Matcher)Matchers.contains((Object[])new String[]{TOP_GROUP}));
        Assertions.assertEquals((Object)"true", token.getOtherClaims().get(TOP_ATTRIBUTE));
        user = ApiUtil.findUserByUsername((RealmResource)this.managedRealm.admin(), (String)LEVEL_2_GROUP_USER);
        token = this.login(user.getUsername(), CLIENT_ID, CLIENT_SECRET);
        Assertions.assertTrue((boolean)token.getRealmAccess().getRoles().contains("user"));
        Assertions.assertTrue((boolean)token.getRealmAccess().getRoles().contains("admin"));
        Assertions.assertTrue((boolean)token.getResourceAccess(CLIENT_ID).getRoles().contains(CLIENT_ROLE));
        Assertions.assertNotNull(token.getOtherClaims().get("groups"));
        groups = (Map)token.getOtherClaims().get("groups");
        MatcherAssert.assertThat((Object)((Collection)groups.get("groups")), (Matcher)Matchers.contains((Object[])new String[]{LEVEL_2_GROUP}));
        Assertions.assertEquals((Object)"true", token.getOtherClaims().get(TOP_ATTRIBUTE));
        Assertions.assertEquals((Object)"true", token.getOtherClaims().get(LEVEL_2_ATTRIBUTE));
    }

    @Test
    public void testGroupMappersWithSlash() {
        RealmResource realm = this.managedRealm.admin();
        GroupRepresentation topGroup = realm.getGroupByPath("/topGroup");
        Assertions.assertNotNull((Object)topGroup);
        GroupRepresentation childSlash = new GroupRepresentation();
        childSlash.setName("child/slash");
        Response response = realm.groups().group(topGroup.getId()).subGroup(childSlash);
        childSlash.setId(ApiUtil.getCreatedId((Response)response));
        UserRepresentation user = ApiUtil.findUserByUsername((RealmResource)this.managedRealm.admin(), (String)LEVEL_2_GROUP_USER);
        realm.users().get(user.getId()).joinGroup(childSlash.getId());
        ClientResource client = ApiUtil.findClientByClientId((RealmResource)realm, (String)CLIENT_ID);
        ProtocolMappersResource protocolMappers = client.getProtocolMappers();
        ProtocolMapperRepresentation groupsMapper = ProtocolMapperUtil.getMapperByNameAndProtocol((ProtocolMappersResource)protocolMappers, (String)"openid-connect", (String)"groups");
        Assertions.assertNotNull((Object)groupsMapper);
        groupsMapper.getConfig().put("full.path", Boolean.TRUE.toString());
        protocolMappers.update(groupsMapper.getId(), groupsMapper);
        groupsMapper.getConfig().remove("full.path");
        this.managedRealm.cleanup().add(r -> {
            r.users().get(user.getId()).leaveGroup(childSlash.getId());
            r.groups().group(childSlash.getId()).remove();
            r.clients().get(client.toRepresentation().getId()).getProtocolMappers().update(groupsMapper.getId(), groupsMapper);
        });
        AccessToken token = this.login(user.getUsername(), CLIENT_ID, CLIENT_SECRET);
        Assertions.assertNotNull(token.getOtherClaims().get("groups"));
        Map groups = (Map)token.getOtherClaims().get("groups");
        MatcherAssert.assertThat((Object)((Collection)groups.get("groups")), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{KeycloakModelUtils.buildGroupPath((boolean)false, (String[])new String[]{TOP_GROUP, LEVEL_2_GROUP}), KeycloakModelUtils.buildGroupPath((boolean)false, (String[])new String[]{TOP_GROUP, "child/slash"})}));
    }

    private static class GroupMappersTestRealmConfig
    implements RealmConfig {
        private GroupMappersTestRealmConfig() {
        }

        private List<ProtocolMapperRepresentation> createMappers() {
            LinkedList<ProtocolMapperRepresentation> mappers = new LinkedList<ProtocolMapperRepresentation>();
            ProtocolMapperRepresentation mapper = new ProtocolMapperRepresentation();
            mapper.setName("groups");
            mapper.setProtocolMapper("oidc-group-membership-mapper");
            mapper.setProtocol("openid-connect");
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("claim.name", "groups.groups");
            config.put("access.token.claim", "true");
            config.put("id.token.claim", "true");
            mapper.setConfig(config);
            mappers.add(mapper);
            mapper = new ProtocolMapperRepresentation();
            mapper.setName(GroupMappersTest.TOP_ATTRIBUTE);
            mapper.setProtocolMapper("oidc-usermodel-attribute-mapper");
            mapper.setProtocol("openid-connect");
            config = new HashMap();
            config.put("user.attribute", GroupMappersTest.TOP_ATTRIBUTE);
            config.put("claim.name", GroupMappersTest.TOP_ATTRIBUTE);
            config.put("jsonType.label", "String");
            config.put("access.token.claim", "true");
            config.put("id.token.claim", "true");
            mapper.setConfig(config);
            mappers.add(mapper);
            mapper = new ProtocolMapperRepresentation();
            mapper.setName(GroupMappersTest.LEVEL_2_ATTRIBUTE);
            mapper.setProtocolMapper("oidc-usermodel-attribute-mapper");
            mapper.setProtocol("openid-connect");
            config = new HashMap();
            config.put("user.attribute", GroupMappersTest.LEVEL_2_ATTRIBUTE);
            config.put("claim.name", GroupMappersTest.LEVEL_2_ATTRIBUTE);
            config.put("jsonType.label", "String");
            config.put("access.token.claim", "true");
            config.put("id.token.claim", "true");
            mapper.setConfig(config);
            mappers.add(mapper);
            return mappers;
        }

        public RealmConfigBuilder configure(RealmConfigBuilder realm) {
            List<ProtocolMapperRepresentation> mappers = this.createMappers();
            realm.addClient(GroupMappersTest.CLIENT_ID).enabled(true).secret(GroupMappersTest.CLIENT_SECRET).directAccessGrantsEnabled(true).protocolMappers(mappers);
            realm.eventsEnabled(true).clientRoles(GroupMappersTest.CLIENT_ID, new String[]{GroupMappersTest.CLIENT_ROLE});
            GroupRepresentation subGroup = GroupConfigBuilder.create().name(GroupMappersTest.LEVEL_2_GROUP).realmRoles(new String[]{"admin"}).clientRoles(GroupMappersTest.CLIENT_ID, new String[]{GroupMappersTest.CLIENT_ROLE}).attribute(GroupMappersTest.LEVEL_2_ATTRIBUTE, new String[]{"true"}).build();
            GroupRepresentation subGroup2 = GroupConfigBuilder.create().name("level2group2").realmRoles(new String[]{"admin"}).clientRoles(GroupMappersTest.CLIENT_ID, new String[]{GroupMappersTest.CLIENT_ROLE}).attribute(GroupMappersTest.LEVEL_2_ATTRIBUTE, new String[]{"true"}).build();
            realm.addGroup(GroupMappersTest.TOP_GROUP).attribute(GroupMappersTest.TOP_ATTRIBUTE, new String[]{"true"}).realmRoles(new String[]{"user"}).subGroups(new GroupRepresentation[]{subGroup, subGroup2});
            realm.addUser(GroupMappersTest.TOP_GROUP_USER).name("John", "Doe").enabled(true).email("top@redhat.com").password(GroupMappersTest.CLIENT_SECRET).groups(new String[]{GroupMappersTest.TOP_GROUP});
            realm.addUser(GroupMappersTest.LEVEL_2_GROUP_USER).name("Jane", "Doe").enabled(true).email("level2@redhat.com").password(GroupMappersTest.CLIENT_SECRET).groups(new String[]{"topGroup/level2group"});
            return realm;
        }
    }
}

