/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.group;

import com.google.common.collect.Comparators;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.GroupResource;
import org.keycloak.admin.client.resource.GroupsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.realm.GroupConfigBuilder;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.RealmConfig;
import org.keycloak.testframework.realm.RealmConfigBuilder;
import org.keycloak.tests.admin.group.AbstractGroupTest;
import org.keycloak.tests.utils.admin.AdminEventPaths;
import org.keycloak.tests.utils.admin.ApiUtil;

@KeycloakIntegrationTest
public class GroupSearchTest
extends AbstractGroupTest {
    @InjectRealm(config=GroupSearchTestRealmConfig.class)
    ManagedRealm managedRealm;
    private static final String ATTR_ORG_NAME = "org";
    private static final String ATTR_QUOTES_NAME = "test \"123\"";
    private static final String ATTR_QUOTES_VAL = "field=\"blah blah\"";

    @Test
    public void querySubGroups() {
        int i;
        GroupRepresentation testGroup;
        int i2;
        GroupRepresentation parentGroup = GroupConfigBuilder.create().name("parentGroup").attribute(ATTR_ORG_NAME, new String[]{"parentOrg"}).build();
        String groupUuid = this.createGroup(this.managedRealm, parentGroup);
        GroupResource parentGroupResource = this.managedRealm.admin().groups().group(groupUuid);
        for (i2 = 1; i2 <= 5; ++i2) {
            testGroup = GroupConfigBuilder.create().name("kcgroup-" + i2).attribute(ATTR_ORG_NAME, new String[]{"kcgroup-" + i2}).attribute(ATTR_QUOTES_NAME, new String[]{ATTR_QUOTES_VAL}).build();
            this.addSubGroup(this.managedRealm, parentGroup, testGroup);
            if (i2 != 2) continue;
            GroupRepresentation subGroup = GroupConfigBuilder.create().name("kcsubgroup-" + i2).build();
            this.addSubGroup(this.managedRealm, testGroup, subGroup);
        }
        for (i2 = 1; i2 <= 3; ++i2) {
            testGroup = GroupConfigBuilder.create().name("testgroup-" + i2).build();
            this.addSubGroup(this.managedRealm, parentGroup, testGroup);
        }
        List subGroups = parentGroupResource.getSubGroups("kc", Boolean.valueOf(false), Integer.valueOf(0), Integer.valueOf(10), Boolean.valueOf(true));
        MatcherAssert.assertThat((Object)subGroups, (Matcher)Matchers.hasSize((int)5));
        for (i = 1; i <= 5; ++i) {
            MatcherAssert.assertThat((Object)((GroupRepresentation)subGroups.get(i - 1)).getName(), (Matcher)CoreMatchers.is((Matcher)Matchers.equalTo((Object)("kcgroup-" + i))));
            MatcherAssert.assertThat((Object)((GroupRepresentation)subGroups.get(i - 1)).getAttributes(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        }
        subGroups = parentGroupResource.getSubGroups("test", Boolean.valueOf(false), Integer.valueOf(0), Integer.valueOf(10), Boolean.valueOf(true));
        MatcherAssert.assertThat((Object)subGroups, (Matcher)Matchers.hasSize((int)3));
        for (i = 1; i <= 3; ++i) {
            MatcherAssert.assertThat((Object)((GroupRepresentation)subGroups.get(i - 1)).getName(), (Matcher)CoreMatchers.is((Matcher)Matchers.equalTo((Object)("testgroup-" + i))));
        }
        subGroups = parentGroupResource.getSubGroups("gro", Boolean.valueOf(false), Integer.valueOf(0), Integer.valueOf(10), Boolean.valueOf(true));
        MatcherAssert.assertThat((Object)subGroups, (Matcher)Matchers.hasSize((int)8));
        subGroups = parentGroupResource.getSubGroups("nonexistent", Boolean.valueOf(false), Integer.valueOf(0), Integer.valueOf(10), Boolean.valueOf(false));
        MatcherAssert.assertThat((Object)subGroups, (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        subGroups = parentGroupResource.getSubGroups("kcgroup-2", Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(10), Boolean.valueOf(false));
        MatcherAssert.assertThat((Object)subGroups, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((GroupRepresentation)subGroups.get(0)).getName(), (Matcher)CoreMatchers.is((Matcher)Matchers.equalTo((Object)"kcgroup-2")));
        MatcherAssert.assertThat((Object)((GroupRepresentation)subGroups.get(0)).getSubGroupCount(), (Matcher)CoreMatchers.is((Object)1L));
        Map attributes = ((GroupRepresentation)subGroups.get(0)).getAttributes();
        MatcherAssert.assertThat((Object)attributes, (Matcher)CoreMatchers.not((Matcher)Matchers.anEmptyMap()));
        MatcherAssert.assertThat(attributes.keySet(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(attributes.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{ATTR_ORG_NAME, ATTR_QUOTES_NAME}));
        subGroups = parentGroupResource.getSubGroups("kcgroup-2", Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(10), Boolean.valueOf(false), Boolean.valueOf(false));
        MatcherAssert.assertThat((Object)subGroups, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((GroupRepresentation)subGroups.get(0)).getName(), (Matcher)CoreMatchers.is((Matcher)Matchers.equalTo((Object)"kcgroup-2")));
        MatcherAssert.assertThat((Object)((GroupRepresentation)subGroups.get(0)).getSubGroupCount(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        subGroups = this.managedRealm.admin().groups().groups("kcgroup-2", Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(1), true);
        Assertions.assertEquals((int)1, (int)subGroups.size());
        MatcherAssert.assertThat((Object)((GroupRepresentation)subGroups.get(0)).getName(), (Matcher)CoreMatchers.is((Matcher)Matchers.equalTo((Object)parentGroup.getName())));
        Assertions.assertEquals((int)1, (int)((GroupRepresentation)subGroups.get(0)).getSubGroups().size());
        MatcherAssert.assertThat((Object)((GroupRepresentation)((GroupRepresentation)subGroups.get(0)).getSubGroups().get(0)).getName(), (Matcher)CoreMatchers.is((Matcher)Matchers.equalTo((Object)"kcgroup-2")));
        MatcherAssert.assertThat((Object)((GroupRepresentation)((GroupRepresentation)subGroups.get(0)).getSubGroups().get(0)).getSubGroupCount(), (Matcher)CoreMatchers.is((Object)1L));
        subGroups = this.managedRealm.admin().groups().groups("kcgroup-2", Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(1), true, Boolean.valueOf(false));
        Assertions.assertEquals((int)1, (int)subGroups.size());
        MatcherAssert.assertThat((Object)((GroupRepresentation)subGroups.get(0)).getName(), (Matcher)CoreMatchers.is((Matcher)Matchers.equalTo((Object)parentGroup.getName())));
        Assertions.assertEquals((int)1, (int)((GroupRepresentation)subGroups.get(0)).getSubGroups().size());
        MatcherAssert.assertThat((Object)((GroupRepresentation)((GroupRepresentation)subGroups.get(0)).getSubGroups().get(0)).getName(), (Matcher)CoreMatchers.is((Matcher)Matchers.equalTo((Object)"kcgroup-2")));
        MatcherAssert.assertThat((Object)((GroupRepresentation)((GroupRepresentation)subGroups.get(0)).getSubGroups().get(0)).getSubGroupCount(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void searchForGroupsShouldOnlyReturnMatchingElementsOrIntermediatePaths() {
        String needle = "test1234";
        GroupRepresentation g1 = GroupConfigBuilder.create().name("g1").build();
        GroupRepresentation g1_1 = GroupConfigBuilder.create().name("g1.1-bubu").build();
        GroupRepresentation g1_2 = GroupConfigBuilder.create().name("g1.2-" + needle).build();
        GroupRepresentation g2 = GroupConfigBuilder.create().name("g2-" + needle).build();
        GroupRepresentation g3 = GroupConfigBuilder.create().name("g3").build();
        GroupRepresentation g3_1 = GroupConfigBuilder.create().name("g3.1-" + needle).build();
        GroupRepresentation g3_1_1 = GroupConfigBuilder.create().name("g3.1.1").build();
        this.createGroup(this.managedRealm, g1);
        this.createGroup(this.managedRealm, g2);
        this.createGroup(this.managedRealm, g3);
        this.addSubGroup(this.managedRealm, g1, g1_1);
        this.addSubGroup(this.managedRealm, g1, g1_2);
        this.addSubGroup(this.managedRealm, g3, g3_1);
        this.addSubGroup(this.managedRealm, g3_1, g3_1_1);
        RealmResource realm = this.managedRealm.admin();
        List result = realm.groups().groups(needle, Integer.valueOf(0), Integer.valueOf(100));
        Assertions.assertEquals((int)3, (int)result.size());
        Assertions.assertEquals((Object)"g1", (Object)((GroupRepresentation)result.get(0)).getName());
        Assertions.assertEquals((int)1, (int)((GroupRepresentation)result.get(0)).getSubGroups().size());
        Assertions.assertEquals((Object)("g1.2-" + needle), (Object)((GroupRepresentation)((GroupRepresentation)result.get(0)).getSubGroups().get(0)).getName());
        Assertions.assertEquals((Object)("g2-" + needle), (Object)((GroupRepresentation)result.get(1)).getName());
        Assertions.assertEquals((Object)"g3", (Object)((GroupRepresentation)result.get(2)).getName());
        Assertions.assertEquals((int)1, (int)((GroupRepresentation)result.get(2)).getSubGroups().size());
        Assertions.assertEquals((Object)("g3.1-" + needle), (Object)((GroupRepresentation)((GroupRepresentation)result.get(2)).getSubGroups().get(0)).getName());
    }

    @Test
    public void searchGroupsByName() {
        this.createGroup(this.managedRealm, GroupConfigBuilder.create().name("group-name-1").build());
        this.createGroup(this.managedRealm, GroupConfigBuilder.create().name("group-name-2").build());
        GroupsResource groupsResource = this.managedRealm.admin().groups();
        List groups = groupsResource.groups("group-name", Boolean.valueOf(false), Integer.valueOf(0), Integer.valueOf(20), false);
        Assertions.assertEquals((int)2, (int)groups.size());
        groups = groupsResource.groups("group-name-1", Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(20), false);
        Assertions.assertEquals((int)1, (int)groups.size());
        groups = groupsResource.groups("group-name", Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(20), false);
        Assertions.assertTrue((boolean)groups.isEmpty());
    }

    @Test
    public void searchAndCountGroups() {
        String firstGroupId = "";
        RealmResource realm = this.managedRealm.admin();
        for (int i = 0; i < 20; ++i) {
            String groupId = this.createGroup(this.managedRealm, GroupConfigBuilder.create().name("group" + i).build());
            if (i != 0) continue;
            firstGroupId = groupId;
        }
        List allGroups = realm.groups().groups();
        Assertions.assertEquals((int)20, (int)allGroups.size());
        List slice = realm.groups().groups(Integer.valueOf(0), Integer.valueOf(7));
        Assertions.assertEquals((int)7, (int)slice.size());
        slice = realm.groups().groups(null, Integer.valueOf(7));
        Assertions.assertEquals((int)7, (int)slice.size());
        slice = realm.groups().groups(Integer.valueOf(10), null);
        Assertions.assertEquals((int)10, (int)slice.size());
        slice = realm.groups().groups(Integer.valueOf(5), Integer.valueOf(7));
        Assertions.assertEquals((int)7, (int)slice.size());
        slice = realm.groups().groups(Integer.valueOf(15), Integer.valueOf(7));
        Assertions.assertEquals((int)5, (int)slice.size());
        List search = realm.groups().groups("group1", Integer.valueOf(0), Integer.valueOf(20));
        Assertions.assertEquals((int)11, (int)search.size());
        for (GroupRepresentation group2 : search) {
            Assertions.assertTrue((boolean)group2.getName().contains("group1"));
        }
        List noResultSearch = realm.groups().groups("abcd", Integer.valueOf(0), Integer.valueOf(20));
        Assertions.assertEquals((int)0, (int)noResultSearch.size());
        Assertions.assertEquals((Long)Long.valueOf(allGroups.size()), (Long)((Long)realm.groups().count().get("count")));
        Assertions.assertEquals((Long)Long.valueOf(search.size()), (Long)((Long)realm.groups().count("group1").get("count")));
        Assertions.assertEquals((Long)Long.valueOf(noResultSearch.size()), (Long)((Long)realm.groups().count("abcd").get("count")));
        GroupRepresentation level2Group = new GroupRepresentation();
        level2Group.setName("group1111");
        Response response = realm.groups().group(firstGroupId).subGroup(level2Group);
        response.close();
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.groupSubgroupsPath((String)firstGroupId), (Object)level2Group, (ResourceType)ResourceType.GROUP);
        Assertions.assertEquals((Long)Long.valueOf(allGroups.size()), (Long)((Long)realm.groups().count(true).get("count")));
        Assertions.assertEquals((Long)Long.valueOf(allGroups.size() + 1), (Long)((Long)realm.groups().count(false).get("count")));
        GroupRepresentation level2Group2 = new GroupRepresentation();
        level2Group2.setName("group111111");
        realm.groups().group(firstGroupId).subGroup(level2Group2);
        search = realm.groups().groups("group11", Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertEquals((int)2, (int)search.size());
        GroupRepresentation group0 = search.stream().filter(group -> "group0".equals(group.getName())).findAny().orElseGet(null);
        Assertions.assertNotNull((Object)group0);
        Assertions.assertEquals((int)2, (int)group0.getSubGroups().size());
        MatcherAssert.assertThat(group0.getSubGroups().stream().map(GroupRepresentation::getName).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"group1111", "group111111"}));
        Assertions.assertEquals((Long)this.countLeafGroups(search), (Long)((Long)realm.groups().count("group11").get("count")));
    }

    private Long countLeafGroups(List<GroupRepresentation> search) {
        long counter = 0L;
        for (GroupRepresentation group : search) {
            if (group.getSubGroups().isEmpty()) {
                ++counter;
                continue;
            }
            counter += this.countLeafGroups(group.getSubGroups()).longValue();
        }
        return counter;
    }

    @Test
    public void orderGroupsByName() {
        ArrayList<GroupRepresentation> testGroups = new ArrayList<GroupRepresentation>();
        for (int i = 0; i < 40; ++i) {
            GroupRepresentation group = new GroupRepresentation();
            group.setName("group" + i);
            testGroups.add(group);
        }
        Collections.shuffle(testGroups);
        for (GroupRepresentation group : testGroups) {
            this.createGroup(this.managedRealm, group);
        }
        Comparator<GroupRepresentation> compareByName = Comparator.comparing(GroupRepresentation::getName);
        GroupsResource groups = this.managedRealm.admin().groups();
        List allGroups = groups.groups(Integer.valueOf(0), Integer.valueOf(100));
        Assertions.assertEquals((int)40, (int)allGroups.size());
        Assertions.assertTrue((boolean)Comparators.isInStrictOrder((Iterable)allGroups, compareByName));
        List firstPage = groups.groups(Integer.valueOf(0), Integer.valueOf(20));
        Assertions.assertEquals((int)20, (int)firstPage.size());
        Assertions.assertTrue((boolean)Comparators.isInStrictOrder((Iterable)firstPage, compareByName));
        List secondPage = groups.groups(Integer.valueOf(20), Integer.valueOf(20));
        Assertions.assertEquals((int)20, (int)secondPage.size());
        Assertions.assertTrue((boolean)Comparators.isInStrictOrder((Iterable)secondPage, compareByName));
        GroupRepresentation lastGroupOnFirstPage = (GroupRepresentation)firstPage.get(firstPage.size() - 1);
        GroupRepresentation firstGroupOnSecondPage = (GroupRepresentation)secondPage.get(0);
        Assertions.assertTrue((compareByName.compare(lastGroupOnFirstPage, firstGroupOnSecondPage) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void searchGroupsOnGroupHierarchies() {
        RealmResource realm = this.managedRealm.admin();
        String searchFor = UUID.randomUUID().toString();
        GroupRepresentation g1 = new GroupRepresentation();
        g1.setName("g1");
        GroupRepresentation g1_1 = new GroupRepresentation();
        g1_1.setName("g1.1-" + searchFor);
        String g1Id = this.createGroup(this.managedRealm, g1);
        this.addSubGroup(this.managedRealm, g1, g1_1);
        List searchResultGroups = realm.groups().groups(searchFor, Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertFalse((boolean)searchResultGroups.isEmpty());
        Assertions.assertEquals((Object)g1Id, (Object)((GroupRepresentation)searchResultGroups.get(0)).getId());
        Assertions.assertEquals((Object)g1.getName(), (Object)((GroupRepresentation)searchResultGroups.get(0)).getName());
        List searchResultSubGroups = ((GroupRepresentation)searchResultGroups.get(0)).getSubGroups();
        Assertions.assertEquals((Object)g1_1.getId(), (Object)((GroupRepresentation)searchResultSubGroups.get(0)).getId());
        Assertions.assertEquals((Object)g1_1.getName(), (Object)((GroupRepresentation)searchResultSubGroups.get(0)).getName());
    }

    public void testParentAndChildGroup(String parentName, String childName) {
        RealmResource realm = this.managedRealm.admin();
        GroupRepresentation parentGroup = new GroupRepresentation();
        parentGroup.setName(parentName);
        this.createGroup(this.managedRealm, parentGroup);
        GroupRepresentation childGroup = new GroupRepresentation();
        childGroup.setName(childName);
        Response response = realm.groups().group(parentGroup.getId()).subGroup(childGroup);
        childGroup.setId(ApiUtil.getCreatedId((Response)response));
        AdminEventAssertion.assertSuccess((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll())).operationType(OperationType.CREATE).resourcePath(new String[]{AdminEventPaths.groupSubgroupsPath((String)parentGroup.getId())}).representation((Object)childGroup).resourceType(ResourceType.GROUP);
        List groupsFound = realm.groups().groups(parentGroup.getName(), Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(1), true);
        Assertions.assertEquals((int)1, (int)groupsFound.size());
        Assertions.assertEquals((Object)parentGroup.getId(), (Object)((GroupRepresentation)groupsFound.get(0)).getId());
        parentGroup = (GroupRepresentation)groupsFound.get(0);
        Assertions.assertEquals((int)0, (int)parentGroup.getSubGroups().size());
        Assertions.assertEquals((Object)KeycloakModelUtils.buildGroupPath((boolean)false, (String[])new String[]{parentName}), (Object)parentGroup.getPath());
        groupsFound = realm.groups().groups(childGroup.getName(), Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(1), true);
        Assertions.assertEquals((int)1, (int)groupsFound.size());
        Assertions.assertEquals((Object)parentGroup.getId(), (Object)((GroupRepresentation)groupsFound.get(0)).getId());
        Assertions.assertEquals((int)1, (int)((GroupRepresentation)groupsFound.get(0)).getSubGroups().size());
        Assertions.assertEquals((Object)childGroup.getId(), (Object)((GroupRepresentation)((GroupRepresentation)groupsFound.get(0)).getSubGroups().get(0)).getId());
        childGroup = (GroupRepresentation)((GroupRepresentation)groupsFound.get(0)).getSubGroups().get(0);
        Assertions.assertEquals((Object)KeycloakModelUtils.normalizeGroupPath((String)KeycloakModelUtils.buildGroupPath((boolean)false, (String[])new String[]{parentName, childName})), (Object)childGroup.getPath());
        GroupRepresentation groupFound = realm.getGroupByPath(parentGroup.getPath());
        Assertions.assertNotNull((Object)groupFound);
        Assertions.assertEquals((Object)parentGroup.getId(), (Object)groupFound.getId());
        groupFound = realm.getGroupByPath(childGroup.getPath());
        Assertions.assertNotNull((Object)groupFound);
        Assertions.assertEquals((Object)childGroup.getId(), (Object)groupFound.getId());
        realm.groups().group(childGroup.getId()).remove();
    }

    @Test
    public void testGroupsWithSpaces() {
        this.testParentAndChildGroup("parent space", "child space");
    }

    @Test
    public void testGroupsWithSlashes() {
        this.testParentAndChildGroup("parent/slash", "child/slash");
    }

    private static class GroupSearchTestRealmConfig
    implements RealmConfig {
        private GroupSearchTestRealmConfig() {
        }

        public RealmConfigBuilder configure(RealmConfigBuilder realm) {
            return realm.eventsEnabled(true);
        }
    }
}

