/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.group;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.GroupResource;
import org.keycloak.admin.client.resource.GroupsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleMappingResource;
import org.keycloak.admin.client.resource.UserProfileResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.GroupModel;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.ClientMappingsRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.MappingsRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.userprofile.config.UPConfig;
import org.keycloak.testframework.annotations.InjectAdminClient;
import org.keycloak.testframework.annotations.InjectHttpClient;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.realm.ClientConfigBuilder;
import org.keycloak.testframework.realm.GroupConfigBuilder;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.RealmConfig;
import org.keycloak.testframework.realm.RealmConfigBuilder;
import org.keycloak.testframework.realm.RoleConfigBuilder;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.testframework.remote.providers.runonserver.FetchOnServer;
import org.keycloak.testframework.remote.providers.runonserver.RunOnServer;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.tests.admin.group.AbstractGroupTest;
import org.keycloak.tests.utils.Assert;
import org.keycloak.tests.utils.admin.AdminEventPaths;
import org.keycloak.tests.utils.admin.ApiUtil;
import org.keycloak.testsuite.util.userprofile.UserProfileUtil;
import org.keycloak.util.JsonSerialization;

@KeycloakIntegrationTest
public class GroupTest
extends AbstractGroupTest {
    @InjectRealm(config=GroupTestRealmConfig.class)
    ManagedRealm managedRealm;
    @InjectRunOnServer
    RunOnServerClient runOnServer;
    @InjectAdminClient
    Keycloak adminClient;
    @InjectHttpClient
    CloseableHttpClient httpClient;

    @Test
    public void createMultiDeleteMultiReadMulti() {
        ArrayList groupUuuids = new ArrayList();
        IntStream.range(0, 100).forEach(groupIndex -> {
            GroupRepresentation group = new GroupRepresentation();
            group.setName("Test Group " + groupIndex);
            try (Response response = this.managedRealm.admin().groups().add(group);){
                boolean created;
                boolean bl = created = response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL;
                if (created) {
                    String groupUuid = ApiUtil.getCreatedId((Response)response);
                    groupUuuids.add(groupUuid);
                } else {
                    Assertions.fail((String)("Failed to create group: " + response.getStatusInfo().getReasonPhrase()));
                }
            }
        });
        AtomicBoolean deletedAll = new AtomicBoolean(false);
        CopyOnWriteArrayList caughtExceptions = new CopyOnWriteArrayList();
        new Thread(() -> {
            while (!deletedAll.get()) {
                try {
                    this.managedRealm.admin().groups().groups(null, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), true);
                }
                catch (Exception e) {
                    caughtExceptions.add(e);
                }
            }
        }).start();
        groupUuuids.forEach(groupUuid -> this.managedRealm.admin().groups().group(groupUuid).remove());
        deletedAll.set(true);
        MatcherAssert.assertThat(caughtExceptions, (Matcher)Matchers.empty());
    }

    @Test
    public void testClientRemoveWithClientRoleGroupMapping() {
        RealmResource realm = this.managedRealm.admin();
        ClientRepresentation client = ClientConfigBuilder.create().clientId("foo").rootUrl("http://foo").protocol("openid-connect").build();
        Response response = this.managedRealm.admin().clients().create(client);
        String clientUuid = ApiUtil.getCreatedId((Response)response);
        AdminEventAssertion.assertSuccess((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll())).operationType(OperationType.CREATE).resourcePath(new String[]{AdminEventPaths.clientResourcePath((String)clientUuid)}).representation((Object)client).resourceType(ResourceType.CLIENT);
        client = (ClientRepresentation)realm.clients().findByClientId("foo").get(0);
        RoleRepresentation role = RoleConfigBuilder.create().name("foo-role").build();
        realm.clients().get(client.getId()).roles().create(role);
        AdminEventAssertion.assertSuccess((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll())).operationType(OperationType.CREATE).resourcePath(new String[]{AdminEventPaths.clientRoleResourcePath((String)clientUuid, (String)"foo-role")}).representation((Object)role).resourceType(ResourceType.CLIENT_ROLE);
        role = realm.clients().get(clientUuid).roles().get("foo-role").toRepresentation();
        GroupRepresentation group = GroupConfigBuilder.create().name("2716").build();
        this.createGroup(this.managedRealm, group);
        LinkedList<RoleRepresentation> list = new LinkedList<RoleRepresentation>();
        list.add(role);
        realm.groups().group(group.getId()).roles().clientLevel(client.getId()).add(list);
        AdminEventAssertion.assertSuccess((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll())).operationType(OperationType.CREATE).resourcePath(new String[]{AdminEventPaths.groupRolesClientRolesPath((String)group.getId(), (String)clientUuid)}).representation(list).resourceType(ResourceType.CLIENT_ROLE_MAPPING);
        realm.clients().get(client.getId()).remove();
        AdminEventAssertion.assertSuccess((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll())).operationType(OperationType.DELETE).resourcePath(new String[]{AdminEventPaths.clientResourcePath((String)clientUuid)}).resourceType(ResourceType.CLIENT);
    }

    @Test
    public void doNotAllowSameGroupNameAtSameLevel() {
        RealmResource realm = this.managedRealm.admin();
        GroupRepresentation topGroup = new GroupRepresentation();
        topGroup.setName("top");
        this.createGroup(this.managedRealm, topGroup);
        GroupRepresentation anotherTopGroup = new GroupRepresentation();
        anotherTopGroup.setName("top");
        Response response = realm.groups().add(anotherTopGroup);
        this.assertSameNameNotAllowed(response, "Top level group named 'top' already exists.");
        response.close();
        response = realm.groups().add(topGroup);
        Assertions.assertEquals((Object)Response.Status.NO_CONTENT, (Object)response.getStatusInfo());
        response.close();
        GroupRepresentation level2Group = new GroupRepresentation();
        level2Group.setName("level2");
        response = realm.groups().group(topGroup.getId()).subGroup(level2Group);
        level2Group.setId(ApiUtil.getCreatedId((Response)response));
        response.close();
        GroupRepresentation anotherlevel2Group = new GroupRepresentation();
        anotherlevel2Group.setName("level2");
        response = realm.groups().group(topGroup.getId()).subGroup(anotherlevel2Group);
        this.assertSameNameNotAllowed(response, "Sibling group named 'level2' already exists.");
        response.close();
        response = realm.groups().group(topGroup.getId()).subGroup(level2Group);
        Assertions.assertEquals((Object)Response.Status.NO_CONTENT, (Object)response.getStatusInfo());
        response.close();
    }

    @Test
    public void doNotAllowSameGroupNameAtSameLevelWhenUpdatingName() {
        RealmResource realm = this.managedRealm.admin();
        GroupRepresentation topGroup1 = GroupConfigBuilder.create().name("top1").build();
        this.createGroup(this.managedRealm, topGroup1);
        GroupRepresentation topGroup2 = GroupConfigBuilder.create().name("top2").build();
        this.createGroup(this.managedRealm, topGroup2);
        topGroup2.setName("top1");
        ClientErrorException ex1 = (ClientErrorException)Assertions.assertThrows(ClientErrorException.class, () -> realm.groups().group(topGroup2.getId()).update(topGroup2));
        this.assertSameNameNotAllowed(ex1.getResponse(), "Sibling group named 'top1' already exists.");
        GroupRepresentation level2Group = new GroupRepresentation();
        level2Group.setName("level2-1");
        this.addSubGroup(this.managedRealm, topGroup1, level2Group);
        GroupRepresentation anotherlevel2Group = new GroupRepresentation();
        anotherlevel2Group.setName("level2-2");
        this.addSubGroup(this.managedRealm, topGroup1, anotherlevel2Group);
        anotherlevel2Group.setName("level2-1");
        ClientErrorException ex2 = (ClientErrorException)Assertions.assertThrows(ClientErrorException.class, () -> realm.groups().group(anotherlevel2Group.getId()).update(anotherlevel2Group));
        this.assertSameNameNotAllowed(ex2.getResponse(), "Sibling group named 'level2-1' already exists.");
    }

    @Test
    public void allowSameGroupNameAtDifferentLevel() {
        RealmResource realm = this.managedRealm.admin();
        GroupRepresentation topGroup = new GroupRepresentation();
        topGroup.setName("test-group");
        this.createGroup(this.managedRealm, topGroup);
        GroupRepresentation childGroup = new GroupRepresentation();
        childGroup.setName("test-group");
        try (Response response = realm.groups().group(topGroup.getId()).subGroup(childGroup);){
            Assertions.assertEquals((int)201, (int)response.getStatus());
        }
        Assertions.assertNotNull((Object)realm.getGroupByPath("/test-group/test-group"));
    }

    @Test
    public void doNotAllowSameGroupNameAtTopLevel() {
        GroupRepresentation topGroup = new GroupRepresentation();
        topGroup.setName("test-group");
        this.createGroup(this.managedRealm, topGroup);
        GroupRepresentation group2 = new GroupRepresentation();
        group2.setName("test-group");
        try (Response response = this.managedRealm.admin().groups().add(group2);){
            Assertions.assertEquals((int)Response.Status.CONFLICT.getStatusCode(), (int)response.getStatus());
        }
    }

    @Test
    public void doNotAllowSameGroupNameAtTopLevelInDatabase() {
        String realmName = this.managedRealm.getName();
        String id = (String)this.runOnServer.fetch((FetchOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName(realmName);
            GroupModel g = realm.createGroup("test-group");
            return g.getId();
        }, String.class);
        this.managedRealm.cleanup().add(r -> r.groups().group(id).remove());
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName(realmName);
            Assertions.assertThrows(ModelDuplicateException.class, () -> realm.createGroup("test-group"));
        });
    }

    @Test
    public void createGroupWithEmptyNameShouldFail() {
        GroupRepresentation group = new GroupRepresentation();
        group.setName("");
        try (Response response = this.managedRealm.admin().groups().add(group);){
            Assertions.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatus());
        }
        group.setName(null);
        response = this.managedRealm.admin().groups().add(group);
        try {
            Assertions.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatus());
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    @Test
    public void updatingGroupWithEmptyNameShouldFail() {
        RealmResource realm = this.managedRealm.admin();
        GroupRepresentation group = new GroupRepresentation();
        group.setName("groupWithName");
        Response response = realm.groups().add(group);
        String groupId = ApiUtil.getCreatedId((Response)response);
        this.managedRealm.cleanup().add(r -> r.groups().group(groupId).remove());
        group.setName("");
        Assertions.assertThrows(BadRequestException.class, () -> realm.groups().group(groupId).update(group), (String)"Updating a group with empty name should fail");
        group.setName(null);
        Assertions.assertThrows(BadRequestException.class, () -> realm.groups().group(groupId).update(group), (String)"Updating a group with null name should fail");
    }

    @Test
    public void createAndTestGroups() throws IOException {
        RoleRepresentation topRole = this.createRealmRole(this.managedRealm, RoleConfigBuilder.create().name("topRole").build());
        RoleRepresentation level2Role = this.createRealmRole(this.managedRealm, RoleConfigBuilder.create().name("level2Role").build());
        RoleRepresentation level3Role = this.createRealmRole(this.managedRealm, RoleConfigBuilder.create().name("level3Role").build());
        this.adminEvents.skipAll();
        RealmResource realm = this.managedRealm.admin();
        GroupRepresentation topGroup = new GroupRepresentation();
        topGroup.setName("top");
        String topGroupId = ApiUtil.getCreatedId((Response)realm.groups().add(topGroup));
        topGroup.setId(topGroupId);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.groupPath((String)topGroupId), (Object)topGroup, (ResourceType)ResourceType.GROUP);
        LinkedList<RoleRepresentation> roles = new LinkedList<RoleRepresentation>(List.of(topRole));
        realm.groups().group(topGroup.getId()).roles().realmLevel().add(roles);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.groupRolesRealmRolesPath((String)topGroup.getId()), roles, (ResourceType)ResourceType.REALM_ROLE_MAPPING);
        GroupRepresentation level2Group = new GroupRepresentation();
        level2Group.setName("level2");
        Response response = realm.groups().group(topGroup.getId()).subGroup(level2Group);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.groupSubgroupsPath((String)topGroup.getId()), (Object)level2Group, (ResourceType)ResourceType.GROUP);
        URI location = response.getLocation();
        String level2Id = ApiUtil.getCreatedId((Response)response);
        GroupRepresentation level2GroupById = realm.groups().group(level2Id).toRepresentation();
        Assertions.assertEquals((Object)level2Id, (Object)level2GroupById.getId());
        Assertions.assertEquals((Object)level2Group.getName(), (Object)level2GroupById.getName());
        HttpGet httpGet = new HttpGet(location);
        httpGet.setHeader("Authorization", "Bearer " + this.adminClient.tokenManager().getAccessTokenString());
        CloseableHttpResponse getResponse = this.httpClient.execute((HttpUriRequest)httpGet);
        Assertions.assertEquals((int)200, (int)getResponse.getStatusLine().getStatusCode());
        GroupRepresentation level2 = (GroupRepresentation)JsonSerialization.readValue((InputStream)getResponse.getEntity().getContent(), GroupRepresentation.class);
        getResponse.close();
        Assertions.assertEquals((Object)level2Id, (Object)level2.getId());
        level2Group = realm.getGroupByPath("/top/level2");
        Assertions.assertNotNull((Object)level2Group);
        roles.clear();
        roles.add(level2Role);
        realm.groups().group(level2Group.getId()).roles().realmLevel().add(roles);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.groupRolesRealmRolesPath((String)level2Group.getId()), roles, (ResourceType)ResourceType.REALM_ROLE_MAPPING);
        GroupRepresentation level3Group = new GroupRepresentation();
        level3Group.setName("level3");
        response = realm.groups().group(level2Group.getId()).subGroup(level3Group);
        response.close();
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.groupSubgroupsPath((String)level2Group.getId()), (Object)level3Group, (ResourceType)ResourceType.GROUP);
        level3Group = realm.getGroupByPath("/top/level2/level3");
        Assertions.assertNotNull((Object)level3Group);
        roles.clear();
        roles.add(level3Role);
        realm.groups().group(level3Group.getId()).roles().realmLevel().add(roles);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.groupRolesRealmRolesPath((String)level3Group.getId()), roles, (ResourceType)ResourceType.REALM_ROLE_MAPPING);
        topGroup = realm.getGroupByPath("/top");
        Assertions.assertEquals((int)1, (int)topGroup.getRealmRoles().size());
        Assertions.assertTrue((boolean)topGroup.getRealmRoles().contains("topRole"));
        Assertions.assertEquals((int)1, (int)realm.groups().group(topGroup.getId()).getSubGroups(Integer.valueOf(0), null, Boolean.valueOf(false)).size());
        level2Group = realm.getGroupByPath("/top/level2");
        Assertions.assertEquals((Object)"level2", (Object)level2Group.getName());
        Assertions.assertEquals((int)1, (int)level2Group.getRealmRoles().size());
        Assertions.assertTrue((boolean)level2Group.getRealmRoles().contains("level2Role"));
        Assertions.assertEquals((int)1, (int)realm.groups().group(level2Group.getId()).getSubGroups(Integer.valueOf(0), null, Boolean.valueOf(false)).size());
        level3Group = realm.getGroupByPath("/top/level2/level3");
        Assertions.assertEquals((Object)"level3", (Object)level3Group.getName());
        Assertions.assertEquals((int)1, (int)level3Group.getRealmRoles().size());
        Assertions.assertTrue((boolean)level3Group.getRealmRoles().contains("level3Role"));
        UserRepresentation user = (UserRepresentation)realm.users().search("direct-login", Integer.valueOf(-1), Integer.valueOf(-1)).get(0);
        realm.users().get(user.getId()).joinGroup(level3Group.getId());
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.userGroupPath((String)user.getId(), (String)level3Group.getId()), (ResourceType)ResourceType.GROUP_MEMBERSHIP);
        List membership = realm.users().get(user.getId()).groups();
        Assertions.assertEquals((int)1, (int)membership.size());
        Assertions.assertEquals((Object)"level3", (Object)((GroupRepresentation)membership.get(0)).getName());
        AccessToken token = this.login("direct-login", "resource-owner", "secret");
        Assertions.assertTrue((boolean)token.getRealmAccess().getRoles().contains("topRole"));
        Assertions.assertTrue((boolean)token.getRealmAccess().getRoles().contains("level2Role"));
        Assertions.assertTrue((boolean)token.getRealmAccess().getRoles().contains("level3Role"));
        realm.addDefaultGroup(level3Group.getId());
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.defaultGroupPath((String)level3Group.getId()), (ResourceType)ResourceType.GROUP);
        List defaultGroups = realm.getDefaultGroups();
        Assertions.assertEquals((int)1, (int)defaultGroups.size());
        Assertions.assertEquals((Object)((GroupRepresentation)defaultGroups.get(0)).getId(), (Object)level3Group.getId());
        UserRepresentation newUser = UserConfigBuilder.create().username("groupUser").email("group@group.com").build();
        response = realm.users().create(newUser);
        String userId = ApiUtil.getCreatedId((Response)response);
        this.managedRealm.cleanup().add(r -> r.users().get(userId).remove());
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.userResourcePath((String)userId), (Object)newUser, (ResourceType)ResourceType.USER);
        membership = realm.users().get(userId).groups();
        Assertions.assertEquals((int)1, (int)membership.size());
        Assertions.assertEquals((Object)"level3", (Object)((GroupRepresentation)membership.get(0)).getName());
        realm.removeDefaultGroup(level3Group.getId());
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.defaultGroupPath((String)level3Group.getId()), (ResourceType)ResourceType.GROUP);
        defaultGroups = realm.getDefaultGroups();
        Assertions.assertEquals((int)0, (int)defaultGroups.size());
        realm.groups().group(topGroup.getId()).remove();
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.groupPath((String)topGroup.getId()), (ResourceType)ResourceType.GROUP);
        Assertions.assertThrows(NotFoundException.class, () -> realm.getGroupByPath("/top/level2/level3"), (String)"Group should not have been found");
        Assertions.assertThrows(NotFoundException.class, () -> realm.getGroupByPath("/top/level2"), (String)"Group should not have been found");
        Assertions.assertThrows(NotFoundException.class, () -> realm.getGroupByPath("/top"), (String)"Group should not have been found");
        Assertions.assertNull((Object)this.login("direct-login", "resource-owner", "secret").getRealmAccess());
    }

    @Test
    public void updateGroup() {
        RealmResource realm = this.managedRealm.admin();
        String groupName = "group-" + String.valueOf(UUID.randomUUID());
        GroupRepresentation group = GroupConfigBuilder.create().name(groupName).attribute("attr1", new String[]{"attrval1"}).attribute("attr2", new String[]{"attrval2"}).build();
        this.createGroup(this.managedRealm, group);
        group = realm.getGroupByPath("/" + groupName);
        Assertions.assertNotNull((Object)group);
        MatcherAssert.assertThat((Object)group.getName(), (Matcher)Matchers.is((Object)groupName));
        MatcherAssert.assertThat(group.getAttributes().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"attr1", "attr2"}));
        MatcherAssert.assertThat((Object)group.getAttributes(), (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"attr1"), (Matcher)Matchers.contains((Object[])new String[]{"attrval1"})));
        MatcherAssert.assertThat((Object)group.getAttributes(), (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"attr2"), (Matcher)Matchers.contains((Object[])new String[]{"attrval2"})));
        String groupNewName = "group-" + String.valueOf(UUID.randomUUID());
        group.setName(groupNewName);
        group.getAttributes().remove("attr1");
        ((List)group.getAttributes().get("attr2")).add("attrval2-2");
        group.getAttributes().put("attr3", List.of("attrval2"));
        realm.groups().group(group.getId()).update(group);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.groupPath((String)group.getId()), (Object)group, (ResourceType)ResourceType.GROUP);
        group = realm.getGroupByPath("/" + groupNewName);
        MatcherAssert.assertThat((Object)group.getName(), (Matcher)Matchers.is((Object)groupNewName));
        MatcherAssert.assertThat(group.getAttributes().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"attr2", "attr3"}));
        MatcherAssert.assertThat((Object)group.getAttributes(), (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"attr2"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"attrval2", "attrval2-2"})));
        MatcherAssert.assertThat((Object)group.getAttributes(), (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"attr3"), (Matcher)Matchers.contains((Object[])new String[]{"attrval2"})));
    }

    @Test
    public void moveGroups() {
        RealmResource realm = this.managedRealm.admin();
        GroupRepresentation group1 = GroupConfigBuilder.create().name("mygroup1").build();
        this.createGroup(this.managedRealm, group1);
        GroupRepresentation group2 = GroupConfigBuilder.create().name("mygroup2").build();
        this.createGroup(this.managedRealm, group2);
        Response response = realm.groups().group(group1.getId()).subGroup(group2);
        Assertions.assertEquals((int)204, (int)response.getStatus());
        response.close();
        List group1Children = realm.groups().group(group1.getId()).getSubGroups(Integer.valueOf(0), Integer.valueOf(10), Boolean.valueOf(false));
        Assert.assertNames((List)group1Children, (String[])new String[]{"mygroup2"});
        Assertions.assertEquals((Object)"/mygroup1/mygroup2", (Object)realm.groups().group(group2.getId()).toRepresentation().getPath());
        GroupRepresentation group3 = GroupConfigBuilder.create().name("mygroup2").build();
        response = this.managedRealm.admin().groups().add(group3);
        String group3Id = ApiUtil.getCreatedId((Response)response);
        group3.setId(group3Id);
        response = realm.groups().group(group1.getId()).subGroup(group3);
        Assertions.assertEquals((int)409, (int)response.getStatus());
        realm.groups().group(group3.getId()).remove();
        response = realm.groups().add(group2);
        Assertions.assertEquals((int)204, (int)response.getStatus());
        response.close();
        group1Children = realm.groups().group(group1.getId()).getSubGroups(Integer.valueOf(0), Integer.valueOf(10), Boolean.valueOf(false));
        Assertions.assertEquals((int)0, (int)group1Children.size());
        Assertions.assertEquals((Object)"/mygroup2", (Object)realm.groups().group(group2.getId()).toRepresentation().getPath());
        realm.groups().add(group2);
    }

    @Test
    public void groupMembership() {
        UsersResource users = this.managedRealm.admin().users();
        GroupRepresentation groupRep = new GroupRepresentation();
        groupRep.setName("group");
        String groupId = this.createGroup(this.managedRealm, groupRep);
        GroupResource group = this.managedRealm.admin().groups().group(groupId);
        Response response = users.create(UserConfigBuilder.create().username("user-a").build());
        String userAId = ApiUtil.getCreatedId((Response)response);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.userResourcePath((String)userAId), (ResourceType)ResourceType.USER);
        response = users.create(UserConfigBuilder.create().username("user-b").build());
        String userBId = ApiUtil.getCreatedId((Response)response);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.userResourcePath((String)userBId), (ResourceType)ResourceType.USER);
        users.get(userAId).joinGroup(groupId);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.userGroupPath((String)userAId, (String)groupId), (Object)groupRep, (ResourceType)ResourceType.GROUP_MEMBERSHIP);
        List members = group.members(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertNames((List)members, (String[])new String[]{"user-a"});
        users.get(userBId).joinGroup(groupId);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.userGroupPath((String)userBId, (String)groupId), (Object)groupRep, (ResourceType)ResourceType.GROUP_MEMBERSHIP);
        members = group.members(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertNames((List)members, (String[])new String[]{"user-a", "user-b"});
        users.get(userAId).leaveGroup(groupId);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.userGroupPath((String)userAId, (String)groupId), (Object)groupRep, (ResourceType)ResourceType.GROUP_MEMBERSHIP);
        members = group.members(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertNames((List)members, (String[])new String[]{"user-b"});
        List groupsList = users.get(userAId).groups(null, null);
        Assert.assertNames((List)groupsList, (String[])new String[0]);
    }

    @Test
    public void groupMembershipUsersOrder() {
        RealmResource realm = this.managedRealm.admin();
        GroupRepresentation group = new GroupRepresentation();
        group.setName("group");
        String groupId = this.createGroup(this.managedRealm, group);
        ArrayList<String> usernames = new ArrayList<String>();
        for (int i = 0; i < 9; ++i) {
            UserRepresentation user = UserConfigBuilder.create().username("user" + i).build();
            usernames.add(user.getUsername());
            Response create = realm.users().create(user);
            String userId = ApiUtil.getCreatedId((Response)create);
            realm.users().get(userId).joinGroup(groupId);
        }
        ArrayList<String> memberUsernames = new ArrayList<String>();
        for (UserRepresentation member : realm.groups().group(groupId).members(Integer.valueOf(0), Integer.valueOf(10))) {
            memberUsernames.add(member.getUsername());
        }
        Assertions.assertArrayEquals((Object[])usernames.toArray(), (Object[])memberUsernames.toArray(), (String)("Expected: " + String.valueOf(usernames) + ", was: " + String.valueOf(memberUsernames)));
    }

    @Test
    public void deleteRealmWithDefaultGroups() {
        RealmConfigBuilder realmConfigBuilder = RealmConfigBuilder.create().name("foo").defaultGroups(new String[]{"/default1"});
        realmConfigBuilder.addGroup("default1").path("/default1");
        RealmRepresentation rep = realmConfigBuilder.build();
        this.adminClient.realms().create(rep);
        this.adminClient.realm(rep.getRealm()).remove();
    }

    @Test
    public void roleMappings() {
        RealmResource realm = this.managedRealm.admin();
        this.createRealmRole(this.managedRealm, RoleConfigBuilder.create().name("realm-role").build());
        this.createRealmRole(this.managedRealm, RoleConfigBuilder.create().name("realm-composite").build());
        this.createRealmRole(this.managedRealm, RoleConfigBuilder.create().name("realm-child").build());
        realm.roles().get("realm-composite").addComposites(List.of(realm.roles().get("realm-child").toRepresentation()));
        Response response = realm.clients().create(ClientConfigBuilder.create().clientId("myclient").build());
        String clientId = ApiUtil.getCreatedId((Response)response);
        this.managedRealm.cleanup().add(r -> r.clients().get(clientId).remove());
        realm.clients().get(clientId).roles().create(RoleConfigBuilder.create().name("client-role").build());
        realm.clients().get(clientId).roles().create(RoleConfigBuilder.create().name("client-role2").build());
        realm.clients().get(clientId).roles().create(RoleConfigBuilder.create().name("client-composite").build());
        realm.clients().get(clientId).roles().create(RoleConfigBuilder.create().name("client-child").build());
        realm.clients().get(clientId).roles().get("client-composite").addComposites(List.of(realm.clients().get(clientId).roles().get("client-child").toRepresentation()));
        this.adminEvents.skipAll();
        GroupRepresentation group = new GroupRepresentation();
        group.setName("group");
        String groupId = this.createGroup(this.managedRealm, group);
        RoleMappingResource roles = realm.groups().group(groupId).roles();
        Assertions.assertEquals((int)0, (int)roles.realmLevel().listAll().size());
        LinkedList<RoleRepresentation> l = new LinkedList<RoleRepresentation>();
        l.add(realm.roles().get("realm-role").toRepresentation());
        l.add(realm.roles().get("realm-composite").toRepresentation());
        roles.realmLevel().add(l);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.groupRolesRealmRolesPath((String)group.getId()), l, (ResourceType)ResourceType.REALM_ROLE_MAPPING);
        RoleRepresentation clientRole = realm.clients().get(clientId).roles().get("client-role").toRepresentation();
        RoleRepresentation clientComposite = realm.clients().get(clientId).roles().get("client-composite").toRepresentation();
        roles.clientLevel(clientId).add(List.of(clientRole));
        roles.clientLevel(clientId).add(List.of(clientComposite));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.groupRolesClientRolesPath((String)group.getId(), (String)clientId), List.of(clientRole), (ResourceType)ResourceType.CLIENT_ROLE_MAPPING);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.groupRolesClientRolesPath((String)group.getId(), (String)clientId), List.of(clientComposite), (ResourceType)ResourceType.CLIENT_ROLE_MAPPING);
        Assert.assertNames((List)roles.realmLevel().listAll(), (String[])new String[]{"realm-role", "realm-composite"});
        Assert.assertNames((List)roles.realmLevel().listAvailable(), (String[])new String[]{"realm-child", "offline_access", "uma_authorization", "default-roles-" + this.managedRealm.getName()});
        Assert.assertNames((List)roles.realmLevel().listEffective(), (String[])new String[]{"realm-role", "realm-composite", "realm-child"});
        Assert.assertNames((List)roles.clientLevel(clientId).listAll(), (String[])new String[]{"client-role", "client-composite"});
        Assert.assertNames((List)roles.clientLevel(clientId).listAvailable(), (String[])new String[]{"client-role2", "client-child"});
        Assert.assertNames((List)roles.clientLevel(clientId).listEffective(), (String[])new String[]{"client-role", "client-composite", "client-child"});
        MappingsRepresentation all = roles.getAll();
        Assert.assertNames((List)all.getRealmMappings(), (String[])new String[]{"realm-role", "realm-composite"});
        Assertions.assertEquals((int)1, (int)all.getClientMappings().size());
        Assert.assertNames((List)((ClientMappingsRepresentation)all.getClientMappings().get("myclient")).getMappings(), (String[])new String[]{"client-role", "client-composite"});
        RoleRepresentation realmRoleRep = realm.roles().get("realm-role").toRepresentation();
        roles.realmLevel().remove(List.of(realmRoleRep));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.groupRolesRealmRolesPath((String)group.getId()), List.of(realmRoleRep), (ResourceType)ResourceType.REALM_ROLE_MAPPING);
        Assert.assertNames((List)roles.realmLevel().listAll(), (String[])new String[]{"realm-composite"});
        RoleRepresentation clientRoleRep = realm.clients().get(clientId).roles().get("client-role").toRepresentation();
        roles.clientLevel(clientId).remove(List.of(clientRoleRep));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.groupRolesClientRolesPath((String)group.getId(), (String)clientId), List.of(clientRoleRep), (ResourceType)ResourceType.CLIENT_ROLE_MAPPING);
        Assert.assertNames((List)roles.clientLevel(clientId).listAll(), (String[])new String[]{"client-composite"});
    }

    @Test
    public void rolesCanBeAssignedEvenWhenTheyAreAlreadyIndirectlyAssigned() {
        RealmResource realm = this.managedRealm.admin();
        this.createRealmRole(this.managedRealm, RoleConfigBuilder.create().name("realm-composite").build());
        this.createRealmRole(this.managedRealm, RoleConfigBuilder.create().name("realm-child").build());
        realm.roles().get("realm-composite").addComposites(List.of(realm.roles().get("realm-child").toRepresentation()));
        Response response = realm.clients().create(ClientConfigBuilder.create().clientId("myclient").build());
        String clientId = ApiUtil.getCreatedId((Response)response);
        this.managedRealm.cleanup().add(r -> r.clients().get(clientId).remove());
        realm.clients().get(clientId).roles().create(RoleConfigBuilder.create().name("client-composite").build());
        realm.clients().get(clientId).roles().create(RoleConfigBuilder.create().name("client-child").build());
        realm.clients().get(clientId).roles().get("client-composite").addComposites(List.of(realm.clients().get(clientId).roles().get("client-child").toRepresentation()));
        GroupRepresentation group = new GroupRepresentation();
        group.setName("group");
        this.adminEvents.skipAll();
        String groupId = this.createGroup(this.managedRealm, group);
        RoleMappingResource roles = realm.groups().group(groupId).roles();
        roles.realmLevel().add(List.of(realm.roles().get("realm-composite").toRepresentation()));
        RoleRepresentation clientComposite = realm.clients().get(clientId).roles().get("client-composite").toRepresentation();
        roles.clientLevel(clientId).add(List.of(clientComposite));
        Assert.assertNames((List)roles.realmLevel().listAll(), (String[])new String[]{"realm-composite"});
        Assert.assertNames((List)roles.realmLevel().listAvailable(), (String[])new String[]{"realm-child", "offline_access", "uma_authorization", "default-roles-" + this.managedRealm.getName()});
        Assert.assertNames((List)roles.realmLevel().listEffective(), (String[])new String[]{"realm-composite", "realm-child"});
        Assert.assertNames((List)roles.clientLevel(clientId).listAll(), (String[])new String[]{"client-composite"});
        Assert.assertNames((List)roles.clientLevel(clientId).listAvailable(), (String[])new String[]{"client-child"});
        Assert.assertNames((List)roles.clientLevel(clientId).listEffective(), (String[])new String[]{"client-composite", "client-child"});
        roles.realmLevel().add(List.of(realm.roles().get("realm-child").toRepresentation()));
        RoleRepresentation clientChild = realm.clients().get(clientId).roles().get("client-child").toRepresentation();
        roles.clientLevel(clientId).add(List.of(clientChild));
        Assert.assertNames((List)roles.realmLevel().listAll(), (String[])new String[]{"realm-composite", "realm-child"});
        Assert.assertNames((List)roles.realmLevel().listAvailable(), (String[])new String[]{"offline_access", "uma_authorization", "default-roles-" + this.managedRealm.getName()});
        Assert.assertNames((List)roles.realmLevel().listEffective(), (String[])new String[]{"realm-composite", "realm-child"});
        Assert.assertNames((List)roles.clientLevel(clientId).listAll(), (String[])new String[]{"client-composite", "client-child"});
        Assert.assertNames((List)roles.clientLevel(clientId).listAvailable(), (String[])new String[0]);
        Assert.assertNames((List)roles.clientLevel(clientId).listEffective(), (String[])new String[]{"client-composite", "client-child"});
        MappingsRepresentation all = roles.getAll();
        Assert.assertNames((List)all.getRealmMappings(), (String[])new String[]{"realm-composite", "realm-child"});
        Assertions.assertEquals((int)1, (int)all.getClientMappings().size());
        Assert.assertNames((List)((ClientMappingsRepresentation)all.getClientMappings().get("myclient")).getMappings(), (String[])new String[]{"client-composite", "client-child"});
    }

    @Test
    public void defaultMaxResults() {
        GroupsResource groups = this.managedRealm.admin().groups();
        Response response = groups.add(GroupConfigBuilder.create().name("test").build());
        String groupId = ApiUtil.getCreatedId((Response)response);
        GroupResource group = groups.group(groupId);
        UsersResource users = this.managedRealm.admin().users();
        for (int i = 0; i < 110; ++i) {
            Response resp = users.create(UserConfigBuilder.create().username("test-" + i).build());
            String userUuid = ApiUtil.getCreatedId((Response)resp);
            users.get(userUuid).joinGroup(groupId);
            this.managedRealm.cleanup().add(r -> r.users().delete(userUuid).close());
        }
        Assertions.assertEquals((int)100, (int)group.members(null, null).size());
        Assertions.assertEquals((int)100, (int)group.members().size());
        Assertions.assertEquals((int)105, (int)group.members(Integer.valueOf(0), Integer.valueOf(105)).size());
        Assertions.assertEquals((int)110, (int)group.members(Integer.valueOf(0), Integer.valueOf(1000)).size());
        Assertions.assertEquals((int)110, (int)group.members(Integer.valueOf(-1), Integer.valueOf(-2)).size());
    }

    @Test
    public void getGroupsWithBriefAndFullRepresentation() {
        GroupRepresentation group = GroupConfigBuilder.create().name("groupWithAttribute").attribute("attribute1", new String[]{"attribute1", "attribute2"}).build();
        this.createGroup(this.managedRealm, group);
        List groups = this.managedRealm.admin().groups().groups("groupWithAttribute", Integer.valueOf(0), Integer.valueOf(20));
        Assertions.assertFalse((boolean)groups.isEmpty());
        Assertions.assertNull((Object)((GroupRepresentation)groups.get(0)).getAttributes());
        groups = this.managedRealm.admin().groups().groups("groupWithAttribute", Integer.valueOf(0), Integer.valueOf(20), false);
        Assertions.assertFalse((boolean)groups.isEmpty());
        Assertions.assertTrue((boolean)((GroupRepresentation)groups.get(0)).getAttributes().containsKey("attribute1"));
    }

    @Test
    public void getSubGroups() {
        GroupRepresentation parent = new GroupRepresentation();
        parent.setName("parent");
        this.createGroup(this.managedRealm, parent);
        GroupRepresentation child = GroupConfigBuilder.create().name("child").attribute("attribute1", new String[]{"value1", "value2"}).build();
        this.addSubGroup(this.managedRealm, parent, child);
        GroupResource parentGroup = this.managedRealm.admin().groups().group(parent.getId());
        boolean briefRepresentation = true;
        Assertions.assertNull((Object)((GroupRepresentation)parentGroup.getSubGroups(null, null, Boolean.valueOf(briefRepresentation)).get(0)).getAttributes());
        briefRepresentation = false;
        MatcherAssert.assertThat((Object)((List)((GroupRepresentation)parentGroup.getSubGroups(null, null, Boolean.valueOf(briefRepresentation)).get(0)).getAttributes().get("attribute1")), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"value1", "value2"}));
    }

    @Test
    public void removeAllGroupAttributes() {
        GroupRepresentation groupToCreate = GroupConfigBuilder.create().name("remove-all-attributes-group").attribute("test-key", new String[]{"test-val"}).build();
        GroupsResource groupsResource = this.managedRealm.admin().groups();
        Response response = groupsResource.add(groupToCreate);
        String groupId = ApiUtil.getCreatedId((Response)response);
        this.managedRealm.cleanup().add(r -> r.groups().group(groupId).remove());
        GroupResource groupResource = groupsResource.group(groupId);
        GroupRepresentation createdGroup = groupResource.toRepresentation();
        MatcherAssert.assertThat((Object)createdGroup.getAttributes(), (Matcher)Matchers.equalTo(Map.of("test-key", List.of("test-val"))));
        GroupRepresentation groupToUpdate = GroupConfigBuilder.update((GroupRepresentation)groupToCreate).setAttributes(Map.of()).build();
        groupResource.update(groupToUpdate);
        GroupRepresentation updatedGroup = groupResource.toRepresentation();
        MatcherAssert.assertThat((Object)updatedGroup.getAttributes(), (Matcher)Matchers.anEmptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBriefRepresentationOnGroupMembers() {
        RealmResource realm = this.managedRealm.admin();
        String groupName = "brief-grouptest-group";
        String userName = "brief-grouptest-user";
        UserProfileResource upResource = realm.users().userProfile();
        UPConfig cfg = UserProfileUtil.enableUnmanagedAttributes((UserProfileResource)upResource);
        AdminEventAssertion.assertSuccess((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll())).operationType(OperationType.UPDATE).resourcePath(new String[]{AdminEventPaths.userProfilePath()}).resourceType(ResourceType.USER_PROFILE);
        try {
            String groupId = this.createGroup(this.managedRealm, GroupConfigBuilder.create().name(groupName).build());
            GroupResource group = this.managedRealm.admin().groups().group(groupId);
            UserRepresentation userRepresentation = UserConfigBuilder.create().username(userName).attribute("myattribute", new String[]{"myvalue"}).build();
            UsersResource users = realm.users();
            Response response = users.create(userRepresentation);
            String userUuid = ApiUtil.getCreatedId((Response)response);
            this.managedRealm.cleanup().add(r -> r.users().get(userUuid).remove());
            users.get(userUuid).joinGroup(groupId);
            UserRepresentation defaultRepresentation = (UserRepresentation)group.members(null, null).get(0);
            UserRepresentation fullRepresentation = (UserRepresentation)group.members(null, null, Boolean.valueOf(false)).get(0);
            UserRepresentation briefRepresentation = (UserRepresentation)group.members(null, null, Boolean.valueOf(true)).get(0);
            Assertions.assertEquals((Object)userRepresentation.getAttributes(), (Object)fullRepresentation.getAttributes());
            Assertions.assertEquals((Object)userRepresentation.getAttributes(), (Object)defaultRepresentation.getAttributes());
            Assertions.assertNull((Object)briefRepresentation.getAttributes());
        }
        finally {
            cfg.setUnmanagedAttributePolicy(null);
            upResource.update(cfg);
        }
    }

    private void assertSameNameNotAllowed(Response response, String expectedErrorMessage) {
        Assertions.assertEquals((int)409, (int)response.getStatus());
        ErrorRepresentation error = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
        Assertions.assertEquals((Object)expectedErrorMessage, (Object)error.getErrorMessage());
    }

    private static class GroupTestRealmConfig
    implements RealmConfig {
        private GroupTestRealmConfig() {
        }

        public RealmConfigBuilder configure(RealmConfigBuilder realm) {
            realm.eventsEnabled(true);
            realm.addUser("direct-login").name("Direct", "Login").email("direct-login@localhost").enabled(true).password("password");
            realm.addClient("resource-owner").directAccessGrantsEnabled(true).secret("secret");
            return realm;
        }
    }
}

