/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.identityprovider;

import jakarta.ws.rs.core.Response;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.utils.StripSecretsUtils;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.testframework.annotations.InjectAdminEvents;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.events.AdminEvents;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.tests.utils.admin.AdminEventPaths;
import org.keycloak.tests.utils.admin.ApiUtil;

public class AbstractIdentityProviderTest {
    @InjectRealm
    ManagedRealm managedRealm;
    @InjectAdminEvents
    AdminEvents adminEvents;
    @InjectRunOnServer
    RunOnServerClient runOnServer;

    protected String create(IdentityProviderRepresentation idpRep) {
        String idpId = ApiUtil.getCreatedId((Response)this.managedRealm.admin().identityProviders().create(idpRep));
        Assertions.assertNotNull((Object)idpId);
        String secret = idpRep.getConfig() != null ? (String)idpRep.getConfig().get("clientSecret") : null;
        idpRep = (IdentityProviderRepresentation)StripSecretsUtils.stripSecrets(null, (Object)idpRep);
        idpRep.setHideOnLogin(Boolean.parseBoolean((String)idpRep.getConfig().remove("hideOnLoginPage")));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.identityProviderPath((String)idpRep.getAlias()), (Object)idpRep, (ResourceType)ResourceType.IDENTITY_PROVIDER);
        if (secret != null) {
            idpRep.getConfig().put("clientSecret", secret);
        }
        return idpId;
    }

    protected IdentityProviderRepresentation createRep(String alias, String providerId) {
        return this.createRep(alias, providerId, true, null);
    }

    protected IdentityProviderRepresentation createRep(String alias, String providerId, boolean enabled, Map<String, String> config) {
        return this.createRep(alias, alias, providerId, enabled, config);
    }

    protected IdentityProviderRepresentation createRep(String alias, String displayName, String providerId, boolean enabled, Map<String, String> config) {
        IdentityProviderRepresentation idp = new IdentityProviderRepresentation();
        idp.setAlias(alias);
        idp.setDisplayName(displayName);
        idp.setProviderId(providerId);
        idp.setEnabled(enabled);
        if (config != null) {
            idp.setConfig(config);
        }
        return idp;
    }

    protected void assertProviderInfo(Map<String, String> info, String id, String name) {
        System.out.println(info);
        Assertions.assertEquals((Object)id, (Object)info.get("id"), (String)"id");
        Assertions.assertEquals((Object)name, (Object)info.get("name"), (String)"name");
    }
}

