/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.identityprovider;

import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.IdentityProviderMapperSyncMode;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderMapperTypeRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;
import org.keycloak.tests.admin.identityprovider.AbstractIdentityProviderTest;
import org.keycloak.tests.utils.admin.AdminEventPaths;
import org.keycloak.tests.utils.admin.ApiUtil;

@KeycloakIntegrationTest(config=IdentityProviderMapperServerConf.class)
public class IdentityProviderMapperTest
extends AbstractIdentityProviderTest {
    @InjectRealm(lifecycle=LifeCycle.METHOD)
    ManagedRealm managedRealm;

    @Test
    public void testMapperTypes() {
        this.create(this.createRep("google", "google"));
        IdentityProviderResource provider = this.managedRealm.admin().identityProviders().get("google");
        Map mapperTypes = provider.getMapperTypes();
        this.assertMapperTypes(mapperTypes, "google-user-attribute-mapper", "oidc-username-idp-mapper");
        this.create(this.createRep("facebook", "facebook"));
        provider = this.managedRealm.admin().identityProviders().get("facebook");
        mapperTypes = provider.getMapperTypes();
        this.assertMapperTypes(mapperTypes, "facebook-user-attribute-mapper", "oidc-username-idp-mapper");
        this.create(this.createRep("github", "github"));
        provider = this.managedRealm.admin().identityProviders().get("github");
        mapperTypes = provider.getMapperTypes();
        this.assertMapperTypes(mapperTypes, "github-user-attribute-mapper", "oidc-username-idp-mapper");
        this.create(this.createRep("twitter", "twitter"));
        provider = this.managedRealm.admin().identityProviders().get("twitter");
        mapperTypes = provider.getMapperTypes();
        this.assertMapperTypes(mapperTypes, "oidc-username-idp-mapper");
        this.create(this.createRep("microsoft", "microsoft"));
        provider = this.managedRealm.admin().identityProviders().get("microsoft");
        mapperTypes = provider.getMapperTypes();
        this.assertMapperTypes(mapperTypes, "microsoft-user-attribute-mapper", "oidc-username-idp-mapper");
        this.create(this.createRep("stackoverflow", "stackoverflow"));
        provider = this.managedRealm.admin().identityProviders().get("stackoverflow");
        mapperTypes = provider.getMapperTypes();
        this.assertMapperTypes(mapperTypes, "stackoverflow-user-attribute-mapper", "oidc-username-idp-mapper");
        this.create(this.createRep("keycloak-oidc", "keycloak-oidc"));
        provider = this.managedRealm.admin().identityProviders().get("keycloak-oidc");
        mapperTypes = provider.getMapperTypes();
        this.assertMapperTypes(mapperTypes, "keycloak-oidc-role-to-role-idp-mapper", "oidc-user-attribute-idp-mapper", "oidc-role-idp-mapper", "oidc-username-idp-mapper", "oidc-advanced-group-idp-mapper", "oidc-advanced-role-idp-mapper", "oidc-user-session-note-idp-mapper");
        this.create(this.createRep("oidc", "oidc"));
        provider = this.managedRealm.admin().identityProviders().get("oidc");
        mapperTypes = provider.getMapperTypes();
        this.assertMapperTypes(mapperTypes, "oidc-user-attribute-idp-mapper", "oidc-role-idp-mapper", "oidc-username-idp-mapper", "oidc-advanced-group-idp-mapper", "oidc-advanced-role-idp-mapper", "oidc-user-session-note-idp-mapper");
        this.create(this.createRep("saml", "saml"));
        provider = this.managedRealm.admin().identityProviders().get("saml");
        mapperTypes = provider.getMapperTypes();
        this.assertMapperTypes(mapperTypes, "saml-user-attribute-idp-mapper", "saml-role-idp-mapper", "saml-username-idp-mapper", "saml-advanced-role-idp-mapper", "saml-advanced-group-idp-mapper", "saml-xpath-attribute-idp-mapper");
    }

    @Test
    public void mapperTypesCanBeOverwritten() {
        String kcOidcProviderId = "keycloak-oidc";
        this.create(this.createRep(kcOidcProviderId, kcOidcProviderId));
        String testProviderId = "overwritten-mappers-test-id-idp";
        this.create(this.createRep(testProviderId, testProviderId));
        IdentityProviderResource kcOidcProvider = this.managedRealm.admin().identityProviders().get(kcOidcProviderId);
        Set expectedMapperTypes = kcOidcProvider.getMapperTypes().keySet();
        IdentityProviderResource testProvider = this.managedRealm.admin().identityProviders().get(testProviderId);
        Set actualMapperTypes = testProvider.getMapperTypes().keySet();
        MatcherAssert.assertThat(actualMapperTypes, (Matcher)Matchers.equalTo(expectedMapperTypes));
    }

    @Test
    public void testMappers() {
        this.create(this.createRep("google", "google"));
        IdentityProviderResource provider = this.managedRealm.admin().identityProviders().get("google");
        IdentityProviderMapperRepresentation mapper = new IdentityProviderMapperRepresentation();
        mapper.setIdentityProviderAlias("google");
        mapper.setName("my_mapper");
        mapper.setIdentityProviderMapper("oidc-hardcoded-role-idp-mapper");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("role", "offline_access");
        config.put("syncMode", IdentityProviderMapperSyncMode.INHERIT.toString());
        mapper.setConfig(config);
        Response response = provider.addMapper(mapper);
        String id = ApiUtil.getCreatedId((Response)response);
        Assertions.assertNotNull((Object)id);
        response.close();
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.identityProviderMapperPath((String)"google", (String)id), (Object)mapper, (ResourceType)ResourceType.IDENTITY_PROVIDER_MAPPER);
        List mappers = provider.getMappers();
        Assertions.assertEquals((int)1, (int)mappers.size(), (String)"mappers count");
        Assertions.assertEquals((Object)id, (Object)((IdentityProviderMapperRepresentation)mappers.get(0)).getId(), (String)"newly created mapper id");
        mapper = provider.getMapperById(id);
        Assertions.assertEquals((Object)"INHERIT", ((IdentityProviderMapperRepresentation)mappers.get(0)).getConfig().get("syncMode"));
        Assertions.assertNotNull((Object)mapper, (String)"mapperById not null");
        Assertions.assertEquals((Object)id, (Object)mapper.getId(), (String)"mapper id");
        Assertions.assertNotNull((Object)mapper.getConfig(), (String)"mapper.config exists");
        Assertions.assertEquals((Object)"offline_access", mapper.getConfig().get("role"), (String)"config retained");
        Response error = provider.addMapper(mapper);
        Assertions.assertEquals((int)400, (int)error.getStatus(), (String)"mapper unique name");
        error.close();
        mapper.getConfig().put("role", "master-realm.manage-realm");
        provider.update(id, mapper);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.identityProviderMapperPath((String)"google", (String)id), (Object)mapper, (ResourceType)ResourceType.IDENTITY_PROVIDER_MAPPER);
        mapper = provider.getMapperById(id);
        Assertions.assertNotNull((Object)mapper, (String)"mapperById not null");
        Assertions.assertEquals((Object)"master-realm.manage-realm", mapper.getConfig().get("role"), (String)"config changed");
        provider.delete(id);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.identityProviderMapperPath((String)"google", (String)id), (ResourceType)ResourceType.IDENTITY_PROVIDER_MAPPER);
        try {
            provider.getMapperById(id);
            Assertions.fail((String)"Should fail with NotFoundException");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testUpdateProtocolMappers() {
        this.create(this.createRep("google2", "google"));
        IdentityProviderResource provider = this.managedRealm.admin().identityProviders().get("google2");
        IdentityProviderMapperRepresentation mapper = new IdentityProviderMapperRepresentation();
        mapper.setIdentityProviderAlias("google2");
        mapper.setName("my_mapper");
        mapper.setIdentityProviderMapper("oidc-hardcoded-role-idp-mapper");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("syncMode", IdentityProviderMapperSyncMode.INHERIT.toString());
        config.put("role", "");
        mapper.setConfig(config);
        Response response = provider.addMapper(mapper);
        String mapperId = ApiUtil.getCreatedId((Response)response);
        List mappers = provider.getMappers();
        Assertions.assertEquals((int)1, (int)mappers.size());
        Assertions.assertEquals((int)1, (int)((IdentityProviderMapperRepresentation)mappers.get(0)).getConfig().size());
        mapper = provider.getMapperById(mapperId);
        mapper.getConfig().put("role", "offline_access");
        provider.update(mapperId, mapper);
        mappers = provider.getMappers();
        Assertions.assertEquals((Object)"INHERIT", ((IdentityProviderMapperRepresentation)mappers.get(0)).getConfig().get("syncMode"));
        Assertions.assertEquals((int)1, (int)mappers.size());
        Assertions.assertEquals((int)2, (int)((IdentityProviderMapperRepresentation)mappers.get(0)).getConfig().size());
        Assertions.assertEquals((Object)"offline_access", ((IdentityProviderMapperRepresentation)mappers.get(0)).getConfig().get("role"));
    }

    @Test
    public void testDeleteProtocolMappersAfterDeleteIdentityProvider() {
        this.create(this.createRep("google3", "google"));
        IdentityProviderResource provider = this.managedRealm.admin().identityProviders().get("google3");
        IdentityProviderMapperRepresentation mapper = new IdentityProviderMapperRepresentation();
        mapper.setIdentityProviderAlias("google3");
        mapper.setName("my_mapper");
        mapper.setIdentityProviderMapper("oidc-hardcoded-role-idp-mapper");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("syncMode", IdentityProviderMapperSyncMode.INHERIT.toString());
        config.put("role", "offline_access");
        mapper.setConfig(config);
        provider.addMapper(mapper);
        List mappers = provider.getMappers();
        MatcherAssert.assertThat((Object)mappers, (Matcher)Matchers.hasSize((int)1));
        this.adminEvents.clear();
        provider.remove();
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.identityProviderPath((String)"google3"), (ResourceType)ResourceType.IDENTITY_PROVIDER);
        this.create(this.createRep("google3", "google"));
        IdentityProviderResource newProvider = this.managedRealm.admin().identityProviders().get("google3");
        MatcherAssert.assertThat((Object)newProvider.getMappers(), (Matcher)Matchers.empty());
    }

    private void assertMapperTypes(Map<String, IdentityProviderMapperTypeRepresentation> mapperTypes, String ... mapperIds) {
        HashSet<String> expected = new HashSet<String>();
        expected.add("hardcoded-user-session-attribute-idp-mapper");
        expected.add("oidc-hardcoded-role-idp-mapper");
        expected.add("oidc-hardcoded-group-idp-mapper");
        expected.add("hardcoded-attribute-idp-mapper");
        expected.addAll(Arrays.asList(mapperIds));
        Assertions.assertEquals(expected, mapperTypes.keySet(), (String)"mapperTypes");
    }

    public static class IdentityProviderMapperServerConf
    implements KeycloakServerConfig {
        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder builder) {
            return builder.dependency("org.keycloak.tests", "keycloak-tests-custom-providers");
        }
    }
}

