/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.identityprovider;

import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.remote.providers.runonserver.FetchOnServer;
import org.keycloak.tests.admin.identityprovider.AbstractIdentityProviderTest;
import org.keycloak.tests.utils.admin.AdminEventPaths;
import org.keycloak.testsuite.util.broker.OIDCIdentityProviderConfigRep;

@KeycloakIntegrationTest
public class IdentityProviderOidcTest
extends AbstractIdentityProviderTest {
    @Test
    public void testCreateWithReservedCharacterForAlias() {
        IdentityProviderRepresentation newIdentityProvider = this.createRep("ne$&w-identity-provider", "oidc");
        newIdentityProvider.getConfig().put("clientId", "clientId");
        newIdentityProvider.getConfig().put("clientSecret", "some secret value");
        Response response = this.managedRealm.admin().identityProviders().create(newIdentityProvider);
        Assertions.assertEquals((int)400, (int)response.getStatus());
    }

    @Test
    public void testCreate() {
        IdentityProviderRepresentation newIdentityProvider = this.createRep("new-identity-provider", "oidc");
        newIdentityProvider.getConfig().put("syncMode", "IMPORT");
        newIdentityProvider.getConfig().put("clientId", "clientId");
        newIdentityProvider.getConfig().put("clientSecret", "some secret value");
        String id = this.create(newIdentityProvider);
        IdentityProviderResource identityProviderResource = this.managedRealm.admin().identityProviders().get("new-identity-provider");
        Assertions.assertNotNull((Object)identityProviderResource);
        IdentityProviderRepresentation representation = identityProviderResource.toRepresentation();
        Assertions.assertNotNull((Object)representation);
        Assertions.assertNotNull((Object)representation.getInternalId());
        Assertions.assertEquals((Object)"new-identity-provider", (Object)representation.getAlias());
        Assertions.assertEquals((Object)"oidc", (Object)representation.getProviderId());
        Assertions.assertEquals((Object)"IMPORT", representation.getConfig().get("syncMode"));
        Assertions.assertEquals((Object)"clientId", representation.getConfig().get("clientId"));
        Assertions.assertEquals((Object)"**********", representation.getConfig().get("clientSecret"));
        Assertions.assertTrue((boolean)representation.isEnabled());
        Assertions.assertFalse((boolean)representation.isStoreToken());
        Assertions.assertFalse((boolean)representation.isTrustEmail());
        Assertions.assertNull((Object)representation.getFirstBrokerLoginFlowAlias());
        Assertions.assertEquals((Object)"some secret value", (Object)this.runOnServer.fetch((FetchOnServer & Serializable)s -> s.identityProviders().getByAlias("new-identity-provider").getConfig().get("clientSecret"), String.class));
        IdentityProviderRepresentation rep = this.managedRealm.admin().identityProviders().findAll().stream().filter(i -> i.getAlias().equals("new-identity-provider")).findFirst().get();
        Assertions.assertEquals((Object)"**********", rep.getConfig().get("clientSecret"));
        this.managedRealm.cleanup().add(r -> r.identityProviders().get(id).remove());
    }

    @Test
    public void failCreateInvalidUrl() throws Exception {
        ErrorRepresentation error;
        this.managedRealm.updateWithCleanup(new ManagedRealm.RealmUpdate[]{r -> r.sslRequired(SslRequired.ALL.name())});
        IdentityProviderRepresentation newIdentityProvider = this.createRep("new-identity-provider", "oidc");
        newIdentityProvider.getConfig().put("clientId", "clientId");
        newIdentityProvider.getConfig().put("clientSecret", "some secret value");
        OIDCIdentityProviderConfigRep oidcConfig = new OIDCIdentityProviderConfigRep(newIdentityProvider);
        oidcConfig.setAuthorizationUrl("invalid://test");
        try (Response response = this.managedRealm.admin().identityProviders().create(newIdentityProvider);){
            Assertions.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatus());
            error = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"The url [authorization_url] is malformed", (Object)error.getErrorMessage());
        }
        oidcConfig.setAuthorizationUrl(null);
        oidcConfig.setTokenUrl("http://test");
        response = this.managedRealm.admin().identityProviders().create(newIdentityProvider);
        try {
            Assertions.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatus());
            error = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"The url [token_url] requires secure connections", (Object)error.getErrorMessage());
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        oidcConfig.setAuthorizationUrl(null);
        oidcConfig.setTokenUrl(null);
        oidcConfig.setJwksUrl("http://test");
        response = this.managedRealm.admin().identityProviders().create(newIdentityProvider);
        try {
            Assertions.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatus());
            error = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"The url [jwks_url] requires secure connections", (Object)error.getErrorMessage());
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        oidcConfig.setAuthorizationUrl(null);
        oidcConfig.setTokenUrl(null);
        oidcConfig.setJwksUrl(null);
        oidcConfig.setLogoutUrl("http://test");
        response = this.managedRealm.admin().identityProviders().create(newIdentityProvider);
        try {
            Assertions.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatus());
            error = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"The url [logout_url] requires secure connections", (Object)error.getErrorMessage());
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        oidcConfig.setAuthorizationUrl(null);
        oidcConfig.setTokenUrl(null);
        oidcConfig.setJwksUrl(null);
        oidcConfig.setLogoutUrl(null);
        oidcConfig.setUserInfoUrl("http://test");
        response = this.managedRealm.admin().identityProviders().create(newIdentityProvider);
        try {
            Assertions.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatus());
            error = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"The url [userinfo_url] requires secure connections", (Object)error.getErrorMessage());
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    @Test
    public void shouldFailWhenAliasHasSpaceDuringCreation() {
        IdentityProviderRepresentation newIdentityProvider = this.createRep("New Identity Provider", "oidc");
        newIdentityProvider.getConfig().put("syncMode", "IMPORT");
        newIdentityProvider.getConfig().put("clientId", "clientId");
        newIdentityProvider.getConfig().put("clientSecret", "some secret value");
        newIdentityProvider.getConfig().put("clientAuthMethod", "client_secret_basic");
        try (Response response = this.managedRealm.admin().identityProviders().create(newIdentityProvider);){
            Assertions.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatus());
            String error = (String)response.readEntity(String.class);
            Assertions.assertTrue((boolean)error.contains("Empty Space not allowed."));
        }
    }

    @Test
    public void testCreateWithBasicAuth() {
        IdentityProviderRepresentation newIdentityProvider = this.createRep("new-identity-provider", "oidc");
        newIdentityProvider.getConfig().put("syncMode", "IMPORT");
        newIdentityProvider.getConfig().put("clientId", "clientId");
        newIdentityProvider.getConfig().put("clientSecret", "some secret value");
        newIdentityProvider.getConfig().put("clientAuthMethod", "client_secret_basic");
        String id = this.create(newIdentityProvider);
        IdentityProviderResource identityProviderResource = this.managedRealm.admin().identityProviders().get("new-identity-provider");
        Assertions.assertNotNull((Object)identityProviderResource);
        IdentityProviderRepresentation representation = identityProviderResource.toRepresentation();
        Assertions.assertNotNull((Object)representation);
        Assertions.assertNotNull((Object)representation.getInternalId());
        Assertions.assertEquals((Object)"new-identity-provider", (Object)representation.getAlias());
        Assertions.assertEquals((Object)"oidc", (Object)representation.getProviderId());
        Assertions.assertEquals((Object)"IMPORT", representation.getConfig().get("syncMode"));
        Assertions.assertEquals((Object)"clientId", representation.getConfig().get("clientId"));
        Assertions.assertEquals((Object)"**********", representation.getConfig().get("clientSecret"));
        Assertions.assertEquals((Object)"client_secret_basic", representation.getConfig().get("clientAuthMethod"));
        Assertions.assertTrue((boolean)representation.isEnabled());
        Assertions.assertFalse((boolean)representation.isStoreToken());
        Assertions.assertFalse((boolean)representation.isTrustEmail());
        Assertions.assertEquals((Object)"some secret value", (Object)this.runOnServer.fetch((FetchOnServer & Serializable)s -> s.identityProviders().getByAlias("new-identity-provider").getConfig().get("clientSecret"), String.class));
        IdentityProviderRepresentation rep = this.managedRealm.admin().identityProviders().findAll().stream().filter(i -> i.getAlias().equals("new-identity-provider")).findFirst().get();
        Assertions.assertEquals((Object)"**********", rep.getConfig().get("clientSecret"));
        this.managedRealm.cleanup().add(r -> r.identityProviders().get(id).remove());
    }

    @Test
    public void testCreateWithJWT() {
        IdentityProviderRepresentation newIdentityProvider = this.createRep("new-identity-provider", "oidc");
        newIdentityProvider.getConfig().put("syncMode", "IMPORT");
        newIdentityProvider.getConfig().put("clientId", "clientId");
        newIdentityProvider.getConfig().put("clientAuthMethod", "private_key_jwt");
        String id = this.create(newIdentityProvider);
        IdentityProviderResource identityProviderResource = this.managedRealm.admin().identityProviders().get("new-identity-provider");
        Assertions.assertNotNull((Object)identityProviderResource);
        IdentityProviderRepresentation representation = identityProviderResource.toRepresentation();
        Assertions.assertNotNull((Object)representation);
        Assertions.assertNotNull((Object)representation.getInternalId());
        Assertions.assertEquals((Object)"new-identity-provider", (Object)representation.getAlias());
        Assertions.assertEquals((Object)"oidc", (Object)representation.getProviderId());
        Assertions.assertEquals((Object)"IMPORT", representation.getConfig().get("syncMode"));
        Assertions.assertEquals((Object)"clientId", representation.getConfig().get("clientId"));
        Assertions.assertNull(representation.getConfig().get("clientSecret"));
        Assertions.assertEquals((Object)"private_key_jwt", representation.getConfig().get("clientAuthMethod"));
        Assertions.assertNull(representation.getConfig().get("jwtX509HeadersEnabled"));
        Assertions.assertTrue((boolean)representation.isEnabled());
        Assertions.assertFalse((boolean)representation.isStoreToken());
        Assertions.assertFalse((boolean)representation.isTrustEmail());
        this.managedRealm.cleanup().add(r -> r.identityProviders().get(id).remove());
    }

    @Test
    public void testCreateWithJWTAndX509Headers() {
        IdentityProviderRepresentation newIdentityProvider = this.createRep("new-identity-provider", "oidc");
        newIdentityProvider.getConfig().put("syncMode", "IMPORT");
        newIdentityProvider.getConfig().put("clientId", "clientId");
        newIdentityProvider.getConfig().put("clientAuthMethod", "private_key_jwt");
        newIdentityProvider.getConfig().put("jwtX509HeadersEnabled", "true");
        String id = this.create(newIdentityProvider);
        IdentityProviderResource identityProviderResource = this.managedRealm.admin().identityProviders().get("new-identity-provider");
        Assertions.assertNotNull((Object)identityProviderResource);
        IdentityProviderRepresentation representation = identityProviderResource.toRepresentation();
        Assertions.assertNotNull((Object)representation);
        Assertions.assertNotNull((Object)representation.getInternalId());
        Assertions.assertEquals((Object)"new-identity-provider", (Object)representation.getAlias());
        Assertions.assertEquals((Object)"oidc", (Object)representation.getProviderId());
        Assertions.assertEquals((Object)"IMPORT", representation.getConfig().get("syncMode"));
        Assertions.assertEquals((Object)"clientId", representation.getConfig().get("clientId"));
        Assertions.assertNull(representation.getConfig().get("clientSecret"));
        Assertions.assertEquals((Object)"private_key_jwt", representation.getConfig().get("clientAuthMethod"));
        Assertions.assertEquals((Object)"true", representation.getConfig().get("jwtX509HeadersEnabled"));
        Assertions.assertTrue((boolean)representation.isEnabled());
        Assertions.assertFalse((boolean)representation.isStoreToken());
        Assertions.assertFalse((boolean)representation.isTrustEmail());
        this.managedRealm.cleanup().add(r -> r.identityProviders().get(id).remove());
    }

    @Test
    public void testUpdate() {
        IdentityProviderRepresentation newIdentityProvider = this.createRep("update-identity-provider", "oidc");
        newIdentityProvider.getConfig().put("syncMode", "IMPORT");
        newIdentityProvider.getConfig().put("clientId", "clientId");
        newIdentityProvider.getConfig().put("clientSecret", "some secret value");
        this.create(newIdentityProvider);
        IdentityProviderResource identityProviderResource = this.managedRealm.admin().identityProviders().get("update-identity-provider");
        Assertions.assertNotNull((Object)identityProviderResource);
        IdentityProviderRepresentation representation = identityProviderResource.toRepresentation();
        Assertions.assertNotNull((Object)representation);
        Assertions.assertEquals((Object)"update-identity-provider", (Object)representation.getAlias());
        representation.setAlias("changed-alias");
        representation.setEnabled(false);
        representation.setStoreToken(true);
        representation.getConfig().put("clientId", "changedClientId");
        identityProviderResource.update(representation);
        AdminEventRepresentation event = (AdminEventRepresentation)this.adminEvents.poll();
        AdminEventAssertion.assertEvent((AdminEventRepresentation)event, (OperationType)OperationType.UPDATE, (String)AdminEventPaths.identityProviderPath((String)"update-identity-provider"), (Object)representation, (ResourceType)ResourceType.IDENTITY_PROVIDER);
        Assertions.assertFalse((boolean)event.getRepresentation().contains("some secret value"));
        Assertions.assertTrue((boolean)event.getRepresentation().contains("**********"));
        identityProviderResource = this.managedRealm.admin().identityProviders().get(representation.getInternalId());
        Assertions.assertNotNull((Object)identityProviderResource);
        representation = identityProviderResource.toRepresentation();
        Assertions.assertFalse((boolean)representation.isEnabled());
        Assertions.assertTrue((boolean)representation.isStoreToken());
        Assertions.assertEquals((Object)"changedClientId", representation.getConfig().get("clientId"));
        Assertions.assertEquals((Object)"some secret value", (Object)this.runOnServer.fetch((FetchOnServer & Serializable)s -> s.identityProviders().getByAlias("changed-alias").getConfig().get("clientSecret"), String.class));
        representation.getConfig().put("clientSecret", "${vault.key}");
        identityProviderResource.update(representation);
        event = (AdminEventRepresentation)this.adminEvents.poll();
        AdminEventAssertion.assertEvent((AdminEventRepresentation)event, (OperationType)OperationType.UPDATE, (String)AdminEventPaths.identityProviderPath((String)representation.getInternalId()), (Object)representation, (ResourceType)ResourceType.IDENTITY_PROVIDER);
        MatcherAssert.assertThat((Object)event.getRepresentation(), (Matcher)Matchers.containsString((String)"${vault.key}"));
        MatcherAssert.assertThat((Object)event.getRepresentation(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"**********")));
        MatcherAssert.assertThat((Object)identityProviderResource.toRepresentation().getConfig(), (Matcher)Matchers.hasEntry((Object)"clientSecret", (Object)"${vault.key}"));
        Assertions.assertEquals((Object)"${vault.key}", (Object)this.runOnServer.fetch((FetchOnServer & Serializable)s -> s.identityProviders().getByAlias("changed-alias").getConfig().get("clientSecret"), String.class));
    }

    @Test
    public void failUpdateInvalidUrl() throws Exception {
        ErrorRepresentation error;
        Response response;
        this.managedRealm.updateWithCleanup(new ManagedRealm.RealmUpdate[]{r -> r.sslRequired(SslRequired.ALL.name())});
        this.adminEvents.poll();
        IdentityProviderRepresentation representation = this.createRep(UUID.randomUUID().toString(), "oidc");
        representation.getConfig().put("clientId", "clientId");
        representation.getConfig().put("clientSecret", "some secret value");
        String id = this.create(representation);
        IdentityProviderResource resource = this.managedRealm.admin().identityProviders().get(representation.getAlias());
        representation = resource.toRepresentation();
        OIDCIdentityProviderConfigRep oidcConfig = new OIDCIdentityProviderConfigRep(representation);
        oidcConfig.setAuthorizationUrl("invalid://test");
        try {
            resource.update(representation);
            Assertions.fail((String)"Invalid URL");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof ClientErrorException));
            response = ((ClientErrorException)((Object)ClientErrorException.class.cast(e))).getResponse();
            Assertions.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatus());
            error = (ErrorRepresentation)((ClientErrorException)((Object)e)).getResponse().readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"The url [authorization_url] is malformed", (Object)error.getErrorMessage());
        }
        oidcConfig.setAuthorizationUrl(null);
        oidcConfig.setTokenUrl("http://test");
        try {
            resource.update(representation);
            Assertions.fail((String)"Invalid URL");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof ClientErrorException));
            response = ((ClientErrorException)((Object)ClientErrorException.class.cast(e))).getResponse();
            Assertions.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatus());
            error = (ErrorRepresentation)((ClientErrorException)((Object)e)).getResponse().readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"The url [token_url] requires secure connections", (Object)error.getErrorMessage());
        }
        oidcConfig.setAuthorizationUrl(null);
        oidcConfig.setTokenUrl(null);
        oidcConfig.setJwksUrl("http://test");
        try {
            resource.update(representation);
            Assertions.fail((String)"Invalid URL");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof ClientErrorException));
            response = ((ClientErrorException)((Object)ClientErrorException.class.cast(e))).getResponse();
            Assertions.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatus());
            error = (ErrorRepresentation)((ClientErrorException)((Object)e)).getResponse().readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"The url [jwks_url] requires secure connections", (Object)error.getErrorMessage());
        }
        oidcConfig.setAuthorizationUrl(null);
        oidcConfig.setTokenUrl(null);
        oidcConfig.setJwksUrl(null);
        oidcConfig.setLogoutUrl("http://test");
        try {
            resource.update(representation);
            Assertions.fail((String)"Invalid URL");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof ClientErrorException));
            response = ((ClientErrorException)((Object)ClientErrorException.class.cast(e))).getResponse();
            Assertions.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatus());
            error = (ErrorRepresentation)((ClientErrorException)((Object)e)).getResponse().readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"The url [logout_url] requires secure connections", (Object)error.getErrorMessage());
        }
        oidcConfig.setAuthorizationUrl(null);
        oidcConfig.setTokenUrl(null);
        oidcConfig.setJwksUrl(null);
        oidcConfig.setLogoutUrl(null);
        oidcConfig.setUserInfoUrl("http://localhost");
        try {
            resource.update(representation);
            Assertions.fail((String)"Invalid URL");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof ClientErrorException));
            response = ((ClientErrorException)((Object)ClientErrorException.class.cast(e))).getResponse();
            Assertions.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatus());
            error = (ErrorRepresentation)((ClientErrorException)((Object)e)).getResponse().readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"The url [userinfo_url] requires secure connections", (Object)error.getErrorMessage());
        }
        this.managedRealm.updateWithCleanup(new ManagedRealm.RealmUpdate[]{r -> r.sslRequired(SslRequired.EXTERNAL.name())});
        resource.update(representation);
        this.managedRealm.cleanup().add(r -> r.identityProviders().get(id).remove());
    }

    @Test
    public void testNoExport() {
        String id = this.create(this.createRep("keycloak-oidc", "keycloak-oidc"));
        Response response = this.managedRealm.admin().identityProviders().get("keycloak-oidc").export("json");
        Assertions.assertEquals((int)204, (int)response.getStatus(), (String)"status");
        String body = (String)response.readEntity(String.class);
        Assertions.assertNull((Object)body, (String)"body");
        response.close();
        this.managedRealm.cleanup().add(r -> r.identityProviders().get(id).remove());
    }
}

