/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.identityprovider;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.dom.saml.v2.metadata.EndpointType;
import org.keycloak.dom.saml.v2.metadata.EntityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.IndexedEndpointType;
import org.keycloak.dom.saml.v2.metadata.KeyDescriptorType;
import org.keycloak.dom.saml.v2.metadata.KeyTypes;
import org.keycloak.dom.saml.v2.metadata.SPSSODescriptorType;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.rotation.HardcodedKeyLocator;
import org.keycloak.rotation.KeyLocator;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.common.util.XmlKeyInfoKeyNameTransformer;
import org.keycloak.saml.processing.api.saml.v2.sig.SAML2Signature;
import org.keycloak.saml.processing.core.parsers.saml.SAMLParser;
import org.keycloak.saml.processing.core.util.XMLSignatureUtil;
import org.keycloak.testframework.annotations.InjectKeycloakUrls;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.server.KeycloakUrls;
import org.keycloak.tests.admin.identityprovider.AbstractIdentityProviderTest;
import org.keycloak.tests.utils.Assert;
import org.keycloak.tests.utils.KeyUtils;
import org.keycloak.tests.utils.admin.AdminEventPaths;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@KeycloakIntegrationTest
public class IdentityProviderSamlTest
extends AbstractIdentityProviderTest {
    @InjectKeycloakUrls
    KeycloakUrls keycloakUrls;
    private static final String SIGNING_CERT_1 = "MIICmzCCAYMCBgFUYnC0OjANBgkqhkiG9w0BAQsFADARMQ8wDQYDVQQDDAZtYXN0ZXIwHhcNMTYwNDI5MTQzMjEzWhcNMjYwNDI5MTQzMzUzWjARMQ8wDQYDVQQDDAZtYXN0ZXIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCN25AW1poMEZRbuMAHG58AThZmCwMV6/Gcui4mjGacRFyudgqzLjQ2rxpoW41JAtLjbjeAhuWvirUcFVcOeS3gM/ZC27qCpYighAcylZz6MYocnEe1+e8rPPk4JlID6Wv62dgu+pL/vYsQpRhvD3Y2c/ytgr5D32xF+KnzDehUy5BSyzypvu12Wq9mS5vK5tzkN37EjkhpY2ZxaXPubjDIITCAL4Q8M/m5IlacBaUZbzI4AQrHnMP1O1IH2dHSWuMiBe+xSDTco72PmuYPJKTV4wQdeBUIkYbfLc4RxVmXEvgkQgyW86EoMPxlWJpj7+mTIR+l+2thZPr/VgwTs82rAgMBAAEwDQYJKoZIhvcNAQELBQADggEBAA/Ip/Hi8RoVu5ouaFFlc5whT7ltuK8slfLGW4tM4vJXhInYwsqIRQKBNDYW/64xle3eII4u1yAH1OYRRwEs7Em1pr4QuFuTY1at+aE0sE46XDlyESI0txJjWxYoT133vM0We2pj1b2nxgU30rwjKA3whnKEfTEYT/n3JBSqNggy6l8ZGw/oPSgvPaR4+xeB1tfQFC4VrLoYKoqH6hAL530nKxL+qV8AIfL64NDEE8ankIAEDAAFe8x3CPUfXR/p4KOANKkpz8ieQaHDb1eITkAwUwjESj6UF9D1aePlhWls/HX0gujFXtWfWfrJ8CU/ogwlH8y1jgRuLjFQYZk6llc=";
    private static final String SIGNING_CERT_2 = "MIIBnDCCAQUCBgFYKXKsPTANBgkqhkiG9w0BAQsFADAUMRIwEAYDVQQDDAlzYW1sLWRlbW8wHhcNMTYxMTAzMDkwNzEwWhcNMjYxMTAzMDkwODUwWjAUMRIwEAYDVQQDDAlzYW1sLWRlbW8wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAKtWsK5O0CtuBpnMvWG+HTG0vmZzujQ2o9WdheQu+BzCILcGMsbDW0YQaglpcO5JpGWWhubnckGGPHfdQ2/7nP9QwbiTK0FbGF41UqcvoaCqU1psxoV88s8IXyQCAqeyLv00yj6foqdJjxh5SZ5z+na+M7Y2OxIBVxYRAxWEnfUvAgMBAAEwDQYJKoZIhvcNAQELBQADgYEAhetvOU8TyqfZF5jpv0IcrviLl/DoFrbjByeHR+pu/vClcAOjL/u7oQELuuTfNsBI4tpexUj5G8q/YbEz0gk7idfLXrAUVcsR73oTngrhRfwUSmPrjjK0kjcRb6HL9V/+wh3R/6mEd59U08ExT8N38rhmn0CI3ehMdebReprP7U8=";

    @Test
    public void testRemove() {
        IdentityProviderRepresentation newIdentityProvider = this.createRep("remove-identity-provider", "saml");
        this.create(newIdentityProvider);
        IdentityProviderResource identityProviderResource = this.managedRealm.admin().identityProviders().get("remove-identity-provider");
        Assertions.assertNotNull((Object)identityProviderResource);
        IdentityProviderRepresentation representation = identityProviderResource.toRepresentation();
        Assertions.assertNotNull((Object)representation);
        identityProviderResource.remove();
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.identityProviderPath((String)"remove-identity-provider"), (ResourceType)ResourceType.IDENTITY_PROVIDER);
        try {
            this.managedRealm.admin().identityProviders().get("remove-identity-provider").toRepresentation();
            Assertions.fail((String)"Not expected to found");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testNotAvailableFromRealRepresentation() {
        IdentityProviderRepresentation newIdentityProvider = this.createRep("remove-identity-provider", "saml");
        String id = this.create(newIdentityProvider);
        RealmRepresentation rep = this.managedRealm.admin().toRepresentation();
        Assertions.assertNull((Object)rep.getIdentityProviders());
        Assertions.assertNull((Object)rep.getIdentityProviderMappers());
        this.managedRealm.cleanup().add(r -> r.identityProviders().get(id).remove());
    }

    @Test
    public void importShouldFailDueAliasWithSpace() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("providerId", "saml");
        data.put("alias", "Alias With Space");
        data.put("fromUrl", "http://");
        Assertions.assertThrows(BadRequestException.class, () -> this.managedRealm.admin().identityProviders().importFrom(data));
    }

    @Test
    public void testSamlImportAndExport() throws URISyntaxException, IOException, ParsingException {
        this.testSamlImport("saml-idp-metadata.xml", true);
        Response response = this.managedRealm.admin().identityProviders().get("saml").export("xml");
        Assertions.assertEquals((int)200, (int)response.getStatus());
        String body = (String)response.readEntity(String.class);
        response.close();
        this.assertSamlExport(body, true);
    }

    @Test
    public void testSamlImportWithBom() throws URISyntaxException, IOException, ParsingException {
        this.testSamlImport("saml-idp-metadata_utf8_bom.xml", true);
        Response response = this.managedRealm.admin().identityProviders().get("saml").export("xml");
        Assertions.assertEquals((int)200, (int)response.getStatus());
        String body = (String)response.readEntity(String.class);
        response.close();
        this.assertSamlExport(body, true);
    }

    @Test
    public void testSamlImportAndExportDifferentBindings() throws URISyntaxException, IOException, ParsingException {
        this.testSamlImport("saml-idp-metadata-different-bindings.xml", false);
        try (Response response = this.managedRealm.admin().identityProviders().get("saml").export("xml");){
            Assertions.assertEquals((int)200, (int)response.getStatus());
            String body = (String)response.readEntity(String.class);
            this.assertSamlExport(body, false);
        }
    }

    @Test
    public void testSamlImportWithAnyEncryptionMethod() throws URISyntaxException, IOException, ParsingException {
        this.testSamlImport("saml-idp-metadata-encryption-methods.xml", true);
    }

    @Test
    public void testSamlImportAndExportDisabled() throws URISyntaxException, IOException, ParsingException {
        MultipartFormDataOutput form = new MultipartFormDataOutput();
        form.addFormData("providerId", (Object)"saml", MediaType.TEXT_PLAIN_TYPE);
        URL idpMeta = IdentityProviderSamlTest.class.getResource("saml-idp-metadata-disabled.xml");
        byte[] content = Files.readAllBytes(Paths.get(idpMeta.toURI()));
        String body = new String(content, Charset.forName("utf-8"));
        form.addFormData("file", (Object)body, MediaType.APPLICATION_XML_TYPE, "saml-idp-metadata-disabled.xml");
        Map result = this.managedRealm.admin().identityProviders().importFrom((Object)form);
        this.assertSamlImport(result, SIGNING_CERT_1, false, true);
        String id = this.create(this.createRep("saml", "saml", false, result));
        IdentityProviderResource provider = this.managedRealm.admin().identityProviders().get("saml");
        IdentityProviderRepresentation rep = provider.toRepresentation();
        this.assertCreatedSamlIdp(rep, false, true);
        this.managedRealm.cleanup().add(r -> r.identityProviders().get(id).remove());
    }

    @Test
    public void testSamlImportAndExportMultipleSigningKeys() throws URISyntaxException, IOException, ParsingException {
        MultipartFormDataOutput form = new MultipartFormDataOutput();
        form.addFormData("providerId", (Object)"saml", MediaType.TEXT_PLAIN_TYPE);
        URL idpMeta = IdentityProviderSamlTest.class.getResource("saml-idp-metadata-two-signing-certs.xml");
        byte[] content = Files.readAllBytes(Paths.get(idpMeta.toURI()));
        String body = new String(content, Charset.forName("utf-8"));
        form.addFormData("file", (Object)body, MediaType.APPLICATION_XML_TYPE, "saml-idp-metadata-two-signing-certs");
        Map result = this.managedRealm.admin().identityProviders().importFrom((Object)form);
        this.assertSamlImport(result, "MIICmzCCAYMCBgFUYnC0OjANBgkqhkiG9w0BAQsFADARMQ8wDQYDVQQDDAZtYXN0ZXIwHhcNMTYwNDI5MTQzMjEzWhcNMjYwNDI5MTQzMzUzWjARMQ8wDQYDVQQDDAZtYXN0ZXIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCN25AW1poMEZRbuMAHG58AThZmCwMV6/Gcui4mjGacRFyudgqzLjQ2rxpoW41JAtLjbjeAhuWvirUcFVcOeS3gM/ZC27qCpYighAcylZz6MYocnEe1+e8rPPk4JlID6Wv62dgu+pL/vYsQpRhvD3Y2c/ytgr5D32xF+KnzDehUy5BSyzypvu12Wq9mS5vK5tzkN37EjkhpY2ZxaXPubjDIITCAL4Q8M/m5IlacBaUZbzI4AQrHnMP1O1IH2dHSWuMiBe+xSDTco72PmuYPJKTV4wQdeBUIkYbfLc4RxVmXEvgkQgyW86EoMPxlWJpj7+mTIR+l+2thZPr/VgwTs82rAgMBAAEwDQYJKoZIhvcNAQELBQADggEBAA/Ip/Hi8RoVu5ouaFFlc5whT7ltuK8slfLGW4tM4vJXhInYwsqIRQKBNDYW/64xle3eII4u1yAH1OYRRwEs7Em1pr4QuFuTY1at+aE0sE46XDlyESI0txJjWxYoT133vM0We2pj1b2nxgU30rwjKA3whnKEfTEYT/n3JBSqNggy6l8ZGw/oPSgvPaR4+xeB1tfQFC4VrLoYKoqH6hAL530nKxL+qV8AIfL64NDEE8ankIAEDAAFe8x3CPUfXR/p4KOANKkpz8ieQaHDb1eITkAwUwjESj6UF9D1aePlhWls/HX0gujFXtWfWfrJ8CU/ogwlH8y1jgRuLjFQYZk6llc=,MIIBnDCCAQUCBgFYKXKsPTANBgkqhkiG9w0BAQsFADAUMRIwEAYDVQQDDAlzYW1sLWRlbW8wHhcNMTYxMTAzMDkwNzEwWhcNMjYxMTAzMDkwODUwWjAUMRIwEAYDVQQDDAlzYW1sLWRlbW8wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAKtWsK5O0CtuBpnMvWG+HTG0vmZzujQ2o9WdheQu+BzCILcGMsbDW0YQaglpcO5JpGWWhubnckGGPHfdQ2/7nP9QwbiTK0FbGF41UqcvoaCqU1psxoV88s8IXyQCAqeyLv00yj6foqdJjxh5SZ5z+na+M7Y2OxIBVxYRAxWEnfUvAgMBAAEwDQYJKoZIhvcNAQELBQADgYEAhetvOU8TyqfZF5jpv0IcrviLl/DoFrbjByeHR+pu/vClcAOjL/u7oQELuuTfNsBI4tpexUj5G8q/YbEz0gk7idfLXrAUVcsR73oTngrhRfwUSmPrjjK0kjcRb6HL9V/+wh3R/6mEd59U08ExT8N38rhmn0CI3ehMdebReprP7U8=", true, true);
        String id = this.create(this.createRep("saml", "saml", true, result));
        IdentityProviderResource provider = this.managedRealm.admin().identityProviders().get("saml");
        IdentityProviderRepresentation rep = provider.toRepresentation();
        this.assertCreatedSamlIdp(rep, true, true);
        List providers = this.managedRealm.admin().identityProviders().findAll();
        Assertions.assertNotNull((Object)providers, (String)"identityProviders not null");
        Assertions.assertEquals((int)1, (int)providers.size(), (String)"identityProviders instance count");
        this.assertEqual(rep, (IdentityProviderRepresentation)providers.get(0));
        Response response = this.managedRealm.admin().identityProviders().get("saml").export("xml");
        Assertions.assertEquals((int)200, (int)response.getStatus());
        body = (String)response.readEntity(String.class);
        response.close();
        this.assertSamlExport(body, true);
        this.managedRealm.cleanup().add(r -> r.identityProviders().get(id).remove());
    }

    @Test
    public void testSamlExportSignatureOff() throws URISyntaxException, IOException, ConfigurationException, ParsingException, ProcessingException {
        MultipartFormDataOutput form = new MultipartFormDataOutput();
        form.addFormData("providerId", (Object)"saml", MediaType.TEXT_PLAIN_TYPE);
        URL idpMeta = IdentityProviderSamlTest.class.getResource("saml-idp-metadata.xml");
        byte[] content = Files.readAllBytes(Paths.get(idpMeta.toURI()));
        String body = new String(content, Charset.forName("utf-8"));
        form.addFormData("file", (Object)body, MediaType.APPLICATION_XML_TYPE, "saml-idp-metadata.xml");
        Map result = this.managedRealm.admin().identityProviders().importFrom((Object)form);
        result.put("signSpMetadata", "false");
        IdentityProviderRepresentation idpRep = this.createRep("saml", "saml", true, result);
        String id = this.create(idpRep);
        Response response = this.managedRealm.admin().identityProviders().get("saml").export("xml");
        Assertions.assertEquals((int)200, (int)response.getStatus());
        body = (String)response.readEntity(String.class);
        response.close();
        Document document = DocumentUtil.getDocument((String)body);
        Element signatureElement = DocumentUtil.getDirectChildElement((Element)document.getDocumentElement(), (String)JBossSAMLURIConstants.XMLDSIG_NSURI.get(), (String)"Signature");
        Assertions.assertNull((Object)signatureElement);
        this.managedRealm.cleanup().add(r -> r.identityProviders().get(id).remove());
    }

    @Test
    public void testSamlExportSignatureOn() throws URISyntaxException, IOException, ConfigurationException, ParsingException, ProcessingException, CertificateEncodingException {
        MultipartFormDataOutput form = new MultipartFormDataOutput();
        form.addFormData("providerId", (Object)"saml", MediaType.TEXT_PLAIN_TYPE);
        URL idpMeta = IdentityProviderSamlTest.class.getResource("saml-idp-metadata.xml");
        byte[] content = Files.readAllBytes(Paths.get(idpMeta.toURI()));
        String body = new String(content, Charset.forName("utf-8"));
        form.addFormData("file", (Object)body, MediaType.APPLICATION_XML_TYPE, "saml-idp-metadata.xml");
        Map result = this.managedRealm.admin().identityProviders().importFrom((Object)form);
        result.put("signSpMetadata", "true");
        result.put("xmlSigKeyInfoKeyNameTransformer", XmlKeyInfoKeyNameTransformer.CERT_SUBJECT.name());
        IdentityProviderRepresentation idpRep = this.createRep("saml", "saml", true, result);
        String id = this.create(idpRep);
        Response response = this.managedRealm.admin().identityProviders().get("saml").export("xml");
        Assertions.assertEquals((int)200, (int)response.getStatus());
        body = (String)response.readEntity(String.class);
        response.close();
        Document document = DocumentUtil.getDocument((String)body);
        Element signatureElement = DocumentUtil.getDirectChildElement((Element)document.getDocumentElement(), (String)JBossSAMLURIConstants.XMLDSIG_NSURI.get(), (String)"Signature");
        MatcherAssert.assertThat((String)"Signature not null", (Object)signatureElement, (Matcher)Matchers.notNullValue());
        Element keyInfoElement = DocumentUtil.getDirectChildElement((Element)signatureElement, (String)JBossSAMLURIConstants.XMLDSIG_NSURI.get(), (String)"KeyInfo");
        MatcherAssert.assertThat((String)"KeyInfo not null", (Object)keyInfoElement, (Matcher)Matchers.notNullValue());
        Element x509DataElement = DocumentUtil.getDirectChildElement((Element)keyInfoElement, (String)JBossSAMLURIConstants.XMLDSIG_NSURI.get(), (String)"X509Data");
        MatcherAssert.assertThat((String)"X509Data not null", (Object)x509DataElement, (Matcher)Matchers.notNullValue());
        Element x509CertificateElement = DocumentUtil.getDirectChildElement((Element)x509DataElement, (String)JBossSAMLURIConstants.XMLDSIG_NSURI.get(), (String)"X509Certificate");
        MatcherAssert.assertThat((String)"X509Certificate not null", (Object)x509CertificateElement, (Matcher)Matchers.notNullValue());
        Element keyNameElement = DocumentUtil.getDirectChildElement((Element)keyInfoElement, (String)JBossSAMLURIConstants.XMLDSIG_NSURI.get(), (String)"KeyName");
        MatcherAssert.assertThat((String)"KeyName not null", (Object)keyNameElement, (Matcher)Matchers.notNullValue());
        String activeSigCert = KeyUtils.findActiveSigningKey((RealmResource)this.managedRealm.admin(), (String)"RS256").getCertificate();
        MatcherAssert.assertThat((String)"activeSigCert not null", (Object)activeSigCert, (Matcher)Matchers.notNullValue());
        X509Certificate activeX509SigCert = XMLSignatureUtil.getX509CertificateFromKeyInfoString((String)activeSigCert);
        MatcherAssert.assertThat((String)"KeyName matches subject DN", (Object)keyNameElement.getTextContent().trim(), (Matcher)Matchers.equalTo((Object)activeX509SigCert.getSubjectX500Principal().getName()));
        MatcherAssert.assertThat((String)"Signing cert matches active realm cert", (Object)x509CertificateElement.getTextContent().trim(), (Matcher)Matchers.equalTo((Object)Base64.getEncoder().encodeToString(activeX509SigCert.getEncoded())));
        PublicKey activePublicSigKey = activeX509SigCert.getPublicKey();
        MatcherAssert.assertThat((String)"Metadata signature is valid", (Object)new SAML2Signature().validate(document, (KeyLocator)new HardcodedKeyLocator((Key)activePublicSigKey)), (Matcher)Matchers.is((Object)true));
        this.managedRealm.cleanup().add(r -> r.identityProviders().get(id).remove());
    }

    private void testSamlImport(String fileName, boolean postBindingResponse) throws URISyntaxException, IOException, ParsingException {
        MultipartFormDataOutput form = new MultipartFormDataOutput();
        form.addFormData("providerId", (Object)"saml", MediaType.TEXT_PLAIN_TYPE);
        URL idpMeta = IdentityProviderSamlTest.class.getResource(fileName);
        byte[] content = Files.readAllBytes(Paths.get(idpMeta.toURI()));
        String body = new String(content, Charset.forName("utf-8"));
        form.addFormData("file", (Object)body, MediaType.APPLICATION_XML_TYPE, fileName);
        Map result = this.managedRealm.admin().identityProviders().importFrom((Object)form);
        this.assertSamlImport(result, SIGNING_CERT_1, true, postBindingResponse);
        String id = this.create(this.createRep("saml", "saml", true, result));
        IdentityProviderResource provider = this.managedRealm.admin().identityProviders().get("saml");
        IdentityProviderRepresentation rep = provider.toRepresentation();
        this.assertCreatedSamlIdp(rep, true, postBindingResponse);
        List providers = this.managedRealm.admin().identityProviders().findAll();
        Assertions.assertNotNull((Object)providers, (String)"identityProviders not null");
        Assertions.assertEquals((int)1, (int)providers.size(), (String)"identityProviders instance count");
        this.assertEqual(rep, (IdentityProviderRepresentation)providers.get(0));
        this.managedRealm.cleanup().add(r -> r.identityProviders().get(id).remove());
    }

    private void assertEqual(IdentityProviderRepresentation expected, IdentityProviderRepresentation actual) {
        Assertions.assertNotNull((Object)expected, (String)"expected IdentityProviderRepresentation not null");
        Assertions.assertNotNull((Object)actual, (String)"actual IdentityProviderRepresentation not null");
        Assertions.assertEquals((Object)expected.getInternalId(), (Object)actual.getInternalId(), (String)"internalId");
        Assertions.assertEquals((Object)expected.getAlias(), (Object)actual.getAlias(), (String)"alias");
        Assertions.assertEquals((Object)expected.getProviderId(), (Object)actual.getProviderId(), (String)"providerId");
        Assertions.assertEquals((Object)expected.isEnabled(), (Object)actual.isEnabled(), (String)"enabled");
        Assertions.assertEquals((Object)expected.isHideOnLogin(), (Object)actual.isHideOnLogin(), (String)"hideOnLogin");
        Assertions.assertEquals((Object)expected.getFirstBrokerLoginFlowAlias(), (Object)actual.getFirstBrokerLoginFlowAlias(), (String)"firstBrokerLoginFlowAlias");
        Assertions.assertEquals((Object)expected.getConfig(), (Object)actual.getConfig(), (String)"config");
    }

    private void assertCreatedSamlIdp(IdentityProviderRepresentation idp, boolean enabled, boolean postBindingResponse) {
        Assertions.assertNotNull((Object)idp, (String)"IdentityProviderRepresentation not null");
        Assertions.assertNotNull((Object)idp.getInternalId(), (String)"internalId");
        Assertions.assertEquals((Object)"saml", (Object)idp.getAlias(), (String)"alias");
        Assertions.assertEquals((Object)"saml", (Object)idp.getProviderId(), (String)"providerId");
        Assertions.assertEquals((Object)enabled, (Object)idp.isEnabled(), (String)"enabled");
        Assertions.assertTrue((boolean)idp.isHideOnLogin(), (String)"hideOnLogin");
        Assertions.assertNull((Object)idp.getFirstBrokerLoginFlowAlias(), (String)"firstBrokerLoginFlowAlias");
        this.assertSamlConfig(idp.getConfig(), postBindingResponse, false);
    }

    private void assertSamlConfig(Map<String, String> config, boolean postBindingResponse, boolean hasHideOnLoginPage) {
        ArrayList<String> keys = new ArrayList<String>(List.of("syncMode", "validateSignature", "singleLogoutServiceUrl", "postBindingLogout", "postBindingResponse", "artifactBindingResponse", "postBindingAuthnRequest", "singleSignOnServiceUrl", "artifactResolutionServiceUrl", "wantAuthnRequestsSigned", "nameIDPolicyFormat", "signingCertificate", "addExtensionsElementWithKeyInfo", "loginHint", "idpEntityId"));
        if (hasHideOnLoginPage) {
            keys.add("hideOnLoginPage");
        }
        MatcherAssert.assertThat(config.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])keys.toArray()));
        MatcherAssert.assertThat(config, (Matcher)Matchers.hasEntry((Object)"validateSignature", (Object)"true"));
        MatcherAssert.assertThat(config, (Matcher)Matchers.hasEntry((Object)"singleLogoutServiceUrl", (Object)"http://localhost:8080/auth/realms/master/protocol/saml"));
        MatcherAssert.assertThat(config, (Matcher)Matchers.hasEntry((Object)"artifactResolutionServiceUrl", (Object)"http://localhost:8080/auth/realms/master/protocol/saml/resolve"));
        MatcherAssert.assertThat(config, (Matcher)Matchers.hasEntry((Object)"postBindingResponse", (Object)Boolean.toString(postBindingResponse)));
        MatcherAssert.assertThat(config, (Matcher)Matchers.hasEntry((Object)"artifactBindingResponse", (Object)"false"));
        MatcherAssert.assertThat(config, (Matcher)Matchers.hasEntry((Object)"postBindingAuthnRequest", (Object)Boolean.toString(postBindingResponse)));
        MatcherAssert.assertThat(config, (Matcher)Matchers.hasEntry((Object)"singleSignOnServiceUrl", (Object)"http://localhost:8080/auth/realms/master/protocol/saml"));
        MatcherAssert.assertThat(config, (Matcher)Matchers.hasEntry((Object)"wantAuthnRequestsSigned", (Object)"true"));
        MatcherAssert.assertThat(config, (Matcher)Matchers.hasEntry((Object)"addExtensionsElementWithKeyInfo", (Object)"false"));
        MatcherAssert.assertThat(config, (Matcher)Matchers.hasEntry((Object)"nameIDPolicyFormat", (Object)"urn:oasis:names:tc:SAML:2.0:nameid-format:persistent"));
        if (hasHideOnLoginPage) {
            MatcherAssert.assertThat(config, (Matcher)Matchers.hasEntry((Object)"hideOnLoginPage", (Object)"true"));
        }
        MatcherAssert.assertThat(config, (Matcher)Matchers.hasEntry((Object)"idpEntityId", (Object)"http://localhost:8080/auth/realms/master"));
        MatcherAssert.assertThat(config, (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"signingCertificate"), (Matcher)Matchers.notNullValue()));
    }

    private void assertSamlImport(Map<String, String> config, String expectedSigningCertificates, boolean enabled, boolean postBindingResponse) {
        boolean enabledFromMetadata = Boolean.valueOf(config.get("enabledFromMetadata"));
        config.remove("enabledFromMetadata");
        Assert.assertEquals((Object)enabledFromMetadata, (Object)enabled);
        this.assertSamlConfig(config, postBindingResponse, true);
        MatcherAssert.assertThat(config, (Matcher)Matchers.hasEntry((Object)"signingCertificate", (Object)expectedSigningCertificates));
    }

    private void assertSamlExport(String body, boolean postBindingResponse) throws ParsingException, URISyntaxException {
        Object entBody = SAMLParser.getInstance().parse((InputStream)new ByteArrayInputStream(body.getBytes(Charset.forName("utf-8"))));
        Assertions.assertEquals(EntityDescriptorType.class, entBody.getClass(), (String)"Parsed export type");
        EntityDescriptorType entity = (EntityDescriptorType)entBody;
        Assertions.assertEquals((Object)(String.valueOf(this.keycloakUrls.getBaseUrl()) + "/realms/default"), (Object)entity.getEntityID(), (String)"EntityID");
        Assertions.assertNotNull((Object)entity.getChoiceType(), (String)"ChoiceType not null");
        Assertions.assertEquals((int)1, (int)entity.getChoiceType().size(), (String)"ChoiceType.size");
        List descriptors = ((EntityDescriptorType.EDTChoiceType)entity.getChoiceType().get(0)).getDescriptors();
        Assertions.assertNotNull((Object)descriptors, (String)"Descriptors not null");
        Assertions.assertEquals((int)1, (int)descriptors.size(), (String)"Descriptors.size");
        SPSSODescriptorType desc = ((EntityDescriptorType.EDTDescriptorChoiceType)descriptors.get(0)).getSpDescriptor();
        Assertions.assertNotNull((Object)desc, (String)"SPSSODescriptor not null");
        Assertions.assertTrue((boolean)desc.isAuthnRequestsSigned(), (String)"AuthnRequestsSigned");
        HashSet<String> expected = new HashSet<String>(Arrays.asList("urn:oasis:names:tc:SAML:2.0:protocol"));
        HashSet actual = new HashSet(desc.getProtocolSupportEnumeration());
        Assertions.assertEquals(expected, actual, (String)"ProtocolSupportEnumeration");
        Assertions.assertNotNull((Object)desc.getAssertionConsumerService(), (String)"AssertionConsumerService not null");
        Assertions.assertEquals((int)3, (int)desc.getAssertionConsumerService().size(), (String)"AssertionConsumerService.size");
        IndexedEndpointType endpoint = (IndexedEndpointType)desc.getAssertionConsumerService().get(0);
        URI samlUri = new URI(this.keycloakUrls.getBase() + "/realms/default/broker/saml/endpoint");
        Assertions.assertEquals((Object)samlUri, (Object)endpoint.getLocation(), (String)"AssertionConsumerService.Location");
        Assert.assertEquals((Object)(postBindingResponse ? JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.getUri() : JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.getUri()), (Object)endpoint.getBinding(), (String)"AssertionConsumerService.Binding");
        Assertions.assertTrue((boolean)endpoint.isIsDefault(), (String)"AssertionConsumerService.isDefault");
        endpoint = (IndexedEndpointType)desc.getAssertionConsumerService().get(1);
        Assertions.assertEquals((Object)samlUri, (Object)endpoint.getLocation(), (String)"AssertionConsumerService.Location");
        Assert.assertEquals((Object)(postBindingResponse ? JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.getUri() : JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.getUri()), (Object)endpoint.getBinding(), (String)"AssertionConsumerService.Binding");
        endpoint = (IndexedEndpointType)desc.getAssertionConsumerService().get(2);
        Assertions.assertEquals((Object)samlUri, (Object)endpoint.getLocation(), (String)"AssertionConsumerService.Location");
        Assertions.assertEquals((Object)JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.getUri(), (Object)endpoint.getBinding(), (String)"AssertionConsumerService.Binding");
        Assertions.assertNotNull((Object)desc.getSingleLogoutService(), (String)"SingleLogoutService not null");
        Assertions.assertEquals((int)2, (int)desc.getSingleLogoutService().size(), (String)"SingleLogoutService.size");
        EndpointType sloEndpoint = (EndpointType)desc.getSingleLogoutService().get(0);
        Assertions.assertEquals((Object)samlUri, (Object)sloEndpoint.getLocation(), (String)"SingleLogoutService.Location");
        Assertions.assertEquals((Object)JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.getUri(), (Object)sloEndpoint.getBinding(), (String)"SingleLogoutService.Binding");
        sloEndpoint = (EndpointType)desc.getSingleLogoutService().get(1);
        Assertions.assertEquals((Object)samlUri, (Object)sloEndpoint.getLocation(), (String)"SingleLogoutService.Location");
        Assertions.assertEquals((Object)JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.getUri(), (Object)sloEndpoint.getBinding(), (String)"SingleLogoutService.Binding");
        Assertions.assertNotNull((Object)desc.getKeyDescriptor(), (String)"KeyDescriptor not null");
        Assertions.assertEquals((int)1, (int)desc.getKeyDescriptor().size(), (String)"KeyDescriptor.size");
        KeyDescriptorType keyDesc = (KeyDescriptorType)desc.getKeyDescriptor().get(0);
        MatcherAssert.assertThat((Object)keyDesc, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)keyDesc.getUse(), (Matcher)Matchers.equalTo((Object)KeyTypes.SIGNING));
        NodeList cert = keyDesc.getKeyInfo().getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509Certificate");
        MatcherAssert.assertThat((String)"KeyDescriptor.Signing.Cert existence", (Object)cert.getLength(), (Matcher)Matchers.is((Object)1));
    }
}

