/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.identityprovider;

import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.IdentityProviderStorageProvider;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.remote.providers.runonserver.RunOnServer;
import org.keycloak.tests.admin.identityprovider.AbstractIdentityProviderTest;
import org.keycloak.tests.utils.Assert;

@KeycloakIntegrationTest
public class IdentityProviderTest
extends AbstractIdentityProviderTest {
    @InjectRealm(lifecycle=LifeCycle.METHOD)
    ManagedRealm managedRealm;

    @Test
    public void testFind() {
        this.create(this.createRep("twitter", "twitter idp", "twitter", true, Collections.singletonMap("key1", "value1")));
        this.create(this.createRep("linkedin-openid-connect", "linkedin-openid-connect"));
        this.create(this.createRep("google", "google"));
        this.create(this.createRep("github", "github"));
        this.create(this.createRep("facebook", "facebook"));
        Assert.assertNames((List)this.managedRealm.admin().identityProviders().findAll(), (String[])new String[]{"facebook", "github", "google", "linkedin-openid-connect", "twitter"});
        Assert.assertNames((List)this.managedRealm.admin().identityProviders().find(null, Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(2)), (String[])new String[]{"facebook", "github"});
        Assert.assertNames((List)this.managedRealm.admin().identityProviders().find(null, Boolean.valueOf(true), Integer.valueOf(2), Integer.valueOf(2)), (String[])new String[]{"google", "linkedin-openid-connect"});
        Assert.assertNames((List)this.managedRealm.admin().identityProviders().find(null, Boolean.valueOf(true), Integer.valueOf(4), Integer.valueOf(2)), (String[])new String[]{"twitter"});
        Assert.assertNames((List)this.managedRealm.admin().identityProviders().find("g", Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(5)), (String[])new String[]{"github", "google"});
        Assert.assertNames((List)this.managedRealm.admin().identityProviders().find("g*", Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(5)), (String[])new String[]{"github", "google"});
        Assert.assertNames((List)this.managedRealm.admin().identityProviders().find("g*", Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(1)), (String[])new String[]{"github"});
        Assert.assertNames((List)this.managedRealm.admin().identityProviders().find("g*", Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1)), (String[])new String[]{"google"});
        Assert.assertNames((List)this.managedRealm.admin().identityProviders().find("*oo*", Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(5)), (String[])new String[]{"google", "facebook"});
        Assert.assertNames((List)this.managedRealm.admin().identityProviders().find("*ter i*", Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(5)), (String[])new String[]{"twitter"});
        List results = this.managedRealm.admin().identityProviders().find("\"twitter\"", Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(5));
        Assert.assertNames((List)results, (String[])new String[]{"twitter"});
        Assertions.assertTrue((boolean)((IdentityProviderRepresentation)results.iterator().next()).getConfig().isEmpty(), (String)"Result is not in brief representation");
        results = this.managedRealm.admin().identityProviders().find("\"twitter\"", null, Integer.valueOf(0), Integer.valueOf(5));
        Assert.assertNames((List)results, (String[])new String[]{"twitter"});
        Assertions.assertFalse((boolean)((IdentityProviderRepresentation)results.iterator().next()).getConfig().isEmpty(), (String)"Config should be present in full representation");
    }

    @Test
    public void testFindForLoginPreservesOrderByAlias() {
        this.create(this.createRep("twitter", "twitter"));
        this.create(this.createRep("linkedin-openid-connect", "linkedin-openid-connect"));
        this.create(this.createRep("google", "google"));
        this.create(this.createRep("github", "github"));
        this.create(this.createRep("facebook", "facebook"));
        this.create(this.createRep("stackoverflow", "stackoverflow"));
        this.create(this.createRep("openshift-v4", "openshift-v4"));
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            List<String> aliases = session.identityProviders().getForLogin(IdentityProviderStorageProvider.FetchMode.ALL, null).map(IdentityProviderModel::getAlias).toList();
            MatcherAssert.assertThat(aliases, (Matcher)Matchers.contains((Object[])new String[]{"facebook", "github", "google", "linkedin-openid-connect", "openshift-v4", "stackoverflow", "twitter"}));
        });
    }

    @Test
    public void testInstalledIdentityProviders() {
        Response response = this.managedRealm.admin().identityProviders().getIdentityProviders("oidc");
        Assertions.assertEquals((int)200, (int)response.getStatus(), (String)"Status");
        Map body = (Map)response.readEntity(Map.class);
        this.assertProviderInfo(body, "oidc", "OpenID Connect v1.0");
        response = this.managedRealm.admin().identityProviders().getIdentityProviders("keycloak-oidc");
        Assertions.assertEquals((int)200, (int)response.getStatus(), (String)"Status");
        body = (Map)response.readEntity(Map.class);
        this.assertProviderInfo(body, "keycloak-oidc", "Keycloak OpenID Connect");
        response = this.managedRealm.admin().identityProviders().getIdentityProviders("saml");
        Assertions.assertEquals((int)200, (int)response.getStatus(), (String)"Status");
        body = (Map)response.readEntity(Map.class);
        this.assertProviderInfo(body, "saml", "SAML v2.0");
        response = this.managedRealm.admin().identityProviders().getIdentityProviders("google");
        Assertions.assertEquals((int)200, (int)response.getStatus(), (String)"Status");
        body = (Map)response.readEntity(Map.class);
        this.assertProviderInfo(body, "google", "Google");
        response = this.managedRealm.admin().identityProviders().getIdentityProviders("facebook");
        Assertions.assertEquals((int)200, (int)response.getStatus(), (String)"Status");
        body = (Map)response.readEntity(Map.class);
        this.assertProviderInfo(body, "facebook", "Facebook");
        response = this.managedRealm.admin().identityProviders().getIdentityProviders("github");
        Assertions.assertEquals((int)200, (int)response.getStatus(), (String)"Status");
        body = (Map)response.readEntity(Map.class);
        this.assertProviderInfo(body, "github", "GitHub");
        response = this.managedRealm.admin().identityProviders().getIdentityProviders("twitter");
        Assertions.assertEquals((int)200, (int)response.getStatus(), (String)"Status");
        body = (Map)response.readEntity(Map.class);
        this.assertProviderInfo(body, "twitter", "Twitter");
        response = this.managedRealm.admin().identityProviders().getIdentityProviders("linkedin-openid-connect");
        Assertions.assertEquals((int)200, (int)response.getStatus(), (String)"Status");
        body = (Map)response.readEntity(Map.class);
        this.assertProviderInfo(body, "linkedin-openid-connect", "LinkedIn");
        response = this.managedRealm.admin().identityProviders().getIdentityProviders("microsoft");
        Assertions.assertEquals((int)200, (int)response.getStatus(), (String)"Status");
        body = (Map)response.readEntity(Map.class);
        this.assertProviderInfo(body, "microsoft", "Microsoft");
        response = this.managedRealm.admin().identityProviders().getIdentityProviders("stackoverflow");
        Assertions.assertEquals((int)200, (int)response.getStatus(), (String)"Status");
        body = (Map)response.readEntity(Map.class);
        this.assertProviderInfo(body, "stackoverflow", "StackOverflow");
        response = this.managedRealm.admin().identityProviders().getIdentityProviders("nonexistent");
        Assertions.assertEquals((int)400, (int)response.getStatus(), (String)"Status");
    }
}

