/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.metric;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.testframework.annotations.InjectHttpClient;
import org.keycloak.testframework.annotations.InjectKeycloakUrls;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.InjectUser;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.oauth.OAuthClient;
import org.keycloak.testframework.oauth.annotations.InjectOAuthClient;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.ManagedUser;
import org.keycloak.testframework.realm.UserConfig;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;
import org.keycloak.testframework.server.KeycloakUrls;
import org.keycloak.testsuite.util.oauth.AccessTokenResponse;
import org.keycloak.testsuite.util.oauth.AuthorizationEndpointResponse;

@KeycloakIntegrationTest(config=ServerConfigWithMetrics.class)
public class PasswordValidationMetricCustomTagsTest {
    @InjectUser(config=OAuthUserConfig.class)
    ManagedUser user;
    @InjectRealm
    ManagedRealm realm;
    @InjectOAuthClient
    OAuthClient oAuthClient;
    @InjectKeycloakUrls
    KeycloakUrls keycloakUrls;
    @InjectHttpClient
    HttpClient httpClient;
    Pattern passValidationRegex = Pattern.compile("keycloak_credentials_password_hashing_validations_total\\{realm=\"([^\"]+)\"} ([.0-9]*)");

    @Test
    void testValidAndInvalidPasswordValidation() throws IOException {
        this.runAuthorizationCodeFlow(this.user.getUsername(), "invalid_password", false);
        this.runAuthorizationCodeFlow(this.user.getUsername(), this.user.getPassword(), true);
        String metrics = EntityUtils.toString((HttpEntity)this.httpClient.execute((HttpUriRequest)new HttpGet(this.keycloakUrls.getMetric())).getEntity());
        Matcher matcher = this.passValidationRegex.matcher(metrics);
        Assertions.assertTrue((boolean)matcher.find());
        Assertions.assertEquals((Object)this.realm.getName(), (Object)matcher.group(1));
        Assertions.assertEquals((Object)"2.0", (Object)matcher.group(2));
        Assertions.assertFalse((boolean)matcher.find());
    }

    private void runAuthorizationCodeFlow(String username, String password, boolean success) {
        AuthorizationEndpointResponse authorizationEndpointResponse = this.oAuthClient.doLogin(username, password);
        if (!success) {
            Assertions.assertFalse((boolean)authorizationEndpointResponse.isRedirected());
            return;
        }
        AccessTokenResponse accessTokenResponse = this.oAuthClient.doAccessTokenRequest(authorizationEndpointResponse.getCode());
        Assertions.assertTrue((boolean)accessTokenResponse.isSuccess());
    }

    public static class OAuthUserConfig
    implements UserConfig {
        public UserConfigBuilder configure(UserConfigBuilder user) {
            return user.name("First", "Last").email("test@local").password("password");
        }
    }

    public static class ServerConfigWithMetrics
    implements KeycloakServerConfig {
        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder config) {
            return config.option("metrics-enabled", "true").option("spi-credential-keycloak-password-validations-counter-tags", "realm");
        }
    }
}

