/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.metric;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.testframework.annotations.InjectHttpClient;
import org.keycloak.testframework.annotations.InjectKeycloakUrls;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.InjectUser;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.oauth.OAuthClient;
import org.keycloak.testframework.oauth.annotations.InjectOAuthClient;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.ManagedUser;
import org.keycloak.testframework.realm.UserConfig;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;
import org.keycloak.testframework.server.KeycloakUrls;
import org.keycloak.testframework.ui.annotations.InjectWebDriver;
import org.keycloak.testsuite.util.oauth.AccessTokenResponse;
import org.keycloak.testsuite.util.oauth.AuthorizationEndpointResponse;
import org.openqa.selenium.WebDriver;

@KeycloakIntegrationTest(config=ServerConfigWithMetrics.class)
public class PasswordValidationMetricTest {
    @InjectUser(config=OAuthUserConfig.class)
    ManagedUser user;
    @InjectRealm
    ManagedRealm realm;
    @InjectOAuthClient
    OAuthClient oAuthClient;
    @InjectKeycloakUrls
    KeycloakUrls keycloakUrls;
    @InjectHttpClient
    HttpClient httpClient;
    @InjectWebDriver
    WebDriver webDriver;
    Pattern passValidationRegex = Pattern.compile("keycloak_credentials_password_hashing_validations_total\\{algorithm=\"([^\"]+)\",hashing_strength=\"([^\"]+)\",outcome=\"([^\"]+)\",realm=\"([^\"]+)\"} ([.0-9]*)");

    @Test
    void testValidAndInvalidPasswordValidation() throws IOException {
        this.runAuthorizationCodeFlow(this.user.getUsername(), "invalid_password");
        this.webDriver.manage().deleteAllCookies();
        this.runAuthorizationCodeFlow(this.user.getUsername(), this.user.getPassword());
        String metrics = EntityUtils.toString((HttpEntity)this.httpClient.execute((HttpUriRequest)new HttpGet(this.keycloakUrls.getMetric())).getEntity());
        Matcher matcher = this.passValidationRegex.matcher(metrics);
        Assertions.assertTrue((boolean)matcher.find());
        String algorithm = matcher.group(1);
        String hashing_strength = matcher.group(2);
        String outcome = matcher.group(3);
        String realmTag = matcher.group(4);
        String counterValue = matcher.group(5);
        Assertions.assertTrue(("valid".equals(outcome) || "invalid".equals(outcome) ? 1 : 0) != 0, (String)("outcome tag should be valid or invalid but was " + outcome));
        Assertions.assertEquals((Object)this.realm.getName(), (Object)realmTag);
        Assertions.assertEquals((Object)"1.0", (Object)counterValue);
        Assertions.assertTrue((boolean)matcher.find());
        Assertions.assertEquals((Object)algorithm, (Object)matcher.group(1));
        Assertions.assertEquals((Object)hashing_strength, (Object)matcher.group(2));
        Assertions.assertEquals((Object)("valid".equals(outcome) ? "invalid" : "valid"), (Object)matcher.group(3));
        Assertions.assertEquals((Object)this.realm.getName(), (Object)matcher.group(4));
        Assertions.assertEquals((Object)"1.0", (Object)matcher.group(5));
        Assertions.assertFalse((boolean)matcher.find());
    }

    private void runAuthorizationCodeFlow(String username, String password) {
        AuthorizationEndpointResponse authorizationEndpointResponse = this.oAuthClient.doLogin(username, password);
        if (authorizationEndpointResponse.isRedirected()) {
            AccessTokenResponse tokenResponse = this.oAuthClient.doAccessTokenRequest(authorizationEndpointResponse.getCode());
            Assertions.assertTrue((boolean)tokenResponse.isSuccess());
            Assertions.assertNotNull((Object)tokenResponse.getAccessToken());
        }
    }

    public static class OAuthUserConfig
    implements UserConfig {
        public UserConfigBuilder configure(UserConfigBuilder user) {
            return user.name("First", "Last").email("test@local").password("password");
        }
    }

    public static class ServerConfigWithMetrics
    implements KeycloakServerConfig {
        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder config) {
            return config.option("metrics-enabled", "true");
        }
    }
}

