/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.model.workflow;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.keycloak.models.UserModel;
import org.keycloak.models.workflow.AddRequiredActionStepProvider;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.workflows.WorkflowRepresentation;
import org.keycloak.representations.workflows.WorkflowStepRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.tests.admin.model.workflow.WorkflowsServerConfig;

@KeycloakIntegrationTest(config=WorkflowsServerConfig.class)
public class AddRequiredActionTest {
    @InjectRealm(lifecycle=LifeCycle.METHOD)
    ManagedRealm managedRealm;

    @Test
    public void testStepRun() {
        this.managedRealm.admin().workflows().create(WorkflowRepresentation.create().of("user-creation-time-workflow").withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("set-user-required-action").withConfig(AddRequiredActionStepProvider.REQUIRED_ACTION_KEY, "UPDATE_PASSWORD").build()}).build()).close();
        this.managedRealm.admin().users().create(UserConfigBuilder.create().username("test").build()).close();
        List users = this.managedRealm.admin().users().search("test");
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)1));
        UserRepresentation userRepresentation = (UserRepresentation)users.get(0);
        MatcherAssert.assertThat((Object)userRepresentation.getRequiredActions(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((String)userRepresentation.getRequiredActions().get(0)), (Matcher)Matchers.is((Object)UserModel.RequiredAction.UPDATE_PASSWORD.name()));
    }
}

