/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.model.workflow;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.workflow.ResourceType;
import org.keycloak.models.workflow.WorkflowsManager;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.workflows.WorkflowRepresentation;
import org.keycloak.representations.workflows.WorkflowStepRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.remote.providers.runonserver.RunOnServer;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.testframework.util.ApiUtil;
import org.keycloak.tests.admin.model.workflow.WorkflowsServerConfig;

@KeycloakIntegrationTest(config=WorkflowsServerConfig.class)
public class AdhocWorkflowTest {
    private static final String REALM_NAME = "default";
    @InjectRunOnServer(permittedPackages={"org.keycloak.tests"})
    RunOnServerClient runOnServer;
    @InjectRealm(lifecycle=LifeCycle.METHOD)
    ManagedRealm managedRealm;

    @Test
    public void testCreate() {
        this.managedRealm.admin().workflows().create(WorkflowRepresentation.create().of("event-based-workflow").withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("set-user-attribute").withConfig("message", "message").after(Duration.ofDays(1L)).build()}).build()).close();
        List workflows = this.managedRealm.admin().workflows().list();
        MatcherAssert.assertThat((Object)workflows, (Matcher)Matchers.hasSize((int)1));
        WorkflowRepresentation workflow = (WorkflowRepresentation)workflows.get(0);
        MatcherAssert.assertThat((Object)workflow.getSteps(), (Matcher)Matchers.hasSize((int)1));
        WorkflowStepRepresentation aggregatedStep = (WorkflowStepRepresentation)workflow.getSteps().get(0);
        MatcherAssert.assertThat((Object)aggregatedStep.getUses(), (Matcher)Matchers.is((Object)"set-user-attribute"));
    }

    @Test
    public void testBindAdHocScheduledWithImmediateWorkflow() {
        this.managedRealm.admin().workflows().create(WorkflowRepresentation.create().of("event-based-workflow").withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("set-user-attribute").withConfig("message", "message").build()}).build()).close();
        List workflows = this.managedRealm.admin().workflows().list();
        MatcherAssert.assertThat((Object)workflows, (Matcher)Matchers.hasSize((int)1));
        WorkflowRepresentation workflow = (WorkflowRepresentation)workflows.get(0);
        try (Response response = this.managedRealm.admin().users().create(this.getUserRepresentation("alice", "Alice", "Wonderland", "alice@wornderland.org"));){
            String id = ApiUtil.getCreatedId((Response)response);
            try {
                this.managedRealm.admin().workflows().workflow(workflow.getId()).bind(ResourceType.USERS.name(), id, Long.valueOf(Duration.ofDays(5L).toMillis()));
            }
            catch (Exception e) {
                MatcherAssert.assertThat((Object)e, (Matcher)Matchers.instanceOf(BadRequestException.class));
            }
        }
    }

    @Test
    public void testRunAdHocScheduledWorkflow() {
        this.managedRealm.admin().workflows().create(WorkflowRepresentation.create().of("event-based-workflow").withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("set-user-attribute").after(Duration.ofDays(5L)).withConfig("message", "message").build()}).build()).close();
        List workflows = this.managedRealm.admin().workflows().list();
        MatcherAssert.assertThat((Object)workflows, (Matcher)Matchers.hasSize((int)1));
        WorkflowRepresentation workflow = (WorkflowRepresentation)workflows.get(0);
        try (Response response = this.managedRealm.admin().users().create(this.getUserRepresentation("alice", "Alice", "Wonderland", "alice@wornderland.org"));){
            String id = ApiUtil.getCreatedId((Response)response);
            this.managedRealm.admin().workflows().workflow(workflow.getId()).bind(ResourceType.USERS.name(), id);
        }
    }

    @Test
    public void testRunAdHocImmediateWorkflow() {
        this.managedRealm.admin().workflows().create(WorkflowRepresentation.create().of("event-based-workflow").withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("set-user-attribute").withConfig("message", "message").build()}).build()).close();
        List workflows = this.managedRealm.admin().workflows().list();
        MatcherAssert.assertThat((Object)workflows, (Matcher)Matchers.hasSize((int)1));
        WorkflowRepresentation workflow = (WorkflowRepresentation)workflows.get(0);
        try (Response response = this.managedRealm.admin().users().create(this.getUserRepresentation("alice", "Alice", "Wonderland", "alice@wornderland.org"));){
            String id = ApiUtil.getCreatedId((Response)response);
            this.managedRealm.admin().workflows().workflow(workflow.getId()).bind(ResourceType.USERS.name(), id);
        }
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = AdhocWorkflowTest.configureSessionContext(session);
            WorkflowsManager manager = new WorkflowsManager(session);
            UserModel user = session.users().getUserByUsername(realm, "alice");
            manager.runScheduledSteps();
            Assertions.assertNotNull(user.getAttributes().get("message"));
        });
    }

    @Test
    public void testRunAdHocTimedWorkflow() {
        String id;
        this.managedRealm.admin().workflows().create(WorkflowRepresentation.create().of("event-based-workflow").withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("set-user-attribute").withConfig("message", "message").build()}).build()).close();
        List workflows = this.managedRealm.admin().workflows().list();
        MatcherAssert.assertThat((Object)workflows, (Matcher)Matchers.hasSize((int)1));
        WorkflowRepresentation workflow = (WorkflowRepresentation)workflows.get(0);
        try (Response response = this.managedRealm.admin().users().create(this.getUserRepresentation("alice", "Alice", "Wonderland", "alice@wornderland.org"));){
            id = ApiUtil.getCreatedId((Response)response);
            this.managedRealm.admin().workflows().workflow(workflow.getId()).bind(ResourceType.USERS.name(), id, Long.valueOf(Duration.ofDays(5L).toMillis()));
        }
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = AdhocWorkflowTest.configureSessionContext(session);
            WorkflowsManager manager = new WorkflowsManager(session);
            UserModel user = session.users().getUserByUsername(realm, "alice");
            manager.runScheduledSteps();
            Assertions.assertNull(user.getAttributes().get("message"));
            try {
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(6L).toSeconds()));
                manager.runScheduledSteps();
                user = session.users().getUserByUsername(realm, "alice");
                Assertions.assertNotNull(user.getAttributes().get("message"));
            }
            finally {
                user.removeAttribute("message");
                Time.setOffset((int)0);
            }
        });
        this.managedRealm.admin().workflows().workflow(workflow.getId()).bind(ResourceType.USERS.name(), id, Long.valueOf(Duration.ofDays(10L).toMillis()));
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = AdhocWorkflowTest.configureSessionContext(session);
            WorkflowsManager manager = new WorkflowsManager(session);
            UserModel user = session.users().getUserByUsername(realm, "alice");
            manager.runScheduledSteps();
            Assertions.assertNull(user.getAttributes().get("message"));
            try {
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(6L).toSeconds()));
                manager.runScheduledSteps();
                user = session.users().getUserByUsername(realm, "alice");
                Assertions.assertNull(user.getAttributes().get("message"));
            }
            finally {
                Time.setOffset((int)0);
            }
            try {
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(11L).toSeconds()));
                manager.runScheduledSteps();
                user = session.users().getUserByUsername(realm, "alice");
                Assertions.assertNotNull(user.getAttributes().get("message"));
            }
            finally {
                Time.setOffset((int)0);
            }
        });
    }

    private static RealmModel configureSessionContext(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName(REALM_NAME);
        session.getContext().setRealm(realm);
        return realm;
    }

    private UserRepresentation getUserRepresentation(String username, String firstName, String lastName, String email) {
        UserRepresentation representation = new UserRepresentation();
        representation.setUsername(username);
        representation.setFirstName(firstName);
        representation.setLastName(lastName);
        representation.setEmail(email);
        representation.setEnabled(Boolean.valueOf(true));
        CredentialRepresentation credential = new CredentialRepresentation();
        credential.setType("password");
        credential.setValue(username);
        representation.setCredentials(List.of(credential));
        return representation;
    }
}

