/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.model.workflow;

import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.workflow.ResourceOperationType;
import org.keycloak.models.workflow.Workflow;
import org.keycloak.models.workflow.WorkflowStateProvider;
import org.keycloak.models.workflow.WorkflowsManager;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.workflows.WorkflowConditionRepresentation;
import org.keycloak.representations.workflows.WorkflowRepresentation;
import org.keycloak.representations.workflows.WorkflowStateRepresentation;
import org.keycloak.representations.workflows.WorkflowStepRepresentation;
import org.keycloak.testframework.annotations.InjectClient;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.InjectUser;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.oauth.OAuthClient;
import org.keycloak.testframework.oauth.annotations.InjectOAuthClient;
import org.keycloak.testframework.realm.ClientConfig;
import org.keycloak.testframework.realm.ClientConfigBuilder;
import org.keycloak.testframework.realm.ManagedClient;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.ManagedUser;
import org.keycloak.testframework.realm.RealmConfig;
import org.keycloak.testframework.realm.RealmConfigBuilder;
import org.keycloak.testframework.realm.UserConfig;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.testframework.remote.providers.runonserver.RunOnServer;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.testframework.ui.annotations.InjectPage;
import org.keycloak.testframework.ui.annotations.InjectWebDriver;
import org.keycloak.testframework.ui.page.ConsentPage;
import org.keycloak.testframework.ui.page.LoginPage;
import org.keycloak.tests.admin.model.workflow.WorkflowsServerConfig;
import org.openqa.selenium.WebDriver;

@KeycloakIntegrationTest(config=WorkflowsServerConfig.class)
public class BrokeredUserSessionRefreshTimeWorkflowTest {
    private static final String REALM_NAME = "consumer";
    @InjectRunOnServer(permittedPackages={"org.keycloak.tests"})
    RunOnServerClient runOnServer;
    @InjectRealm(ref="consumer", config=ConsumerRealmConf.class, lifecycle=LifeCycle.METHOD)
    ManagedRealm consumerRealm;
    @InjectRealm(ref="provider", lifecycle=LifeCycle.METHOD)
    ManagedRealm providerRealm;
    @InjectUser(ref="alice", realmRef="provider", config=ProviderRealmUserConf.class)
    ManagedUser aliceFromProviderRealm;
    @InjectUser(ref="bob", realmRef="consumer", config=ConsumerRealmUserConf.class)
    ManagedUser bobFromConsumerRealm;
    @InjectOAuthClient(ref="consumer", realmRef="consumer")
    OAuthClient consumerRealmOAuth;
    @InjectClient(realmRef="provider", config=ProviderRealmClientConf.class)
    ManagedClient providerRealmClient;
    @InjectWebDriver
    WebDriver driver;
    @InjectPage
    LoginPage loginPage;
    @InjectPage
    ConsentPage consentPage;
    private static final String REALM_PROV_NAME = "provider";
    private static final String REALM_CONS_NAME = "consumer";
    private static final String IDP_OIDC_ALIAS = "kc-oidc-idp";
    private static final String IDP_OIDC_PROVIDER_ID = "keycloak-oidc";
    private static final String CLIENT_ID = "brokerapp";
    private static final String CLIENT_SECRET = "secret";

    @Test
    public void testInvalidateWorkflowOnIdentityProviderRemoval() {
        this.consumerRealm.admin().workflows().create(WorkflowRepresentation.create().of("user-refresh-time-workflow").onEvent(ResourceOperationType.USER_LOGIN.toString()).onConditions(new WorkflowConditionRepresentation[]{WorkflowConditionRepresentation.create().of("has-identity-provider-link").withConfig("alias", IDP_OIDC_ALIAS).build()}).withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("delete-user").after(Duration.ofDays(1L)).build()}).build()).close();
        List workflows = this.consumerRealm.admin().workflows().list();
        MatcherAssert.assertThat((Object)workflows, (Matcher)Matchers.hasSize((int)1));
        WorkflowRepresentation workflowRep = this.consumerRealm.admin().workflows().workflow(((WorkflowRepresentation)workflows.get(0)).getId()).toRepresentation();
        MatcherAssert.assertThat((Object)((String)workflowRep.getConfig().getFirst((Object)"enabled")), (Matcher)Matchers.nullValue());
        this.consumerRealm.admin().identityProviders().get(IDP_OIDC_ALIAS).remove();
        this.consumerRealm.admin().users().create(UserConfigBuilder.create().username("test").build()).close();
        workflowRep = this.consumerRealm.admin().workflows().workflow(((WorkflowRepresentation)workflows.get(0)).getId()).toRepresentation();
        MatcherAssert.assertThat((Object)workflowRep.getEnabled(), (Matcher)Matchers.allOf((Matcher)Matchers.notNullValue(), (Matcher)Matchers.is((Object)false)));
        WorkflowStateRepresentation status = workflowRep.getState();
        MatcherAssert.assertThat((Object)status, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)status.getErrors(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((String)status.getErrors().get(0)), (Matcher)Matchers.containsString((String)"Identity provider %s does not exist.".formatted(IDP_OIDC_ALIAS)));
    }

    @Test
    public void tesRunStepOnFederatedUser() {
        this.consumerRealm.admin().workflows().create(WorkflowRepresentation.create().of("user-refresh-time-workflow").onEvent(ResourceOperationType.USER_LOGIN.toString()).onConditions(new WorkflowConditionRepresentation[]{WorkflowConditionRepresentation.create().of("has-identity-provider-link").withConfig("alias", IDP_OIDC_ALIAS).build()}).withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("delete-user").after(Duration.ofDays(1L)).build()}).build()).close();
        this.loginBrokeredUser();
        UsersResource users = this.consumerRealm.admin().users();
        String username = this.aliceFromProviderRealm.getUsername();
        UserRepresentation federatedUser = (UserRepresentation)users.search(username).get(0);
        List federatedIdentities = users.get(federatedUser.getId()).getFederatedIdentity();
        Assertions.assertFalse((boolean)federatedIdentities.isEmpty());
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = BrokeredUserSessionRefreshTimeWorkflowTest.configureSessionContext(session);
            WorkflowsManager manager = new WorkflowsManager(session);
            manager.runScheduledSteps();
            UserModel user = session.users().getUserByUsername(realm, username);
            Assertions.assertNotNull((Object)user);
            Assertions.assertTrue((boolean)user.isEnabled());
            try {
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(2L).toSeconds()));
                manager.runScheduledSteps();
                user = session.users().getUserByUsername(realm, username);
                Assertions.assertNull((Object)user);
            }
            finally {
                Time.setOffset((int)0);
            }
        });
        this.consumerRealmOAuth.openLoginForm();
        this.loginPage.fillLogin(this.bobFromConsumerRealm.getUsername(), this.bobFromConsumerRealm.getPassword());
        this.loginPage.submit();
        Assertions.assertTrue((boolean)this.driver.getPageSource().contains("Happy days"), (String)"Test user should be successfully logged in.");
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = BrokeredUserSessionRefreshTimeWorkflowTest.configureSessionContext(session);
            WorkflowsManager manager = new WorkflowsManager(session);
            manager.runScheduledSteps();
            UserModel user = session.users().getUserByUsername(realm, "bob");
            Assertions.assertNotNull((Object)user);
            Assertions.assertTrue((boolean)user.isEnabled());
            try {
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(2L).toSeconds()));
                manager.runScheduledSteps();
                user = session.users().getUserByUsername(realm, "bob");
                Assertions.assertNotNull((Object)user);
            }
            finally {
                Time.setOffset((int)0);
            }
        });
    }

    @Disabled(value="For now deactivation events is not enabled to any event")
    @Test
    public void testAddRemoveFedIdentityAffectsWorkflowAssociation() {
        this.consumerRealm.admin().workflows().create(WorkflowRepresentation.create().of("user-refresh-time-workflow").onEvent(ResourceOperationType.USER_FEDERATED_IDENTITY_ADD.toString()).onConditions(new WorkflowConditionRepresentation[]{WorkflowConditionRepresentation.create().of("has-identity-provider-link").withConfig("alias", IDP_OIDC_ALIAS).build()}).withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("delete-user").after(Duration.ofDays(1L)).build()}).build()).close();
        this.loginBrokeredUser();
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = BrokeredUserSessionRefreshTimeWorkflowTest.configureSessionContext(session);
            WorkflowsManager manager = new WorkflowsManager(session);
            Workflow workflow = (Workflow)manager.getWorkflows().get(0);
            UserModel alice = session.users().getUserByUsername(realm, "alice");
            Assertions.assertNotNull((Object)alice);
            WorkflowStateProvider stateProvider = (WorkflowStateProvider)session.getProvider(WorkflowStateProvider.class);
            WorkflowStateProvider.ScheduledStep scheduledStep = stateProvider.getScheduledStep(workflow.getId(), alice.getId());
            Assertions.assertNotNull((Object)scheduledStep, (String)("A step should have been scheduled for the user " + alice.getUsername()));
        });
        UserRepresentation aliceInConsumerRealm = (UserRepresentation)this.consumerRealm.admin().users().search(this.aliceFromProviderRealm.getUsername()).get(0);
        Assertions.assertNotNull((Object)aliceInConsumerRealm);
        this.consumerRealm.admin().users().get(aliceInConsumerRealm.getId()).removeFederatedIdentity(IDP_OIDC_ALIAS);
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = BrokeredUserSessionRefreshTimeWorkflowTest.configureSessionContext(session);
            WorkflowsManager manager = new WorkflowsManager(session);
            try {
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(2L).toSeconds()));
                manager.runScheduledSteps();
                UserModel user = session.users().getUserByUsername(realm, "alice");
                Assertions.assertNotNull((Object)user, (String)"User alice should not be deleted as she is no longer associated with the IDP and thus the workflow.");
            }
            finally {
                Time.setOffset((int)0);
            }
        });
        FederatedIdentityRepresentation federatedIdentityRepresentation = new FederatedIdentityRepresentation();
        federatedIdentityRepresentation.setIdentityProvider(IDP_OIDC_ALIAS);
        federatedIdentityRepresentation.setUserId("bob-federated-id");
        federatedIdentityRepresentation.setUserName("bob-federated-usewrname");
        this.consumerRealm.admin().users().get(this.bobFromConsumerRealm.getId()).addFederatedIdentity(IDP_OIDC_ALIAS, federatedIdentityRepresentation).close();
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = BrokeredUserSessionRefreshTimeWorkflowTest.configureSessionContext(session);
            WorkflowsManager manager = new WorkflowsManager(session);
            try {
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(2L).toSeconds()));
                manager.runScheduledSteps();
                UserModel user = session.users().getUserByUsername(realm, "bob");
                Assertions.assertNull((Object)user);
            }
            finally {
                Time.setOffset((int)0);
            }
        });
    }

    private void loginBrokeredUser() {
        this.consumerRealmOAuth.openLoginForm();
        this.loginPage.clickSocial(IDP_OIDC_ALIAS);
        Assertions.assertTrue((boolean)this.driver.getCurrentUrl().contains("/realms/" + this.providerRealm.getName() + "/"), (String)"Driver should be on the provider realm page right now");
        this.loginPage.fillLogin(this.aliceFromProviderRealm.getUsername(), this.aliceFromProviderRealm.getPassword());
        this.loginPage.submit();
        this.consentPage.waitForPage();
        this.consentPage.assertCurrent();
        this.consentPage.confirm();
        Assertions.assertTrue((boolean)this.driver.getPageSource().contains("Happy days"), (String)"Test user should be successfully logged in.");
    }

    private static IdentityProviderRepresentation setUpIdentityProvider() {
        IdentityProviderRepresentation idp = BrokeredUserSessionRefreshTimeWorkflowTest.createIdentityProvider(IDP_OIDC_ALIAS, IDP_OIDC_PROVIDER_ID);
        Map config = idp.getConfig();
        config.put("clientId", CLIENT_ID);
        config.put("clientSecret", CLIENT_SECRET);
        config.put("prompt", "login");
        config.put("authorizationUrl", "http://localhost:8080/realms/provider/protocol/openid-connect/auth");
        config.put("tokenUrl", "http://localhost:8080/realms/provider/protocol/openid-connect/token");
        config.put("logoutUrl", "http://localhost:8080/realms/provider/protocol/openid-connect/logout");
        config.put("userInfoUrl", "http://localhost:8080/realms/provider/protocol/openid-connect/userinfo");
        config.put("defaultScope", "email profile");
        config.put("backchannelSupported", "true");
        return idp;
    }

    private static IdentityProviderRepresentation createIdentityProvider(String alias, String providerId) {
        IdentityProviderRepresentation identityProviderRepresentation = new IdentityProviderRepresentation();
        identityProviderRepresentation.setAlias(alias);
        identityProviderRepresentation.setDisplayName(providerId);
        identityProviderRepresentation.setProviderId(providerId);
        identityProviderRepresentation.setEnabled(true);
        return identityProviderRepresentation;
    }

    private static RealmModel configureSessionContext(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("consumer");
        session.getContext().setRealm(realm);
        return realm;
    }

    private static class ConsumerRealmConf
    implements RealmConfig {
        private ConsumerRealmConf() {
        }

        public RealmConfigBuilder configure(RealmConfigBuilder builder) {
            builder.identityProvider(BrokeredUserSessionRefreshTimeWorkflowTest.setUpIdentityProvider());
            return builder;
        }
    }

    private static class ProviderRealmClientConf
    implements ClientConfig {
        private ProviderRealmClientConf() {
        }

        public ClientConfigBuilder configure(ClientConfigBuilder builder) {
            builder.clientId(BrokeredUserSessionRefreshTimeWorkflowTest.CLIENT_ID);
            builder.name(BrokeredUserSessionRefreshTimeWorkflowTest.CLIENT_ID);
            builder.secret(BrokeredUserSessionRefreshTimeWorkflowTest.CLIENT_SECRET);
            builder.consentRequired(true);
            builder.redirectUris(new String[]{"http://localhost:8080/realms/consumer/broker/kc-oidc-idp/endpoint/*"});
            builder.adminUrl("http://localhost:8080/realms/consumer/broker/kc-oidc-idp/endpoint");
            return builder;
        }
    }

    private static class ConsumerRealmUserConf
    implements UserConfig {
        private ConsumerRealmUserConf() {
        }

        public UserConfigBuilder configure(UserConfigBuilder builder) {
            builder.username("bob");
            builder.password("password");
            builder.email("bob@wonderland.org");
            builder.emailVerified(true);
            builder.name("Bob", "Madhatter");
            return builder;
        }
    }

    private static class ProviderRealmUserConf
    implements UserConfig {
        private ProviderRealmUserConf() {
        }

        public UserConfigBuilder configure(UserConfigBuilder builder) {
            builder.username("alice");
            builder.password("password");
            builder.email("alice@wonderland.org");
            builder.emailVerified(true);
            builder.name("Alice", "Wonderland");
            return builder;
        }
    }
}

