/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.model.workflow;

import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.admin.client.resource.WorkflowsResource;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.workflow.ResourceOperationType;
import org.keycloak.models.workflow.WorkflowsManager;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.userprofile.config.UPConfig;
import org.keycloak.representations.workflows.WorkflowConditionRepresentation;
import org.keycloak.representations.workflows.WorkflowRepresentation;
import org.keycloak.representations.workflows.WorkflowSetRepresentation;
import org.keycloak.representations.workflows.WorkflowStepRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.oauth.OAuthClient;
import org.keycloak.testframework.oauth.annotations.InjectOAuthClient;
import org.keycloak.testframework.realm.GroupConfigBuilder;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.RoleConfigBuilder;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.testframework.remote.providers.runonserver.RunOnServer;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.testframework.ui.annotations.InjectPage;
import org.keycloak.testframework.ui.annotations.InjectWebDriver;
import org.keycloak.testframework.ui.page.LoginPage;
import org.keycloak.testframework.util.ApiUtil;
import org.keycloak.tests.admin.model.workflow.WorkflowsServerConfig;
import org.openqa.selenium.WebDriver;

@KeycloakIntegrationTest(config=WorkflowsServerConfig.class)
public class ExpressionConditionWorkflowTest {
    private static final String REALM_NAME = "default";
    @InjectRunOnServer(permittedPackages={"org.keycloak.tests"})
    RunOnServerClient runOnServer;
    @InjectRealm(lifecycle=LifeCycle.METHOD)
    ManagedRealm managedRealm;
    @InjectWebDriver
    WebDriver driver;
    @InjectPage
    LoginPage loginPage;
    @InjectOAuthClient
    OAuthClient oauth;

    @BeforeEach
    public void onBefore() {
        UPConfig upConfig = this.managedRealm.admin().users().userProfile().getConfiguration();
        upConfig.setUnmanagedAttributePolicy(UPConfig.UnmanagedAttributePolicy.ENABLED);
        this.managedRealm.admin().users().userProfile().update(upConfig);
    }

    @Test
    public void testExpressionCondition() {
        String contractorsGroup;
        String engineeringGroup;
        try (Response response = this.managedRealm.admin().groups().add(GroupConfigBuilder.create().name("engineering").build());){
            engineeringGroup = ApiUtil.getCreatedId((Response)response);
        }
        response = this.managedRealm.admin().groups().add(GroupConfigBuilder.create().name("contractors").build());
        try {
            contractorsGroup = ApiUtil.getCreatedId((Response)response);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        this.addUser("bwayne", "Bruce", "Wayne", List.of("developer", "admin"), List.of("engineering"), Map.of("title", List.of("manager"), "status", List.of("active"), "key", List.of("value1", "value2")));
        this.addUser("lfox", "Lucius", "Fox", List.of("developer"), List.of("contractors"), Map.of("title", List.of("partner engineer"), "status", List.of("active"), "key", List.of("value1")));
        this.addUser("jgordon", "Jim", "Gordon", List.of("admin", "tester"), List.of("engineering"), Map.of("title", List.of("SRE admin"), "status", List.of("inactive"), "key", List.of("value1", "value2")));
        this.addUser("hdent", "Harvey", "Dent", List.of("developer", "tester"), List.of("engineering", "contractors"), Map.of("title", List.of("partner engineer"), "status", List.of("active"), "key", List.of("value2")));
        Object expression = "(is-member-of(\"" + engineeringGroup + "\") OR has-role(\"admin\")) AND !(is-member-of(\"" + contractorsGroup + "\") OR has-user-attribute(\"status\", \"inactive\"))";
        String workflowId = this.createWorkflow((String)expression);
        this.checkWorkflowRunsForUser("bwayne", true);
        this.checkWorkflowRunsForUser("lfox", false);
        this.checkWorkflowRunsForUser("jgordon", false);
        this.checkWorkflowRunsForUser("hdent", false);
        this.managedRealm.admin().workflows().workflow(workflowId).delete().close();
        expression = "has-user-attribute(\"title\", \"partner engineer\") OR has-role(\"tester\")";
        workflowId = this.createWorkflow((String)expression);
        this.checkWorkflowRunsForUser("bwayne", false);
        this.checkWorkflowRunsForUser("lfox", true);
        this.checkWorkflowRunsForUser("jgordon", true);
        this.checkWorkflowRunsForUser("hdent", true);
        this.managedRealm.admin().workflows().workflow(workflowId).delete().close();
        expression = "has-role(\"tester\") AND has-user-attribute(\"key\", \"value1,value2\")";
        workflowId = this.createWorkflow((String)expression);
        this.checkWorkflowRunsForUser("bwayne", false);
        this.checkWorkflowRunsForUser("lfox", false);
        this.checkWorkflowRunsForUser("jgordon", true);
        this.checkWorkflowRunsForUser("hdent", false);
        this.managedRealm.admin().workflows().workflow(workflowId).delete().close();
        expression = "!has-role(\"tester\") AND !has-user-attribute(\"title\", \"manager\")";
        workflowId = this.createWorkflow((String)expression);
        this.checkWorkflowRunsForUser("bwayne", false);
        this.checkWorkflowRunsForUser("lfox", true);
        this.checkWorkflowRunsForUser("jgordon", false);
        this.checkWorkflowRunsForUser("hdent", false);
        this.managedRealm.admin().workflows().workflow(workflowId).delete().close();
        expression = "!(has-role(\"tester\") OR has-user-attribute(\"title\", \"manager\"))";
        workflowId = this.createWorkflow((String)expression);
        this.checkWorkflowRunsForUser("bwayne", false);
        this.checkWorkflowRunsForUser("lfox", true);
        this.checkWorkflowRunsForUser("jgordon", false);
        this.checkWorkflowRunsForUser("hdent", false);
        this.managedRealm.admin().workflows().workflow(workflowId).delete().close();
        expression = ")(has-role(\"tester\") AND OR has-user-attribute(\"key\", \"value1,value2\")";
        workflowId = this.createWorkflow((String)expression);
        this.checkWorkflowRunsForUser("bwayne", false);
        this.checkWorkflowRunsForUser("lfox", false);
        this.checkWorkflowRunsForUser("jgordon", false);
        this.checkWorkflowRunsForUser("hdent", false);
        this.managedRealm.admin().workflows().workflow(workflowId).delete().close();
    }

    public void checkWorkflowRunsForUser(String username, boolean shouldHaveAttribute) {
        this.oauth.openLoginForm();
        this.loginPage.fillLogin(username, username);
        this.loginPage.submit();
        Assertions.assertTrue((boolean)this.driver.getPageSource().contains("Happy days"));
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = ExpressionConditionWorkflowTest.configureSessionContext(session);
            try {
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(6L).toSeconds()));
                new WorkflowsManager(session).runScheduledSteps();
            }
            finally {
                Time.setOffset((int)0);
            }
            UserModel user = session.users().getUserByUsername(realm, username);
            Assertions.assertNotNull((Object)user, (String)(username + " not found"));
            if (shouldHaveAttribute) {
                Assertions.assertTrue((boolean)user.getAttributes().containsKey("notified"));
                user.removeAttribute("notified");
            } else {
                Assertions.assertFalse((boolean)user.getAttributes().containsKey("notified"));
            }
            session.sessions().removeUserSessions(realm, user);
        });
    }

    public void addUser(String username, String firstName, String lastName, List<String> roles, List<String> groups, Map<String, List<String>> attributes) {
        try (Response response = this.managedRealm.admin().users().create(UserConfigBuilder.create().username(username).email(username + "@gotham.com").name(firstName, lastName).groups(groups.toArray(new String[0])).password(username).attributes(attributes).build());){
            String id = ApiUtil.getCreatedId((Response)response);
            for (String roleName : roles) {
                RoleRepresentation role = this.createRoleIfNotExists(roleName);
                if (role.getClientRole().booleanValue()) {
                    this.managedRealm.admin().users().get(id).roles().clientLevel(role.getContainerId()).add(List.of(role));
                    continue;
                }
                this.managedRealm.admin().users().get(id).roles().realmLevel().add(List.of(role));
            }
        }
    }

    private String createWorkflow(String expression) {
        WorkflowSetRepresentation expectedWorkflows = WorkflowRepresentation.create().of("event-based-workflow").onEvent(ResourceOperationType.USER_LOGIN.name()).onConditions(new WorkflowConditionRepresentation[]{WorkflowConditionRepresentation.create().of("expression").withConfig(Map.of("expression", List.of(expression))).build()}).withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("set-user-attribute").withConfig("notified", "true").after(Duration.ofDays(5L)).build()}).build();
        WorkflowsResource workflows = this.managedRealm.admin().workflows();
        try (Response response = workflows.create((WorkflowRepresentation)expectedWorkflows.getWorkflows().get(0));){
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)Response.Status.CREATED.getStatusCode()));
            String string = ApiUtil.getCreatedId((Response)response);
            return string;
        }
    }

    private RoleRepresentation createRoleIfNotExists(String roleName) {
        if (roleName.indexOf(47) != -1) {
            String[] parts = roleName.split("/");
            String clientId = parts[0];
            String clientRoleName = parts[1];
            List clients = this.managedRealm.admin().clients().findByClientId(clientId);
            if (clients.isEmpty()) {
                ClientRepresentation client = new ClientRepresentation();
                client.setClientId(clientId);
                client.setName(clientId);
                client.setProtocol("openid-connect");
                this.managedRealm.admin().clients().create(client).close();
                clients = this.managedRealm.admin().clients().findByClientId(clientId);
            }
            MatcherAssert.assertThat((Object)clients.isEmpty(), (Matcher)Matchers.is((Object)false));
            RolesResource roles = this.managedRealm.admin().clients().get(((ClientRepresentation)clients.get(0)).getId()).roles();
            if (roles.list(clientRoleName, Integer.valueOf(-1), Integer.valueOf(-1)).isEmpty()) {
                roles.create(RoleConfigBuilder.create().name(clientRoleName).build());
            }
            return roles.get(clientRoleName).toRepresentation();
        }
        RolesResource roles = this.managedRealm.admin().roles();
        if (roles.list(roleName, Integer.valueOf(-1), Integer.valueOf(-1)).isEmpty()) {
            roles.create(RoleConfigBuilder.create().name(roleName).build());
        }
        return roles.get(roleName).toRepresentation();
    }

    private static RealmModel configureSessionContext(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName(REALM_NAME);
        session.getContext().setRealm(realm);
        return realm;
    }
}

