/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.model.workflow;

import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.WorkflowsResource;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.workflow.ResourceOperationType;
import org.keycloak.models.workflow.WorkflowsManager;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.userprofile.config.UPConfig;
import org.keycloak.representations.workflows.WorkflowConditionRepresentation;
import org.keycloak.representations.workflows.WorkflowRepresentation;
import org.keycloak.representations.workflows.WorkflowSetRepresentation;
import org.keycloak.representations.workflows.WorkflowStateRepresentation;
import org.keycloak.representations.workflows.WorkflowStepRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.realm.GroupConfigBuilder;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.testframework.remote.providers.runonserver.RunOnServer;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.testframework.util.ApiUtil;
import org.keycloak.tests.admin.model.workflow.WorkflowsServerConfig;

@KeycloakIntegrationTest(config=WorkflowsServerConfig.class)
public class GroupMembershipJoinWorkflowTest {
    private static final String REALM_NAME = "default";
    @InjectRunOnServer(permittedPackages={"org.keycloak.tests"})
    RunOnServerClient runOnServer;
    @InjectRealm(lifecycle=LifeCycle.METHOD)
    ManagedRealm managedRealm;

    @Test
    public void testEventsOnGroupMembershipJoin() {
        String userId;
        String groupId;
        UPConfig upConfig = this.managedRealm.admin().users().userProfile().getConfiguration();
        upConfig.setUnmanagedAttributePolicy(UPConfig.UnmanagedAttributePolicy.ENABLED);
        this.managedRealm.admin().users().userProfile().update(upConfig);
        try (Response response = this.managedRealm.admin().groups().add(GroupConfigBuilder.create().name("generic-group").build());){
            groupId = ApiUtil.getCreatedId((Response)response);
        }
        WorkflowSetRepresentation expectedWorkflows = WorkflowRepresentation.create().of("event-based-workflow").onEvent(ResourceOperationType.USER_GROUP_MEMBERSHIP_ADD.name()).onConditions(new WorkflowConditionRepresentation[]{WorkflowConditionRepresentation.create().of("is-member-of").withConfig("groups", groupId).build()}).withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("set-user-attribute").withConfig("attribute", "attr1").after(Duration.ofDays(5L)).build()}).build();
        WorkflowsResource workflows = this.managedRealm.admin().workflows();
        try (Response response = workflows.create(expectedWorkflows);){
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)Response.Status.CREATED.getStatusCode()));
        }
        try (Response response = this.managedRealm.admin().users().create(UserConfigBuilder.create().username("generic-user").email("generic-user@example.com").build());){
            userId = ApiUtil.getCreatedId((Response)response);
        }
        UserResource userResource = this.managedRealm.admin().users().get(userId);
        userResource.joinGroup(groupId);
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = GroupMembershipJoinWorkflowTest.configureSessionContext(session);
            WorkflowsManager manager = new WorkflowsManager(session);
            try {
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(6L).toSeconds()));
                manager.runScheduledSteps();
            }
            finally {
                Time.setOffset((int)0);
            }
        });
        UserRepresentation rep = userResource.toRepresentation();
        Assertions.assertNotNull(rep.getAttributes().get("attribute"));
    }

    @Test
    public void testRemoveAssociatedGroup() {
        String groupId;
        try (Response response = this.managedRealm.admin().groups().add(GroupConfigBuilder.create().name("generic-group").build());){
            groupId = ApiUtil.getCreatedId((Response)response);
        }
        this.managedRealm.admin().workflows().create(WorkflowRepresentation.create().of("user-refresh-time-workflow").onEvent(ResourceOperationType.USER_LOGIN.toString()).onConditions(new WorkflowConditionRepresentation[]{WorkflowConditionRepresentation.create().of("is-member-of").withConfig("groups", groupId).build()}).withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("notify-user").after(Duration.ofDays(1L)).build()}).build()).close();
        List workflows = this.managedRealm.admin().workflows().list();
        MatcherAssert.assertThat((Object)workflows, (Matcher)Matchers.hasSize((int)1));
        WorkflowRepresentation workflowRep = this.managedRealm.admin().workflows().workflow(((WorkflowRepresentation)workflows.get(0)).getId()).toRepresentation();
        MatcherAssert.assertThat((Object)((String)workflowRep.getConfig().getFirst((Object)"enabled")), (Matcher)Matchers.nullValue());
        this.managedRealm.admin().groups().group(groupId).remove();
        this.managedRealm.admin().users().create(UserConfigBuilder.create().username("test").build()).close();
        workflowRep = this.managedRealm.admin().workflows().workflow(((WorkflowRepresentation)workflows.get(0)).getId()).toRepresentation();
        MatcherAssert.assertThat((Object)workflowRep.getEnabled(), (Matcher)Matchers.allOf((Matcher)Matchers.notNullValue(), (Matcher)Matchers.is((Object)false)));
        WorkflowStateRepresentation status = workflowRep.getState();
        MatcherAssert.assertThat((Object)status, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)status.getErrors(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((String)status.getErrors().get(0)), (Matcher)Matchers.containsString((String)"Group with id %s does not exist.".formatted(groupId)));
    }

    private static RealmModel configureSessionContext(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName(REALM_NAME);
        session.getContext().setRealm(realm);
        return realm;
    }
}

