/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.model.workflow;

import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.admin.client.resource.WorkflowsResource;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.workflow.ResourceOperationType;
import org.keycloak.models.workflow.WorkflowsManager;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.userprofile.config.UPConfig;
import org.keycloak.representations.workflows.WorkflowConditionRepresentation;
import org.keycloak.representations.workflows.WorkflowRepresentation;
import org.keycloak.representations.workflows.WorkflowSetRepresentation;
import org.keycloak.representations.workflows.WorkflowStepRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.RoleConfigBuilder;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.testframework.remote.providers.runonserver.RunOnServer;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.testframework.util.ApiUtil;
import org.keycloak.tests.admin.model.workflow.WorkflowsServerConfig;

@KeycloakIntegrationTest(config=WorkflowsServerConfig.class)
public class RoleWorkflowConditionTest {
    private static final String REALM_NAME = "default";
    @InjectRunOnServer(permittedPackages={"org.keycloak.tests"})
    RunOnServerClient runOnServer;
    @InjectRealm(lifecycle=LifeCycle.METHOD)
    ManagedRealm managedRealm;

    @BeforeEach
    public void onBefore() {
        UPConfig upConfig = this.managedRealm.admin().users().userProfile().getConfiguration();
        upConfig.setUnmanagedAttributePolicy(UPConfig.UnmanagedAttributePolicy.ENABLED);
        this.managedRealm.admin().users().userProfile().update(upConfig);
    }

    @Test
    public void testConditionForSingleRole() {
        String expected = "realm-role-1";
        this.createWorkflow(expected);
        this.assertUserRoles("user-1", false, new String[0]);
        this.assertUserRoles("user-2", false, "not-valid-role");
        this.assertUserRoles("user-3", true, expected);
    }

    @Test
    public void testConditionForMultipleRole() {
        List<String> expected = List.of("realm-role-1", "realm-role-2", "client-a/client-role-1");
        this.createWorkflow(expected);
        this.assertUserRoles("user-1", false, List.of("realm-role-1", "realm-role-2"));
        this.assertUserRoles("user-2", false, List.of("realm-role-1", "realm-role-2", "client-b/client-role-1"));
        this.assertUserRoles("user-3", true, expected);
    }

    private void assertUserRoles(String username, boolean shouldExist, String ... roles) {
        this.assertUserRoles(username, shouldExist, List.of(roles));
    }

    private void assertUserRoles(String username, boolean shouldExist, List<String> roles) {
        try (Response response = this.managedRealm.admin().users().create(UserConfigBuilder.create().username(username).email(username + "@example.com").build());){
            String id = ApiUtil.getCreatedId((Response)response);
            for (String roleName : roles) {
                RoleRepresentation role = this.createRoleIfNotExists(roleName);
                if (role.getClientRole().booleanValue()) {
                    this.managedRealm.admin().users().get(id).roles().clientLevel(role.getContainerId()).add(List.of(role));
                    continue;
                }
                this.managedRealm.admin().users().get(id).roles().realmLevel().add(List.of(role));
            }
        }
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = RoleWorkflowConditionTest.configureSessionContext(session);
            try {
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(6L).toSeconds()));
                new WorkflowsManager(session).runScheduledSteps();
            }
            finally {
                Time.setOffset((int)0);
            }
            UserModel user = session.users().getUserByUsername(realm, username);
            Assertions.assertNotNull((Object)user);
            if (shouldExist) {
                Assertions.assertTrue((boolean)user.getAttributes().containsKey("notified"));
            } else {
                Assertions.assertFalse((boolean)user.getAttributes().containsKey("notified"));
            }
        });
    }

    private void createWorkflow(String ... expectedValues) {
        this.createWorkflow(Map.of("roles", List.of(expectedValues)));
    }

    private void createWorkflow(List<String> expectedValues) {
        this.createWorkflow(Map.of("roles", expectedValues));
    }

    private void createWorkflow(Map<String, List<String>> attributes) {
        for (String roleName : attributes.getOrDefault("roles", List.of())) {
            this.createRoleIfNotExists(roleName);
        }
        WorkflowSetRepresentation expectedWorkflows = WorkflowRepresentation.create().of("event-based-workflow").onEvent(ResourceOperationType.USER_ROLE_ADD.name()).recurring().onConditions(new WorkflowConditionRepresentation[]{WorkflowConditionRepresentation.create().of("has-role").withConfig(attributes).build()}).withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("set-user-attribute").withConfig("notified", "true").after(Duration.ofDays(5L)).build()}).build();
        WorkflowsResource workflows = this.managedRealm.admin().workflows();
        try (Response response = workflows.create(expectedWorkflows);){
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)Response.Status.CREATED.getStatusCode()));
        }
    }

    private RoleRepresentation createRoleIfNotExists(String roleName) {
        if (roleName.indexOf(47) != -1) {
            String[] parts = roleName.split("/");
            String clientId = parts[0];
            String clientRoleName = parts[1];
            List clients = this.managedRealm.admin().clients().findByClientId(clientId);
            if (clients.isEmpty()) {
                ClientRepresentation client = new ClientRepresentation();
                client.setClientId(clientId);
                client.setName(clientId);
                client.setProtocol("openid-connect");
                this.managedRealm.admin().clients().create(client).close();
                clients = this.managedRealm.admin().clients().findByClientId(clientId);
            }
            MatcherAssert.assertThat((Object)clients.isEmpty(), (Matcher)Matchers.is((Object)false));
            RolesResource roles = this.managedRealm.admin().clients().get(((ClientRepresentation)clients.get(0)).getId()).roles();
            if (roles.list(clientRoleName, Integer.valueOf(-1), Integer.valueOf(-1)).isEmpty()) {
                roles.create(RoleConfigBuilder.create().name(clientRoleName).build());
            }
            return roles.get(clientRoleName).toRepresentation();
        }
        RolesResource roles = this.managedRealm.admin().roles();
        if (roles.list(roleName, Integer.valueOf(-1), Integer.valueOf(-1)).isEmpty()) {
            roles.create(RoleConfigBuilder.create().name(roleName).build());
        }
        return roles.get(roleName).toRepresentation();
    }

    private static RealmModel configureSessionContext(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName(REALM_NAME);
        session.getContext().setRealm(realm);
        return realm;
    }
}

