/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.model.workflow;

import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.workflow.WorkflowStepRunnerSuccessEvent;
import org.keycloak.provider.ProviderEventListener;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.workflows.WorkflowRepresentation;
import org.keycloak.representations.workflows.WorkflowStepRepresentation;
import org.keycloak.storage.UserStoragePrivateUtil;
import org.keycloak.testframework.annotations.InjectAdminClient;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.testframework.remote.providers.runonserver.RunOnServer;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.tests.admin.model.workflow.WorkflowsScheduledTaskServerConfig;

@KeycloakIntegrationTest(config=WorkflowsScheduledTaskServerConfig.class)
public class StepRunnerScheduledTaskTest {
    private static final String REALM_NAME = "default";
    @InjectRunOnServer(permittedPackages={"org.keycloak.tests"})
    RunOnServerClient runOnServer;
    @InjectAdminClient(mode=InjectAdminClient.Mode.BOOTSTRAP)
    Keycloak adminClient;

    @Test
    public void testStepRunnerScheduledTask() {
        for (int i = 0; i < 2; ++i) {
            RealmRepresentation realm = new RealmRepresentation();
            realm.setRealm(REALM_NAME.concat("-").concat(String.valueOf(i)));
            realm.setEnabled(Boolean.valueOf(true));
            this.adminClient.realms().create(realm);
            this.assertStepRuns(realm.getRealm());
        }
    }

    private void assertStepRuns(String realmName) {
        RealmResource realm = this.adminClient.realm(realmName);
        realm.workflows().create(WorkflowRepresentation.create().of("user-creation-time-workflow").withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("set-user-attribute").after(Duration.ofDays(5L)).withConfig("message", "message").build(), WorkflowStepRepresentation.create().of("disable-user").after(Duration.ofDays(5L)).build()}).build()).close();
        realm.users().create(UserConfigBuilder.create().username("alice").email("alice@keycloak.org").name("alice", "wonderland").build()).close();
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
            CountDownLatch count = new CountDownLatch(2);
            ProviderEventListener listener = event -> {
                if (event instanceof WorkflowStepRunnerSuccessEvent) {
                    WorkflowStepRunnerSuccessEvent e = (WorkflowStepRunnerSuccessEvent)event;
                    KeycloakSession s = e.session();
                    RealmModel r = s.getContext().getRealm();
                    if (!realmName.equals(r.getName())) {
                        return;
                    }
                    UserProvider provider = UserStoragePrivateUtil.userLocalStorage((KeycloakSession)s);
                    UserModel user = provider.getUserByUsername(r, "alice");
                    if (user.isEnabled() && user.getAttributes().containsKey("message")) {
                        count.countDown();
                        user.removeAttribute("message");
                        Time.setOffset((int)Math.toIntExact(Duration.ofDays(20L).toSeconds()));
                    } else if (!user.isEnabled()) {
                        count.countDown();
                    }
                }
            };
            try {
                sessionFactory.register(listener);
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(12L).toSeconds()));
                System.out.println("Waiting for steps to be run for realm " + realmName);
                Assertions.assertTrue((boolean)count.await(15L, TimeUnit.SECONDS));
                System.out.println("... steps run for realm " + realmName);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            finally {
                sessionFactory.unregister(listener);
                Time.setOffset((int)0);
            }
        });
    }
}

