/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.model.workflow;

import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.WorkflowsResource;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.workflow.ResourceOperationType;
import org.keycloak.models.workflow.WorkflowsManager;
import org.keycloak.representations.userprofile.config.UPConfig;
import org.keycloak.representations.workflows.WorkflowConditionRepresentation;
import org.keycloak.representations.workflows.WorkflowRepresentation;
import org.keycloak.representations.workflows.WorkflowSetRepresentation;
import org.keycloak.representations.workflows.WorkflowStepRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.testframework.remote.providers.runonserver.RunOnServer;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.tests.admin.model.workflow.WorkflowsServerConfig;

@KeycloakIntegrationTest(config=WorkflowsServerConfig.class)
public class UserAttributeWorkflowConditionTest {
    private static final String REALM_NAME = "default";
    @InjectRunOnServer(permittedPackages={"org.keycloak.tests"})
    RunOnServerClient runOnServer;
    @InjectRealm(lifecycle=LifeCycle.METHOD)
    ManagedRealm managedRealm;

    @BeforeEach
    public void onBefore() {
        UPConfig upConfig = this.managedRealm.admin().users().userProfile().getConfiguration();
        upConfig.setUnmanagedAttributePolicy(UPConfig.UnmanagedAttributePolicy.ENABLED);
        this.managedRealm.admin().users().userProfile().update(upConfig);
    }

    @Test
    public void testConditionForSingleValuedAttribute() {
        String expected = "valid";
        this.createWorkflow(expected);
        this.assertUserAttribute("user-1", false, new String[0]);
        this.assertUserAttribute("user-2", false, "not-valid");
        this.assertUserAttribute("user-3", true, expected);
    }

    @Test
    public void testConditionForMultiValuedAttribute() {
        List<String> expected = List.of("v1", "v2", "v3");
        this.createWorkflow(expected);
        this.assertUserAttribute("user-1", false, "v1");
        this.assertUserAttribute("user-2", true, expected);
        this.assertUserAttribute("user-3", false, "v1", "v2", "v3", "v4");
    }

    @Test
    public void testConditionForMultipleAttributes() {
        Map<String, List<String>> expected = Map.of("a", List.of("a1"), "b", List.of("b1"), "c", List.of("c11", "c2"));
        this.createWorkflow(expected);
        this.assertUserAttribute("user-1", false, Map.of("a", List.of("a3"), "b", List.of("b1"), "c", List.of("c1", "c2")));
        this.assertUserAttribute("user-2", true, expected);
        this.assertUserAttribute("user-3", false, Map.of("a", List.of("a1"), "b", List.of("b1")));
        HashMap<String, List<String>> values = new HashMap<String, List<String>>(expected);
        values.put("d", List.of("d1"));
        this.assertUserAttribute("user-4", true, values);
    }

    private void assertUserAttribute(String username, boolean shouldExist, String ... values) {
        this.assertUserAttribute(username, shouldExist, Map.of("attribute", List.of(values)));
    }

    private void assertUserAttribute(String username, boolean shouldExist, List<String> values) {
        this.assertUserAttribute(username, shouldExist, Map.of("attribute", values));
    }

    private void assertUserAttribute(String username, boolean shouldExist, Map<String, List<String>> attributes) {
        this.managedRealm.admin().users().create(UserConfigBuilder.create().username(username).email(username + "@example.com").attributes(attributes).build()).close();
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = UserAttributeWorkflowConditionTest.configureSessionContext(session);
            try {
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(6L).toSeconds()));
                new WorkflowsManager(session).runScheduledSteps();
            }
            finally {
                Time.setOffset((int)0);
            }
            UserModel user = session.users().getUserByUsername(realm, username);
            Assertions.assertNotNull((Object)user);
            if (shouldExist) {
                Assertions.assertTrue((boolean)user.getAttributes().containsKey("notified"));
            } else {
                Assertions.assertFalse((boolean)user.getAttributes().containsKey("notified"));
            }
        });
    }

    private void createWorkflow(String ... expectedValues) {
        this.createWorkflow(Map.of("attribute", List.of(expectedValues)));
    }

    private void createWorkflow(List<String> expectedValues) {
        this.createWorkflow(Map.of("attribute", expectedValues));
    }

    private void createWorkflow(Map<String, List<String>> attributes) {
        WorkflowSetRepresentation expectedWorkflows = WorkflowRepresentation.create().of("event-based-workflow").onEvent(ResourceOperationType.USER_ADD.name()).recurring().onConditions(new WorkflowConditionRepresentation[]{WorkflowConditionRepresentation.create().of("has-user-attribute").withConfig(attributes).build()}).withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("set-user-attribute").withConfig("notified", "true").after(Duration.ofDays(5L)).build()}).build();
        WorkflowsResource workflows = this.managedRealm.admin().workflows();
        try (Response response = workflows.create(expectedWorkflows);){
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)Response.Status.CREATED.getStatusCode()));
        }
    }

    private static RealmModel configureSessionContext(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName(REALM_NAME);
        session.getContext().setRealm(realm);
        return realm;
    }
}

