/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.model.workflow;

import jakarta.mail.internet.MimeMessage;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.workflow.WorkflowsManager;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.workflows.WorkflowRepresentation;
import org.keycloak.representations.workflows.WorkflowStepRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.mail.MailServer;
import org.keycloak.testframework.mail.annotations.InjectMailServer;
import org.keycloak.testframework.oauth.OAuthClient;
import org.keycloak.testframework.oauth.annotations.InjectOAuthClient;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.remote.providers.runonserver.RunOnServer;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.testframework.ui.annotations.InjectPage;
import org.keycloak.testframework.ui.annotations.InjectWebDriver;
import org.keycloak.testframework.ui.page.LoginPage;
import org.keycloak.tests.admin.model.workflow.WorkflowManagementTest;
import org.keycloak.tests.admin.model.workflow.WorkflowsServerConfig;
import org.openqa.selenium.WebDriver;

@KeycloakIntegrationTest(config=WorkflowsServerConfig.class)
public class UserCreationTimeWorkflowTest {
    private static final String REALM_NAME = "default";
    @InjectRunOnServer(permittedPackages={"org.keycloak.tests"})
    RunOnServerClient runOnServer;
    @InjectRealm
    ManagedRealm managedRealm;
    @InjectWebDriver
    WebDriver driver;
    @InjectPage
    LoginPage loginPage;
    @InjectOAuthClient
    OAuthClient oauth;
    @InjectMailServer
    private MailServer mailServer;

    @Test
    public void testDisableUserBasedOnCreationDate() {
        this.managedRealm.admin().workflows().create(WorkflowRepresentation.create().of("user-creation-time-workflow").withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("notify-user").after(Duration.ofDays(5L)).build(), WorkflowStepRepresentation.create().of("disable-user").after(Duration.ofDays(5L)).build()}).build()).close();
        this.managedRealm.admin().users().create(this.getUserRepresentation("alice", "Alice", "Wonderland", "alice@wornderland.org")).close();
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = UserCreationTimeWorkflowTest.configureSessionContext(session);
            WorkflowsManager manager = new WorkflowsManager(session);
            UserModel user = session.users().getUserByUsername(realm, "alice");
            Assertions.assertTrue((boolean)user.isEnabled());
            Assertions.assertNull(user.getAttributes().get("message"));
            manager.runScheduledSteps();
            user = session.users().getUserByUsername(realm, "alice");
            Assertions.assertTrue((boolean)user.isEnabled());
            Assertions.assertNull(user.getAttributes().get("message"));
            try {
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(6L).toSeconds()));
                manager.runScheduledSteps();
                user = session.users().getUserByUsername(realm, "alice");
                Assertions.assertTrue((boolean)user.isEnabled());
            }
            finally {
                Time.setOffset((int)0);
            }
        });
        MimeMessage testUserMessage = WorkflowManagementTest.findEmailByRecipient(this.mailServer, "alice@wornderland.org");
        Assertions.assertNotNull((Object)testUserMessage, (String)"The first step (notify) should have sent an email.");
        this.mailServer.runCleanup();
        this.oauth.openLoginForm();
        this.loginPage.fillLogin("alice", "alice");
        this.loginPage.submit();
        Assertions.assertTrue((boolean)this.driver.getPageSource().contains("Happy days"));
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = UserCreationTimeWorkflowTest.configureSessionContext(session);
            WorkflowsManager manager = new WorkflowsManager(session);
            try {
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(12L).toSeconds()));
                manager.runScheduledSteps();
                UserModel user = session.users().getUserByUsername(realm, "alice");
                Assertions.assertFalse((boolean)user.isEnabled());
            }
            finally {
                Time.setOffset((int)0);
            }
        });
    }

    private static RealmModel configureSessionContext(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName(REALM_NAME);
        session.getContext().setRealm(realm);
        return realm;
    }

    private UserRepresentation getUserRepresentation(String username, String firstName, String lastName, String email) {
        UserRepresentation representation = new UserRepresentation();
        representation.setUsername(username);
        representation.setFirstName(firstName);
        representation.setLastName(lastName);
        representation.setEmail(email);
        representation.setEnabled(Boolean.valueOf(true));
        CredentialRepresentation credential = new CredentialRepresentation();
        credential.setType("password");
        credential.setValue(username);
        representation.setCredentials(List.of(credential));
        return representation;
    }
}

